<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$report_tittle}}</title>

    <style>

        .tittle {
            font-size: 11px;
        }

        .slot-table td {
            border: 1px solid #999999;
        }

        .slot-table th {
            border: 1px solid #999999;
        }

        .slot-table tr td {
            border: 1px dotted #999999;
        }

        .slot-table tr td.no-br-td {
            vertical-align: text-top;
        }

        .slot-table tr td:first-child {
            border: 1px solid #999999;
            vertical-align: middle;
        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: text-top;
            padding-left: 20px;

        }

        .slot {
            min-height: 200px;
            padding: 0 3px;
        }

        .class_timings {
            font-size: 10px;

        }

        .subject-div {
            font-size: 11px;
            font-weight: bold;

        }

        .employee-div {
            font-size: 9px;

        }

        .room-div {
            font-size: 11px;

        }

        .heading-slot-bg td {
            text-align: center;
        }

        .sl-circle {

        }


    </style>

</head>
<body>
<main>
    @if($lists)
        @include('default.site.layout.pdf-header')
        <div>
            <table class="slot-table" width="100%" cellspacing="0" border="0">
                <thead>
                <tr class="heading-slot-bg">
                    <td>S/L</td>
                    <td>
                        Teacher Name
                    </td>
                    @foreach($headingList as $key=>$week)
                        <td>{{strtoupper($key) }}</td>
                    @endforeach
                    <td>Total</td>
                </tr>
                </thead>

                <tbody>
                @foreach($lists as $key=>$list)
                    <tr>
                        <td>
                            {{$key+1}}.
                        </td>
                        <td>
                            {{$list['emp']->full_name}}
                        </td>

                        @foreach($headingList as $key=>$week)
                            @php
                                $slot_serial=1;
                            @endphp

                            <td>
                                @if($list[$key]['slot'])
                                    @foreach($list[$key]['slot'] as $slot_k=>$slot)

                                        <div class="slot">
                                            <div class="class_timings">
                                         <span class="sl-circle">
                                             {{--<b><i>{{$slot_serial}}).</i></b>--}}
                                             <b> ({{addOrdinalNumberSuffix($slot_k+1)}})</b>
                                         </span>

                                                {{date('h:i A', strtotime($slot->start_time)) }}
                                                - {{date('h:i A', strtotime($slot->end_time)) }}


                                            </div>

                                            @if(count($slot->routineAllocations))

                                                @foreach($slot->routineAllocations as $ks=>$routineAllocation)
                                                    <div class="subject-div">
                                                        @if($routineAllocation->subject)
                                                            {{$routineAllocation->subject->subject_name}}
                                                        @endif
                                                    </div>

                                                    <div class="employee-div">
                                                        {{$slot->academicClass->class_name ?? 'n/a'}}  {{$slot->classGroup->group_name ?? ''}}  {{$slot->academicSection->section_name ?? ''}}
                                                    </div>

                                                    <div class="room-div">
                                                        @if($routineAllocation->room)
                                                            {{$routineAllocation->room->room_name}}
                                                            ({{($routineAllocation->room->building->building_name ?? '') .'- '. ($routineAllocation->room->floor->floor_name ?? '')}}
                                                            )
                                                        @endif
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                        @if(count($list[$key]['slot'])>=2)
                                            <div style="width:100%; height: 1px; background-color: #2a5164"></div>
                                        @endif
                                        @php($slot_serial++)
                                    @endforeach
                                @endif
                            </td>
                        @endforeach

                        <td style="text-align: center">   {{$list['total']}}  </td>
                    </tr>
                @endforeach
                </tbody>

            </table>
        </div>
    @endif

</main>
<footer>
    @include('default.site.layout.pdf-footer')
</footer>
</body>


<style>

    @page {
        size: a4 landscape;
        margin: 0px;
    }

    body {
        margin: 5px;
    }

    #headerA {
        position: fixed;
        left: 0px;
        right: 0px;
        top: 0px;
        text-align: center;
        background-color: #ffffff;
        height: 90px;
    }

    #headerB {
        position: absolute;
        left: -20px;
        right: -20px;
        top: -200px;
        text-align: center;
        background-color: orange;
        height: 190px;
    }

    #footer {
        position: fixed;
        left: 0px;
        right: 0px;
        bottom: 0px;
        text-align: center;
        background-color: orange;
        height: 40px;
    }
</style>

</html>












