<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>Page Title</title>

    <style>

        .tittle {
            background-color: #dcdcdc;
            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
            font-weight: bold;
        }

        .slot-table td {
            border: 1px solid #999999;
        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }

        .class_timings {
            font-size: 10px;
        }

        .subject-div {
            font-size: 11px;

        }

        .employee-div {
            font-size: 9px;

        }

        .room-div {
            font-size: 11px;

        }

        .vertical {
            -ms-transform: rotate(270deg); /* IE 9 */
            -webkit-transform: rotate(270deg); /* Chrome, Safari, Opera */
            transform: rotate(270deg);
            text-align: center;
            font-size: 12px;
            height: 60px;
        }

        .break_timings {
            font-size: 12px;
            font-weight: normal;
            width: 40px;
            height: 30px;

        }

        .break {
            transform: rotate(270deg);
            text-align: center;

        }

    </style>

</head>
<body>

@if($weekDays && $week_array)


    <div id="headerA">
        <h1>Class Routine of Class Nine</h1>
        <div style="position: fixed; left: 0px; right: 0px; top: 0px;">
            <img src="{{asset("img/site").'/'.$site->site_logo}}" width="50" height="50">

        </div>
    </div>


    <main>


    <div style=" width: auto">

        <table class="slot-table" cellspacing="0" border="0"  style="">
            <thead>

            <tr class="heading-slot-bg">
                <td class="td2">
                    <div class="">Day/Class</div>
                </td>
                @foreach($headingList as $k=>$h)
                    @if(!$h->is_break)
                        <td>
                            <div class="td-period-title">{{$h->name}}</div>
                        </td>
                    @else
                        <td>
                            <div class="td-period-break-title">
                                Break
                            </div>
                        </td>
                    @endif
                @endforeach

                @if(count($headingList) < $max_col_count)



                    <td colspan="{{$max_col_count - count($headingList)}}">

                    </td>

                @endif
            </tr>


            </thead>


            @if(count($week_array)>0)
                <tbody>

                @foreach($week_array as $key=>$week)
                    <tr>

                        <td class="heading-slot-bg">
                            <div class="vertical">
                                {{$key}}
                            </div>
                        </td>
                        @if(count($week)<1)
                            <td colspan="{{$max_col_count}}"></td>
                        @endif

                        @php
                            $count=0;
                            $s_key=0;
                        @endphp

                        @foreach($week as $key1 => $slot)

                            @php($count++)
                            @php($s_key++)

                            @if(!$slot->is_break)
                                <td>
                                    <div class="slot">
                                        <div class="check-timing-div">
                                            <div class="class_timings">
                                                {{date('h:i A', strtotime($slot->start_time)) }}
                                                - {{date('h:i A', strtotime($slot->end_time)) }}
                                            </div>
                                        </div>
                                        @if(count($slot->routineAllocations))
                                            @foreach($slot->routineAllocations as $ks=>$routineAllocation)
                                                <div class="subject-div">
                                                    @if($routineAllocation->subject)
                                                        {{$routineAllocation->subject->subject_name}}
                                                    @endif
                                                </div>

                                                <div class="employee-div">
                                                    @if($routineAllocation->employee)
                                                        {{$routineAllocation->employee->first_name}}
                                                    @endif
                                                </div>

                                                <div class="room-div">
                                                    @if($routineAllocation->room)
                                                        {{$routineAllocation->room->room_name}}
                                                    @endif
                                                </div>
                                            @endforeach
                                        @endif
                                    </div>

                                </td>
                            @else
                                <td class="td">
                                    <div class="break_timings">
                                        <div class="break">
                                            <span class="break_label">Break</span>
                                            <span class="break_ct"><b>
                                                                  {{intval((strtotime(date($slot->end_time))-strtotime($slot->start_time))/60)<60
                                                                            ? intval((strtotime(date($slot->end_time))-strtotime($slot->start_time))/60)
                                                                            : floor(intval((strtotime(date($slot->end_time))-strtotime($slot->start_time))/60)/60).
                                                                            ' : '.(intval((strtotime(date($slot->end_time))-strtotime($slot->start_time))/60)
                                                                            - floor(intval((strtotime(date($slot->end_time))-strtotime($slot->start_time))/60) / 60) * 60)}}
                                                    mins</b>
                                            </span>
                                        </div>
                                    </div>

                                </td>
                            @endif

                            @if($s_key <$max_col_count && count($week)==$s_key) &&)
                            <td colspan="{{($max_col_count - $s_key)}}">

                            </td>
                            @endif

                        @endforeach
                    </tr>
                @endforeach


                </tbody>
            @endif

        </table>
    </div>


@endif

<style>




    @page {
        size: a4 landscape;
        margin: 0px;
    }
    @page :first {
        margin-top: 100px;
    }
    body {
        margin: 100px 20px 50px 20px;
    }
    #headerA {
        position: fixed;
        left: 0px; right: 0px; top: 0px;
        text-align: center;
        background-color: #ffffff;
        height: 90px;
    }
    #headerB {
        position: absolute;
        left: -20px; right: -20px; top: -200px;
        text-align: center;
        background-color: orange;
        height: 190px;
    }
    #footer {
        position: fixed;
        left: 0px; right: 0px; bottom: 0px;
        text-align: center;
        background-color: orange;
        height: 40px;
    }
</style>


</body>
</html>












