<!DOCTYPE html>
<html>
<head>
    @php($site=getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>


    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .st-image {
            text-align: center;
            width: 57px;
            height: 55px;
            border-radius: 10px;
            border: 1px solid #0b0b0b;
        }

        .txt-left {
            text-align: left;
        }

        td{
            font-size: 10px;
        }
    </style>

</head>
<body>


@include('default.site.layout.pdf-header')


<table class="data-table" cellspacing="0" border="1" width="100%;">
    <thead>
    <tr>
        <th>S/L</th>

        <th class="txt-left">
            <nobr>Name</nobr>
        </th>
        <th>Roll</th>
        <th>Status</th>
        <th>In Out</th>


    </tr>
    </thead>

    <tbody>
    @foreach($st_att_list as $key => $value)
        <tr>
            <td>{{$key+1}}</td>



            <td>
                {{$value['name']}}
            </td>  <td>
                {{$value['student_roll_number']}}
            </td>
            <td>
                {{$value['st_status']}}
            </td>
            <td>
                {{$value['in_time'] ?? 'n/f'}} - {{$value['out_time'] ?? 'n/f'}}
            </td>

        </tr>
    @endforeach

    </tbody>
</table>


</body>


<style>

    @page {
        size: a4;
        margin: 0px;

    }

    body {
        margin: 5px;
    }


</style>

</html>












