<!DOCTYPE html>
<html>
<head>
    @set('site',getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>


    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .st-image {
            text-align: center;
            width: 50px;
            height: 60px;
            border-radius: 10px;
            border: 1px solid #0b0b0b;
        }

        .txt-left {
            text-align: left;
        }


        .site-logo {
            background: transparent;
        }

    </style>

</head>
<body>

@include('default.site.layout.pdf-header')


<table class="data-table" cellspacing="0" border="0" width="100%;">

    <tbody>


    <tr>
        <td style="width: 100%;text-align: center">

            @if(file_exists(public_path("uploads").'/'.$student_history->student->latestPhoto->name))
                <img class="st-image"
                     src="{{asset("uploads").'/'.$student_history->student->latestPhoto->name  ?? 'image-not.png'}}">
            @else
                <img class="st-image"
                     src="{{asset("uploads").'/image-not.png'}}">
            @endif
        </td>
    </tr>
    <tr>
        <td style="width: 100%;text-align: center">
            <span style="text-transform:uppercase;font-weight: bold; color: #00ca6d"> {{$student_history->student->full_name ?? '--'}} </span>
        </td>
    </tr>

    <tr>
        <td style="width: 100%;text-align: center">
            <b> ({{$student_history->student->username}})</b>
        </td>
    </tr>
    <tr>
        <td style="width: 100%;text-align: center">

               {!! $report_tittle3 !!}
        </td>
    </tr>
    </tbody>
</table>

<div>



    <fieldset>
        <legend>{{ trans('translate.student_login') }}</legend>
        <table class="table table-bordered  table-striped">

            <tbody>
            <tr>
                <td>{{ trans('translate.user_name') }}</td>
                <td>:{{ $student_history->student->username }}</td>
            </tr>
            </tbody>
        </table>

    </fieldset>
    <fieldset>
        <legend>{{ trans('translate.student_information') }}</legend>
        <table class="table table-bordered table-striped">
            <tbody>


            @if($student_history->department)
                <tr>
                    <td>{{ trans('translate.department') }}</td>
                    <td> :{{ $student_history->department->name ?? 'n/a' }}</td>
                </tr>
            @endif

            <tr>
                <td>{{ trans('translate.class_name') }}</td>
                <td> :{{ $student_history->stClass->class_name ?? 'n/a' }}</td>
            </tr>

            @if($student_history->section)

                <tr>
                    <td> {{ trans('translate.section_name') }}</td>
                    <td> :{{  $student_history->section->section_name ?? 'Not Found' }}</td>
                </tr>
            @endif


            <tr>
                <td>{{ trans('translate.roll_number') }}</td>
                <td> :{{ $student_history->student_full_roll_number }}</td>
            </tr>

            <tr>
                <td> {{ trans('translate.fathers_name') }}</td>
                <td> :{{ $student_history->student->father_name ?? 'Not Found' }}</td>
            </tr>


            <tr>
                <td>{{ trans('translate.mothers_name') }} </td>
                <td>:{{ $student_history->student->mother_name ?? 'Not Found' }}</td>

            </tr>
            <tr>
                <td>{{ trans('translate.admission_date') }}</td>
                <td> :{{ $student_history->dept_join_date }}</td>
            </tr>
            <tr>
                <td> {{ trans('translate.address') }}</td>
                <td> :{{ $student_history->student->address ?? 'Not Found'}}</td>

            </tr>

            <tr>
                <td>{{ trans('translate.gender') }}</td>
                <td> :{{ $student_history->student->gender->gender_name ?? 'Not Found'  }}</td>
            </tr>

            <tr>
                <td> {{ trans('translate.religion') }}</td>
                <td>: {{ $student_history->student->religion->name ?? 'Not Found' }}</td>
            </tr>

            <tr>
                <td>{{ trans('translate.nid_number') }}</td>
                <td> :{{ $student_history->student->nid_number }}</td>
            </tr>
            <tr>
                <td>{{ trans('translate.passport_number') }}</td>
                <td> :{{ $student_history->student->passport_no }}</td>
            </tr>
            <tr>
                <td>  {{ trans('translate.birth_certificate') }}</td>
                <td> :{{ $student_history->student->birth_certificate_no }}</td>
            </tr>

            </tbody>
        </table>


    </fieldset>

    <fieldset>
        <legend>{{ trans('translate.contact') }}</legend>
        <table class="table table-bordered table-striped">

            <tbody>
            <tr>
                <td> {{ trans('translate.phone') }}</td>
                <td> :{{ $student_history->student->contact_number }}</td>

            </tr>
            <tr>
                <td>{{ trans('translate.emergency_contact') }}</td>
                <td> :{{ $student_history->student->emergency_contact }}</td>
            </tr>
            <tr>
                <td> {{ trans('translate.email') }}</td>
                <td>:{{ $student_history->student->email }}</td>
            </tr>
            </tbody>
        </table>


    </fieldset>


    <fieldset>
        <legend>{{ trans('translate.guardian') }}</legend>
        <table class="table table-bordered table-striped">

            <tbody>
            <tr>
                <td> {{ trans('translate.phone') }}</td>
                <td> :{{ $student_history->student->guardian->full_name ?? 'N/A' }}</td>

            </tr>
            <tr>
                <td>{{ trans('translate.emergency_contact') }}</td>
                <td> :{{ $student_history->student->guardian->emergency_contact ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td> {{ trans('translate.email') }}</td>
                <td>:{{ $student_history->student->guardian->usename ?? 'N/A' }}</td>
            </tr>
            </tbody>
        </table>


    </fieldset>


</div>


</body>


<style>

    @page {
        size: A4;
        margin: 0px;

    }

    body {
        margin: 10px 20px 50px 40px;
    }


</style>

</html>












