<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>


        #header,
        #footer {
            position: fixed;
            left: 0;
            right: 0;
            color: #aaa;
            font-size: 0.9em;
        }
        #header {
            top: 0;
            border-bottom: 0.1pt solid #aaa;
        }
        #footer {
            bottom: 0;
            border-top: 0.1pt solid #aaa;
        }
        .page-number:before {
            content: "Page " counter(page);
        }


        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {

            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
        }

        .data-table td,th {
            border: 1px dotted #999999;
            text-align: center;
        }
        .data-table th {
            border: 1px solid #999999;
            text-align: center;
        }


    </style>

</head>
<body>
@include('default.site.layout.pdf-header')

<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <th style="width: 1px">S/L</th>
            <th>Name</th>
            <th>User Id</th>
            <th>Class</th>
            <th>Group</th>
            <th>Section</th>
            <th>Roll</th>
        </tr>
        </thead>


        <tbody>
        @foreach($student_list as $key => $value)

            <tr>
                <td>{{$key +1}}</td>
                <td>
                    {{$value->full_name ?? 'na'}}
                </td>
                <td> {{ $value->student->username ?? 'n/a'}}</td>
                <td> {{ $value->stClass->class_name  ?? 'n/a'}}</td>
                <td> {{ $value->classGroup->group_name ?? 'n/a'}}</td>
                <td> {{ $value->section->section_name ?? 'n/a'}}</td>
                <td>
                    {{$value->student_full_roll_number ?? '--' }}
                </td>
            </tr>


        @endforeach
        </tbody>


    </table>
</div>




</body>


<style>

    @page {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












