<!DOCTYPE html>
<html>
<head>
    @set('site',getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {

            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
        }

        .data-table td, th {
            border: 1px dotted #999999;
            text-align: center;
        }

        .data-table th {
            border: 1px solid #999999;
            text-align: center;
        }


    </style>

</head>
<body>


@include('default.site.layout.pdf-header')


<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <th>S/L</th>
            <th>Student’s Name.
                Father’s Name &
                Mother’s Name.
            </th>
            <th>Date of Admission Class,
                Group and
                Class Roll
            </th>
            <th>Subjects</th>
            <th>Address,
                Date of Birth &
                Mobile No
            </th>
            <th>Institution Name</th>
            <th>Signature</th>
        </tr>
        </thead>


        <tbody>
        @foreach($student_history as $key => $value)

            <tr>
                <td>{{$key +1}}</td>
                <td>
                    {{$value->full_name ?? 'na'}}
                    <br>
                    {{$value->student->father_name ?? 'na'}}
                    <br>
                    {{$value->student->mother_name ?? 'na'}}
                </td>

                <td>
                    {{ $value->stClass->class_name  ?? 'n/a'}} <br>

                    @if ( $value->classGroup)
                        {{    $value->classGroup->group_name ?? '--'}}
                        <br>
                    @endif
                    @if ( $value->section)
                        {{    $value->section->section_name ?? '--'}}
                        <br>
                    @endif


                    {{$value->student_roll_number ?? '--' }}

                </td>
                <td>
                    @if(count($value->academic_subject_ids[0]))
                        @foreach($value->academic_subject_ids[0] as $k=>$subject)
                                {{ $subject->subject_name }} ,
                        @endforeach
                    @endif
                </td>
                <td>
                    {{ $value->student->address ?? '--'}} <br>
                    {{ $value->student->date_of_birth ?? '--'}} <br>
                    {{$value->student->contact_number ?? '--'}}
                </td>
                <td>{{$value->previous_institute_name}}</td>
                <td></td>
            </tr>


        @endforeach
        </tbody>


    </table>
</div>


</body>


<style>

    @page {
        size: Landscape;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












