<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }



    </style>

</head>
<body>


{{--@include('default.site.layout.pdf-header')--}}


<div>

    <div>
        <table style="width:100%">
            <tr>


                <td colspan="3" style="text-align: left; padding:10px;">
                    <span><img style=" padding-top: 0px;" width="40px" height="30px;"   src="{!! asset(Session::get('LOGO_PATH')) !!}"></span>
                    <span  style="font-size: 20px;font-weight: bolder;">  {{\Session::get('FULL_NAME')}}</span><br>

{{--                        <span style="font-size: 30px;"> {{$site_list->site_name}}</span><br>--}}

                </td>

                <td colspan="3" style="text-align: right; padding:10px;">
                    <span><img style=" padding-top: 0px;" width="200px" height="50px;"   src="{{ asset('image/edu.png') }}"></span>

                </td>


            </tr>


        </table>
    </div>

    <div style="text-align: center;">
        <h3>Money Receipt</h3>
    </div>

    <br>





    <div class="student-info">
        <table style="width:60%;">
            <tr>
                <th  style="text-transform: uppercase;font-size: 13px;text-align:left;">

                    @if ($student_info->full_name)
                        {{$student_info->full_name}}
                    @endif

                </th>
            </tr>

            <tr>
                <td>
                    Student ID:
                    @if ($student_info->username)
                        {{$student_info->username}}
                    @endif
                </td>

            </tr>


        </table>
    </div>






    <div>
        @foreach($student_detail as $key=>$item)

            <table>
                <tr>
                    @if ($item->department)
                    <td align="left" ><b> Department:</b> {{$item->department ? $item->department->name : ""}}</td>
                    @endif
                    <td align="left"><b> Class:</b> {{$item->stClass->class_name}}</td>
                    <td align="left"><b> Group:</b> {{$item->accGroup->group_name ?? "N/A"}}</td>
                    <td align="left"> <b>Section:</b> {{$item->section->section_name ?? "N/A"}}</td>
                </tr>
                <tr>
                    <td align="left"><b> Roll:</b> {{$item->student_roll_number ?? "N/A"}}</td>
                    <td align="left"><b> Shift:</b> {{$item->shift->shift_name ?? "N/A"}}</td>
                    <td align="left"><b> Version:</b> {{$item->version->version_name ?? "N/A"}}</td>

                </tr>

            </table>

        @endforeach

    </div>




    <div style="margin-top: 25px;">

        <table>
            <tr>

                <td align="left"><b> Transaction ID:</b> {{$voucher_list->order_id}}</td>
                <td align="left"><b> Transaction Date:</b> {{$voucher_list->created_at ?? "N/A"}}</td>
                <td align="left">
                    <b>Payment Type:</b>
                    @if ($voucher_list->academic_online_payment_method_id)
                        Online
                        ({{$voucher_list->academicOnlinePaymentMethod->name}})
                    @else
                        Cash in hand
                    @endif

                </td>
            </tr>

        </table>

    </div>




    <div class="voucher-list" style="margin-top: 20px;width: 100%;">
        <table style="width:100%;border-radius: 5px;">

            <thead>
                <tr>
                    <th style="width: 70%;" colspan="2">
                        Items
                    </th>
                    <th style="width: 20%;">
                       Amount
                    </th>
                </tr>
            </thead>
            


            <tbody>

            @foreach($voucher_list->eduStudentInvoice as $key=>$item)
                <tr>
                    <td class="first-column" colspan="2" style="padding: 7px;">
                        Order: {{$item->order_id}}
                    </td>
                    <td class="second-column" style="padding: 10px;"></td>
                </tr>
                @foreach($item->eduStudentInvoiceItem as $keys=>$items)

                    <tr>
                        <td class="first-column" colspan="2" style="padding: 3px;">
                            &nbsp;&nbsp;&nbsp;&nbsp;{{$items->itemDetail->item_name}}
                        </td>
                        <td class="second-column" style="text-align:right;"">
                            <span style="margin-right: 10px;">{{$items->payment_amount}}</span>
                        </td>
                    </tr>

                @endforeach
            @endforeach

            </tbody>


            <tfoot>
                <tr>
                    <td class="inword">
                        <b>In word :

                        @if($voucher_list->paid_amount)
                            {{ucwords( convertNumberToWord($voucher_list->paid_amount))}}
                        @else
                            {{ucwords( convertNumberToWord($voucher_list->paid_amount))}}
                        @endif
                        Only</b>
                    </td>
                    <td class="total" style="text-align:right"><b>Total</b></td>
                    <td class="total-amount" style="text-align:right"><b>{{$voucher_list->paid_amount}}</b></td>
                </tr>
            </tfoot>

        </table>
    </div>

    <div style="margin-top:20px;font-size:10px;">
        This is a computer generated document, signature is not required.<br>
        Software Developed and Maintenance by Edu world. www.theworld.com.bd
    </div>



</div>


</body>


<style>

    .student-info table{
        border-collapse: collapse;
    }

    thead{
        background-color: #B2D4ED;
        color:black;
        text-align: center;
    }

    .student-info table tr td{
        border-collapse: collapse;
        border:1px solid white;
        padding:5px;
    }

    .student-info table tr td{
        border-collapse: collapse;
        border:1px solid white;
    }

    .voucher-list table{
        border-collapse: collapse;
    }

    .voucher-list table thead tr th, .voucher-list table tfoot tr td{
        padding: 10px;
    }

    .voucher-list  table tr th{
        border:1px solid black;
    }


    .first-column{
        border-left:1px solid black;
    }

    .second-column{
        border-left:1px solid black;
        border-right:1px solid black;
    }

    .inword{
        border-left: 1px solid black;
        border-top: 1px solid black;
        border-bottom: 1px solid black;
    }

    .total{
        border-right: 1px solid black;
        border-top: 1px solid black;
        border-bottom: 1px solid black;
    }

    .total-amount{
        border: 1px solid black;
    }
    /*@page {*/
        /*size: Landscape;*/
        /*margin: 0px;*/
    /*}*/

    /*body {*/
        /*margin: 10px 10px 10px 10px;*/
    /*}*/

</style>
</html>