<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .th-bg {
            background-color: #87adbd;
            color: #FFFFFF;
        }

        .data-table td {
            border: 1px dotted #999999;
            text-align: center;
        }


    </style>

</head>
<body>

@include('default.site.layout.pdf-header')
.
<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="th-bg">
            <tr>
                <th style="width: 1px">S/L</th>
                <th>Name</th>
                <th>Roll</th>
                <th>Present Day</th>
                <th>Absent Day</th>
                <th>Present (%)</th>
            </tr>
        </thead>
        <tbody>
        @foreach($final_data as $key => $value)
            <tr>
                <td>{{$key+1}}</td>
                <td style="text-align: left; padding-left:5px">
                    <nobr>
                        {{$value['name'] ?? 'na'}}
                    </nobr>
                </td>
                <td>{{$value['roll'] ?? 'na'}}</td>
                <td>{{$value['present_count'] ?? 'na'}}</td>
                <td>{{$value['absent_count'] ?? 'na'}}</td>
                <td>{{$value['attendance_petcent'] ?? 'na'}}</td>
            </tr>
           
        @endforeach
        </tbody>
    </table>
</div>


</body>


<style>

    @page {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












