<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }
        .tittle {
            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
        }

        .data-table td {
            border: 1px dotted #999999;
            text-align: center;
        }


    </style>

</head>
<body>


@include('default.site.layout.pdf-header')

<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <td style="width: 1px">S/L</td>
            <td>Date</td>
            <td>In</td>
            <td>Out</td>
            <td>Late Status</td>

        </tr>
        </thead>


        <tbody>
        @foreach($st_att_list as $key => $value)

            <tr>
                <td>{{$sl++}}</td>
                <td> {{ date('d M Y',strtotime($value['present_date']))}}</td>
                <td>
                    {{$value['in_time'] ? date('h:i:s A',strtotime($value['in_time'])) : '--'}}
                </td>
                <td>
                    {{$value['out_time'] ? date('h:i:s A',strtotime($value['out_time'])) : '--'}}
                </td>

                <td>
                    {{getLateIntime($value['late_status'])}}
                </td>

            </tr>


        @endforeach
        </tbody>


    </table>
</div>


</body>


<style>

    @page {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












