<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Employees Payroll PDF</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        h2 {
            text-align: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }

        .bg-info {
            background-color: #5bc0de;
            color: #fff;
        }

        .error {
            text-align: center;
            color: red;
        }

        .total-row {
            color: red;
            font-weight: bold;
        }

        .badge-success {
            color: #468847;
        }

        .badge-danger {
            color: #f11c00;
        }
    </style>
</head>

<body>
    <div>



        <div class="headerco" style="width: 100%; ">
            <table style="width: 100%; border: none;">
                <tr>
                    <td style="width: 10%; text-align: left; border: none;">
                        <img style="text-align: center; padding-top: 0px;" width="70px" height="70px;"
                            src="{!! public_path(Session::get('LOGO_PATH')) !!}">
                    </td>
                    <td style="width: 100%; text-align:center;  padding-right:100px;  border: none;">
                        <span style="font-size:20px">{{ $site_info->site_name }}</span> <br>
                        {{ $site_info->address }}
                    </td>
                </tr>
            </table>
        </div>
        <div class="header-right" style="text-align: center">
            <strong>Student Fine Report </strong>
        </div>


        <div class="new" style="text-align: right">
            @if ($start_date && $end_date)
                <span
                    style="color: red">{{ \Carbon\Carbon::parse($start_date)->format('d M Y') . ' - ' . \Carbon\Carbon::parse($end_date)->format('d M Y') }}</span>
            @endif
        </div>
        @if ($StudentFineType->fine_type_name_key == 'attendance')
            <table>
                <thead>
                    <tr style="background-color: 	#c4c4c3">
                        <th>Sl</th>
                        <th>Student Name</th>
                        <th>Roll</th>
                        <th>Total days of Month</th>
                        <th>Total absent days</th>
                        <th>Total Fine Amount</th>
                        <th>Payment status</th>
                        <th>Issue Date</th>
                    </tr>
                </thead>

                <tbody>
                    @if ($StudentQuery->isEmpty())
                        <tr>
                            <td colspan="12" class="text-center error">
                                No data!
                            </td>
                        </tr>
                    @else
                        @foreach ($StudentQuery as $index => $student)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $student['full_name'] }}</td>
                                <td>{{ $student['student_full_roll_number'] }}</td>
                                <td>{{ $student['total_days_of_month'] }}</td>
                                <td>{{ $student['total_absent'] }}</td>
                                <td>{{ $student['student_total_fine'] }}</td>

                                <td>
                                    @if ($student['student_fine_payment_status'] == 1)
                                        <span style="color: rgb(15, 179, 116)">Paid</span>
                                    @else
                                        <span style="color: rgb(243, 49, 0)">Unpaid</span>
                                    @endif
                                </td>
                                <td>{{ $student['fine_collect_date'] }}</td>


                            </tr>
                        @endforeach


                    @endif
                </tbody>
            </table>
        @else
            <table>
                <thead>
                    <tr style="background-color: 	#c4c4c3">
                        <th>#</th>
                        <th>Name</th>
                        <th>Fine Type</th>
                        <th>Waiver</th>
                        <th>Total Fine</th>
                        <th>action</th>
                        <th>Issue Date</th>
                    </tr>
                </thead>

                <tbody>
                    @if ($StudentQuery->isEmpty())
                        <tr>
                            <td colspan="12" class="text-center error">
                                No data!
                            </td>
                        </tr>
                    @else
                        @foreach ($StudentQuery as $index => $student)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $student['full_name'] }}</td>
                                <td>{{ $student['fine_Type_name'] }}</td>
                                <td>{{ $student['student_fine_waiver'] }}</td>
                                <td>{{ $student['student_total_fine'] }}</td>
                                <td>Paid</td>
                                <td>{{ $student['fine_collect_date'] }}</td>

                            </tr>
                        @endforeach


                    @endif
                </tbody>
            </table>
        @endif

    </div>
</body>

</html>
