<!DOCTYPE html>
<html>
<head>
    @php($site=getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>


    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .st-image {
            text-align: center;
            width: 57px;
            height: 55px;
            border-radius: 10px;
            border: 1px solid #0b0b0b;
        }

        .txt-left {
            text-align: left;
        }
        .txt-center {
            text-align: center;
        }

        td{
            font-size: 10px;
        }
    </style>

</head>
<body>


@include('default.site.layout.pdf-header')


<table class="data-table" cellspacing="0" border="1" width="100%;">
    <thead>
    <tr>
        <th>S/L</th>
        {{--<th>Pic</th>--}}
        <th class="txt-left">
            <nobr>User Id</nobr>
        </th>
        <th class="txt-left">
            <nobr>Name</nobr>
        </th>
        <th class="txt-center">
             Roll
        </th>
        <th class="txt-left">
            <nobr> Father Name</nobr>
        </th>
        <th class="txt-left">
            <nobr> M. Name</nobr>
        </th>
        <th class="txt-center">
            Shift
        </th>
        <th class="txt-center">
            Class
        </th>
        <th class="txt-center">
            Group & Sec.
        </th>
        <th class="txt-center">
            B. Group
        </th>
        <th class="txt-left">
            DOB
        </th>
        <th class="txt-left">
            Mobile
        </th>
    </tr>
    </thead>

    <tbody>
    @foreach($card_data as $key => $value)
        <tr>
            <td class="txt-center">{{$key+1}}</td>
        {{--    <td>

                @if(file_exists(public_path("uploads").'/'.$value['student']['latest_photo']['name']))
                    <img class="st-image"
                         src="{{asset("uploads").'/'.$value['student']['latest_photo']['name']  ?? 'image-not.png'}}">
                @else
                    <img class="st-image"
                         src="{{asset("uploads").'/image-not.png'}}">
                @endif
            </td>--}}
            <td>
                {{$value['username'] ?? '--'}}
            </td>

            <td>
                <nobr>  {{$value['full_name'] ?? '--'}}  </nobr>
            </td>

            <td class="txt-center">
                {{$value['student_roll_number'] ?? '--'}}
            </td>

            <td class="txt-left">
                <nobr>  {{$value['father_name'] ??  '--'}}</nobr>
            </td>

            <td class="txt-left">
                <nobr>    {{$value['mother_name'] ?? '--'}}</nobr>
            </td>
            <td class="txt-center">
                {{$value['shift_name'] ?? '--'}}
            </td>
            <td class="txt-center">
                {{$value['class_name'] ?? '--'}}
            </td>
            <td class="txt-center">

                @if($value['group_name'])
                    {{$value['group_name'] }}
                @endif

                {{$value['section_name'] ?? '--'}}
            </td>
            <td class="txt-center">
                {{$value['blood_group'] ?? '--'}}
            </td>

            <td>
                <nobr>{{ date('d M Y', strtotime($value['date_of_birth'] ?? '1970-12-16'))}}</nobr>
            </td>
            <td>
                 {{$value['contact_number'] ?? '--'}}
            </td>
        </tr>
    @endforeach

    </tbody>
</table>


</body>


<style>

    @page {
        size: landscape;
        margin: 0px;

    }

    body {
        margin: 5px;
    }


</style>

</html>












