<!DOCTYPE html>
<html>
<head>
    @set('site',getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {

            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
        }

        .table-div{
            width:80%;
            margin-left:auto;
            margin-right:auto;
        }

        table {
            border-collapse: collapse;
            font-size:12px;
        }


        .data-table th, .data-table td {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: center;


        }
        .data-table td {
            font-size:11px;

        }
        .hideclass{
            /*display: none;*/
            font-size:0 !important;
            height:0 !important;
            margin:0;
            padding:0;
            border-bottom: 1px solid white !important;
        }

    </style>

</head>
<body>


@include('default.site.layout.pdf-header')



<div class="table-div">
    <table class="data-table" style="margin-top:15px;">

        <thead>
            <tr>
                @if (count($student_count_array)>1)
                    <th width="100">Version</th>
                @endif

                <th width="100">Shift</th>

                @if ($department_present)
                    <th width="150">Department</th>
                @endif

                <th width="150">Class</th>

                @if ($class_group_present)
                    <th width="100">Group</th>
                @endif

                @if ($section_present)
                    <th width="100">Section</th>
                @endif


            </tr>
        </thead>


        <tbody>

            @foreach($student_count_array as $key => $value)

                @if (count($student_count_array)>1)
                    <tr>
                        <td rowspan={{$value['version_array_row'] + 1}}>
                            <label>Version : {{$value['version_name']}}</label><br>
                            Total Student: <label>{{$value['version_student_count']}}</label>
                        </td>

                        {{--@if ($department_present)--}}
                        {{--<td></td>--}}
                        {{--@endif--}}
                        {{--<td></td>--}}

                        {{--@if ($class_group_present)--}}
                        {{--<td></td>--}}
                        {{--@endif--}}

                        {{--@if ($section_present)--}}
                        {{--<td></td>--}}
                        {{--@endif--}}
                    </tr>
                @endif


                @foreach($value['shift_array'] as $keys => $values)

                    <tr dontbreak="1">
                        <td rowspan={{$values['shift_array_row'] + 1}}>
                            <div class="text-center">
                                <label>{{$values['shift_name']}} - {{$values['shift_student_count']}}</label>
                            </div>
                        </td>

                        @if ($department_present)
                            <td class="hideclass"></td>
                        @endif
                        <td class="hideclass"></td>

                        @if ($class_group_present)
                            <td class="hideclass"></td>
                        @endif

                        @if ($section_present)
                            <td class="hideclass"></td>
                        @endif
                    </tr>



                    @foreach($values['department_array'] as $keystp => $valuestp)

                        <tr>
                            <td rowspan={{$valuestp['count_class_row'] + 1}}>
                                <div class="text-center">
                                    <label>{{$valuestp['department_name']}} - {{$valuestp['department_student_count']}}</label>
                                </div>
                            </td>

                            <td class="hideclass"></td>
                            @if ($class_group_present)
                                <td class="hideclass"></td>
                            @endif

                            @if ($section_present)
                                <td class="hideclass"></td>
                            @endif
                        </tr>




                        @foreach($valuestp['class_array'] as $keyst => $valuest)

                            <tr>
                                <td rowspan={{$valuest['count_class_row'] + 1}}>
                                    <div class="text-center">
                                        <label>{{$valuest['class_name']}} - {{$valuest['class_student_count']}}</label>
                                    </div>
                                </td>
                                @if ($class_group_present)
                                    <td class="hideclass"></td>
                                @endif

                                @if ($section_present)
                                    <td class="hideclass"></td>
                                @endif
                            </tr>



                            @foreach($valuest['class_group_array'] as $keystr => $valuestr)

                                <tr>
                                    <td rowspan={{$valuestr['count_class_group_row'] + 1}}>
                                        <div class="text-center">
                                            <label>{{$valuestr['group_name']}} - {{$valuestr['class_group_student_count']}}</label>
                                        </div>
                                    </td>
                                    @if ($section_present)
                                        <td class="hideclass"></td>
                                    @endif
                                </tr>


                                @foreach($valuest['section_array'] as $keystrs => $valuestrs)

                                    <tr>
                                        <td rowspan={{$valuestrs['count_class_row'] + 1}}>
                                            <div class="text-center">
                                                <label>{{$valuestrs['section_name']}} - {{$valuestrs['class_section_count']}}</label>
                                            </div>
                                        </td>
                                    </tr>

                                @endforeach
                            @endforeach



                            @foreach($valuest['section_array'] as $keystrs => $valuestr)


                                <tr>

                                    @if ($class_group_present)
                                        <td>
                                            <div class="text-center">
                                                <label>N/A</label>
                                            </div>
                                        </td>
                                    @endif

                                    <td>
                                        <div class="text-center">
                                            <label>{{$valuestr['section_name']}} - {{$valuestr['class_section_count']}}</label>
                                        </div>
                                    </td>
                                </tr>

                            @endforeach
                        @endforeach
                    @endforeach



                    @foreach($values['class_array'] as $keyst => $valuest)

                        <tr>
                            <td rowspan={{$valuest['count_class_row'] + 1}}>
                                <div class="text-center">
                                    <label>{{$valuest['class_name']}} - {{$valuest['class_student_count']}}</label>
                                </div>
                            </td>


                            @if ($class_group_present)
                                <td class="hideclass"></td>
                            @endif

                            @if ($section_present)
                                <td class="hideclass"></td>
                            @endif
                        </tr>



                        @foreach($valuest['class_group_array'] as $keystr => $valuestr)

                            <tr>
                                <td rowspan={{$valuestr['count_class_group_row'] + 1}}>
                                    <div class="text-center">
                                        <label>{{$valuestr['group_name']}} - {{$valuestr['class_group_student_count']}}</label>
                                    </div>
                                </td>



                                @if ($section_present)
                                    <td class="hideclass"></td>
                                @endif
                            </tr>



                            @foreach($valuestr['section_array'] as $keystrs => $valuestrs)

                                <tr>
                                    <td>
                                        <div class="text-center">
                                            <label>{{$valuestrs['section_name']}} - {{$valuestrs['class_section_count']}}</label>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @endforeach





                        @foreach($valuest['section_array'] as $keystrs => $valuestr)

                            <tr>
                                @if ($class_group_present)
                                    <td>
                                        <div class="text-center">
                                            <label>N/A</label>
                                        </div>
                                    </td>
                                @endif

                                <td>
                                    <div class="text-center">
                                        <label>{{$valuestr['section_name']}} - {{$valuestr['class_section_count']}}</label>
                                    </div>
                                </td>
                            </tr>



                        @endforeach

                    @endforeach


                @endforeach


            @endforeach

        </tbody>



    </table>
</div>




</body>


<style>

    /*@page {*/
        /*size: Landscape;*/
        /*margin: 0px;*/
    /*}*/

    /*body {*/
        /*margin: 10px 20px 50px 20px;*/
    /*}*/


</style>

</html>












