<!DOCTYPE html>
<html>
<head>
    @set('site',getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {

            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
        }

        .data-table td, th {
            border: 1px dotted #999999;
            text-align: center;
        }

        .data-table th {
            border: 1px solid #999999;
            text-align: center;
        }


    </style>

</head>
<body>


@include('default.site.layout.pdf-header')


<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <th>S/L</th>
            <th>
                Student’s Name.
                Father’s Name &
                Mother’s Name.
            </th>
            @if($username)
            <th>Username</th>
            @endif
            <th>Gender, <br> DOB</th>
           
            <th>
                @if($class)
                    Class,
                @endif
                @if($group)
                    Group,
                @endif
                Section and Roll
            </th>
            @if($subject || $sub_code)
                <th>Subjects</th>
            @endif
            @if($optional )
                <th>Optional</th>
            @endif
            @if($address)
                <th>
                    Address,
                    District,
                </th>
            @endif
            @if($contact_number )
                <th> Mobile No</th>
            @endif




            @if($has_previous_institute )
                <th>Institution Name</th>
            @endif
            @if($passRollReg)
                <th>Pass Year, Roll, <br>
                    Board, <br>Reg.No
                </th>
            @endif

            @if($picture )
                <th>Picture</th>
            @endif

            @if($signature )
                <th>Signature</th>
            @endif
            @if($comment)
                <th>Comment</th>
            @endif
        </tr>
        </thead>


        <tbody>
        @foreach($student_history as $key => $value)

            <tr>
                <td>{{$key +1}}</td>
                <td>
                    {{$value['full_name'] ?? 'na'}}
                    <br>
                    {{$value['father_name'] ?? 'na'}}
                    <br>
                    {{$value['mother_name'] ?? 'na'}}
                   
                </td>
                @if($username)
                <td>
                    {{ $value['username']  ?? 'n/a'}}
                </td>
                @endif
                <td>
                    {{ $value['gender'] ?? '--'}} <br/>
                    {{  date("d M Y",strtotime($value['date_of_birth']))}}
                </td>
                
                <td>
                    @if($class)
                        {{ $value['class_name']  ?? 'n/a'}} <br>
                    @endif

                    @if ($group && $value['group_name'])
                        {{   $value['group_name']  ?? '--'}}
                        <br>
                    @endif
                    @if ( $value['section_name'])
                        {{   $value['section_name'] ?? '--'}}
                        <br>
                    @endif
                    {{$value['student_roll_number'] ?? '--' }}

                </td>
                @if($subject || $sub_code)
                    <td>
                         @if(count($value['subject_list']))
                            @foreach($value['subject_list'] as $k=>$sub)
                            

                                 @if($subject && $sub->subject_name)
                                    {{ $sub->subject_name }} -
                                @endif

                               @if($sub_code && $sub->subject_code)
                                    {{$sub->subject_code}}
                                @endif

                                @if(!$loop->last),
                                @endif
                             @endforeach
                        @endif
                        {{-- @if(count($value['general_subjects']))
                            @foreach($value['general_subjects'] as $k=>$sub)

                                @if($subject && $sub->subject_name)
                                    {{ $sub->subject_name }} -
                                @endif

                                @if($sub_code && $sub->subject_code)
                                    {{$sub->subject_code}}
                                @endif

                                @if(!$loop->last),
                                @endif
                            @endforeach
                        @endif
                        @if(count($value['compulsory_subjects']))
                            @foreach($value['compulsory_subjects'] as $k=>$sub)
                                @if($subject && $sub->subject_name)
                                    {{ $sub->subject_name }}
                                @endif
                                @if($sub_code && $sub->subject_code)
                                    {{$sub->subject_code}}
                                @endif
                                @if(!$loop->last),
                                @endif
                            @endforeach
                        @endif --}}
                    </td>
                @endif

                @if($optional)
                    <td>

                        @if(count($value['optional_subjects']))
                            @foreach($value['optional_subjects'] as $k=>$sub)

                                @if($subject && $sub->subject_name)
                                    {{ $sub->subject_name }}
                                @endif
                                @if($sub_code && $sub->subject_code)
                                    {{$sub->subject_code}}
                                @endif
                                @if(!$loop->last),
                                @endif
                            @endforeach
                        @endif
                    </td>
                @endif
                @if($address)

                    <td>
                        {{ $value['address'] ?? '--'}} <br>
                        {{ $value['permanent_district'] ?? ''}} <br>
                    </td>
                @endif


                @if($contact_number )
                    <td>    {{$value['contact_number'] ?? '--'}}</td>
                @endif

                @if($has_previous_institute )
                    <td>{{$value['previous_institute_name']}}</td>
                @endif

                @if($passRollReg)
                    <td>
                        {{$value['passing_year'] ?? '--'}} ,
                        {{$value['board_roll_number'] ?? '--'}}, <br>
                        {{$value['board'] ?? '--'}}, <br>
                        {{$value['board_registration_number'] ?? '--'}}
                    </td>
                @endif

                @if($picture )
                    <td>
                        <img style="padding-top: 0;" width="50px" height="50px;" src="{{ public_path($value['picture']) }}">
                    </td>
                @endif

                @if($signature )
                    <td></td>
                @endif
                
                @if($comment)
                    <td></td>
                @endif

            </tr>


        @endforeach
        </tbody>


    </table>
</div>


</body>


<style>
    @if($report_type)
        @page {
        size: a4;
        margin: 0px;
    }

    @else
      @page {
        size: Landscape;
        margin: 0px;
    }

    @endif

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












