<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$title_view}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

    </style>

</head>
<body>

<div>

    @include('default.site.layout.pdf-header')

    <table width="100%">


        <tr>
            {{-- <td colspan="2" valign="top" align="left"><b> Username:</b> {{$payment_details['username']}}</td> --}}
            <td colspan="2" valign="top" align="left"><b> Name:</b> {{$payment_details['candidate_name']}}</td>
            <td align="left"><b>Board Roll:</b> {{$payment_details['roll']}}</td>
            <td align="left"><b>Contact Number:</b> {{$payment_details['contact_number']}}</td>

        </tr>
        {{-- <tr>
            <td colspan="2" valign="top" align="left"><b> Father Name:</b> {{$payment_details['father_name']}}</td>
            <td colspan="2" valign="top" align="left"><b> Mother Name:</b> {{$payment_details['mother_name']}}</td>
        </tr> --}}
        <tr>
            <td align="left"><b> Class:</b> {{$payment_details['class_name']}}</td>
            <td align="left"><b> Group:</b> {{$payment_details['group_name']}}</td>
            {{-- <td align="left"> <b>Section:</b> {{$payment_details['section_name']}}</td> --}}
        </tr>
        <tr>
            <td align="left"><b> Invoice By:</b> Admin</td>
            <td align="left"><b> Invoice Date:</b> {{$payment_details['invoice_date']}}</td>
            <td align="left"><b> Transaction ID:</b> {{$payment_details['transaction_id']}}</td>
            <td align="left"><b> Invoice No:</b> {{$payment_details['invoice_id']}}</td>
        </tr>
        <tr>
            <td align="left"><b> Payment By:</b> {{$payment_details['transaction_gateway']}}</td>
            <td align="left"><b> payment date:</b> {{$payment_details['payment_date']}}</td>
        </tr>

    </table>


    <table width="100%">

        <thead style="background-color: #e2e6e9;">
        <tr>
            <td class=""></td>
            <th align="left">Fee Items</th>
            <th align="center" class="amount-right">Amount</th>
        </tr>
        </thead>
        <tbody>

        @if(($slip_owner == 'student' && $site_info->show_subhead_in_payment_slip) || $slip_owner != 'student')
            @foreach($payment_details['fee_list'] as $key=>$value)
                <tr style="height: 2px;">
                    <td class=""></td>
                    <td style="padding:0px;">{{$value['academic_fee_sub_head']}}</td>
                    <td style="padding:0px;" class="amount-right">{{number_format($value['amount'],2)}}</td>
                </tr>
            @endforeach
        @else
            <tr style="height: 2px;">
                <td class=""></td>
                <td style="padding:0px;">Admission Fee</td>
                <td style="padding:0px;" class="amount-right">{{number_format($payment_details['total_paid_amount'],2)}}</td>
            </tr>
        @endif

        {{-- <tr class="table_tr">
            <td class=""></td>
            <td  class="amount-right">Waiver(TK)</td>
            <td  class="amount-right">{{$payment_details['waiver']}}</td>
        </tr> --}}
        {{-- <tr class="table_tr">
            <td class=""></td>
            <td class="amount-right">Special Waiver(TK)</td>
            <td class="amount-right">{{$payment_details['special_waiver']}}</td>
        </tr>
        --}}
 
        <tr class="table_tr">
            <td class=""></td>
            <td class="amount-right">Extra Payment/Fine(TK)</td>
            <td class="amount-right">{{ number_format($payment_details['extra_fine'], 2) }}</td>
        </tr> 
        <tr class="table_tr">
            <td class="colorChange"></td>
            <td class="amount-right colorChange">Total(TK)</td>
            <td class="amount-right">{{number_format($payment_details['total_paid_amount'],2)}}</td>
        </tr>
    
        <tr class="table_tr">
            <td class="colorChange"></td>
            <td class="amount-right colorChange">Transation Amount(TK)</td>
            <td class="amount-right">{{number_format($payment_details['transaction_amount'],2)}}</td>
        </tr>
        <tr class="table_tr">
            <td class="colorChange"></td>
            <td class="amount-right colorChange">Gateway charge(TK)</td>
            <td class="amount-right">{{number_format($payment_details['gateway_charge'],2)}}</td>
        </tr>
        <tr class="table_tr">
            <td><b>In Word:</b> {{$payment_details['total_paid_amount_in_word']}} taka only</td>
            <td class="amount-right colorChange"><b>Payment received (Paid TK)</b></td>
            <td class="amount-right"><b>{{number_format($payment_details['total_paid_amount'],2)}}</b></td>
        </tr>
        </tbody>

    </table>
    <br><br><br>
    <table width="100%">
        <tr>
            <td align="left">
                {{--Print Date: {{date('d-m-Y h:i:s A',time())}}--}}
            </td>
            <td align="right" colspan="1">
                ------------------------<br>
                sign by authority
            </td>
        </tr>

    </table>
    <br> <br> <br>
    <table width="100%">
        <tr>
            <td>

            </td>

        </tr>
    </table>




</body>



<style>
    @page {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        border:1px dotted black;
    }
    .table_tr {
        background-color: #e2e6e9
    }

</style>
</html>