<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {

            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
        }

        .data-table td, th {
            border: 1px dotted #999999;
            text-align: center;
        }

        .data-table th {
            border: 1px solid #999999;
            text-align: center;
        }

        .image {
            width: 40px;
            height: 40px;
            border-radius: 5px;
        }


    </style>

</head>
<body>


@include('default.site.layout.pdf-header')


<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <th>S/L</th>
            <th>Student’s Name.
                Father’s Name &
                Mother’s Name.
            </th>
            <th>
                Picture
            </th>
            <th>
                Board Name
            </th>
            <th>
                Board Roll
            </th>

            {{--<th>Roll</th>--}}
            <th>Roll / Admission Roll</th>
            <th>
                Date of Birth &
                Mobile No
            </th>
            <th>Transaction ID</th>
            <th>Amount</th>

            <th>Date of Apply</th>
        </tr>
        </thead>


        <tbody>
        @foreach($student_list as $key => $value)

            <tr>
                <td>{{$key +1}}</td>
                <td>
                    {{$value->full_name ?? 'na'}}
                    <br>
                    {{ucwords($value->father_name ?? 'na')}}
                    <br>
                    {{ucwords($value->mother_name ?? 'na')}}
                </td>

                <td>
                    @if(file_exists(public_path("uploads").'/'.$value->student_image))

                    <img class="image"
                             src="{{public_path("uploads/".$value->student_image) }}">
                    @else
                        <img class="image"
                             src="{{public_path("uploads/").'image-not.png'}}">
                    @endif
                </td>
                <td>
                    @foreach ($value->siteStudentAdmissionEducationQualification as $board)
                   {{ $board->academicBoard->key_name}} <br>
                    @endforeach
                </td>
                <td>{{$value->board_roll_number}}</td>

                <td>

                    {{$value->student_roll_number ? $value->student_roll_number :
                    ($value->menual_form_number ? sprintf("%08d", $value->menual_form_number): '--')}}

                    {{--{{$value->student_roll_number?? '--'}}--}}
                    {{--{{$value->menual_form_number?? '--'}}--}}


                </td>


                <td>
                    @if($value->date_of_birth)
                        <nobr> {{ date('M d Y', strtotime($value->date_of_birth))}}</nobr>
                    @endif
                        <br>
                    {{$value->student_contact_number ?? '--'}}
                </td>
                <td>
                    {{$value->transaction_number ?? '--'}}
                </td>
                <td>
                    {{$value->transaction_amount ?? '--'}}
                </td>
                <td> <nobr> {{ date('M d Y h:i:s A', strtotime($value->created_at))}}</nobr>

                </td>

            </tr>


        @endforeach
        </tbody>


    </table>

</div>


</body>


<style>
    @page {
        size: Landscape;
        margin: 0px;
    }

    body {
        margin: 10px 10px 10px 10px;
    }

</style>
</html>
