@if(Auth::check())
    @php($validUser=request()->user())
@endif

<aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->

    <section class="sidebar">
        <!-- Sidebar user panel -->
        <div class="user-panel">
            <div class="pull-left image" style="min-height: 25px">
                @if( isset($validUser) && !$validUser->photos->isEmpty())
                    {!!  Html::image('uploads/'.$validUser->photos->last()->name, 'User Image',['class'=>'user-image img-circle']) !!}
                @endif
            </div>

            @if(Session::get('SITE_ID'))
                <div class="pull-left info">
                    <p>    {{Session::get('ACADEMIC_GROUP_NAME')}}
                        <br>

                    <span style="color: #fffef0; font-size: 10px; text-transform: capitalize"> {{ $validUser->roles[0]->name ?? 'not available' }} Panel</span>
                    </p>
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true"
                       aria-expanded="true"><span class="caret"></span> &nbsp;Switch</a>
                    <ul class="dropdown-menu">
                        @php($acc_group_list=getAllAcademicGroupsBySite(Session::get('SITE_ID')))
                        @if($acc_group_list)
                            @foreach($acc_group_list as $k=>$v)
                                <li>
                                    <a href="{{route('edu-impersonate-academic-group',[$v->id])}}">{{$v->academic_group_name}}</a>
                                </li>
                            @endforeach
                        @endif

                        <li role="separator" class="divider"></li>
                        <li>
                            <a href="{{route('back-to-main-panel')}}">
                                Back To Panel
                            </a>
                        </li>
                    </ul>
                </div>
            @elseif(Session::get('SITE_GROUP_ID'))

                <div class="pull-left info">
                    <p>    {{Session::get('ACADEMIC_GROUP_NAME')}}</p>
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true"
                       aria-expanded="true"><span class="caret"></span> &nbsp;Switch</a>
                    <ul class="dropdown-menu">

                        @php($acc_group_list=academicGroupsBySiteGroup(Session::get('SITE_GROUP_ID')))

                        @if($acc_group_list)
                            @foreach($acc_group_list as $k=>$v)
                                <li>
                                    <a href="{{route('edu-impersonate-academic-group',[$v->id])}}">{{$v->academic_group_name}}</a>
                                </li>
                            @endforeach
                        @endif

                        <li role="separator" class="divider"></li>
                        <li>
                            <a href="{{route('back-to-main-panel')}}">
                                Back To Panel
                            </a>
                        </li>
                    </ul>
                </div>
            @else

                <div class="pull-left info">
                    <p>

                        @if( isset($validUser))
                            {{ $validUser->first_name ?? ''}}
                            {{$validUser->last_name ?? '' }}
                        @endif
                            <br>
                    <span style="color: #fffef0; font-size: 10px; text-transform: capitalize"> ({{ $validUser->roles[0]->name ?? 'not available' }} Panel)</span>
                    </p>

                    <a href="#"><i class="fa fa-circle text-success"></i> Online</a>
                </div>

            @endif


        </div>

        @if(view()->exists('default.admin.layouts.sidebars.'. Session::get('ALIAS').'.'.$validUser->id))
            @include('default.admin.layouts.sidebars.'. Session::get('ALIAS').'.'.$validUser->id)
        @else
            {{generateSideBar()}}
            @include('default.admin.layouts.sidebars.'.Session::get('ALIAS').'.'.$validUser->id)

        @endif
    </section>
</aside>

