@extends('default.admin.layouts.master')


@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a></li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>
        </div>

        <edu-site-routine-component
        >
        </edu-site-routine-component>

    </div>

@endsection


@section('hscripts')


    <script>


        window.routes = {
            'route_class_timing_details': '{{ route('class-timing-details',['']) }}',
            'route_get_class_timing_name_list': '{{ route('get-class-timing-name-list') }}',
            'route_class_timing_create': '{{ route('class-timing-create') }}',
            'route_class_timing_update': '{{ route('class-timing-update',['']) }}',
            'route_class_timing_delete': '{{ route('class-timing-delete',['']) }}',
            'route_class_timing_copy': '{{ route('class-timing-copy') }}',


            'route_get_class_timing_details_list': '{{ route('get-class-timing-details-list',['']) }}',
            'route_class_timing_details_create': '{{ route('class-timing-details-create',['']) }}',
            'route_class_timing_details_update': '{{ route('class-timing-details-update',['']) }}',
            'route_class_timing_details_delete': '{{ route('class-timing-details-delete',['']) }}',


            'route_weekday_list_for_section': '{{ route('weekday-list-for-section') }}',
            'route_save_weekday': '{{ route('save-weekday-list-for-section') }}',
            'route_site_year_shift_department_class_session_version_condition_load': '{{ route('site-year-shift-department-class-session-version-condition-load',[Session::get('SITE_ID'),Session::get('ACADEMIC_GROUP_ID')]) }}',


            'route_get_employee_list': "{{route('site-employee-get-employees-by-department-class-subject-or-type')}}",
            'route_get_room_list': "{{route('site-room-get-room-list-with-building-and-floor-appended')}}",
            'route_get_routine_details': "{{route('routine-details-get-routine-details',['','','','','','','','',''])}}",
            'route_routine_details_regenerate': "{{route('site-routine-details-regenerate')}}",
            'route_routine_allocate': "{{route('routine-allocation-allocate-employee-subject-room')}}",
            'route_get_subject_for_routine': "{{route('site-routine-get-subjects-for-routine')}}",
            'route_routine_delete_allocation': "{{route('routine-allocation-delete-allocation',[''])}}",
            'route_site_routine_update': "{{route('site-routine-allocation-update')}}",
            'route_routine_save_assign_and_remove': "{{route('routine-allocation-assign-and-remove')}}",
            'route_routine_save_assign_and_retain': "{{route('routine-allocation-assign-and-retain')}}",
            'route_site_routine_check_auto_capability': "{{route('site-routine-check-auto-capability')}}",
            'route_site_routine_auto_generate': "{{route('site-routine-auto-generate')}}",

            'route_routine_pdf_report': "{{route('routine-report-get-routine-report',['','','','','','','','',''])}}",


            'route_site_routine_get_subject_with_weekly_class': "{{route('site-routine-get-subject-with-weekly-class')}}",
            'route_site_routine_save_subject_weekly_class': "{{route('site-routine-save-subject-weekly-class')}}",

            'route_site_routine_get_employee_weekly_class': '{{ route('site-routine-get-employee-weekly-class') }}',
            'route_site_employee_get_employee_assigned_subject_by_version_year_shift': '{{ route('site-employee-get-employee-assigned-subject-by-version-year-shift') }}',
            'route_site_routine_save_employee_weekly_class': '{{ route('site-routine-save-employee-weekly-class') }}',


            'route_get_class_wise_routine_slot_by_date': '{{ route('routine-details-get-class-wise-routine-slot-by-date') }}',


            'route_site_routine_swap_cancel_available_teacher_to_swap': '{{ route('site-routine-swap-cancel-available-teacher-to-swap') }}',
            'route_site_routine_swap_cancel_swap_class': '{{ route('site-routine-swap-cancel-swap-class') }}',
            'route_site_routine_swap_cancel_cancel_class': '{{ route('site-routine-swap-cancel-cancel-class') }}',
            'route_site_routine_swap_cancel_revert_class': '{{ route('site-routine-swap-cancel-revert-class') }}',


        }
    </script>
@endsection

