<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Api Routes
|--------------------------------------------------------------------------
|
| Here is where you can register Api routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your Api!
|
*/

//admin panle api here.....

/*Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});*/


//Route::post('/broadcasting/auth', 'BroadCastingController')->middleware('auth:api');



Route::group(['namespace' => 'Api'], function () {
    Route::post('/api-login', 'LoginController@apiLogin')->name('api-login');
-
    Route::group(['namespace' => 'Dashboard', 'prefix' => 'dashboard'], function () {

        Route::get('get-dashboard-data', 'DashboardApiController@getDashboardData')->name('api-dashboard-get-dashboard-data');


    });


    Route::group(['namespace' => 'Academic', 'prefix' => 'academic'], function () {
        Route::get('get-board-list', 'AcademicApiController@getBoardList')->name('api-academic-get-board-list');
    });


    Route::group(['namespace' => 'Web', 'prefix' => 'web'], function () {


        Route::get('get-academic-data', 'AcademicApiController@getAcademicList')->name('api-web-get-academic-data');
        Route::get('get-division-list/{country_id}', 'AcademicApiController@getDivisionListByCountryID')->name('web-division-list-by-country-id');
        Route::get('get-district-list/{division_id}', 'AcademicApiController@getDistrictListByDivisionID')->name('web-district-list-by-division-id');
        Route::get('get-thana-list/{district_id}', 'AcademicApiController@getTanaListByDistrictID')->name('web-thana-list-by-district-id');

        //  Route::get('get-academic-data-by-academic-group/{id}', 'AcademicApiController@getAcademicDataByGroup')->name('api-web-get-academic-data-by-academic-group');
        Route::post('edu/save-application', 'EduApiController@saveApplication')->name('api-web-save-newsite-application');

    });

    Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {
        Route::group(['namespace' => 'Web', 'prefix' => 'web'], function () {
            Route::group(['namespace' => 'Setting', 'prefix' => 'setting'], function () {

                Route::group(['prefix' => 'event'], function () {
                    Route::get('get-event-list-with-pagination', 'EventApiController@getEventGalleryListWithPagination')->name('api-website-event-get-event-list-with-pagination');
//                    Route::get('get-video-list-with-pagination-test', 'EventApiController@getEventGalleryListWithPaginationTest')->name('api-website-event-get-event-list-with-pagination-test');
                    Route::get('get-event-details/{id}', 'EventApiController@getEventDetails')->name('api-website-setting-event-get-event-details');

                    Route::post('create', 'EventApiController@create')->name('api-website-event-create-event');
                    Route::post('update', 'EventApiController@update')->name('api-website-event-update-event');
                    Route::post('delete/{id}', 'EventApiController@delete')->name('api-website-event-delete-event');

                });

                Route::group(['prefix' => 'about'], function () {
                    Route::get('get-about-list-with-pagination', 'AboutUsController@getAboutListWithPagination')->name('api-website-event-get-about-list-with-pagination');
                    Route::get('get-about-details/{id}', 'AboutUsController@getAboutDetails')->name('api-website-setting-get-about-details');

                    Route::post('create', 'AboutUsController@create')->name('api-website-about-create');
                    Route::post('update', 'AboutUsController@update')->name('api-website-about-update');
                    Route::post('delete/{id}', 'AboutUsController@delete')->name('api-website-about-delete');

                });
                Route::group(['prefix' => 'message'], function () {
                    Route::get('get-message-list-with-pagination', 'MessageController@getMessageListWithPagination')->name('api-website-get-message-list-with-pagination');
                    Route::get('get-message-details/{id}', 'MessageController@getMessageDetails')->name('api-website-setting-get-message-details');

                    Route::post('create', 'MessageController@create')->name('api-website-message-create');
                    Route::post('update', 'MessageController@update')->name('api-website-message-update');
                    Route::post('delete/{id}', 'MessageController@delete')->name('api-website-message-delete');

                });

//                Route::group(['prefix' => 'video'], function () {
//                    Route::get('get-video-list-with-pagination', 'EventApiController@getVideoListWithPagination')->name('api-website-setting-video-get-video-list-with-pagination');
//                    Route::get('get-video-details/{id}', 'EventApiController@getVideoDetails')->name('api-website-setting-video-get-video-details');
//                    Route::post('create', 'EventApiController@createWebsiteVideo')->name('api-website-setting-video-create');
//                    Route::post('update', 'EventApiController@updateWebsiteVideo')->name('api-website-setting-video-update');
//                    Route::post('delete/{id}', 'EventApiController@deleteWebsiteVideo')->name('api-website-setting-video-delete');
//
//                });

//                Route::group(['namespace' => 'Video', 'prefix' => 'video'], function () {
//                    Route::get('get-video-list-with-pagination', 'VideoController@getVideoListWithPagination')->name('api-website-setting-video-get-video-list-with-pagination');
//                    Route::get('get-video-details/{id}', 'VideoController@getVideoDetails')->name('api-website-setting-video-get-video-details');
//                    Route::post('create', 'VideoController@create')->name('api-website-setting-video-create');
//                    Route::post('update', 'VideoController@update')->name('api-website-setting-video-update');
//                    Route::post('delete/{id}', 'VideoController@delete')->name('api-website-setting-video-delete');
//
//                });

                Route::group(['prefix' => 'menu'], function () {
                    Route::get('get-web-menu-list/{parent?}', 'MenuApiController@getWebMenu')->name('api-website-setting-menu-get-web-menu-list');
                    Route::post('update-web-menu', 'MenuApiController@updateWebMenu')->name('api-website-setting-menu-get-web-menu-update-web-menu');
                });

            });
        });
    });


    Route::group(['namespace' => 'Edu', 'prefix' => 'edu'], function () {

        Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {
            Route::get('get-application-list', 'NewSiteApplicationApiController@getList')->name('api-edu-site-get-application-list');
            Route::get('application/{id}', 'NewSiteApplicationApiController@getTheApplication')->name('api-edu-site-get-the-application');
            Route::post('application/update', 'NewSiteApplicationApiController@update')->name('api-edu-site-application-update');
            Route::get('application/delete/{id}', 'NewSiteApplicationApiController@delete')->name('api-edu-site-application-delete');
        });


        Route::group(['namespace' => 'Menu', 'prefix' => 'menu'], function () {

            Route::get('edu-menu-get-menu-list', 'MenuApiController@getMenusList')->name('api-edu-menu-get-menu-list');
            Route::post('get-menu-by-search', 'MenuApiController@getMenuBySearch')->name('api-edu-menu-get-menu-by-search');
            Route::get('edu-menu-get-menu-for-list', 'MenuApiController@getMenuForList')->name('api-edu-menu-get-menu-for-list');
            Route::get('edu-menu-get-displayable-menu-list', 'MenuApiController@displayableMenusList')->name('api-edu-menu-get-displayable-menu-list');
            Route::get('get-position-list-for-parent-menu', 'MenuApiController@getPositionForParentMenu')->name('api-get-position-list-for-parent-menu');


            Route::post('edu-menu-create', 'MenuApiController@createMenu')->name('api-edu-menu-create');
            Route::put('edu-menu-update/{id}', 'MenuApiController@updateMenu')->name('api-edu-menu-update');
            Route::put('delete/{id}', 'MenuApiController@deleteMenu')->name('menu-delete');

        });
    });

    Route::group(['namespace' => 'Payment', 'prefix' => 'payment'], function () {
        Route::post('check-trans-id', 'PaymentApiController@checkTransactionId')->name('site-student-payment-check-trans-id');
    });

});

Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {
    Route::group(['namespace' => 'Academic', 'prefix' => 'academic'], function () {

        Route::group(['prefix' => 'period-type'], function () {

            // Route::get('get-period-type-for-site', 'PeriodTypeController@getPeriodTypeForSite')->name('site-academic-period-type-get-period-type-for-site');
        });
    });
});


Route::group(['namespace' => 'Api\Module', 'prefix' => 'sub-module'], function () {
    Route::get('get-sub-module-list', 'SubModuleApiController@getSubModuleList')->name('api-get-sub-module-list');

    Route::post('save-menu-ids', 'SubModuleApiController@saveMenuIds')->name('api-save-menu-ids-for-sub-module');
});


//Route::get('profile','Api\UserController@profile');


/// student panel api

Route::group(['namespace' => 'Api'], function () {
    //Route::get('check-user-auth', 'WebSiteApiController@checkUserAuth')->name('check-site-user-auth'); 

    Route::post('api-login', 'LoginController@apiLogin')->name('api-login'); 
    

    Route::post('api-logout', 'LogoutController@apiLogout')->name('api-logout'); 
    Route::get('get-user-read-unread-notification', 'UserApiController@getUserReadUnreadNotificaion')->name('site-user-api-get-user-read-unread-notification'); 
    Route::get('get-user-all-notification', 'UserApiController@getUserAllNotificaion')->name('site-user-api-get-user-all-notification'); 
    Route::get('read-notification', 'UserApiController@readNotification')->name('site-user-api-read-notification'); 

    Route::post('get-user-location', 'UserApiController@getUserLocation')->name('site-user-api-get-user-location'); 
   
    Route::group(['namespace' => 'StudentPanel', 'prefix' => 'student'], function () {
        Route::get('get-student-subject-list', 'AcademicApiController@getStudentAcademicSubjectListForApi')->name('get-api-student-subject-list'); 
        Route::get('get-student-profile', 'AcademicApiController@getStudentProfileForApi')->name('get-api-student-profile'); 
        Route::get('get-student-calendar', 'AcademicApiController@getStudentAcademicCalendarForApi')->name('get-api-student-calendar'); 
   
        Route::get('get-student-date-wise-attendance-list', 'AttendanceApiController@getDataWiseAttendanceListForApi')->name('site-student-panel-api-get-student-date-wise-attendance'); 
   
        Route::get('get-period-type-for-api', 'AttendanceApiController@getPeriodTypeForApi')->name('site-student-panel-api-get-period-type'); 
        Route::get('get-student-routine-period-list', 'AttendanceApiController@getRoutinePeriodListForApi')->name('site-student-panel-api-get-routine-period-list'); 
        Route::get('get-student-routine-pdf', 'AttendanceApiController@getRoutinePdfApi')->name('site-student-panel-api-get-routine-pdf'); 
     
        Route::get('get-student-history-list', 'StudentExamResultApiController@siteStudentAllHistoryListForApi')->name('site-student-panel-api-get-student-history-list'); 
        Route::post('get-exam-type-list', 'StudentExamApiController@getExamTypeListForStudenApi')->name('site-student-panel-api-get-exam-subject-routine-list'); 
        Route::post('get-exam-subject-routine-list', 'StudentExamApiController@getExamSubjectRoutineList')->name('site-student-panel-api-get-exam-type-list'); 
        Route::post('get-exam-admit-card', 'StudentExamApiController@studentExamDetailForAdmitCardPdfFroApi')->name('site-student-panel-api-get-exam-admit-card'); 
      
        Route::post('get-student-api-primary-result-list', 'StudentExamResultApiController@getStudentPrimaryResultListForStudentApi')->name('site-student-panel-api-get-primary-result-list-student-api'); 
        Route::post('get-student-api-primary-result-details', 'StudentExamResultApiController@getPrimaryResultTypeResultDetailForStudentApi')->name('site-student-panel-api-get-primary-result-details-student-api'); 
        Route::post('get-student-api-primary-result-details-pdf', 'StudentExamResultApiController@getPrimaryResultTypeResultDetailForStudentApiPdf')->name('site-student-panel-api-get-primary-result-details-pdf-student-api'); 
     
     //   Route::get('get-student-bank-slip-pdf', 'StudentPaymentController@getStudentBankSlipPdfForApi')->name('site-student-panel-api-get-student-bank-slip-pdf'); 
        Route::get('get-student-demand-slip', 'StudentPaymentController@getDemadSlipForApi')->name('site-student-panel-api-get-student-demand-slip'); 
        Route::post('get-student-demand-slip-pdf', 'StudentPaymentController@getDemadSlipPdfForApi')->name('site-student-panel-api-get-student-demand-slip-pdf'); 
        Route::post('get-student-bank-slip-pdf', 'StudentPaymentController@getBankSlipPdfForApi')->name('site-student-panel-api-get-student-bank-slip-pdf'); 
       
        Route::get('get-payment-method-list', 'StudentPaymentController@paymentMethodListForApi')->name('site-student-panel-api-get-payment-method-list'); 
        Route::post('create-online-payment-request', 'StudentPaymentController@createOnlinePaymentRequest')->name('site-student-panel-api-create-online-payment-request'); 
        Route::post('verify-payment-transaction', 'StudentPaymentController@verifyPaymentTransaction')->name('site-student-panel-api-verify-payment-transaction'); 
    
        Route::get('get-payment-list', 'StudentPaymentController@getPaymentList')->name('site-student-panel-api-get-payment-list');
        Route::get('get-site-payment-slip/{voucher_no}', 'StudentPaymentController@getSitePaymentSlip')->name('site-student-panel-api-get-site-payment-slip');

        Route::get('get-student-helpdesk-list', 'StudentHelpDeskController@getStudentHelpDeskList')->name('get-student-panel-api-helpdesk-list'); 
     
        Route::get('get-active-quiz-list-for-student', 'StudentQuizController@getActiveQuizListForStudent')->name('get-student-panel-api-active-quiz-list-for-student'); 
        Route::post('student-quiz-start', 'StudentQuizController@quizStartByStudnet')->name('get-student-panel-api-quiz-start'); 
        Route::get('get-quiz-question-list-for-student', 'StudentQuizController@getQuizQuestionListForStudent')->name('get-student-panel-api-quiz-question-list-for-student'); 
        Route::post('quiz-answer-silent-save-for-student', 'StudentQuizController@studentQuizAnswerSilentSubmit')->name('get-student-panel-api-quiz-answer-silent-save'); 
        Route::post('quiz-answer-end-save-for-student', 'StudentQuizController@studentQuizAnswerSubmit')->name('get-student-panel-api-quiz-answer-end-save'); 
      
        Route::get('get-active-quiz-routine-list', 'StudentQuizController@getActiveQuizRoutineList')->name('get-student-panel-api-active-quiz-routine-list'); 
        Route::get('get-previews-quiz-report-list', 'StudentQuizController@getPreviewsQuizReportListForStudent')->name('get-student-panel-api-previews-quiz-report-list'); 
        Route::get('get-student-message-list', 'StudentMessageController@getMessageList')->name('get-student-panel-api-student-message-list'); 
    

        // sonaliPay api
        //Route::post('get-student-payment-base-page-for-sonalipay-transaction', 'SiteStudentTransactionController@getPaymentDetailsForSonaliPayTransaction')->name('get-student-payment-base-page-for-sonali-transaction');

    
    });

    Route::group(['namespace' => 'EmployeePanel', 'prefix' => 'employee'], function () {
      
        Route::get('get-academic-group-list', 'AcademicApiController@getAcademicGroupList')->name('get-employee-panel-api-academic-group-list'); 
        Route::get('get-employee-profile', 'AcademicApiController@getEmployeeProfileForApi')->name('get-employee-panel-api-profile'); 
        Route::get('get-academic-version-year-shift-list', 'AcademicApiController@getAcademicVersionYearShiftList')->name('get-employee-panel-api-academic-version-year-shift-list'); 
        Route::get('get-version-year-shift-based-department-class', 'AcademicApiController@getYearVersionAndShiftBasedDepartmentClass')->name('get-employee-panel-api-version-year-shift-based-department-class'); 
        Route::get('get-version-year-shift-based-section-or-class-group-session-by-class', 'AcademicApiController@getVersionYearShiftBasedSectionsOrClassGroupsAndSessionByClass')->name('get-employee-panel-api-version-year-shift-based-section-or-class-group-session-by-class'); 
        Route::get('get-site-class-base-section', 'AcademicApiController@getSiteClassBaseSection')->name('get-employee-panel-api-site-class-base-section'); 
       
        Route::get('get-period-type-list', 'AcademicApiController@getPeriodTypeForApi')->name('get-employee-panel-api-period-type-list'); 
      
        Route::get('get-employee-helpdesk-list', 'EmployeeHelpDeskApiController@getEmployeeHelpDeskList')->name('get-employee-panel-api-helpdesk-list'); 

        Route::get('get-employee-routine-report-pdf', 'EmployeeRoutineApiController@getEmployeeRoutineReportPdf')->name('get-employee-routine-report-pdf'); 
      
        Route::get('get-site-department-class-base-examination-list-by-employee', 'EmployeeExamAttendanceApiController@getSiteDepartmentClassBaseExaminationList')->name('get-employee-panel-api-site-department-class-base-examination-list'); 
        Route::get('get-site-examination-base-subject-list-by-employee', 'EmployeeExamAttendanceApiController@getSiteExaminationBaseSubjectList')->name('get-employee-panel-api-site-examination-base-subject-list'); 
        Route::get('get-site-base-attendance-paper-list-by-employee', 'EmployeeExamAttendanceApiController@getSiteEmployeeBaseAnswerPaperList')->name('get-employee-panel-api-site-employee-base-attendance-paper-list'); 
        Route::get('get-site-exam-type-list', 'EmployeeExamAttendanceApiController@getSiteSubjectWiseExamTypeList')->name('get-employee-panel-api-site-exam-type-list'); 

        Route::get('get-site-student-list-for-attendance-by-employee', 'EmployeeExamAttendanceApiController@getSiteStudentListForAttendanceApi')->name('get-employee-panel-api-site-student-list-for-attendance'); 
        Route::post('site-student-exam-attendance-submit-by-employee', 'EmployeeExamAttendanceApiController@siteStudentExamAttendanceSubmit')->name('get-employee-panel-api-site-student-exam-attendance-submit'); 
      
        Route::get('get-site-employee-base-student-marks-entry-list', 'EmployeeExamMarkEntryApiController@getSiteEmployeeBaseStudentMarksEntryList')->name('get-employee-panel-api-site-employee-base-student-marks-entry-list'); 
        Route::post('site-student-marks-entry-submit-by-employee', 'EmployeeExamMarkEntryApiController@siteStudentMarksEntrySubmitByEmployee')->name('get-employee-panel-api-site-student-marks-entry-submit-by-employee'); 
        Route::get('get-student-exam-mark-list-for-employee', 'EmployeeExamMarkEntryApiController@studetnsSubjectMarkListPdf')->name('get-employee-panel-api-student-exam-mark-list-for-employee'); 
      
        // my attendance
        Route::get('get-my-attendance-list-for-employee', 'MyAttendanceApiForEmployeeController@getEmployeeIndividualAttendance')->name('get-employee-panel-api-my-attendance-list-for-employee'); 
    
        Route::post('check-employee-attendace-activity', 'MyAttendanceApiForEmployeeController@checkEmployeeAttendanceActivityForApi')->name('get-employee-panel-api-check-employee-attendace-activity'); 
        Route::post('submit-employee-geo-location-attendance', 'MyAttendanceApiForEmployeeController@submitEmployeeGeoLocationAttendance')->name('get-employee-panel-api-submit-employee-geo-location-attendance'); 
      
        // student attendance
        Route::get('get-site-student-attendance-list', 'StudentAttendanceApiForEmployeeController@getSiteStudentAttendanceList')->name('get-employee-panel-api-student-student-attendance-list'); 
        Route::get('get-site-periodic-list', 'StudentAttendanceApiForEmployeeController@getSiteStudentPeriodicAttendanceList')->name('get-employee-panel-api-site-periodic-list'); 
        Route::get('get-student-list-by-periodic-allocation', 'StudentAttendanceApiForEmployeeController@getStudentListByPeriodicAllocation')->name('get-employee-panel-apisite-student-list-by-periodic-allocation');
        Route::post('save-student-periodic-attendance', 'StudentAttendanceApiForEmployeeController@savePeriodicStudentAttendance')->name('get-employee-panel-api-site-save-student-periodic-attendance');
       
        Route::get('get-employee-message-list', 'EmployeeMessageApiController@getEmployeeMessageList')->name('get-employee-panel-api-employee-message-list'); 
    
        // leave 
        Route::get('get-leave-type-and-leave-category-list', 'EmployeeLeaveApiController@getLeaveTypeLeaveCategoryList')->name('get-employee-panel-api-get-leave-type-and-leave-category-list'); 
        Route::get('get-leave-type-leave-category-wise-leave-day', 'EmployeeLeaveApiController@getLeaveTypeCategoryWiseEmployeeLeaveDays')->name('get-employee-panel-api-leave-type-leave-category-wise-leave-day'); 
        Route::post('create-employee-leave-aplication', 'EmployeeLeaveApiController@createEmployeeLeaveApplication')->name('employee-panel-api-create-employee-leave-aplication'); 
        Route::get('employee-leave-history-list', 'EmployeeLeaveApiController@getEmployeeLeaveHistoryList')->name('employee-panel-api-employee-leave-history-list'); 
        Route::get('employee-leave-balance-list', 'EmployeeLeaveApiController@getEmployeeLeaveBalanceList')->name('employee-panel-api-employee-leave-balance-list'); 
       
        
    });

});