<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Api Routes
|--------------------------------------------------------------------------
|
| Here is where you can register Api routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your Api!
|
*/


Route::group(['namespace' => 'Api'], function () {

    // cellfin api
    Route::group(['namespace' => 'Payment', 'prefix' => 'cellfin'], function () {
        Route::post('getFeeInfo', 'CellfinPaymentApiController@getFeeInfoForCellfin')->name('get-fee-info-for-cellfin');
        Route::post('payment', 'CellfinPaymentApiController@acceptPaymentInfoInCellfin')->name('accept-payment-info-in-cellfin');
    });

    /// soanli pay api
    Route::group(['namespace' => 'Payment', 'prefix' => 'sonali-pay'], function () {
        Route::post('data-update', 'SonaliPayApiController@dataUpdateForSonaliPay')->name('data-update-for-sonali-pay');
        //  Route::post('admission-payment-update', 'SonaliPayApiController@admissionPaymentUpdateForSonaliPay')->name('admission-payment-update-for-sonali-pay');
    });

    /// NCC bank api
    Route::group(['namespace' => 'Payment', 'prefix' => 'ncc-bank'], function () {
        Route::post('get-fee-info', 'NCCBankStudentPaymentApiController@getFeeInfoForNccBank')->name('get-fee-info-for-nccbank');
        Route::post('payment', 'NCCBankStudentPaymentApiController@acceptPaymentInfoInNccBank')->name('accept-payment-info-in-nccbank');
    });
    
});


