<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
/*
Route::filter('https', function() {

    if ( ! Request::secure())

        return Redirect::secure(URI::current());

});*/

// Authentication Routes...
/*$this->get('login', 'Auth\LoginController@showLoginForm')->name('login');
$this->post('login', 'Auth\LoginController@login');
$this->post('logout', 'Auth\LoginController@logout')->name('logout');

// Registration Routes...
$this->get('register', 'Auth\RegisterController@showRegistrationForm')->name('register');
$this->post('register', 'Auth\RegisterController@register');

// Password Reset Routes...
$this->get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm');
$this->post('password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail');
$this->get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm');
$this->post('password/reset', 'Auth\ResetPasswordController@reset');*/


Auth::routes();

Route::get('google-drive/auth', 'GoogleDriveController@redirectToGoogle');
Route::get('google-drive/callback', 'GoogleDriveController@handleGoogleCallback');

Route::group(['namespace' => 'Site\Chart'], function () {
    Route::get('/get-site-student-statistics-for-graph', 'ChartController@getSiteStudentStatisticsForGraph')->name('get-site-student-statistics-for-graph');
    Route::get('/get-site-employee-statistics-for-graph', 'ChartController@getSiteEmployeeStatisticsForGraph')->name('get-site-employee-statistics-for-graph');
    Route::get('/get-site-employee-attendence-statistics-for-graph', 'ChartController@getSiteEmployeeAttendenceStatisticsForGraph')->name('get-site-employee-attendence-statistics-for-graph');
});

Route::group(['namespace' => 'Site\Retirement'], function () {
    Route::get('/site-get-year-month-list', 'SiteEmployeeRetirementController@siteGetYearMonthlist')->name('site-get-year-month-list');
    Route::get('/site-Employee-retirement', 'SiteEmployeeRetirementController@index')->name('site-Employee-retirement');
    Route::post('/site-get-employee-retirement-list', 'SiteEmployeeRetirementController@siteGetEmployeeRetirementList')->name('site-get-employee-retirement-list');
});
Route::group(['namespace' => 'Site\Birthday'], function () {
    Route::get('/site-employee-birthday-list', 'SiteEmployeeBirthdayController@index')->name('site-employee-birthday-list');
    Route::post('/site-get-employee-birthday-list', 'SiteEmployeeBirthdayController@siteGetEmployeeBirthdayList')->name('site-get-employee-birthday-list');
    Route::post('/site-employee-birthday-setting-store', 'SiteEmployeeBirthdayController@siteGetEmployeeBirthdaySettngsStore')->name('site-employee-birthday-setting-store');
});
Route::group(['namespace' => 'Site\Fine'], function () {
    Route::get('/site-fine-management', 'StudentFineController@index')->name('site-fine-management');
    Route::post('/store-site-student-fine-settings', 'StudentFineController@StoreSiteStudentFineSettings')->name('store-site-student-fine-settings');
    Route::post('/store-site-student-fine-Type', 'StudentFineController@StoreSiteStudentFineType')->name('store-site-student-fine-Type');
    Route::get('/get-site-student-fine-Type', 'StudentFineController@getSiteStudentFineType')->name('get-site-student-fine-Type');
    Route::get('/get-site-student-fine-Type-for-settings', 'StudentFineController@getSiteStudentFineTypeForSettings')->name('get-site-student-fine-Type-for-settings');
    Route::post('/get-site-student-fine-settings', 'StudentFineController@GetSiteStudentFineSettings')->name('get-site-student-fine-settings');
    Route::post('/get-site-student-fine-data', 'StudentFineController@GetSiteStudentFineData')->name('get-site-student-fine-data');
    Route::post('/get-site-student-fine-data-range-wise', 'StudentFineController@GetSiteStudentFineDataRangeWise')->name('get-site-student-fine-data-range-wise');
    Route::post('/store-site-student-fine-data', 'StudentFineController@StoreSiteStudentFineData')->name('store-site-student-fine-data');
    Route::post('/site-change-student-payment-status', 'StudentFineController@ChangeSiteStudentFineStatus')->name('site-change-student-payment-status');
});
Route::group(['namespace' => 'Site\payroll'], function () {
    Route::get('/site-payroll-setting', 'PayrollController@index')->name('site-payroll-setting');
    Route::get('/site-payroll-report', 'PayrollController@report')->name('site-payroll-report');
    Route::post('/site-store-base-sallery', 'PayrollController@StoreBaseSallery')->name('site-store-base-sallery');
    Route::get('/site-get-employee-base-sallery', 'PayrollController@getEmployeeBaseSallery')->name('site-get-employee-base-sallery');
    Route::get('/site-get-employee-attendance', 'PayrollController@getEmployeeAttendance')->name('site-get-employee-attendance');
    Route::post('/site-get-store-employee-attendance', 'PayrollController@getEmployeeUpdateAttendance')->name('site-get-store-employee-attendance');
    Route::get('/site-employee-store-allowance', 'PayrollController@StoreEmployeeAllowance')->name('site-employee-store-allowance');
    Route::post('/site-employee-payroll-store', 'PayrollController@StoreEmployeePayroll')->name('site-employee-payroll-store');

    Route::post('/site-store-bonus-amount', 'PayrollController@StoreEmployeePayrollBonus')->name('site-store-bonus-amount');
    Route::post('/site-store-deduction-amount', 'PayrollController@StoreEmployeePayrollDeduction')->name('site-store-deduction-amount');
    Route::post('/site-store-allowance-amount', 'PayrollController@StoreEmployeePayrollAllowance')->name('site-store-allowance-amount');

    Route::get('/site_delete_deduction_type', 'PayrollController@DeleteDeductionType');
    Route::get('/site_delete_allowance_type', 'PayrollController@DeleteAllowanceType');
    Route::get('/site_delete_bonus_type', 'PayrollController@DeleteBonusType');

    Route::get('/site-get-bonus-type', 'PayrollController@siteGetBonusType')->name('site-get-bonus-type');
    Route::get('/site-get-allowance-type', 'PayrollController@siteGetAllowanceTypeType')->name('site-get-allowance-type');
    Route::get('/site-get-deduction-type', 'PayrollController@siteGetDeductionType')->name('site-get-deduction-type');
});
Route::group(['namespace' => 'Site\HolidayOnDuty'], function () {
    Route::get('/holiday-on-duty-settings', 'HolidayOnDutyController@index')->name('holiday-on-duty-settings');
    Route::get('/site-employee-get-holiday-on-duty', 'HolidayOnDutyController@SiteEmployeeGetHolidayOnDuty')->name('site-employee-get-holiday-on-duty');
    Route::get('/site-employee-get-holiday-on-duty-settings', 'HolidayOnDutyController@SiteEmployeeGetHolidayOnDutySettings')->name('site-employee-get-holiday-on-duty-settings');
});


//Route::get('/tststst', 'HomeController@tststst')->name('tststst');
Route::get('/web/organizeSavedDeviceLog1', 'HomeController@organizeSavedDeviceLog1')->name('organizeSavedDeviceLog1');

Route::get('pdf-page-test', 'HomeController@pdfPageTest');

/*Route::get('/token', function () {
    return Auth::user()->createToken('test');
});*/
Route::get('/login', 'Login\LoginController@loginPage')->name('login-form');
Route::get('/login-redirect', 'Login\LoginController@loginRedirectResponse')->name('login-redirect');
Route::get('/edu/login', 'HomeController@eduLogin')->name('edu-login');
Route::get('/edu/application', 'HomeController@eduApplication')->name('web-edu-application');
Route::get('/edu/feature', 'HomeController@eduFeature')->name('web-edu-feature');

Route::get('/', 'HomeController@index')->name('web-home');
Route::get('/job-application', 'HomeController@index')->name('job-application');
Route::get('/about', 'HomeController@index')->name('web-about-us');
Route::get('/video', 'HomeController@index')->name('web-site-video');
Route::get('/web/notice/all', 'HomeController@index')->name('web-notice-all');
Route::get('/web/classroom/all', 'HomeController@index')->name('web-classroom-all');
Route::get('/web/admission-form', 'HomeController@index')->name('web-admission-form');
Route::get('/web/edu/classroom/all', 'HomeController@index')->name('web-edu-classroom-all');
Route::get('/web/calendar', 'HomeController@index')->name('web-calendar');
Route::get('/web/event/{id}', 'HomeController@index')->name('web-home');
Route::get('/web/citizen-charter', 'HomeController@index')->name('web-citizen-charter');
Route::get('/web/shuborno-joyonti', 'HomeController@index')->name('web-shuborno-joyonti');
Route::get('/web/exam-result', 'HomeController@index')->name('web-exam-result');
Route::get('/web/employee-details', 'HomeController@index')->name('web-employee-details');
Route::get('/web/student-statistics', 'HomeController@index')->name('web-student-statistics');
Route::get('/web/student-details', 'HomeController@index')->name('web-student-details');
Route::get('/web/event-gallery-details', 'HomeController@index')->name('web-event-gallery-details');
Route::get('/web/contact-form', 'HomeController@index')->name('web-contact-form');
Route::get('/web/event-video-details', 'HomeController@index')->name('web-event-video-details');
Route::get('/web/institute-document', 'HomeController@index')->name('web-institute-document');
Route::get('/web/syllabus-details', 'HomeController@index')->name('web-syllabus-details');
Route::get('/web/officer-complaint', 'HomeController@index')->name('web-officer-complaint');
Route::get('/web/prospectus-details', 'HomeController@index')->name('web-prospectus-details');
Route::get('/web/page/{evanttype}', 'HomeController@index')->name('web-custom-page-details');

// Route::get('/student-check-exam-result/{result_id}/{student_history_id}/{result_type_id}', 'HomeController@index')->name('student-check-exam-result');
Route::get('/student-check-exam-combine-result/{student_history_id}/{result_type_id}/{version_id}/{year_id}/{shift_id}/{class_id}', 'HomeController@index')->name('student-check-exam-combine-result');

Route::get('/web/student-fee', 'HomeController@index')->name('web-student-fee');
Route::get('/web/admission-fee', 'HomeController@index')->name('web-admission-fee');
Route::get('/web/sonali-pay-message', 'HomeController@index')->name('web-sonali-pay-message');
Route::get('/web/admission-sonali-pay-message', 'HomeController@index')->name('web-admission-sonali-pay-message');



//


Route::group(['namespace' => 'Login', 'prefix' => 'auth'], function () {
    //    Route::get('role', ['as'=>'role-check','uses'=>'LoginController@roleCheck']);
    Route::post('signin', ['as' => 'log-in', 'uses' => 'LoginController@login']);
    Route::get('signout', ['as' => 'log-out', 'uses' => 'LoginController@logout']);

    Route::post('/api-login', 'LoginController@apiLogin')->name('role-check');
});


Route::get('open-report/{name}', 'HomeController@openReport')->name('web-open-pdf-file');


Route::group(['namespace' => 'SitePublic\Site'], function () {
    // payroll


    Route::get('/check-exam-result-for-qr-code/{result_id}/{student_history_id}/{result_type_id}', 'PublicDataForQrCodeController@checkExamResultForQrCode')->name('check-exam-result-for-qr-code');
    //Route::get('/check-combine-exam-result-for-qr-code-testt', 'PublicDataForQrCodeController@checkCombineExamResultForQrCode')->name('check-combine-exam-result-for-qr-code-testt');
    Route::get('/check-combine-exam-result-for-qr-code/{student_history_id}/{result_type_id}/{version_id}/{year_id}/{shift_id}/{class_id}', 'PublicDataForQrCodeController@checkCombineExamResultForQR')->name('check-combine-exam-result-for-qr-code');

    Route::get('/student-form', 'SiteStudentEntryApplicationFormController@index')->name('site-web-student-remote-registration-form');

    Route::get('/student-check-exam-result/{result_id}/{student_history_id}/{result_type_id}', 'PublicDataForQrCodeController@studentQrResultPdf')->name('student-check-exam-result');

    Route::group(['prefix' => 'site-public'], function () {
        //{username}/{student_history_id}   Route::get('student-details/{id}', 'PublicDataForQrCodeController@getStudentDetails')->name('student-details-for-public');
        Route::get('/student-details/{username}.{site_id}.{student_history_id}', 'PublicDataForQrCodeController@index')->name('student-details-for-public');
        Route::get('/public-student-details/{username}/{site_id}/{student_history_id}', 'PublicDataForQrCodeController@getStudentDetails')->name('public-student-details-for-public');

        Route::get('/get-version-year-shift-for-site-public', 'SitePublicAcademicController@getVersionYearShiftDeptListForSitePublic')->name('get-version-year-shift-for-site-public');
        Route::post('get-academic-group-for-site-public', 'SitePublicAcademicController@getAcademicGroupForSitePublic')->name('get-academic-group-for-site-public');
        Route::post('get-site-year-version-shift-based-department-class-for-site-public', 'SitePublicAcademicController@getYearVersionAndShiftBasedDepartmentClassForSitePublic')->name('get-site-year-version-shift-based-department-class-for-site-public');

        Route::post('get-student-history-list', 'SitePublicAcademicController@getStudentHistoryList')->name('get-student-history-list-for-site-public');

        Route::post('get-student-primary-result-list', 'PublicResultController@getResultListForPublic')->name('get-student-primary-result-list-for-site-public');
        //  Route::post('/result-list-for-site-public', 'PublicResultController@getResultListForPublic')->name('get-result-list-for-site-public');
        Route::get('open-report-for-public/{name}', 'PublicResultController@openReportForPublic')->name('open-pdf-file-storage-for-public');

        //   Route::post('/open-pdf-file-storage-for-public', 'PublicResultController@getStudentResulDetailsPdfForPublic')->name('get-student-result-details-pdf-for-site-public');
        Route::post('/get-student-result-details-pdf-for-site-public', 'PublicResultController@getStudentResulDetailsPdfForPublic')->name('get-student-result-details-pdf-for-site-public');
        Route::post('/get-student-result-for-site-public', 'PublicResultController@getStudentResulForPublic')->name('get-student-result-for-site-public');
        Route::post('get-version-year-shift-based-based-sections-or-class-groups-and-sessions-by-class-for-public', 'PublicResultController@versionYearShiftBasedSectionsOrClassGroupsAndSessionByClassForPublic')->name('get-version-year-shift-based-based-sections-or-class-groups-and-sessions-by-class-for-public');
        Route::post('get-site-class-base-section-for-public', 'PublicResultController@getSiteClassGroupBaseSectionSessionList')->name('get-site-class-base-section-for-public');

        Route::post('get-student-fee-info', 'PublicStudentFeeController@getStudentFeeInfo')->name('get-student-fee-info-for-public');
        Route::get('student-bank-slip-pdf-for-public/{username}', 'PublicStudentFeeController@getStudentBankSlipPdfForPublic')->name('student-bank-slip-pdf-for-public');
        Route::post('create-student-payment', 'PublicStudentFeeController@createStudentPayment')->name('site-public-create-student-payment');
        Route::post('sonali-pay-transaction-message', 'PublicStudentFeeController@checkSonaliPayTokenModeForWeb')->name('site-public-sonali-pay-transaction-message');
        Route::get('get-site-public-payment-slip/{voucher_no}/{tr_id}', 'PublicStudentFeeController@getPublicStudentPaymentSlip')->name('get-site-public-payment-slip-for-web');

        Route::post('get-admission-fee-info', 'PublicAdmissionFeeController@getAdmissionFeeInfo')->name('get-admission-fee-info-for-public');
        // Route::get('student-bank-slip-pdf-for-public/{username}', 'PublicStudentFeeController@getStudentBankSlipPdfForPublic')->name('student-bank-slip-pdf-for-public');
        Route::post('create-admission-payment', 'PublicAdmissionFeeController@createAdmissionPayment')->name('site-public-create-admission-payment');
        Route::post('sonali-pay-admission-transaction-message', 'PublicAdmissionFeeController@checkAdmissionSonaliPayTokenModeForWeb')->name('site-public-sonali-pay-admission-transaction-message');
        Route::get('get-admission-payment-slip/{invoice_no}/{tr_id}', 'PublicAdmissionFeeController@getAdmissionPaymentSlip')->name('get-admission-payment-slip-for-web');
    });

    Route::group(['prefix' => 'student-application'], function () {
        Route::get('global-get-site-academic-group-list', 'SiteStudentEntryApplicationFormController@globalGetSiteAcademicGroupList')->name('global-get-site-academic-group-list');
        Route::get('global-site-year-shift-version-admissiontype-studenttype-load/{group_id}', 'SiteStudentEntryApplicationFormController@globalSiteYearShiftVersionAdmissiontypeStudenttypeLoad')->name('global-site-year-shift-version-admissiontype-studenttype-load');
        Route::get('global-get-site-year-version-base-department-class/{version_id}/{year_id}/{group_id}/{shift_id}', 'SiteStudentEntryApplicationFormController@globalGetSiteYearVersionBaseDepartmentClass')->name('global-get-site-year-version-base-department-class');
        Route::get('global-get-department-base-class/{department_id}/{year_id}/{group_id}', 'SiteStudentEntryApplicationFormController@globalGetDepartmentBaseClass')->name('global-get-department-base-class');
        Route::get('global-get-gender-religion-blood-student-category-quata-occupation-list/{group_id}', 'SiteStudentEntryApplicationFormController@globalGetGenderReligionBloodStudentCategoryQuataOccupationList')->name('global-get-gender-religion-blood-student-category-quata-occupation-list');

        Route::get('global-get-site-class-base-section/{class_id}/{shift_id}/{class_group_id}/{year_id}/{group_id}/{version_id}', 'SiteStudentEntryApplicationFormController@globalSiteClassBaseSection')
            ->name('global-get-site-class-base-section');

        Route::get('global-get-class-group-base-selective-subject-list/{classid}/{class_groupid}/{yearid}/{deptid}/{group_id}', 'SiteStudentEntryApplicationFormController@globalGetClassGroupBaseSubjectList')
            ->name('global-get-class-group-base-selective-subject-list');

        Route::get('global-get-country-list', 'SiteStudentEntryApplicationFormController@globalGetCountryList')
            ->name('global-get-country-list');
        Route::get('global-get-division-by-country-id/{countryId}', 'SiteStudentEntryApplicationFormController@globalGetDivisionByCountryId')
            ->name('global-get-division-by-country-id');
        Route::get('global-get-district-by-division-id/{divisionId}', 'SiteStudentEntryApplicationFormController@globalGetDistrictByDivisionId')
            ->name('global-get-district-by-division-id');
        Route::get('global-get-thana-list-by-district-id/{distroctId}', 'SiteStudentEntryApplicationFormController@globalGetThanaListByDistrictId')
            ->name('global-get-thana-list-by-district-id');

        Route::post('create-student-entry-application', 'SiteStudentEntryApplicationFormController@createStudentEntryApplication')
            ->name('create-student-entry-application');

        Route::get('global-get-applied-student-detail-for-edit/{unique_code}', 'SiteStudentEntryApplicationFormController@globalGetAppliedStudentDetailForEdit')
            ->name('global-get-applied-student-detail-for-edit');

        Route::post('update-student-entry-application', 'SiteStudentEntryApplicationFormController@updateStudentEntryApplication')
            ->name('update-student-entry-application');
    });


    Route::group(['namespace' => 'Admission', 'prefix' => 'admission-application'], function () {
        Route::get('global-get-site-academic-group-list-for-admission', 'SiteStudentAdmissionApplicationFormController@globalGetSiteAcademicGroupList')->name('global-get-site-academic-group-list');
        Route::get('global-site-year-shift-version-admissiontype-studenttype-load-for-admission/{group_id}', 'SiteStudentAdmissionApplicationFormController@globalSiteYearShiftVersionAdmissiontypeStudenttypeLoad')->name('global-site-year-shift-version-admissiontype-studenttype-load');
        Route::get('global-get-site-year-version-base-department-class-for-admission/{version_id}/{year_id}/{group_id}/{shift_id}', 'SiteStudentAdmissionApplicationFormController@globalGetSiteYearVersionBaseDepartmentClass')->name('global-get-site-year-version-base-department-class');
        Route::get('global-get-site-examination-qualification-for-admission/{group_id}', 'SiteStudentAdmissionApplicationFormController@globalGetSiteExaminationQualificationForAdmission')->name('global-get-site-examination-qualification-for-admission');
        Route::get('global-get-admission-applied-student-check-for-edit-download/{unique_code}', 'SiteStudentAdmissionApplicationFormController@globalGetAdmissionAppliedStudentCheckForEditDownload')->name('global-get-admission-applied-student-check-for-edit-download');
        Route::get('download-student-admission-form/{unique_code}', 'SiteStudentAdmissionApplicationFormController@downloadStudentAdmissionForm')->name('download-student-admission-form');
        Route::post('check-valide-student-for-admission', 'SiteStudentAdmissionApplicationFormController@checkValideStudentForAdmission')->name('check-valide-student-for-admission');
        Route::get('global-get-gender-religion-blood-student-category-quata-occupation-list/{group_id}', 'SiteStudentAdmissionApplicationFormController@globalGetGenderReligionBloodStudentCategoryQuataOccupationList')->name('global-get-gender-religion-blood-student-category-quata-occupation-list');

        Route::get('global-get-admission-site-class-base-section/{class_id}/{shift_id}/{class_group_id}/{year_id}/{group_id}', 'SiteStudentAdmissionApplicationFormController@globalGetAdmissionSiteClassBaseSection')
            ->name('global-get-admission-site-class-base-section');


        Route::get('global-get-department-base-class-for-admission/{department_id}/{year_id}/{group_id}', 'SiteStudentAdmissionApplicationFormController@globalGetDepartmentBaseClassForAdmission')->name('global-get-department-base-class-for-admission');

        Route::post('create-student-admission-entry-application', 'SiteStudentAdmissionApplicationFormController@createStudentEntryApplication')
            ->name('create-student-admission-entry-application');

        Route::get('global-get-admission-applied-student-detail-for-edit/{unique_code}', 'SiteStudentAdmissionApplicationFormController@globalGetAppliedStudentDetailForEdit')
            ->name('global-get-admission-applied-student-detail-for-edit');

        Route::post('update-student-admission-application', 'SiteStudentAdmissionApplicationFormController@updateStudentEntryApplication')
            ->name('update-student-admission-application');
    });
});





Route::group(['namespace' => 'Admin'], function () {

    Route::get('/dashboard', 'AdminController@dashboard')->name('admin');
    Route::get('/unauthorized', 'AdminController@dashboard')->name('unauthorized');

    Route::get('dashboard-date-wise-std-attendance-list/{date}', 'AdminController@dashboardGetStudentAttendanceList')->name('site-student-attendance-dashboard-date-wise-attendance-sort-list');

    Route::get('dashboard-date-wise-emp-attendance-list/{date}', 'AdminController@dashboardGetEmployeeAttendanceList')->name('site-employee-attendance-dashboard-date-wise-attendance-list');
    Route::get('dashboard-month-wise-attendance-graph/{month?}', 'AdminController@dashboardGetEmployeeAttendanceGraph')->name('site-employee-attendance-dashboard-date-wise-attendance-graph');
    Route::get('dashboard-date-wise-st-attendance-list/{date}', 'AdminController@dashboardPaletteAttendanceList')->name('site-student-attendance-dashboard-date-wise-attendance-list');

    Route::get('get-notification/{id}', 'AdminController@getNotification')->name('user-notification-get-notification');

    //tsetstst
    Route::get('test', 'AdminController@testFunction')->name('test-function');
    Route::get('tsttwetwetwtwt', 'AdminController@tsttwetwetwtwt')->name('tsttwetwetwtwt');

    Route::get('get-dashboard-data', 'AdminController@getDashboardData')->name('dashboard-get-dashboard-data');
    Route::get('dashboard-site-get-total-student-count', 'AdminController@getStudentTotalCount')->name('dashboard-site-get-total-student-count');
    Route::post('dashboard-site-get-total-student-count-details', 'AdminController@getStudentTotalCountDetails')->name('dashboard-site-get-total-student-count-details');
    Route::get('dashboard-site-get-total-present-student-count', 'AdminController@getPresentStudentTotalCount')->name('dashboard-site-get-total-present-student-count');
    Route::get('dashboard-site-get-total-absent-count', 'AdminController@getAbsentStudentTotalCount')->name('dashboard-site-get-total-absent-count');
    Route::get('dashboard-site-get-device-using-total-student-count', 'AdminController@getDeviceUsingStudentTotalCount')->name('dashboard-site-get-device-using-total-student-count');

    Route::get('dashboard-site-get-total-employee-count', 'AdminController@getEmployeeTotalCount')->name('dashboard-site-get-total-employee-count');
    Route::get('dashboard-site-get-device-using-total-employees-count', 'AdminController@getDeviceUsingEmployeeTotalCount')->name('dashboard-site-get-device-using-total-employees-count');
    Route::get('dashboard-site-get-total-present-employees-count', 'AdminController@getPresentEmployeeTotalCount')->name('dashboard-site-get-total-present-employees-count');
    Route::get('dashboard-site-get-total-absent-employees-count', 'AdminController@getAbsentEmployeeTotalCount')->name('dashboard-site-get-total-absent-employees-count');

    Route::get('back-to-main-panel', 'AdminController@backToMainPanel')->name('back-to-main-panel');
});

Route::group(['namespace' => 'Language'], function () {
    Route::get('lang/{locale}', ['as' => 'choose-lang', 'uses' => 'LanguageController@langChooser']);
    Route::get('/test-api', ['as' => 'test-api', 'uses' => 'LanguageController@testApi']);
});


Route::group(['namespace' => 'Employee', 'prefix' => 'profile1'], function () {
    // Route::get('/', ['as' => 'employee-profile', 'uses' => 'EmployeeAttachController@employeePage']);
});



Route::group(['namespace' => 'Employee', 'prefix' => 'employee-category'], function () {

    /*  Route::get('add', 'EmpCategoryController@createEmpCategoryForm')->name('empcategory-add-form');
      Route::post('add', 'EmpCategoryController@createEmpCategory')->name('empcategory-create');
      Route::get('list', 'EmpCategoryController@index')->name('empcategory-list');
      Route::get('edit/{id}', 'EmpCategoryController@getEmpCategoryEditForm')->name('empcategory-edit-form');
      Route::patch('edit/{id}', 'EmpCategoryController@editEmpCategory')->name('empcategory-edit');
      //Route::get('view/{id}','EmpCategoryController@viewReligion')->name('emp-categor-view');
      Route::get('delete/{id}', 'EmpCategoryController@deleteEmpCategory')->name('empcategory-delete');*/
});


Route::group(['namespace' => 'Employee', 'prefix' => 'employee-position'], function () {

    /*    Route::post('add', 'EmpPositionController@createEmpPosition')->name('emp-position-create');
        Route::get('list', 'EmpPositionController@index')->name('emp-position-list');
        Route::get('position-by-category/{id}', 'EmpPositionController@getPositionByCategory')->name('emp-position-list-by-category');
        Route::get('edit/{id}', 'EmpPositionController@getEmpPositionEditForm')->name('emp-position-edit-form');
        Route::patch('edit/{id}', 'EmpPositionController@editEmpPosition')->name('emp-position-edit');
        //Route::get('view/{id}','EmpPositionController@viewReligion')->name('emp-categor-view');
        Route::get('delete/{id}', 'EmpPositionController@deleteEmpPosition')->name('emp-position-delete');
        Route::get('add', 'EmpPositionController@createEmpPositionForm')->name('emp-position-add-form');*/
});


Route::group(['namespace' => 'Role', 'prefix' => 'user-group'], function () {
    Route::get('add', ['as' => 'role-add-form', 'uses' => 'RolesController@createForm']);
    Route::post('add', ['as' => 'role-create', 'uses' => 'RolesController@createRole']);
    Route::post('assign', ['as' => 'role-assign', 'uses' => 'RolesController@assignRole']);
    Route::get('list', ['as' => 'role-list', 'uses' => 'RolesController@index']);
    Route::get('edit/{id}', ['as' => 'role-edit-form', 'uses' => 'RolesController@editRoleForm']);
    Route::get('view/{id}', ['as' => 'role-view', 'uses' => 'RolesController@viewRole']);
    Route::get('delete/{id}', ['as' => 'role-delete', 'uses' => 'RolesController@deleteRole']);
    Route::patch('edit/{id}', ['as' => 'role-edit', 'uses' => 'RolesController@editRole']);
});

Route::group(['namespace' => 'Permission', 'prefix' => 'permission'], function () {
    Route::get('assign', 'PermissionController@assignPermissionForm')->name('assign-permission-form');
    Route::get('group-access', 'PermissionController@getGroupAccessTable')->name('group-access');
});

Route::group(['namespace' => 'Employee', 'prefix' => 'profile1'], function () {
    Route::get('get-class-timing-name-list', 'ClassTimingController@getClassTimingNameList')->name('get-class-timing-name-list');
});



Route::group(['namespace' => 'Timetable', 'prefix' => 'class-timing'], function () {
    // Route::get('list', 'ClassTimingController@index')->name('class-timing-list');
    Route::get('get-class-timing-name-list', 'ClassTimingController@getClassTimingNameList')->name('get-class-timing-name-list');

    Route::post('add', 'ClassTimingController@store')->name('class-timing-create');
    Route::get('copy', 'ClassTimingController@copyClassTiming')->name('class-timing-copy');
    Route::post('class-timing-update/{id}', 'ClassTimingController@editClassTiming')->name('class-timing-update');
    Route::delete('class-timing-delete/{id}', 'ClassTimingController@destroy')->name('class-timing-delete');


    Route::get('details/{id}', 'ClassTimingDetailsController@index')->name('class-timing-details');
    Route::get('get-class-timing-details-list/{id}', 'ClassTimingDetailsController@getClassTimingDetailsList')->name('get-class-timing-details-list');

    //Route::get('details/add/{id}', 'ClassTimingDetailsController@create')->name('class-timing-details-create-form');

    Route::post('class-timing-details-create/{id}', 'ClassTimingDetailsController@store')->name('class-timing-details-create');
    // Route::get('details/edit/{id}', 'ClassTimingDetailsController@getClassTimingDetailsEditForm')->name('class-timing-details-edit');
    Route::post('class-timing-details-update/{id}', 'ClassTimingDetailsController@update')->name('class-timing-details-update');
    Route::delete('class-timing-details-delete/{id}', 'ClassTimingDetailsController@destroy')->name('class-timing-details-delete');


    // Route::get('weekday', 'WeekdayClassTimingController@index')->name('weekday-class-timing');

    Route::get('weekday-list-for-section', 'WeekdayClassTimingController@weekdayListForSection')->name('weekday-list-for-section');
    Route::post('save-weekday-list-for-section', 'WeekdayClassTimingController@saveWeekdayListForSection')->name('save-weekday-list-for-section');

    Route::get('get-report', 'ClassTimingController@classTimingReport')->name('site-routine-get-class-timing-report');
});


Route::group(['namespace' => 'Timetable', 'prefix' => 'timetable'], function () {
    Route::get('list', 'TimetableController@index')->name('timetable-list');

    Route::get('add', 'TimetableController@createTimetableForm')->name('timetable-create-form');
    Route::post('add', 'TimetableController@createTimetable')->name('timetable-create');
    Route::get('edit/{id}', 'TimetableController@edit')->name('timetable-edit');
    Route::patch('edit/{id}', 'TimetableController@update')->name('class-timetable-update');
    Route::get('delete/{id}', 'TimetableController@destroy')->name('timetable-delete');


    Route::get('manage-section/{id}', 'TimetableController@manageSection')->name('timetable-manage-section');
    Route::get('manage-allocation/{id}', 'TimetableController@manageAllocation')->name('timetable-manage-allocation');
    Route::post('save-section-for-timetable', 'TimetableController@saveSectionForTimetable')->name('save-section-for-timetable');


    Route::get('timetable-entries/{timetable}/{section}', 'TimetableController@timetableEntries')->name('timetable-entries');
    Route::get('get-timetable-entries-list/{timetable}/{section}', 'TimetableController@getTimetableEntriesList')->name('get-timetable-entries-list');
    Route::post('save-timetable-entries-slot-data', 'TimetableController@saveTimetableEntriesSlotData')->name('save-timetable-entries-slot-data');
    Route::get('remove-timetable-entries-slot-data', 'TimetableController@removeTimetableEntriesSlotData')->name('remove-timetable-entries-slot-data');
});


Route::group(['namespace' => 'Religion', 'prefix' => 'religion'], function () {

    Route::get('add', 'ReligionController@createReligionForm')->name('religion-add-form');
    Route::post('add', 'ReligionController@createReligion')->name('religion-add');
    Route::get('list', ['as' => 'religion-list', 'uses' => 'ReligionController@index']);
    Route::get('edit/{id}', ['as' => 'religion-edit-form', 'uses' => 'ReligionController@editReligionForm']);
    Route::patch('edit/{id}', ['as' => 'religion-edit', 'uses' => 'ReligionController@editReligion']);
    Route::get('view/{id}', ['as' => 'religion-view', 'uses' => 'ReligionController@viewReligion']);
    Route::get('delete/{id}', ['as' => 'religion-delete', 'uses' => 'ReligionController@deleteReligion']);


    Route::get('get-all-type-religion-list', 'ReligionController@getReligionList')->name('get-all-type-religion-list');
});

Route::group(['namespace' => 'Gender', 'prefix' => 'gender'], function () {

    Route::get('add', ['as' => 'gender-add-form', 'uses' => 'GenderController@createGenderForm']);
    Route::post('add', ['as' => 'gender-add', 'uses' => 'GenderController@createGender']);
    Route::get('list', ['as' => 'gender-list', 'uses' => 'GenderController@index']);
    Route::get('edit/{id}', ['as' => 'gender-edit-form', 'uses' => 'GenderController@editGenderForm']);
    Route::patch('edit/{id}', ['as' => 'gender-edit', 'uses' => 'GenderController@editGender']);
    Route::get('view/{id}', ['as' => 'gender-view', 'uses' => 'GenderController@viewGender']);
    Route::get('delete/{id}', ['as' => 'gender-delete', 'uses' => 'GenderController@deleteGender']);


    Route::get('get-all-type-gender-list', 'GenderController@getGenderList')->name('get-all-type-gender-list');
});


Route::group(['namespace' => 'BloodGroup', 'prefix' => 'blood-group'], function () {
    Route::get('get-blood-group', 'BloodGroupController@bloodGroupList')->name('get-blood-group-list');
});

Route::group(['namespace' => 'Department', 'prefix' => 'department'], function () {

    Route::get('add', ['as' => 'department-add-form', 'uses' => 'DepartmentController@createDeptForm']);
    Route::post('add', ['as' => 'department-create', 'uses' => 'DepartmentController@createDepartment']);
    Route::get('list', ['as' => 'department-list', 'uses' => 'DepartmentController@index']);
    Route::get('edit/{id}', ['as' => 'department-edit-form', 'uses' => 'DepartmentController@editDeptForm']);
    Route::patch('edit/{id}', ['as' => 'department-edit', 'uses' => 'DepartmentController@editDepartment']);
    Route::get('view/{id}', ['as' => 'department-view', 'uses' => 'DepartmentController@viewDepartment']);
    Route::get('delete/{id}', ['as' => 'department-delete', 'uses' => 'DepartmentController@deleteDepartment']);
});


Route::group(['namespace' => 'Shift', 'prefix' => 'shift'], function () {
    Route::get('add', ['as' => 'shift-add-form', 'uses' => 'ShiftController@createShiftForm']);
    //    Route::post('add', ['as'=>'shift-create','uses'=>'ShiftController@createShift']);
    Route::post('add', ['as' => 'shift-create-json', 'uses' => 'ShiftController@createShiftJson']);
    Route::get('list', ['as' => 'shift-list', 'uses' => 'ShiftController@index']);
    Route::get('assign', ['as' => 'assign-shift-dept-form', 'uses' => 'ShiftController@assignShiftDeptForm']);
    Route::post('assign', ['as' => 'shift-assign', 'uses' => 'ShiftController@assignShift']);
    Route::get('view/{id}', ['as' => 'shift-view', 'uses' => 'ShiftController@viewShift']);
    Route::get('edit/{id}', ['as' => 'shift-edit-form', 'uses' => 'ShiftController@editShiftForm']);
    Route::patch('edit/{id}', ['as' => 'shift-edit', 'uses' => 'ShiftController@editShift']);
    Route::get('delete/{id}', ['as' => 'shift-delete', 'uses' => 'ShiftController@deleteShift']);
    Route::get('user/{userId}', ['as' => 'shift-user', 'uses' => 'ShiftController@shiftToEdit']);
});


Route::group(['namespace' => 'Leave', 'prefix' => 'leave'], function () {
    Route::get('add', ['as' => 'leave-add-form', 'uses' => 'LeaveController@createLeaveForm']);
    Route::post('add', ['as' => 'leave-create', 'uses' => 'LeaveController@createLeave']);
    Route::get('list', ['as' => 'leave-list', 'uses' => 'LeaveController@index']);
    Route::get('edit/{id}', ['as' => 'leave-edit-form', 'uses' => 'LeaveController@editLeaveForm']);
    Route::patch('edit/{id}', ['as' => 'leave-edit', 'uses' => 'LeaveController@editLeave']);
    Route::get('view/{id}', ['as' => 'leave-view', 'uses' => 'LeaveController@viewLeave']);
    Route::get('delete/{id}', ['as' => 'leave-delete', 'uses' => 'LeaveController@deleteLeave']);
});
Route::group(['namespace' => 'Leave', 'prefix' => 'application'], function () {
    Route::get('add', ['as' => 'application-add-form', 'uses' => 'LeaveController@createApplicationForm']);
    Route::post('add', ['as' => 'application-create', 'uses' => 'LeaveController@applyForLeave']);
    Route::get('list', ['as' => 'application-list', 'uses' => 'LeaveController@leaveApplicationList']);
    Route::get('edit/{id}', ['as' => 'application-edit-form', 'uses' => 'LeaveController@applicationEditForm']);
    Route::patch('edit/{id}', ['as' => 'application-edit', 'uses' => 'LeaveController@editAplication']);
    Route::get('delete/{id}', ['as' => 'application-delete', 'uses' => 'LeaveController@deleteApplication']);
    Route::get('myleave', ['as' => 'employee-leave', 'uses' => 'LeaveController@myLeave']);
});

Route::group(['namespace' => 'Status', 'prefix' => 'status'], function () {
    Route::get('add', ['as' => 'status-add-form', 'uses' => 'StatusController@createStatusForm']);
    Route::post('add', ['as' => 'status-create', 'uses' => 'StatusController@createStatus']);
    Route::get('list', ['as' => 'status-list', 'uses' => 'StatusController@index']);
});

Route::group(['namespace' => 'Holiday', 'prefix' => 'holydaytype'], function () {
    Route::get('add', ['as' => 'holydaytype-add-form', 'uses' => 'HolydayController@createHolydayTypeForm']);
    Route::post('add', ['as' => 'holydaytype-add', 'uses' => 'HolydayController@createHolydayType']);
    Route::get('list', ['as' => 'holydaytype-list', 'uses' => 'HolydayController@getHolidayTypeList']);
});
Route::group(['namespace' => 'Holiday', 'prefix' => 'holyday'], function () {
    Route::get('add', ['as' => 'holyday-add-form', 'uses' => 'HolydayController@createHolydayForm']);
    Route::post('add', ['as' => 'holyday-add', 'uses' => 'HolydayController@createHolyday']);
    Route::get('list', ['as' => 'holyday-list', 'uses' => 'HolydayController@holydayList']);
    Route::get('list/{year}/{date}', ['as' => 'holyday-month', 'uses' => 'HolydayController@holydaysByMonth']);

    /* Route::get('edit/{id}', 'LeaveController@applicationEditForm');
     Route::patch('edit/{id}', 'LeaveController@editAplication');
     Route::get('delete/{id}', 'LeaveController@deleteApplication');*/
});
Route::group(['namespace' => 'Punch', 'prefix' => 'punch'], function () {
    Route::get('add', ['as' => 'punch-insert-form', 'uses' => 'PunchController@insertPunchForm']);
    Route::post('add', ['as' => 'punch-in', 'uses' => 'PunchController@punchIn']);
    Route::post('out', ['as' => 'punch-out', 'uses' => 'PunchController@punchOut']);
    Route::get('edit/{date}/{id}', ['as' => 'user-daily-punch-edit-by-date', 'uses' => 'PunchController@editPunchForm']);
    Route::patch('edit/{id}/{date}', ['as' => 'user-punch-edit', 'uses' => 'PunchController@editUserPunch']);
});

Route::group(['namespace' => 'Punch', 'prefix' => 'timesheet'], function () {

    Route::get('/', ['as' => 'your-timesheet', 'uses' => 'PunchController@timesheetPage']);
    Route::get('mine', ['as' => 'my-timesheet', 'uses' => 'PunchController@myTimesheetPage']);
    Route::get('my-details/{id}/{month}/{year}', ['as' => 'my-timesheet-report', 'uses' => 'PunchController@myDailyTimesheet']);
    //    Route::get('monthly-report',['as'=>'timesheet-report','uses'=>'PunchController@timeShiftForMonth']);
    Route::get('monthly-report/{year}/{month}', ['as' => 'timesheet-report', 'uses' => 'PunchController@timeShiftForMonth']);
    Route::get('users-daily-report/{id}/{month}/{year}', ['as' => 'user-month-timesheet-details', 'uses' => 'PunchController@usersDailyTimesheet']);
});


Route::group(['namespace' => 'Punch', 'prefix' => 'attendance'], function () {

    Route::get('monthly', ['as' => 'monthly-device-attendance', 'uses' => 'PunchController@monthlyDeviceAttendance']);
    Route::post('monthly', ['as' => 'monthly-device-data-upload', 'uses' => 'PunchController@uploadDeviceData']);
    Route::any('device-data/preview/', ['as' => 'monthly-device-data-preview', 'uses' => 'PunchController@previewDeviceData']);
});

Route::group(['namespace' => 'Punch', 'prefix' => 'salary'], function () {

    Route::get('reports', ['as' => 'get-salary-from-punch', 'uses' => 'PunchController@getSalaryForm']);
    Route::get('monthly-report/{year}/{month}', ['as' => 'monthly-salary-report', 'uses' => 'PunchController@determineSalaryForAllEmployees']);
    Route::get('user-yearly-report/{userId}/{year}', ['as' => 'user-year-salary-details', 'uses' => 'PunchController@getIndividualYearlySalaryReport']);
});

Route::group(['namespace' => 'Salary', 'prefix' => 'salary'], function () {
    Route::get('type', ['as' => 'salary-type-create-form', 'uses' => 'SalaryController@createSalaryTypeForm']);
    Route::get('type/list', ['as' => 'salary-type-list', 'uses' => 'SalaryController@salaryTypeList']);
    Route::get('type/edit/{id}', ['as' => 'salary-type-edit-form', 'uses' => 'SalaryController@salaryTypeEditForm']);
    Route::patch('type/edit/{id}', ['as' => 'salary-type-edit', 'uses' => 'SalaryController@editSalaryType']);
    Route::get('type/delete/{id}', ['as' => 'salary-type-delete', 'uses' => 'SalaryController@salaryTypeDelete']);
    Route::post('type', ['as' => 'create-salary-type', 'uses' => 'SalaryController@createSalaryType']);

    Route::get('allowance-rules', ['as' => 'salary-rules-create-form', 'uses' => 'SalaryController@createAllowanceForm']);
    Route::post('allowance-rules', ['as' => 'create-salary-rules', 'uses' => 'SalaryController@createAllowance']);
    Route::get('allowance-rules-list', ['as' => 'salary-allowance-rules-list', 'uses' => 'SalaryController@allowanceRulesList']);
    Route::get('allowance-rules/view/{id}', ['as' => 'allowance-rule-view', 'uses' => 'SalaryController@viewAllowanceRules']);
    Route::get('allowance-rules/edit/{id}', ['as' => 'allowance-rule-edit-form', 'uses' => 'SalaryController@allowanceRuleEditForm']);
    Route::patch('allowance-rules/edit/{id}', ['as' => 'allowance-rule-edit', 'uses' => 'SalaryController@editAllowanceRule']);
    Route::get('allowance-rules/delete/{id}', ['as' => 'allowance-rule-delete', 'uses' => 'SalaryController@deleteAllowanceRule']);

    Route::get('overtime-rules', ['as' => 'overtime-rules-create-form', 'uses' => 'SalaryController@createOvertimeForm']);
    Route::post('overtime-rules', ['as' => 'create-overtime-rules', 'uses' => 'SalaryController@createOvertime']);
    Route::get('overtime-rules-list', ['as' => 'salary-overtime-rules-list', 'uses' => 'SalaryController@overtimeRulesList']);
    Route::get('overtime-rules-view/{id}', ['as' => 'overtime-rule-view', 'uses' => 'SalaryController@viewOvertimeRule']);

    Route::get('cut-rules', ['as' => 'cut-rules-create-form', 'uses' => 'SalaryController@createSalaryCutForm']);
    Route::post('cut-rules', ['as' => 'create-salary-cut-rules', 'uses' => 'SalaryController@createSalaryCut']);
    Route::get('cut-rules-list', ['as' => 'salary-cut-rules-list', 'uses' => 'SalaryController@salaryCutRulesList']);
    Route::get('cut-rules-view/{id}', ['as' => 'salary-cut-rule-view', 'uses' => 'SalaryController@viewSalaryCutRule']);

    Route::get('bonus-rules', ['as' => 'bonus-rules-create-form', 'uses' => 'SalaryController@createBonusForm']);
    Route::post('bonus-rules', ['as' => 'create-bonus-rules', 'uses' => 'SalaryController@createBonusRule']);
    Route::get('bonus-rules-list', ['as' => 'salary-bonus-rules-list', 'uses' => 'SalaryController@bonusRulesList']);
    Route::get('bonus-rule-view/{id}', ['as' => 'bonus-rule-view', 'uses' => 'SalaryController@viewBonusRule']);

    Route::post('bonus-attr', ['as' => 'create-bonus-attr', 'uses' => 'SalaryController@createBonusAttr']);
    Route::post('check-bonus-attr/{id}', ['as' => 'check-bonus-attr', 'uses' => 'SalaryController@checkBonusAttr']);
    Route::post('bonus-attr-delete/{id}', ['as' => 'delete-bonus-attr', 'uses' => 'SalaryController@deleteBonusAttr']);

    Route::get('report', ['as' => 'employee-salary', 'uses' => 'SalaryController@determineSalaryForAllEmployees']);

    Route::post('bonus-rules', ['as' => 'create-bonus-rules', 'uses' => 'SalaryController@createBonusRule']);

    Route::post('bonus-types-store', 'SalaryController@BonusTypesStore')->name('edu-bonus-types-store');
    Route::get('bonus-types-get', 'SalaryController@BonusTypesGet')->name('edu-bonus-types-get');

    Route::post('edu-deduction-types-store', 'SalaryController@deductionTypesStore')->name('edu-deduction-types-store');
    Route::get('edu-deduction-types-get', 'SalaryController@deductionTypesGet')->name('edu-deduction-types-get');

    Route::get('edu-allowance-types-get', 'SalaryController@allowanceTypesGet')->name('edu-allowance-types-get');
    Route::post('allowance-types-store', 'SalaryController@allowanceTypesStore')->name('edu-allowance-types-store');
});


Route::group(['namespace' => 'Student', 'prefix' => 'student'], function () {
    Route::get('list', 'StudentController@createStudentForm')->name('student-list');

    Route::post('student-by-search', 'StudentController@getStudentBySearch')->name('site-student-student-by-search');
    Route::post('student-history-by-search', 'StudentController@getStudentHistoryBySearch')->name('site-student-get-student-history-by-search');
    Route::post('student-data-by-search', 'StudentController@getStudentDataBySearchWithPaginaton')->name('site-student-student-data-by-search-with-pagination');

    Route::post('get-student-list-for-attendance-report', 'StudentController@getStudentListForAttendanceReport')->name('get-student-list-for-attendance-report');


    Route::get('add', 'StudentController@createStudentForm')->name('student_add_form');
    Route::post('student-create', 'StudentController@createStudent')->name('student-create');

    Route::get('site-year-shift-department-class-session-version-condition-load', 'StudentController@getSiteYearShiftClassSessionVersionConditionList')->name('site-year-shift-department-class-session-version-condition-load');
    Route::get('list-by-class/{classId}/{attdate}', 'StudentController@getStudentListByClass')->name('student-list-by-class');
    Route::get('get-class-group-base-selective-subject-list/{classid}/{groupid}/{yearid}/{deptid}', 'StudentController@getClassGroupBaseSubjectList')->name('get-class-group-base-selective-subject-list');

    Route::get('get-gender-religion-blood-student-category-quata-occupation-list', 'StudentController@getGenderReligionBloodStudentCategoryQuata')->name('get-gender-religion-blood-student-category-quata-occupation-list');


    Route::get('get-site-class-base-section/{class_id}/{shift_id}/{class_group_id}/{year_id}/{version_id}', 'StudentController@siteClassBaseSection')
        ->name('site-class-shift-group-base-section');
    Route::get('get-global-site-class-base-section/{academic_group_id}/{class_id}/{shift_id}/{class_group_id}/{year_id}/{version_id}', 'StudentController@siteGlobalClassBaseSection')
        ->name('site-global-class-shift-group-base-section');
    Route::get('get-student-detail-for-edit/{student_id}', 'StudentController@getStudentDetailForEdit')->name('get-student-detail-for-edit');
    Route::post('section-category-type-admission-type', 'StudentController@sectionCategoryTypeAdmissionType')->name('section-category-type-admission-type');
    Route::post('get-student-list', 'StudentController@getStudentList')->name('get-student-list');
    Route::post('pause-single-student', 'StudentController@pauseSingleStudent')->name('pause-single-student');
    Route::post('active-single-student', 'StudentController@activeSingleStudent')->name('active-single-student');
    Route::post('delete-single-student', 'StudentController@deleteSingleStudent')->name('delete-single-student');

    Route::get('class/{departmetId}', 'StudentController@getClassForDepartment')->name('student-class');
    Route::get('edit/{id}', 'StudentController@getStudentEditForm')->name('student-edit-form');
    Route::post('student-edit/{id}', 'StudentController@editStudent')->name('student-edit');
    Route::get('view/{id}', 'StudentController@viewStudent')->name('student-view');
    Route::get('delete/{id}', 'StudentController@deleteStudent')->name('student-delete');
    Route::get('site-student-list-report', 'StudentController@getStudentListReport')->name('site-student-list-report');

    Route::get('get-student-history-for-details/{student_history_id}', 'StudentController@getStudentHistoryForDetails')->name('get-student-history-for-details');

    Route::post('get-student-academic-year-list', 'StudentController@getStudentAcademicYearList')->name('get-student-academic-year-list');
    Route::post('get-student-attendance', 'StudentController@getStudentAttendance')->name('get-student-attendance');
    Route::post('get-student-exam-result-list', 'StudentController@getStudentExamResultList')->name('get-student-exam-result-list');
    Route::post('get-student-exam-result-details', 'StudentController@getStudentExamResultDetails')->name('get-student-exam-result-details');
    Route::post('get-student-subject-details', 'StudentController@getStudentSubjectDetails')->name('get-student-subject-details');

    Route::post('add-student-timeline', 'StudentTimelineController@addStudentTimeline')->name('add-student-timeline');
    Route::post('get-student-timeline', 'StudentTimelineController@getStudentTimeline')->name('add-student-timeline');
    Route::post('delete-student-timeline', 'StudentTimelineController@deleteStudentTimeline')->name('delete-student-timeline');




    //    Route::get('get-class-base-site-shift/{id}', 'StudentController@classBaseSiteShift')->name('class-base-site-shift');

});


Route::group(['namespace' => 'Section', 'prefix' => 'section'], function () {
    Route::get('add', ['as' => 'section_add_form', 'uses' => 'SectionController@createSectionForm']);
    Route::post('add', ['as' => 'section-create', 'uses' => 'SectionController@createSection']);
    Route::get('list', ['as' => 'section-list', 'uses' => 'SectionController@index']);
    Route::get('list-by-class/{classId}', ['as' => 'section-list-by-class', 'uses' => 'SectionController@getSectionByClass']);
    Route::get('edit/{id}', ['as' => 'section-edit-form', 'uses' => 'SectionController@getSectionEditForm']);
    Route::patch('edit/{id}', ['as' => 'section-edit', 'uses' => 'SectionController@editSection']);
    Route::get('delete/{id}', ['as' => 'section-delete', 'uses' => 'SectionController@deleteSection']);
});


Route::group(['namespace' => 'Result', 'prefix' => 'result-system'], function () {
    Route::get('add', ['as' => 'result-system-add-form', 'uses' => 'ResultController@createResultSystemForm']);
    Route::post('add', ['as' => 'create-result-system', 'uses' => 'ResultController@createResultSystem']);
    Route::get('list', ['as' => 'result-system-list', 'uses' => 'ResultController@index']);
    //    Route::get('edit/{id}', ['as'=>'result-system-edit-form','uses'=>'ResultController@getResultSystemEditForm']);
    //    Route::patch('edit/{id}', ['as'=>'result-system-edit','uses'=>'ResultController@editResultSystem']);
    //    Route::get('delete/{id}', ['as'=>'result-system-delete','uses'=>'ResultController@deleteResultSystem']);
    Route::get('view/{id}', ['as' => 'result-system-view', 'uses' => 'ResultController@viewResultSystem']);
});
Route::group(['namespace' => 'Result', 'prefix' => 'result-settings'], function () {

    Route::post('add', ['as' => 'create-result-settings', 'uses' => 'ResultController@createResultSettings']);
    Route::post('delete/{id}', ['as' => 'delete-result-settings', 'uses' => 'ResultController@deleteResultSettings']);
});

Route::group(['namespace' => 'Result', 'prefix' => 'total-result-system'], function () {
    Route::get('add', ['as' => 'total-result-system-add-form', 'uses' => 'ResultController@createTotalResultSystemForm']);
    Route::post('add', ['as' => 'create-total-result-system', 'uses' => 'ResultController@createTotalResultSystem']);
    Route::get('list', ['as' => 'total-result-system-list', 'uses' => 'ResultController@totalResultSystemList']);
    Route::get('view/{id}', ['as' => 'total-result-system-view', 'uses' => 'ResultController@viewTotalResultSystem']);
});

Route::group(['namespace' => 'Result', 'prefix' => 'total-result-settings'], function () {
    Route::post('add', ['as' => 'create-total-result-settings', 'uses' => 'ResultController@createTotalResultSettings']);
    Route::post('delete/{id}', ['as' => 'delete-total-result-settings', 'uses' => 'ResultController@deleteTotalResultSettings']);
});
Route::group(['namespace' => 'Form', 'prefix' => 'form-settings'], function () {

    Route::get('add', ['as' => 'form-setting-form', 'uses' => 'FormSettingController@createSettingsForm']);
    Route::post('add', ['as' => 'add-form-settings', 'uses' => 'FormSettingController@createSettings']);
    Route::get('', ['as' => 'form-setting-list', 'uses' => 'FormSettingController@index']);
    Route::get('edit/{id}', ['as' => 'form-setting-edit-form', 'uses' => 'FormSettingController@editSettingForm']);
    Route::patch('edit/{id}', ['as' => 'form-setting-edit', 'uses' => 'FormSettingController@editSettings']);
    Route::get('delete/{id}', ['as' => 'form-setting-delete', 'uses' => 'FormSettingController@deleteSettigs']);
});


Route::group(['namespace' => 'Marks', 'prefix' => 'marks-type'], function () {
    Route::get('add', ['as' => 'marks-type-add-form', 'uses' => 'MarksController@creteMarksTypeForm']);
    Route::post('add', ['as' => 'marks-type-create', 'uses' => 'MarksController@creteMarksType']);
    Route::get('edit/{id}', ['as' => 'marks-type-edit-form', 'uses' => 'MarksController@editMarksTypeForm']);
    Route::patch('edit/{id}', ['as' => 'mark-type-edit', 'uses' => 'MarksController@editMarksType']);
    Route::get('list', ['as' => 'mark-type-list', 'uses' => 'MarksController@index']);
    Route::get('delete/{id}', ['as' => 'marks-type-delete', 'uses' => 'MarksController@deleteMarksType']);
});

Route::group(['namespace' => 'Marks', 'prefix' => 'marks'], function () {

    Route::get('add', ['as' => 'create-marks-form', 'uses' => 'MarksController@createMarksForm']);
    Route::post('add', ['as' => 'create-marks', 'uses' => 'MarksController@createMarks']);
    // Route::get('all-students/add', ['as' => 'student-list-for-marks', 'uses' => 'MarksController@getStListForAddingMarks']);
    Route::post('student-mark/add', ['as' => 'student-mark-add', 'uses' => 'MarksController@saveStudentMarks']);
    Route::get('student-marks', ['as' => 'student-marks-form', 'uses' => 'MarksController@getClassChoosingOption']);
    Route::get('student-list', ['as' => 'student-list-view-marks', 'uses' => 'MarksController@getStudentListForViewingMarks']);
    Route::get('view-student-marks/{stId}/{examId}', ['as' => 'student-marks-view', 'uses' => 'MarksController@viewStudentMarks']);
});


Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {

    Route::get('get-site-group-site-list', 'SiteController@getSiteGroupSiteList')
        ->name('get-site-group-site-list');


    Route::group(['namespace' => 'FileManager', 'prefix' => 'file'], function () {
        Route::post('save-file', 'FileManagerController@saveFile')->name('site-file-save-file');
        Route::get('get-files', 'FileManagerController@getFiles')->name('site-file-get-files');
    });


    Route::group(['namespace' => 'HelpDesk', 'prefix' => 'help-desk'], function () {
        Route::get('view', 'SiteHelpDeskController@index')->name('site-help-desk-form');
        Route::get('get-site-help-desk-list', 'SiteHelpDeskController@getSiteHelpDeskList')->name('get-site-help-desk-list');
    });


    Route::group(['namespace' => 'AcademicCalendar', 'prefix' => 'academic-calendar'], function () {
        Route::get('index', 'AcademicCalendarController@index')->name('academic-calendar-index');
        Route::get('list', 'AcademicCalendarController@getCalendarList')->name('get-academic-calendar-list');
    });

    Route::group(['namespace' => 'EmployeeLeave', 'prefix' => 'employee-leave'], function () {

        Route::get('index', 'SiteLeavePolicyController@index')->name('employee-leave-policy-index');

        Route::get('leave-approve', 'SiteLeavePolicyController@leaveApprove')->name('employee-leave-approve-view');

        Route::get('leave-policy-list', 'SiteLeavePolicyController@getLeavePolicyList')->name('employee-leave-policy-list');

        Route::get('leave-type-leave-category-designation-list', 'SiteLeavePolicyController@leaveTypeLeaveCategoryDesignationList')->name('get-policy-leave-type-leave-category-designation-list');

        Route::post('leave-policy-searched-list', 'SiteLeavePolicyController@searchedLeavePolicyList')->name('leave-policy-searched-list');

        Route::post('create-leave-policy', 'SiteLeavePolicyController@createLeavePolicy')->name('create-leave-policy');

        Route::post('update-leave-policy', 'SiteLeavePolicyController@updateLeavePolicy')->name('update-leave-policy');

        Route::delete('delete-leave-policy/{id}', 'SiteLeavePolicyController@deleteLeavePolicy')->name('delete-leave-policy');

        //=============================employee leave generate==================================

        Route::get('employee-leave-generate-list', 'SiteEmployeeLeaveGenerateController@employeeLeaveGenerateList')->name('get-employee-leave-generate-list');

        Route::get('leave-policy-list/{academicLeaveType}/{academicLeaveCetagory}', 'SiteEmployeeLeaveGenerateController@leavePolicyListByAcademicLeaveTypeAcademicLeaveCategory')->name('get-leave-policy-list-by-academic-leave-type-academic-leave-category');

        Route::get('employee-list/{leavePolicy}', 'SiteEmployeeLeaveGenerateController@getEmployeeByLeavePolicy')->name('get-employee-by-leave-policy');

        Route::post('generate-employee-leave', 'SiteEmployeeLeaveGenerateController@generateEmployeeLeave')->name('generate-employee-leave');

        Route::post('spend-days', 'SiteEmployeeLeaveGenerateController@getEmployeeLeaveSpendDays')->name('get-employee-leave-spend-days');

        Route::post('update-leave-generate', 'SiteEmployeeLeaveGenerateController@updateLeaveGenerate')->name('update-leave-generate');

        Route::delete('delete-leave-generate/{id}', 'SiteEmployeeLeaveGenerateController@deleteLeaveGenerate')->name('delete-leave-generate');

        Route::get('leave-generate-searched-list/{searchItem}', 'SiteEmployeeLeaveGenerateController@searchedLeaveGenerateList')->name('get-leave-generate-searched-list');

        //=============================employee leave application list==================================

        Route::get('application-list', 'SiteEmployeeLeaveHistoryController@employeeLeaveApplicationList')->name('get-employee-leave-application-list');

        Route::get('holiday-number/{id}', 'SiteEmployeeLeaveHistoryController@getHolidayNumber')->name('get-holiday-number');

        Route::get('approve/{id}/{checkHolidy?}', 'SiteEmployeeLeaveHistoryController@employeeLeaveApprove')->name('get-employee-leave-approve');

        Route::get('undo/{id}', 'SiteEmployeeLeaveHistoryController@employeeLeaveUndo')->name('get-employee-leave-undo');

        Route::get('cancel/{id}', 'SiteEmployeeLeaveHistoryController@employeeLeaveCancel')->name('get-employee-leave-cancel');

        //=============================all employee leave balance==================================

        Route::get('all-employee-leave-balance-list', 'SiteEmployeeLeaveHistoryController@allEmployeeLeaveBalanceList')->name('get-all-employee-leave-balance-list');
    });

    Route::group(['namespace' => 'EmployeeDuty', 'prefix' => 'employee-duty'], function () {

        Route::get('duty-master', 'SiteEmployeeDutyController@index')->name('site-employee-duty-master');
        Route::get('get-employee-assign-duty-list', 'SiteEmployeeDutyController@getEmployeeListForAssignDuty')->name('get-employee-assign-duty-list');
        Route::get('get-employee-list', 'SiteEmployeeDutyController@getEmployeeListForDuty')->name('employee-list-for-duty');
        Route::get('get-academic-duty-list', 'SiteEmployeeDutyController@getAcademicDuty')->name('get-academic-duty-list');
        Route::post('create-employee-duty', 'SiteEmployeeDutyController@createEmployeeDuty')->name('create-employee-duty');
        Route::post('create-employee-duty-assign-in-institute', 'SiteEmployeeDutyController@createEmployeeDutyAssignInInstitute')->name('create-employee-duty-assign-in-institute');

        Route::get('get-site-duty-type-detils', 'SiteEmployeeDutyController@getEmployeeDutyDetails')->name('get-site-duty-type-detils');
        Route::get('get-site-duty-type-duty-list', 'SiteEmployeeDutyController@getEmployeeDutyList')->name('get-site-duty-type-duty-list');
        Route::get('get-application-list', 'SiteEmployeeDutyController@getApplicationList')->name('get-application-list');
        Route::get('cancel/{id}', 'SiteEmployeeDutyController@employeeDutyCancel')->name('employee-duty-cancel');
    });

    Route::group(['namespace' => 'EmployeeLeave', 'prefix' => 'employee-leave-history'], function () {

        //=============================employee leave generate==================================

        Route::get('index', 'SiteEmployeeLeaveHistoryController@index')->name('employee-leave-history-index');

        Route::get('employee-list', 'SiteEmployeeLeaveHistoryController@getEmployeeList')->name('employee-list-for-leave');

        Route::get('leave-type-leave-category-list/{id?}', 'SiteEmployeeLeaveHistoryController@getLeaveTypeLeaveCategoryList')->name('get-leave-type-leave-category-list');

        Route::get('leave-days/{academicType}/{academicCategory}/{id?}', 'SiteEmployeeLeaveHistoryController@getEmployeeLeaveDays')->name('get-employee-leave-days');

        Route::get('edit/{leaveHistoryId}/{leaveDays}', 'SiteEmployeeLeaveHistoryController@updateLeaveDaysAndApproved')->name('update-leave-days-and-approve');

        Route::post('add', 'SiteEmployeeLeaveHistoryController@createApplication')->name('apply-for-leave-by-employee');

        Route::get('list', 'SiteEmployeeLeaveHistoryController@getEmployeeLeaveHistoryList')->name('get-employee-leave-history-list');

        Route::get('balance-list', 'SiteEmployeeLeaveHistoryController@getEmployeeLeaveBalanceList')->name('get-employee-leave-balance-list');

        Route::delete('delete-leave-history/{id}', 'SiteEmployeeLeaveHistoryController@deleteLeaveHistory')->name('delete-leave-history');
    });

    Route::group(['namespace' => 'Event', 'prefix' => 'event'], function () {
        Route::get('list', ['as' => 'event-list', 'uses' => 'EventController@index']);
        Route::get('head-list', 'EventController@getAcademicCalenderHeadList')->name('get-academic-calender-head-list');
        Route::get('country-list', 'EventController@getCountryList')->name('get-counry-list-for-event');
        Route::post('general-event-add', 'EventController@createGeneralEvent')->name('general-event-add');
        //        Route::post('filtered-list', ['as' => 'filtered-event-list', 'uses' => 'EventController@getFilteredEventData']);
        Route::get('add/{date?}', ['as' => 'event-add-form', 'uses' => 'EventController@createEventForm']);
        //    Route::post('event-create', [
        //        'uses' => 'EventController@createEvent'
        //    ]);
        Route::post('add', ['as' => 'event-create', 'uses' => 'EventController@createEvent']);
        Route::get('edit/{id}', ['as' => 'event-edit-form', 'uses' => 'EventController@getEventEditForm']);
        Route::post('edit', ['as' => 'event-edit', 'uses' => 'EventController@editEvent']);
        Route::get('view/{id}', ['as' => 'event-view', 'uses' => 'EventController@viewEvent']);
        Route::post('delete', ['as' => 'event-delete', 'uses' => 'EventController@deleteEvent']);
        Route::post('headwise-delete-event', ['as' => 'headwise-delete-event', 'uses' => 'EventController@deleteHeadwiseEvent']);
        Route::get('get-date-and-type-wise-events', 'EventController@getDateWiseEventsList')->name('get-date-and-type-wise-events');
        Route::get('check-holiday/{year}', 'EventController@checkHoliday')->name('check-holiday-from-academic-celendar-by-year');
    });

    Route::get('get-site-department-base-class-list/{department}', 'SiteVersionYearShiftDeptClassGroupController@getSiteDepartmentBaseClassList')->name('get-site-department-base-class-list');

    Route::get('site-version-year-shift-list', 'SiteController@getSiteVersionYearShiftList')->name('site-version-year-shift-list');
    Route::post('get-site-class-base-group-session', 'SiteVersionYearShiftDeptClassGroupController@getSiteClassBaseGroupSession')->name('get-site-class-base-group-session');

    Route::get('calendar-view', 'SiteController@showCalendar')->name('site-calendar-view');
    Route::get('student/calendar-view', 'SiteController@showCalendar')->name('site-calendar-view-for-student');


    Route::get('get-site-base-academic-group-list', 'SiteController@getAcademicGroupList')->name('get-site-base-academic-group-list');
    Route::get('get-sites', 'SiteController@getSites')->name('site-get-site-list');
    Route::get('site-list-by-site-group/{id}', 'SiteController@getSiteListBySiteGroup')->name('site-get-site-list-by-site-group');
    Route::get('logged-in-user-site-info', 'SiteController@getLoggedInUserSiteInfo')->name('site-logged-in-user-site-info');


    Route::group(['namespace' => 'Option', 'prefix' => 'option'], function () {
        Route::get('view-and-form', 'SiteOptionController@index')->name('site-option-view-form');
        Route::get('get-site-options', 'SiteOptionController@getSiteOptions')->name('site-option-get-site-options');
        Route::post('update-site-option', 'SiteOptionController@update')->name('site-option-update-site-options');
        Route::get('get-site-sms-followup', 'SiteOptionController@getSiteSmsFollowUpData')->name('site-option-get-sms-followup');
        Route::get('get-user-message-list', 'SiteOptionController@getUserMessageListUpData')->name('site-option-get-user-message-list');
        Route::get('get-option-for-employee-permission-settings', 'SiteOptionController@getEmployeePermissionOption')->name('get-option-for-employee-permission-settings');
        Route::get('get-employee-permission-settings/{id}', 'SiteOptionController@getEmployeePermissionData')->name('get-employee-permission-settings');
        Route::post('save-employee-permission-settings', 'SiteOptionController@saveEmployeePermissionOption')->name('save-employee-permission-settings');
        Route::post('delete-employee-permission-settings', 'SiteOptionController@deleteEmployeePermissionOption')->name('delete-employee-permission-settings');
        Route::get('get-geolocation-qr-code-generate', 'SiteOptionController@getGeoLocationQrCodeGenerate')->name('get-geolocation-qr-code-generate');
        Route::get('get-geolocation-qr-code-download', 'SiteOptionController@getGeoLocationQrCodeDownload')->name('get-geolocation-qr-code-download');
    });

    // library management
    Route::group(['namespace' => 'Library', 'prefix' => 'library'], function () {

        Route::get('site-library-books', 'SiteLibraryController@index')->name('site-library-books');
        Route::get('site-library-authors', 'SiteLibraryController@index')->name('site-library-authors');
        Route::get('site-library-members', 'SiteLibraryController@index')->name('site-library-members');
        Route::get('site-library-recks', 'SiteLibraryController@index')->name('site-library-recks');
        Route::get('site-library-borrowings-manage', 'SiteLibraryController@index')->name('site-library-borrowings-manage');
        Route::post('delete-book', 'SiteLibraryController@delete')->name('delete-book');

        Route::post('store-books', 'SiteLibraryController@store')->name('store-books');
        Route::get('book-statistics-count', 'SiteLibraryController@BookStatisticsCount')->name('book-statistics-count');


        Route::post('update-books', 'SiteLibraryController@update')->name('update-books');
        Route::post('get-books', 'SiteLibraryController@GetBooks')->name('get-books');
        Route::get('get-without-assign-books', 'SiteLibraryController@GetWithoutAssignBooks')->name('get_without_assign_books');
        Route::post('get-library-members-student-staff-teacher-public', 'SiteLibraryController@GetStudentStaffTeacherPublic')->name('get-library-members-student-staff-teacher-public');
        Route::post('store-member', 'SiteLibraryController@storeMember')->name('store-member');
        Route::get('get-library-members-statistics', 'SiteLibraryController@getMemberStatistics')->name('get-library-members-statistics');

        Route::get('get-library-members', 'SiteLibraryController@getMember')->name('get-library-members');
        Route::get('get-library-members-pdf', 'SiteLibraryController@getLibraryMembersPdf')->name('get-library-members-pdf');

        Route::get('get-active-members', 'SiteLibraryController@getActiveMember')->name('get-library-active-members');
        Route::get('get-borrowing-statistics', 'SiteLibraryController@getBorrowingStatistics')->name('get-borrowing-statistics');
        Route::get('get-available-books', 'SiteLibraryController@getAvailableBooks')->name('get-available-books');
        Route::get('get-book-borrowing', 'SiteLibraryController@getBorrowingBook')->name('get-book-borrowing');

        Route::get('get-overdue-book-borrowing', 'SiteLibraryController@getOverdueBookBorrowingBook')->name('get-overdue-book-borrowing');
        Route::get('get-overdue-book-borrowing-pdf-download', 'SiteLibraryController@getOverdueBookBorrowingBookPdfDownload')->name('get-overdue-book-borrowing-pdf-download');

        Route::get('get-library-borrowing-history', 'SiteLibraryController@getLibraryBorrowingHistory')->name('get-library-borrowing-history');

        Route::post('library-book-borrowing-return', 'SiteLibraryController@libraryBookBorrowingReturn')->name('library-book-borrowing-return');
        Route::post('library-book-borrowing-renew', 'SiteLibraryController@libraryBookBorrowingRenew')->name('library-book-borrowing-renew');
        Route::post('store-fine-configuration', 'SiteLibraryController@storeFineConfiguration')->name('store-fine-configuration');
        Route::get('get-library-fine', 'SiteLibraryController@getLibraryFine')->name('get-library-fine');


        Route::post('update-book-status-condition', 'SiteLibraryController@updateBookStatusCondition')->name('update-book-status-condition');

        Route::post('store-books-borrowing', 'SiteLibraryController@storeBooksBorrowing')->name('store-books-borrowing');

        // books category
        Route::post('store-books-category', 'SiteLibraryController@storeCategory')->name('store-books-category');
        Route::post('get-books-category', 'SiteLibraryController@GetBooksCategory')->name('get-books-category');
        Route::put('update-books-category/{id}', 'SiteLibraryController@UpdateBooksCategory')->name('update-books-category');
        Route::post('get-books-atthors', 'SiteLibraryController@GetBooksAuthors')->name('get-books-atthors');

        Route::get('/authors', 'SiteLibraryController@showAuthors')->name('site-get-library-authors');
        Route::post('/authors', 'SiteLibraryController@storeAuthors')->name('site-store-library-authors');
        Route::put('/authors/{id}', 'SiteLibraryController@updateAuthors')->name('site-update-library-authors');
        Route::delete('/authors/{id}', 'SiteLibraryController@destroyAuthors')->name('site-delete-library-authors');


        // Members CRUD
        Route::get('/members', 'SiteLibraryController@showMembers')->name('site-get-library-members');
        Route::post('/members', 'SiteLibraryController@storeMembers')->name('site-store-library-members');
        Route::put('/members/{id}', 'SiteLibraryController@updateMembers')->name('site-update-library-members');
        Route::delete('/members/{id}', 'SiteLibraryController@destroyMembers')->name('site-delete-library-members');

        // In routes/web.php or routes/api.php
        Route::get('/get-book-recks', 'SiteLibraryController@GetBookRacks')->name('get-book-recksd');
        Route::get('/racks', 'SiteLibraryController@showRacks')->name('site-get-racks');
        Route::post('/racks', 'SiteLibraryController@storeRack')->name('site-store-rack');
        Route::put('/racks/{id}', 'SiteLibraryController@updateRack')->name('site-update-rack');
        Route::delete('/racks/{id}', 'SiteLibraryController@destroyRack')->name('site-delete-rack');

        Route::post('/assign-books', 'SiteLibraryController@assignBooks')->name('site-assign-book');
    });

    // job-application
    Route::group(['namespace' => 'JobApplication', 'prefix' => 'job-application'], function () {
        Route::get('site-job-application', 'JobApplicationController@index')->name('site-job-application');
        Route::post('store-cricular', 'JobApplicationController@store')->name('job-store-cricular');
        Route::post('update-cricular', 'JobApplicationController@UpdateCricular')->name('job-update-cricular');
        Route::post('update-status', 'JobApplicationController@UpdateApplicationStatus')->name('job-update-status');
        Route::post('job-candidate-pdf-download', 'JobApplicationController@CandidatePdfDownload')->name('job-candidate-pdf-download');
        Route::get('get-cricular', 'JobApplicationController@GetJobCricular')->name('job-get-cricular');
        Route::post('get-application', 'JobApplicationController@GetJobApplication')->name('job-get-application');
        Route::post('get-job-position', 'JobApplicationController@GetJobPosition')->name('get-job-position');
        Route::post('delete', 'JobApplicationController@delete')->name('job-delete-cricular');
    });


    Route::group(['namespace' => 'StudentAdmission', 'prefix' => 'student-admission'], function () {
        Route::get('site-base-student-admission-declare-form', 'SiteBaseStudentAdmissionDeclareController@index')->name('site-base-student-admission-declare-form');
        Route::post('create-site-base-student-admission-declare', 'SiteBaseStudentAdmissionDeclareController@createSiteBaseStudentAdmissionDeclare')->name('create-site-base-student-admission-declare');
        Route::post('update-site-base-student-admission-declare', 'SiteBaseStudentAdmissionDeclareController@updateSiteBaseStudentAdmissionDeclare')->name('update-site-base-student-admission-declare');
        Route::post('delete-site-base-student-admission-declare', 'SiteBaseStudentAdmissionDeclareController@deleteSiteBaseStudentAdmissionDeclare')->name('delete-site-base-student-admission-declare');
        Route::post('pause-site-base-student-admission-declare', 'SiteBaseStudentAdmissionDeclareController@pauseSiteBaseStudentAdmissionDeclare')->name('pause-site-base-student-admission-declare');
        Route::get('get-year-dept-class-shift-version-session-admission-declare-list', 'SiteBaseStudentAdmissionDeclareController@getYearDeptClassShiftVersionSessionAdmissionDeclareList')
            ->name('get-year-dept-class-shift-version-session-admission-declare-list');

        Route::post('site-class-wise-academic-class-group-list', 'SiteBaseStudentAdmissionDeclareController@getSiteClassWiseAcademicClassGroup')
            ->name('site-class-wise-academic-class-group-list');

        Route::post('activate-site-base-student-admission-declare', 'SiteBaseStudentAdmissionDeclareController@activateSiteBaseStudentAdmissionDeclare')
            ->name('activate-site-base-student-admission-declare');


        //Roll Reg Entry
        Route::get('get-site-admission-declare-form', 'SiteBaseBoardSelectedStudentAdmissionController@getAdmissionDeclareForm')->name('get-admission-declare-form');
        Route::post('get-roll-registration-entry-list-for-admission', 'SiteBaseBoardSelectedStudentAdmissionController@getRollRegistrationEntryListForAdmission')->name('get-roll-registration-entry-list-for-admission');
        Route::get('get-roll-registration-entry-list-for-admission-pdf', 'SiteBaseBoardSelectedStudentAdmissionController@getRollRegistrationEntryListForAdmissionPdf')->name('get-roll-registration-entry-list-for-admission-pdf');
        Route::get('get-account-wise-admission-fee-report-pdf', 'SiteBaseBoardSelectedStudentAdmissionController@getAccountWiseAdmisssionFeeReportPdf')->name('get-account-wise-admission-fee-report-pdf');
        Route::get('get-subhead-wise-admission-fee-report-pdf', 'SiteBaseBoardSelectedStudentAdmissionController@getSubheadWiseAdmisssionFeeReportPdf')->name('get-subhead-wise-admission-fee-report-pdf');
        Route::post('create-student-roll-reg-for-admission-validation', 'SiteBaseBoardSelectedStudentAdmissionController@createStudentRollRegForAdmissionValidation')->name('create-student-roll-reg-for-admission-validation');
        Route::post('upload-roll-reg-excell-for-admission-validation', 'SiteBaseBoardSelectedStudentAdmissionController@uploadRollRegExcell')->name('upload-roll-reg-excell-for-admission-validation');
        //Route::post('upload-roll-reg-for-admission-validation', 'SiteBaseBoardSelectedStudentAdmissionController@uploadRollRegForAdmissionValidation')->name('upload-roll-reg-for-admission-validation');
        //  Route::post('create-board-selected-student', 'SiteBaseBoardSelectedStudentAdmissionController@createBoardSelectedStudent')->name('create-board-selected-student');

        Route::get('get-site-admission-payment-slip/{invoice_no}/{tr_id}', 'SiteBaseBoardSelectedStudentAdmissionController@siteStudentPaymentSlipPdf')->name('get-site-admission-payment-slip');


        Route::get('site-student-admission-inside-form', 'SiteBaseStudentAdmissionDeclareController@siteStudentAdmissionInsideForm')->name('site-student-admission-inside-form');
    });

    Route::group(['namespace' => 'StudentAdmission', 'prefix' => 'admission-student-list'], function () {
        Route::post('get-admission-applied-student-list', 'SiteStudentAdmissionListController@getAdmissionAppliedStudentList')->name('get-admission-applied-student-list');
        Route::post('approve-student-from-admission-applied', 'SiteStudentAdmissionListController@approveStudentFromAdmissionApplied')->name('approve-student-from-admission-applied');
        Route::post('pause-student-from-admission-applied', 'SiteStudentAdmissionListController@pauseStudentFromAdmissionApplied')->name('pause-student-from-admission-applied');
        Route::post('delete-student-from-admission-applied', 'SiteStudentAdmissionListController@deleteStudentFromAdmissionApplied')->name('delete-student-from-admission-applied');
        Route::post('activeate-student-from-admission-applied', 'SiteStudentAdmissionListController@activeateStudentFromAdmissionApplied')->name('activeate-student-from-admission-applied');
        Route::post('download-single-student-admission-form-pdf', 'SiteStudentAdmissionListController@downloadSingleStudentAdmissionFormPdf')->name('download-single-student-admission-form-pdf');
    });

    //Lottery Result

    Route::group(['namespace' => 'StudentAdmission', 'prefix' => 'lottery-result'], function () {
        Route::get('site-admission-lottery-result-form', 'SiteStudentAdmissionLotteryController@siteAdmissionLotteryResultForm')->name('site-admission-lottery-result-form');
        Route::post('get-admission-lottery-result-student-list', 'SiteStudentAdmissionLotteryController@getAdmissionLotteryResultStudentList')->name('get-admission-lottery-result-student-list');
        Route::post('approve-student-from-admission-lottery-result', 'SiteStudentAdmissionLotteryController@approveStudentFromAdmissionLotteryResult')->name('approve-student-from-admission-lottery-result');
        Route::get('get-admission-test-result-type-list', 'SiteStudentAdmissionLotteryController@getAdmissionTestResultTypeList')->name('get-admission-test-result-type-list');
    });





    //Lottery Result
    Route::group(['namespace' => 'StudentAdmission', 'prefix' => 'addmission-fee-settings'], function () {
        Route::get('site-subhead-list', 'SiteAdmissionSubheadSettingsController@siteFeeSubHeadList')->name('site-admission-site-subhead-list');
        Route::post('create-update-student-admission-fee-subhead', 'SiteAdmissionSubheadSettingsController@createStudentAdmissionSubhead')->name('site-admission-site-subhead-list');
        Route::get('get-site-payment-gateway-list', 'SiteAdmissionSubheadSettingsController@getSitePaymentGateway')->name('get-site-payment-gateway-list');
        Route::post('get-site-payment-gateway-wise-fee-info', 'SiteAdmissionSubheadSettingsController@getHeadWiseSubheadList')->name('get-site-payment-gateway-wise-fee-info');
        Route::post('site-student-fee-payment-gateway-setting-save', 'SiteAdmissionSubheadSettingsController@siteStudentFeePaymentGatewaySettigSave')->name('site-student-fee-payment-gateway-setting-save');
    });


    Route::group(['namespace' => 'StudentRegistration', 'prefix' => 'student-registration'], function () {
        Route::get('site-base-student-registration-declare-form', 'SiteBaseStudentRegistationDeclareController@index')->name('site-base-student-registration-declare-form');
        Route::post('create-site-base-student-registration-declare', 'SiteBaseStudentRegistationDeclareController@createSiteBaseStudentRegistrationDeclare')->name('create-site-base-student-registration-declare');
        Route::post('update-site-base-student-registration-declare', 'SiteBaseStudentRegistationDeclareController@updateSiteBaseStudentRegistrationDeclare')->name('update-site-base-student-registration-declare');
        Route::post('delete-site-base-student-registration-declare', 'SiteBaseStudentRegistationDeclareController@deleteSiteBaseStudentRegistrationDeclare')->name('delete-site-base-student-registration-declare');
        Route::post('pause-site-base-student-registration-declare', 'SiteBaseStudentRegistationDeclareController@pauseSiteBaseStudentRegistrationDeclare')->name('pause-site-base-student-registration-declare');
        Route::get('get-year-dept-class-shift-version-session-registration-declare-list', 'SiteBaseStudentRegistationDeclareController@getYearDeptClassShiftVersionSessionRegistrationDeclareList')
            ->name('get-year-dept-class-shift-version-session-registration-declare-list');

        Route::post('activate-site-base-student-registration-declare', 'SiteBaseStudentRegistationDeclareController@activateSiteBaseStudentRegistrationDeclare')
            ->name('activate-site-base-student-registration-declare');
    });


    Route::group(['namespace' => 'StudentRegistration', 'prefix' => 'student-registration-list'], function () {

        Route::post('get-registration-applied-student-list', 'SiteBaseStudentRegistrationListController@getRegistrationAppliedStudentList')->name('get-registration-applied-student-list');
        Route::post('approve-student-from-registration-applied', 'SiteBaseStudentRegistrationListController@approveStudentFromRegistrationApplied')->name('approve-student-from-registration-applied');
        Route::post('pause-student-from-registration-applied', 'SiteBaseStudentRegistrationListController@pauseStudentFromRegistrationApplied')->name('pause-student-from-registration-applied');
        Route::post('delete-student-from-registration-applied', 'SiteBaseStudentRegistrationListController@deleteStudentFromRegistrationApplied')->name('delete-student-from-registration-applied');
        Route::post('activeate-student-from-registration-applied', 'SiteBaseStudentRegistrationListController@activeateStudentFromRegistrationApplied')->name('activeate-student-from-registration-applied');
    });


    Route::group(['namespace' => 'Exam', 'prefix' => 'exam'], function () {
        Route::get('examination-setting-master', 'SiteExaminationExamTypeSettingController@index')->name('site-examination-setting-master');
        Route::post('get-site-examination-exam-type-list', 'SiteExaminationExamTypeSettingController@getSiteExaminationExamTypeList')->name('get-site-examination-exam-type-list');
        Route::post('create-update-site-examination-exam-type', 'SiteExaminationExamTypeSettingController@createUpdateSiteExaminationExamType')->name('create-update-site-examination-exam-type');

        Route::post('subject-exam-type-marks-setup', 'SiteExaminationExamTypeSettingController@subjectListForExamTypeMarksSetup')->name('subject-exam-type-marks-setup');
        Route::post('subject-exam-type-marks-setup-submit', 'SiteExaminationExamTypeSettingController@subjectListForExamTypeMarksSetupSubmit')->name('subject-exam-type-marks-setup-submit');
    });

    Route::group(['namespace' => 'Progress', 'prefix' => 'progress'], function () {
        Route::get('progress-category-system-setting', 'SiteProgressCategorySettingController@index')->name('site-progress-category-system-setting');
        Route::post('get-site-progress-list', 'SiteProgressCategorySettingController@getProgressList')->name('get-site-progress-list');
        Route::post('create-update-site-progress-settings', 'SiteProgressCategorySettingController@createUpdateSiteProgressSettings')->name('create-update-site-progress-settings');
        Route::post('get-site-class-and-subject-list', 'SiteProgressCategorySettingController@getSiteClassAndSubjectList')->name('get-site-class-and-subject-list');
        Route::post('get-site-class-wise-subject-list', 'SiteProgressCategorySettingController@getSiteClassWiseSubjectList')->name('get-site-class-wise-subject-list');
        Route::post('create-update-subject-progress-area', 'SiteProgressCategorySettingController@createUpdateProgressSubjectArea')->name('create-update-subject-progress-area');
        Route::get('get-subject-progress-area-list', 'SiteProgressCategorySettingController@getProgressSubjectAreaList')->name('get-subject-progress-area-list');
      
        Route::post('get-site-class-progress-list', 'SiteProgressCategorySettingController@getSiteClassProgressList')->name('get-site-class-progress-list');
        Route::post('get-progress-subject-areas-setup', 'SiteProgressCategorySettingController@subjectSettingListProgressSubjectAreasSetup')->name('get-progress-subject-areas-setup');
        Route::post('subject-progress-area-settings-setup-submit', 'SiteProgressCategorySettingController@subjectProgressAreasSetupSubmit')->name('subject-progress-area-settings-setup-submit');
    
        // progress declare
        Route::get('progress-declare-master', 'SiteProgressDeclareController@index')->name('site-progress-declare-master');
        Route::post('get-progress-list-for-declare', 'SiteProgressDeclareController@getProgressListForDeclare')->name('get-progress-list-for-declare');
        Route::post('get-student-list-for-progress-declare', 'SiteProgressDeclareController@getProgressListForDeclare')->name('get-student-list-for-progress-declare');
    });

    Route::group(['namespace' => 'Assessment', 'prefix' => 'assessment'], function () {

        // assessment subject topic
        // Route::get('class-subject-assessment-topic-form', 'SiteClassSubjectWiseAssessmentTopicsController@index')->name('site-class-subject-assessment-topic-form');
        // Route::post('get-subject-list-for-assessment', 'SiteClassSubjectWiseAssessmentTopicsController@getSubjectListForAssessment')->name('get-subject-list-for-assessment');
        // Route::post('add-subject-assessment-topic', 'SiteClassSubjectWiseAssessmentTopicsController@addSubjectAssessmentTopic')->name('add-subject-assessment-topic');
        // Route::post('get-subject-assessment-topics', 'SiteClassSubjectWiseAssessmentTopicsController@getSubjectAssessmentTopics')->name('get-subject-assessment-topics');


        // Route::get('assessment-settings-master', 'SiteAssessmentSettingController@index')->name('site-assessment-settings-master');
        // Route::post('get-site-assessment-and-type-list', 'SiteAssessmentSettingController@getSiteAssessmentAndTypeList')->name('get-site-assessment-and-type-list');
        // Route::post('create-update-site-assessment-and-type', 'SiteAssessmentSettingController@createUpdateSiteAssessmentAndType')->name('create-update-site-assessment-and-type');

        // Route::post('get-site-depertment-class-wise-assessment-list', 'SiteAssessmentSettingController@getSiteDepartmentClassBaseAssessments')->name('get-site-depertment-class-wise-assessment-list');
        // Route::post('get-site-assessment-wise-assessment-type', 'SiteAssessmentSettingController@getSiteAssessmentWiseAssessmentType')->name('get-site-assessment-wise-assessment-type');
        // Route::post('get-subject-assessment-and-type-setup', 'SiteAssessmentSettingController@getSiteSubjectAssessmentAndTypeSetup')->name('get-subject-assessment-and-type-setup');
        // Route::post('submit-subject-topics-assessment-and-type-no-setup', 'SiteAssessmentSettingController@submitSubjectTopicsAssessmentAndTypeNoSetup')->name('submit-subject-topics-assessment-and-type-no-setup');

        Route::get('site-assessment-declare-form', 'SiteAssessmentDeclareController@index')->name('site-assessment-declare-form');
        Route::post('get-assessment-list-for-assessment-declare', 'SiteAssessmentDeclareController@getAssessmentListForAssessmentDeclare')->name('get-assessment-list-for-assessment-declare');
        Route::post('get-student-subject-assessment-setting-list-for-assessment-declare', 'SiteAssessmentDeclareController@getStudentSubjectListSettingForAssessmentDeclare')->name('get-student-subject-assessment-setting-list-for-assessment-declare');
        Route::post('create-update-site-base-assessment-declare', 'SiteAssessmentDeclareController@createUpdateAssessmentDeclare')->name('create-update-site-base-assessment-declare');

        Route::get('site-assessment-mark-entry-form', 'SiteBaseAssessmentMarkEntryController@index')->name('site-assessment-mark-entry-form');
        Route::post('get-site-assessment-list-for-mark-entry', 'SiteBaseAssessmentMarkEntryController@getSiteAssessmentListForMarkEntry')->name('get-site-assessment-list-for-mark-entry');
        Route::post('get-site-assessment-declared-subject-list', 'SiteBaseAssessmentMarkEntryController@getSiteAssessmentDeclaredSubjectList')->name('get-site-assessment-declared-subject-list');
        Route::post('get-site-assessment-wise-assessment-type-for-mark-entry', 'SiteBaseAssessmentMarkEntryController@getSiteAssessmentWiseAssessmentTypeForMarkEntry')->name('get-site-assessment-wise-assessment-type-for-mark-entry');
        Route::post('get-site-assessment-declared-subject-topic-list', 'SiteBaseAssessmentMarkEntryController@getSiteAssessmentDeclaredSubjectTopicList')->name('get-site-assessment-declared-subject-topic-list');
        Route::post('get-site-base-student-list-for-assessment-marks-entry', 'SiteBaseAssessmentMarkEntryController@getSiteBaseStudentListForAssessmentMarkEntry')->name('get-site-base-student-list-for-assessment-marks-entry');
        Route::post('create-update-assessment-type-no-student-mark-entry', 'SiteBaseAssessmentMarkEntryController@createUpdateAssessmentStudentMarkEntry')->name('create-update-assessment-type-no-student-mark-entry');

        Route::get('site-assessment-teacher-mark-entry-form', 'SiteBaseAssessmentMarkEntryController@index')->name('site-assessment-teacher-mark-entry-form');
    });


    Route::group(['namespace' => 'AssessmentResult', 'prefix' => 'assessment-result'], function () {

        Route::get('site-assessment-result-generate-form', 'SiteBaseAssessmentResultGenerateController@index')->name('site-assessment-result-generate-form');
        Route::post('get-site-declared-assessment-list', 'SiteBaseAssessmentResultGenerateController@getSiteDeclaredAssessmentList')->name('get-site-declared-assessment-list');
        Route::post('create-update-assessment-result-generate', 'SiteBaseAssessmentResultGenerateController@createUpdateAssessmentResultRenerate')->name('create-update-assessment-result-generate');
        Route::post('public-pause-assessment-result-to-panel', 'SiteBaseAssessmentResultGenerateController@publishPauseAssessmentResultToPanel')->name('public-pause-assessment-result-to-panel');
        Route::post('delete-assessment-result-to-employee-student-panel', 'SiteBaseAssessmentResultGenerateController@deleteAssessmentResultToPanel')->name('delete-assessment-result-to-employee-student-panel');

        Route::post('get-site-assessment-primary-result-list', 'SiteBaseAssessmentPrimaryResultGenerateController@getAssessmentGeneratedList')->name('get-site-assessment-primary-result-list');
        Route::post('create-update-assessment-primary-result-generate', 'SiteBaseAssessmentPrimaryResultGenerateController@createUpdateAssessmentPrimaryResult')->name('create-update-assessment-primary-result-generate');

        Route::post('get-site-assessment-final-result-list', 'SiteBaseAssessmentFinalResultGenerateController@getAssessmentFianlGeneratedList')->name('get-site-assessment-final-result-list');
        Route::post('create-update-assessment-final-result-generate', 'SiteBaseAssessmentFinalResultGenerateController@createUpdateAssessmentFinalResult')->name('create-update-assessment-final-result-generate');


        // Route::get('get-site-assessment-result-setting-form', 'SiteAssessmentResultSettingController@index')->name('get-site-assessment-result-setting-form');
        // Route::post('get-site-base-assessment-setting-list', 'SiteAssessmentResultSettingController@getSiteBaseAssessmentSettingList')->name('get-site-base-assessment-setting-list');
        // Route::post('create-update-site-assessment-result-setting', 'SiteAssessmentResultSettingController@createUpdateSiteAssessmentResultSetting')->name('create-update-site-assessment-result-setting');
        // Route::post('get-site-base-assessment-scale-system-list', 'SiteAssessmentResultSettingController@getSiteBaseAssessmentScaleSystemList')->name('get-site-base-assessment-scale-system-list');
        // Route::post('create-update-site-assessment-result-scale-setting', 'SiteAssessmentResultSettingController@createUpdateAssessmentResultScaleSystemSetting')->name('create-update-site-assessment-result-scale-setting');

        Route::group(['namespace' => 'Report', 'prefix' => 'report'], function () {
            Route::get('site-assessment-result-report-form', 'SiteBaseAssessmentResultReportController@index')->name('site-assessment-result-report-form');
            Route::post('get-site-base-assessment-declare-list-for-result', 'SiteBaseAssessmentResultReportController@getAssessmentDeclarListForResult')->name('get-site-base-assessment-declare-list-for-result');
            Route::post('get-site-assessment-type-list-for-result', 'SiteBaseAssessmentResultReportController@getAssessmentTypeListForResult')->name('get-site-assessment-type-list-for-result');
            Route::post('get-site-base-student-asessment-tabulation-sheet', 'SiteBaseAssessmentResultReportController@getSiteStudentAssessmentTabulationSheet')->name('get-site-base-student-asessment-tabulation-sheet');
            Route::post('get-site-student-list', 'SiteBaseAssessmentResultReportController@getSiteStudentList')->name('get-site-student-list-for-assessment-report');
            Route::post('get-site-assessment-student-result-details', 'SiteBaseAssessmentResultReportController@getSiteAssessmentStudentResultDetails')->name('get-site-assessment-student-result-details');
            Route::post('get-site-base-assessment-tabulation-sheet-pdf', 'SiteBaseAssessmentResultReportController@getSiteAssessmentTabulationSheetPdf')->name('get-site-base-assessment-tabulation-sheet-pdf');
            Route::post('get-site-assessment-student-result-sheet-pdf', 'SiteBaseAssessmentResultReportController@getSiteAssessmentResultSheetPdf')->name('get-site-assessment-student-result-sheet-pdf');

            //  Route::get('site-assessment-primary-result-report-form', 'SiteBaseAssessmentPrimaryResultReportController@index')->name('site-assessment-primary-result-report-form');
            Route::post('get-site-base-assessment-primary-result-list', 'SiteBaseAssessmentPrimaryResultReportController@getSiteBaseAssessmentPrimaryResultList')->name('get-site-base-assessment-primary-result-list');
            Route::post('get-site-assessment-type-list-for-primary-result', 'SiteBaseAssessmentPrimaryResultReportController@getAssessmentTypeListForPrimaryResult')->name('get-site-assessment-type-list-for-primary-result');
            Route::post('get-site-student-list-for-primary-result', 'SiteBaseAssessmentPrimaryResultReportController@getSiteStudentListForPrimaryList')->name('get-site-student-list-for-primary-result');
            Route::post('get-site-student-assessment-primary-result-details', 'SiteBaseAssessmentPrimaryResultReportController@getSiteStudentAssessmentPrimaryResultDetails')->name('get-site-student-assessment-primary-result-details');
            Route::post('get-site-assessment-student-primary-result-sheet-pdf', 'SiteBaseAssessmentPrimaryResultReportController@getSiteAssessmentPrimaryResultSheetPdf')->name('get-site-assessment-student-primary-result-sheet-pdf');

            Route::post('get-site-student-list-for-final-result', 'SiteBaseAssessmentFinalResultReportController@getSiteAssessmentFinalResultSheet')->name('get-site-student-list-for-final-result');
            Route::post('get-site-student-assessment-final-result-details', 'SiteBaseAssessmentFinalResultReportController@getSiteStudentAssessmentFinalResultDetails')->name('get-site-student-assessment-final-result-details');
            Route::post('get-site-assessment-student-final-result-sheet-pdf', 'SiteBaseAssessmentFinalResultReportController@getSiteStudentAssessmentFinalResultSheetPdf')->name('get-site-assessment-student-final-result-sheet-pdf');
        });
    });

    Route::group(['namespace' => 'EmployeePanel', 'prefix' => 'employee-panel'], function () {


        Route::group(['namespace' => 'Exam', 'prefix' => 'exam'], function () {
            Route::get('employee-exam-marks-entry-form', 'EmployeeExamMarksEntryController@index')->name('employee-exam-marks-entry-form');
            Route::post('get-site-employee-base-class-examination-list', 'EmployeeExamMarksEntryController@getSiteEmployeeBaseClassExaminationList')->name('get-site-employee-base-class-examination-list');
            Route::post('get-site-employee-base-examination-subject-list', 'EmployeeExamMarksEntryController@getSiteEmployeeBaseExaminationSubjectList')->name('get-site-employee-base-examination-subject-list');
            Route::post('get-site-employee-base-answer-paper-list', 'EmployeeExamMarksEntryController@getSiteEmployeeBaseAnswerPaperList')->name('get-site-employee-base-answer-paper-list');
            Route::post('get-site-employee-base-student-marks-entry-list', 'EmployeeExamMarksEntryController@getSiteEmployeeBaseStudentMarksEntryList')->name('get-site-employee-base-student-marks-entry-list');
            Route::post('site-employee-exam-type-student-number-entry', 'EmployeeExamMarksEntryController@siteEmployeeExamTypeStudentNumberEntry')->name('site-employee-exam-type-student-number-entry');

            // for site group exam
            Route::post('get-site-group-employee-base-class-examination-list', 'EmployeeSiteGroupExamMarksEntryController@getSiteGroupEmployeeBaseClassExaminationList')->name('get-site-group-employee-base-class-examination-list');
            Route::post('get-site-group-employee-base-examination-subject-list', 'EmployeeSiteGroupExamMarksEntryController@getSiteGroupEmployeeBaseExaminationSubjectList')->name('get-site-group-employee-base-examination-subject-list');
            Route::post('get-site-group-employee-base-examination-type', 'EmployeeSiteGroupExamMarksEntryController@getSiteGroupEmployeeBaseExaminationTypeList')->name('get-site-group-employee-base-examination-type');
            Route::post('get-site-group-employee-base-student-marks-entry-list', 'EmployeeSiteGroupExamMarksEntryController@getSiteGroupEmployeeBaseStudentMarksEntryList')->name('get-site-group-employee-base-student-mark-entry-list');
            Route::post('save-site-group-employee-exam-type-student-number-entry', 'EmployeeSiteGroupExamMarksEntryController@saveSiteGroupEmployeeExamTypeStudentNumberEntry')->name('save-site-group-employee-exam-type-student-number-entry');
        });


        Route::group(['namespace' => 'Exam', 'prefix' => 'seat-plan-attendance'], function () {
            Route::get('employee-exam-seat-plan-attendance-form', 'EmployeeExamSeatPlanAttendanceController@index')->name('employee-exam-seat-plan-attendance-form');
            Route::post('get-exam-date-base-exam-time-form-emp', 'EmployeeExamSeatPlanAttendanceController@getExamDateBaseExamTimeFormEmp')->name('get-exam-date-base-exam-time-form-emp');
            Route::post('get-exam-date-time-base-seat-plan-for-attendance', 'EmployeeExamSeatPlanAttendanceController@getExamDateTimeBaseSeatPlanForAttendance')->name('get-exam-date-time-base-seat-plan-for-attendance');
            Route::post('save-seat-plan-invigilator-base-exam-attendance', 'EmployeeExamSeatPlanAttendanceController@saveSeatPlanInvigilatorBaseExamAttendance')->name('save-seat-plan-invigilator-base-exam-attendance');
            Route::post('get-exam-date-time-base-student-for-manual-attendance', 'EmployeeExamSeatPlanAttendanceController@getExamDateTimeBaseStudentForManualAttendance')->name('get-exam-date-time-base-student-for-manual-attendance');
            Route::post('save-invigilator-base-manual-exam-attendance', 'EmployeeExamSeatPlanAttendanceController@saveInvigilatorBaseManualExamAttendance')->name('save-invigilator-base-manual-exam-attendance');

            //=========online exam
            Route::post('start-online-exam-for-student-by-employee', 'EmployeeExamSeatPlanAttendanceController@startOnlineExamForStudentByEmployee')->name('start-online-exam-for-student-by-employee');
            Route::post('re-start-online-exam-for-student-by-employee', 'EmployeeExamSeatPlanAttendanceController@reStartOnlineExamForStudentByEmployee')->name('re-start-online-exam-for-student-by-employee');
            Route::post('end-online-exam-for-student-by-employee', 'EmployeeExamSeatPlanAttendanceController@endOnlineExamForStudentByEmployee')->name('end-online-exam-for-student-by-employee');
            Route::post('refresh-online-exam-for-student-by-employee', 'EmployeeExamSeatPlanAttendanceController@refreshOnlineExamForStudentByEmployee')->name('refresh-online-exam-for-student-by-employee');

            //=====online exam all student
            Route::post('start-online-exam-for-all-student-by-employee', 'EmployeeExamSeatPlanAttendanceController@startOnlineExamForAllStudentByEmployee')->name('start-online-exam-for-all-student-by-employee');
            Route::post('re-start-online-exam-for-all-student-by-employee', 'EmployeeExamSeatPlanAttendanceController@reStartOnlineExamForAllStudentByEmployee')->name('re-start-online-exam-for-all-student-by-employee');
            Route::post('end-online-exam-for-all-student-by-employee', 'EmployeeExamSeatPlanAttendanceController@endOnlineExamForAllStudentByEmployee')->name('end-online-exam-for-all-student-by-employee');
            Route::post('get-exam-type-list-for-attendance-refresh', 'EmployeeExamSeatPlanAttendanceController@getExamTypeListForAttendanceRefresh')->name('get-exam-type-list-for-attendance-refresh');
        });

        Route::group(['namespace' => 'Exam', 'prefix' => 'duty-roster'], function () {
            Route::post('get-emp-exam-duty-roster', 'EmployeeExamSeatPlanAttendanceController@getEmpExamDutyRoster')->name('get-emp-exam-duty-roster');
        });

        Route::group(['namespace' => 'Result', 'prefix' => 'result'], function () {
            Route::get('emp-exam-result-master-form', 'EmpExamResultController@index')->name('emp-exam-result-master-form');
        });
    });

    Route::group(['namespace' => 'Exam', 'prefix' => 'exam-committee'], function () {
        Route::get('exam-committee-declare-form', 'SiteExamCommitteeDeclareController@index')->name('exam-committee-declare-form');
        Route::get('get-year-dept-class-shift-version-employee-list', 'SiteExamCommitteeDeclareController@getYearDeptClassShiftVersionEmployeeList')->name('get-year-dept-class-shift-version-employee-list');
        Route::post('create-site-base-emp-exam-committee', 'SiteExamCommitteeDeclareController@createSiteBaseEmpExamCommittee')->name('create-site-base-emp-exam-committee');
        Route::post('update-site-base-emp-exam-committee', 'SiteExamCommitteeDeclareController@updateSiteBaseEmpExamCommittee')->name('update-site-base-emp-exam-committee');
    });


    Route::group(['namespace' => 'Exam', 'prefix' => 'exam-declare'], function () {
        Route::get('site-exam-declare-form', 'SiteBaseExamDeclareController@index')->name('site-exam-declare-form');
        Route::post('get-student-list-for-exam-declare', 'SiteBaseExamDeclareController@getStudentListForExamDeclare')->name('get-student-list-for-exam-declare');
        Route::post('get-examination-list-for-exam-declare', 'SiteBaseExamDeclareController@getExaminationListForExamDeclare')->name('get-examination-list-for-exam-declare');
        //  Route::post('create-site-base-new-exam-declare', 'SiteBaseExamDeclareController@createSiteBaseNewExamDeclare')->name('create-site-base-new-exam-declare');
        Route::post('get-site-base-declared-exam-list', 'SiteBaseExamDeclareController@getSiteBaseDeclaredExamList')->name('get-site-base-declared-exam-list');
        Route::post('update-site-base-new-exam-declare', 'SiteBaseExamDeclareController@updateSiteBaseNewExamDeclare')->name('update-site-base-new-exam-declare');
        Route::post('delete-site-base-exam-declare', 'SiteBaseExamDeclareController@deleteSiteBaseExamDeclare')->name('delete-site-base-exam-declare');
        Route::post('get-examination-routine-list', 'SiteBaseExamDeclareController@getSiteBaseExamRoutineList')->name('get-examination-routine-list');
    });

    Route::group(['namespace' => 'Exam', 'prefix' => 'admit-card'], function () {
        Route::post('get-site-department-class-base-examination', 'SiteExamAdmitCardAttendanceSheetController@getSiteDepartmentClassBaseExamination')->name('get-site-department-class-base-examination');
        Route::get('site-admit-card-form', 'SiteExamAdmitCardAttendanceSheetController@index')->name('site-admit-card-form');
        Route::post('student-list-for-admit-card', 'SiteExamAdmitCardAttendanceSheetController@studentListForAdmitCard')->name('student-list-for-admit-card');
        Route::post('student-exam-detail-for-admit-card', 'SiteExamAdmitCardAttendanceSheetController@studentExamDetailForAdmitCard')->name('student-exam-detail-for-admit-card');
        Route::post('student-exam-detail-for-admit-card-pdf', 'SiteExamAdmitCardAttendanceSheetController@studentExamDetailForAdmitCardPdf')->name('student-exam-detail-for-admit-card-pdf');
        Route::post('student-exam-detail-for-admit-card-two-pdf', 'SiteExamAdmitCardAttendanceSheetController@studentExamDetailForAdmitCardTwoPdf')->name('student-exam-detail-for-admit-card-two-pdf');
        Route::post('site-exam-attendance-sheet-pdf', 'SiteExamAdmitCardAttendanceSheetController@siteExamAttendanceSheetPdf')->name('site-exam-attendance-sheet-pdf');

        Route::post('site-exam-attendance-sheet-two-pdf', 'SiteExamAdmitCardAttendanceSheetController@siteExamAttendanceSheetTwoPdf')->name('site-exam-attendance-sheet-two-pdf');
        Route::post('site-exam-student-list-show-pdf', 'SiteExamAdmitCardAttendanceSheetController@siteExamStudentListPdf')->name('site-exam-student-list-show-pdf');

        Route::post('site-exam-attendance-sheet-three-pdf', 'SiteExamAdmitCardAttendanceSheetController@siteExamAttendanceSheetThreePdf')->name('site-exam-attendance-sheet-three-pdf');
        Route::post('add-site-class-admit-card-description', 'SiteExamAdmitCardAttendanceSheetController@addSiteAdmitCardDescription')->name('add-site-class-admit-card-description');

        Route::post('student-list-for-attendance-sheet', 'SiteExamAdmitCardAttendanceSheetController@studentListForAttendanceSheet')->name('student-list-for-attendance-sheet');
        Route::post('student-exam-short-attendace-sheet', 'SiteExamAdmitCardAttendanceSheetController@siteExamShortAttendanceSheet')->name('student-exam-short-attendace-sheet');
        Route::post('get-room-list-for-attendance-sheet', 'SiteExamAdmitCardAttendanceSheetController@getRoomListForAttendance')->name('get-room-list-for-attendance-sheet');
    });



    Route::group(['namespace' => 'Exam', 'prefix' => 'site-exam-attendance'], function () {
        Route::get('site-exam-attendance-entry-form', 'SiteBaseExamAttendanceController@index')->name('site-exam-attendance-entry-form');
        Route::post('get-site-department-class-base-examination', 'SiteBaseExamAttendanceController@getSiteDepartmentClassBaseExamination')->name('get-site-department-class-base-examination-for-mark-entry');
        Route::post('get-site-examination-base-subject-list-for-attendance', 'SiteBaseExamAttendanceController@getSiteExaminationBaseSubjectListForAttendance')->name('get-site-examination-base-subject-list-for-attendance');
        Route::post('get-site-student-list-for-attendance', 'SiteBaseExamAttendanceController@getSiteStudentListForAttendance')->name('get-site-student-list-for-attendance');
        Route::post('site-student-exam-attendance-entry', 'SiteBaseExamAttendanceController@siteStudentExamAttendanceEntry')->name('site-student-exam-attendance-entry');

        //=============all-student-online-attendance
        Route::post('get-exam-date-base-exam-time-for-admin', 'SiteBaseExamAttendanceController@getExamDateBaseExamTimeForAdmin')->name('get-exam-date-base-exam-time-for-admin');
        Route::post('get-exam-date-time-base-online-exam-statistics', 'SiteBaseExamAttendanceController@getExamDateTimeBaseOnlineExamStatistics')->name('get-exam-date-time-base-online-exam-statistics');
        Route::post('start-online-exam-for-all-student', 'SiteBaseExamAttendanceController@startOnlineExamForAllStudent')->name('start-online-exam-for-all-student');
        Route::post('re-start-online-exam-for-all-student', 'SiteBaseExamAttendanceController@reStartOnlineExamForAllStudent')->name('re-start-online-exam-for-all-student');
        Route::post('end-online-exam-for-all-student', 'SiteBaseExamAttendanceController@endOnlineExamForAllStudent')->name('end-online-exam-for-all-student');

        Route::post('end-cancel-online-exam-for-all-student', 'SiteBaseExamAttendanceController@endCancelOnlineExamForAllStudent')->name('end-cancel-online-exam-for-all-student');

        //============End Exam Cancel
        Route::post('get-site-student-list-for-end-exam-cancel', 'SiteBaseExamAttendanceController@getSiteStudentListForEndExamCancel')->name('get-site-student-list-for-end-exam-cancel');
        Route::post('student-end-online-exam-cancel', 'SiteBaseExamAttendanceController@studentEndOnlineExamCancel')->name('student-end-online-exam-cancel');
    });


    Route::group(['namespace' => 'Exam', 'prefix' => 'site-mark-entry'], function () {
        Route::get('site-exam-marks-entry-form', 'SiteBaseExamMarksEntryController@index')->name('site-exam-marks-entry-form');
        Route::post('get-site-department-class-base-examination', 'SiteBaseExamMarksEntryController@getSiteDepartmentClassBaseExamination')->name('get-site-department-class-base-examination');
        Route::post('get-site-examination-base-subject-list', 'SiteBaseExamMarksEntryController@getSiteExaminationBaseSubjectList')->name('get-site-examination-base-subject-list');
        Route::post('get-site-base-student-list-for-marks-entry', 'SiteBaseExamMarksEntryController@getSiteBaseStudentListForMarksEntry')->name('get-site-base-student-list-for-marks-entry');
        Route::post('get-site-base-student-mark-list', 'SiteBaseExamMarksEntryController@getSiteBaseStudentMarkList')->name('get-site-base-student-mark-list');
        Route::post('indivisual-exam-type-student-number-entry', 'SiteBaseExamMarksEntryController@indivisualExamTypeStudentNumberEntry')->name('Individual-exam-type-student-number-entry');
        Route::post('combinely-exam-type-student-number-entry', 'SiteBaseExamMarksEntryController@combinelyExamTypeStudentNumberEntry')->name('combinely-exam-type-student-number-entry');
        Route::post('get-subject-base-exam-type-list-for-exam-marks-entry', 'SiteBaseExamMarksEntryController@getSubjectBaseExamTypeListForExamMarksEntry')->name('get-subject-base-exam-type-list-for-exam-marks-entry');
        Route::post('get-student-list-for-single-student-marks-entry', 'SiteBaseExamMarksEntryController@getStudentListForSingleStudentMarksEntry')->name('get-student-list-for-single-student-marks-entry');
        Route::post('get-student-examination-base-all-subject-marks-entry-list', 'SiteBaseExamMarksEntryController@getStudentExaminationBaseAllSubjectMarksEntryList')->name('get-student-examination-base-all-subject-marks-entry-list');
        Route::post('site-base-single-student-all-marks-entry', 'SiteBaseExamMarksEntryController@siteBaseSingleStudentAllMarksEntry')->name('site-base-single-student-all-marks-entry');
    });

    Route::group(['namespace' => 'Exam', 'prefix' => 'admit-card'], function () {
        //     Route::get('site-exam-marks-entry-form', 'SiteBaseExamMarksEntryController@index')->name('site-exam-marks-entry-form');
        //     Route::post('get-site-department-class-base-examination', 'SiteBaseExamMarksEntryController@getSiteDepartmentClassBaseExamination')->name('get-site-department-class-base-examination');
        //     Route::post('get-site-examination-base-subject-list', 'SiteBaseExamMarksEntryController@getSiteExaminationBaseSubjectList')->name('get-site-examination-base-subject-list');
        //     Route::post('get-site-base-student-list-for-marks-entry', 'SiteBaseExamMarksEntryController@getSiteBaseStudentListForMarksEntry')->name('get-site-base-student-list-for-marks-entry');
        //     Route::post('get-site-base-student-mark-list', 'SiteBaseExamMarksEntryController@getSiteBaseStudentMarkList')->name('get-site-base-student-mark-list');
        //     Route::post('indivisual-exam-type-student-number-entry', 'SiteBaseExamMarksEntryController@indivisualExamTypeStudentNumberEntry')->name('Individual-exam-type-student-number-entry');
        //     Route::post('combinely-exam-type-student-number-entry', 'SiteBaseExamMarksEntryController@combinelyExamTypeStudentNumberEntry')->name('combinely-exam-type-student-number-entry');
        //     Route::post('get-subject-base-exam-type-list-for-exam-marks-entry', 'SiteBaseExamMarksEntryController@getSubjectBaseExamTypeListForExamMarksEntry')->name('get-subject-base-exam-type-list-for-exam-marks-entry');
        //     Route::post('get-student-list-for-single-student-marks-entry', 'SiteBaseExamMarksEntryController@getStudentListForSingleStudentMarksEntry')->name('get-student-list-for-single-student-marks-entry');
        //     Route::post('get-student-examination-base-all-subject-marks-entry-list', 'SiteBaseExamMarksEntryController@getStudentExaminationBaseAllSubjectMarksEntryList')->name('get-student-examination-base-all-subject-marks-entry-list');
        //     Route::post('site-base-single-student-all-marks-entry', 'SiteBaseExamMarksEntryController@siteBaseSingleStudentAllMarksEntry')->name('site-base-single-student-all-marks-entry');
    });


    Route::group(['namespace' => 'Exam', 'prefix' => 'site-marks'], function () {
        Route::get('send-mark-master', 'SiteBaseExamMarksSendController@index')->name('exam-mark-send-master');
        Route::post('get-site-department-class-base-examination', 'SiteBaseExamMarksSendController@getSiteDepartmentClassBaseExamination')->name('get-site-department-class-base-examination-for-send-marks');
        Route::post('get-site-examination-base-subject-list', 'SiteBaseExamMarksSendController@getSiteExaminationBaseSubjectList')->name('get-site-examination-base-subject-list-for-send-marks');
        Route::post('get-site-base-student-mark-list-for-send-marks', 'SiteBaseExamMarksSendController@getSiteBaseStudentMarkListForSmsMarks')->name('get-site-base-student-mark-list-for-send-marks');
        Route::post('send-single-student-sms', 'SiteBaseExamMarksSendController@sendSingleStudentSms')->name('exam-mark-send-single-student-sms');
        Route::post('send-multiple-student-sms', 'SiteBaseExamMarksSendController@sendMultipleStudentSms')->name('exam-mark-send-multiple-student-sms');
    });

    Route::group(['namespace' => 'Exam', 'prefix' => 'mark-list'], function () {
        Route::get('site-all-exam-mark-list', 'SiteBaseExamMarksController@index')->name('site-all-exam-mark-list');
        Route::post('get-student-list-for-all-subject-entry-mark-list', 'SiteBaseExamMarksController@studetnsSubjectMarkList')->name('get-student-list-for-all-subject-entry-mark-list');
        Route::post('get-student-list-for-all-subject-entry-mark-statistics-list', 'SiteBaseExamMarksController@studetnsSubjectMarkStatisticsList')->name('get-student-list-for-all-subject-entry-mark-statistics-list');
        Route::post('all-subject-entry-mark-list-pdf', 'SiteBaseExamMarksController@studetnsSubjectMarkListPdf')->name('all-subject-entry-mark-list-pdf');
    });


    Route::group(['namespace' => 'Exam', 'prefix' => 'site-answer-paper'], function () {
        Route::get('site-base-answer-paper-distribution-form', 'SiteBaseAnswerPaperController@index')->name('site-base-answer-paper-distribution-form');
        Route::post('get-site-base-answer-paper-distribution', 'SiteBaseAnswerPaperController@getSiteBaseAnswerPaperDistribution')->name('get-site-base-answer-paper-distribution');
        Route::post('save-site-base-answer-paper-distribution', 'SiteBaseAnswerPaperController@saveSiteBaseAnswerPaperDistribution')->name('save-site-base-answer-paper-distribution');
    });

    Route::group(['namespace' => 'Exam', 'prefix' => 'seat-plan'], function () {


        Route::group(['namespace' => 'SeatPlan', 'prefix' => 'exam-room-setting'], function () {
            //            Route::get('site-base-exam-room-setting', 'SiteExamRoomSettingController@index')->name('site-base-exam-room-setting');
            Route::get('get-site-base-building-list', 'SiteExamRoomSettingController@getSiteBaseBuildingList')->name('get-site-base-building-list');
            Route::get('get-site-building-base-floor-list/{building_id}', 'SiteExamRoomSettingController@getSiteBuildingBaseFloorList')->name('get-site-building-base-floor-list');
            Route::post('get-site-building-floor-base-room-list-form-exam', 'SiteExamRoomSettingController@getSiteBuildingFloorBaseRoomListFormExam')->name('get-site-building-floor-base-room-list-form-exam');
            Route::post('create-update-site-exam-room-seat-setting', 'SiteExamRoomSettingController@createUpdateSiteExamRoomSeatSetting')->name('create-update-site-exam-room-seat-setting');
        });


        Route::group(['namespace' => 'SeatPlan', 'prefix' => 'seat-plan-generate'], function () {
            Route::get('site-base-exam-seat-plan-form', 'SiteExamSeatPlanGenerateController@index')->name('site-base-exam-seat-plan-form');

            Route::post('get-site-version-year-shift-base-examination-list', 'SiteExamSeatPlanGenerateController@getSiteVersionYearShiftBaseExaminationList')->name('get-site-version-year-shift-base-examination-list');
            Route::post('get-exam-room-dept-class-examtype-list', 'SiteExamSeatPlanGenerateController@getExamRoomDeptClassExamtypeList')->name('get-exam-room-dept-class-examtype-list');
            Route::post('get-examination-date-list-for-seat-plan', 'SiteExamSeatPlanGenerateController@getExaminationDateListForSeatPlan')->name('get-examination-date-list-for-seat-plan');
            Route::post('get-examination-time-list-for-seat-plan', 'SiteExamSeatPlanGenerateController@getExaminationTimeListForSeatPlan')->name('get-examination-time-list-for-seat-plan');
            Route::post('get-exam-dept-class-examtype-base-subject-list', 'SiteExamSeatPlanGenerateController@getExamDeptClassExamtypeBaseSubjectList')->name('get-exam-dept-class-examtype-base-subject-list');
            Route::post('site-exam-seat-plan-auto-generate', 'SiteExamSeatPlanGenerateController@siteExamSeatPlanAutoGenerate')->name('site-exam-seat-plan-auto-generate');
            Route::post('get-academic-exam-seat-plan-style-list', 'SiteExamSeatPlanGenerateController@getAcademicExamSeatPlanStyleList')->name('get-academic-exam-seat-plan-style-list');
            Route::post('site-date-time-base-seat-plan-copy-to-ohter-date-time', 'SiteExamSeatPlanGenerateController@siteDateTimeBaseSeatPlanCopyToOhterDateTime')->name('site-date-time-base-seat-plan-copy-to-ohter-date-time');
            Route::post('site-exam-seat-plan-full-delete', 'SiteExamSeatPlanGenerateController@siteExamSeatPlanFullDelete')->name('site-exam-seat-plan-full-delete');
        });


        Route::group(['namespace' => 'SeatPlan', 'prefix' => 'seat-plan-show'], function () {
            Route::post('get-exam-room-list-for-show', 'SiteExamSeatPlanShowController@getExamRoomListForShow')->name('get-exam-room-list-for-show');
            Route::post('get-exam-room-base-seat-plan-for-show', 'SiteExamSeatPlanShowController@getExamRoomBaseSeatPlanForShow')->name('get-exam-room-base-seat-plan-for-show');

            Route::post('student-exam-detail-for-seat-plan', 'SiteExamSeatPlanShowController@getExamSeatPlanToken')->name('student-exam-detail-for-seat-plan');
            Route::post('student-exam-pdf-token', 'SiteExamSeatPlanShowController@getExamSeatPlanPdfToken')->name('student-exam-pdf-token');
        });

        Route::group(['namespace' => 'SeatPlan', 'prefix' => 'seat-plan-publish'], function () {
            Route::post('get-date-time-list-for-seat-plan-publish', 'SiteExamSeatPlanShowController@getDateTimeListForSeatPlanPublish')->name('get-date-time-list-for-seat-plan-publish');
            Route::post('publish-pause-exam-seat-plan-for-employee', 'SiteExamSeatPlanShowController@publishPauseExamSeatPlanForEmployee')->name('publish-pause-exam-seat-plan-for-employee');
            Route::post('publish-pause-exam-seat-plan-for-student', 'SiteExamSeatPlanShowController@publishPauseExamSeatPlanForStudent')->name('publish-pause-exam-seat-plan-for-student');
        });
    });


    Route::group(['namespace' => 'Exam', 'prefix' => 'exam-room-invigilator'], function () {


        Route::group(['namespace' => 'ExamRoomInvigilator', 'prefix' => 'invigilator-selection'], function () {

            Route::post('get-site-year-base-examination-list', 'SiteExamRoomInvigilatorSettingController@getSiteYearBaseExaminationList')->name('get-site-year-base-examination-list');
            Route::post('get-examination-base-exam-time-list', 'SiteExamRoomInvigilatorSettingController@getExaminationBaseExamTimeList')->name('get-examination-base-exam-time-list');
            Route::post('get-examination-base-employee-list', 'SiteExamRoomInvigilatorSettingController@getExaminationBaseEmployeeList')->name('get-examination-base-employee-list');
            Route::post('create-update-site-exam-invigilator-selection', 'SiteExamRoomInvigilatorSettingController@createUpdateSiteExamInvigilatorSelection')->name('create-update-site-exam-invigilator-selection');
            Route::post('get-exam-invigilator-room-list', 'SiteExamRoomInvigilatorSettingController@getExamInvigilatorRoomList')->name('get-exam-invigilator-room-list');
        });

        Route::group(['namespace' => 'ExamRoomInvigilator', 'prefix' => 'invigilator-setup'], function () {

            Route::get('site-exam-room-invigilator-set-form', 'SiteExamRoomInvigilatorSettingController@index')->name('site-exam-room-invigilator-set-form');
            Route::post('randomly-exam-room-invigilator-set', 'SiteExamRoomInvigilatorSettingController@randomlyExamRoomInvigilatorSet')->name('randomly-exam-room-invigilator-set');
            Route::post('single-exam-room-invigilator-set', 'SiteExamRoomInvigilatorSettingController@singleExamRoomInvigilatorSet')->name('single-exam-room-invigilator-set');
            Route::post('remove-exam-room-invigilator-set', 'SiteExamRoomInvigilatorSettingController@removeExamRoomInvigilatorSet')->name('remove-exam-room-invigilator-set');
            Route::post('save-update-exam-room-invigilator-set', 'SiteExamRoomInvigilatorSettingController@saveUpdateExamRoomInvigilatorSet')->name('save-update-exam-room-invigilator-set');
            Route::post('copy-exam-room-invigilator-set-to-other-date', 'SiteExamRoomInvigilatorSettingController@copyExamRoomInvigilatorSetToOtherDate')->name('copy-exam-room-invigilator-set-to-other-date');
        });

        Route::group(['namespace' => 'ExamRoomInvigilator', 'prefix' => 'report'], function () {

            Route::post('site-date-room-invigilator-list', 'SiteExamRoomInvigilatorSettingController@siteDateRoomInvigilatorList')->name('site-date-room-invigilator-list');
            Route::post('get-examination-date-time-list-for-invigilator-list', 'SiteExamRoomInvigilatorSettingController@getExaminationDateTimeListForInvigilatorList')->name('get-examination-date-time-list-for-invigilator-list');
            Route::post('publish-pause-delete-duty-roster', 'SiteExamRoomInvigilatorSettingController@publishPauseDeleteDutyRoster')->name('publish-pause-delete-duty-roster');
        });
    });

    Route::group(['namespace' => 'Exam', 'prefix' => 'exam-question'], function () {
        Route::get('form', 'SiteExamQuestionController@index')->name('site-exam-question-form');
        Route::get('active-subject-topic-list/{subject_id}', 'SiteExamQuestionController@getSiteExamQuestionActiveSubjectTopicList')->name('site-exam-question-active-subject-topic-list-by-subject-id');
        Route::get('exam-type-list', 'SiteExamQuestionController@getSiteExamTypeList')->name('site-exam-question-exam-type-list');
        Route::get('list-view', 'SiteExamQuestionController@getSiteExamQuestionListView')->name('site-exam-question-list-view');
        Route::get('list', 'SiteExamQuestionController@getSiteExamQuestionList')->name('site-exam-question-list');
        Route::post('slelected-question-pdf', 'SiteExamQuestionController@getSiteExamQuestionSelectedQuestionPDF')->name('site-exam-question-slelected-question-pdf');
        Route::get('slelected-question-pdf-show/{data}', 'SiteExamQuestionController@getSiteExamQuestionSelectedQuestionPDFShow')->name('site-exam-question-slelected-question-pdf-show');
        Route::post('list-with-pagination', 'SiteExamQuestionController@getQuestionListWithPagination')->name('site-exam-question-list-with-pagination');
        Route::post('add', 'SiteExamQuestionController@createQuestion')->name('site-exam-question-add');
        Route::get('edit/{id}', 'SiteExamQuestionController@editQuestionView')->name('site-exam-question-edit-form');
        Route::get('get-exam-question-details/{id}', 'SiteExamQuestionController@getQuestionDetailsForEdit')->name('site-exam-question-details-by-id');
        Route::post('update', 'SiteExamQuestionController@updateQuestion')->name('site-exam-question-update');
        Route::post('upate-question-status', 'SiteExamQuestionController@updateQuestionStatus')->name('site-exam-question-update-status');
        Route::post('upate-question-status-massly', 'SiteExamQuestionController@updateQuestionStatusMassly')->name('site-exam-question-update-status-massly');
        Route::post('delete/{id}', 'SiteExamQuestionController@deleteQuestion')->name('site-exam-question-delete');
    });



    Route::group(['namespace' => 'Quiz', 'prefix' => 'quiz-question1'], function () {
        Route::get('form', 'SiteQuizQuestionController@index')->name('site-quiz-question-form');
        Route::get('active-subject-topic-list', 'SiteQuizQuestionController@getSiteQuizQuestionActiveSubjectTopicList')->name('site-quiz-question-active-subject-topic-list-by-subject-id');
        Route::get('exam-type-list', 'SiteQuizQuestionController@getSiteExamTypeList')->name('site-quiz-question-exam-type-list');
        Route::get('list-view', 'SiteQuizQuestionController@getSiteQuizQuestionListView')->name('site-quiz-question-list-view');
        Route::get('list', 'SiteQuizQuestionController@getSiteQuizQuestionList')->name('site-quiz-question-list2');
        Route::post('slelected-question-pdf', 'SiteQuizQuestionController@getSiteQuizQuestionSelectedQuestionPDF')->name('site-quiz-question-slelected-question-pdf');
        Route::get('slelected-question-pdf-show/{data}', 'SiteQuizQuestionController@getSiteQuizQuestionSelectedQuestionPDFShow')->name('site-quiz-question-slelected-question-pdf-show');
        Route::post('list-with-pagination', 'SiteQuizQuestionController@getQuizQuestionListWithPagination')->name('site-quiz-question-list-with-pagination');
        Route::post('add', 'SiteQuizQuestionController@createQuestion')->name('site-quiz-question-add2');
        Route::get('edit/{id}', 'SiteQuizQuestionController@editQuestionView')->name('site-quiz-question-edit-form');
        Route::get('get-quiz-question-details/{id}', 'SiteQuizQuestionController@getQuestionDetailsForEdit')->name('site-quiz-question-details-by-id');
        Route::post('update', 'SiteQuizQuestionController@updateQuestion')->name('site-quiz-question-update');
        Route::post('upate-question-status', 'SiteQuizQuestionController@updateQuestionStatus')->name('site-quiz-question-update-status');
        Route::post('upate-question-status-massly', 'SiteQuizQuestionController@updateQuestionStatusMassly')->name('site-quiz-question-update-status-massly');
        Route::post('delete/{id}', 'SiteQuizQuestionController@deleteQuestion')->name('site-quiz-question-delete');
    });


    Route::group(['namespace' => 'Quiz'], function () {
        Route::group(['prefix' => 'quiz'], function () {
            Route::get('/', 'QuizTopicsController@index')->name('quiz-index');
            Route::post('/add', 'SiteBaseQuizDeclareController@createQuiz')->name('create-quiz');

            Route::post('topic-add', 'QuizTopicsController@createQuizTopics')->name('quiz-add');
            //   Route::get('topic-list', 'QuizTopicsController@getQuizTopiclist')->name('quiz-list');
            Route::get('quiz-list', 'SiteBaseQuizDeclareController@getQuizlist')->name('quiz-list');
            // Route::post('topic-edit', 'QuizTopicsController@quizTopicEdit')->name('quiz-edit');
            Route::post('quiz-edit', 'SiteBaseQuizDeclareController@quizEdit')->name('quiz-edit');
            // Route::post('topic-update', 'QuizTopicsController@quizTopicUpate')->name('quiz-update');
            // Route::post('topic-delete', 'QuizTopicsController@quizTopicDelete')->name('quiz-delete');

            Route::post('quiz-update', 'SiteBaseQuizDeclareController@quizUpate')->name('quiz-update');
            Route::post('quiz-delete', 'SiteBaseQuizDeclareController@quizDelete')->name('quiz-delete');
        });
        // Route::group(['prefix' => 'quiz-question'], function () {
        //     Route::get('get-quiz-topic', 'QuizQuestionController@getQuizTopicListForQuestion')->name('get-quiz-topic-for-question');
        //     Route::post('add', 'QuizQuestionController@quizQuestionAdd')->name('quiz-question-add');
        //     Route::get('list-view', 'QuizQuestionController@index')->name('quiz-question-list-view');
        //     Route::post('list-with-pagination', 'QuizQuestionController@getQuizQuestionListWithPagination')->name('list-with-pagination');

        // });
        Route::group(['prefix' => 'quiz-declare'], function () {
            Route::get('get-quiz-list-for-quiz-declare/{declare_key}', 'SiteBaseQuizDeclareController@activeQuizList')->name('get-quiz-list-for-quiz-declare');
            Route::post('get-student-list-for-quiz-declare', 'SiteBaseQuizDeclareController@getStudentListForQuizDeclare')->name('get-student-list-for-quiz-declare');
            Route::post('create-and-update-site-base-quiz-declare', 'SiteBaseQuizDeclareController@createAndUpdateSiteBaseQuizDeclare')->name('create-and-update-site-base-quiz-declare');
            Route::post('delete-site-base-quiz-declare', 'SiteBaseQuizDeclareController@deleteSiteBaseQuizDeclare')->name('delete-site-base-quiz-declare');
            Route::post('site-question-list-for-quiz-question-declare', 'SiteBaseQuizQuestionDeclareController@getQuestionListForQuizDeclare')->name('site-question-list-for-quiz-question-declare');


            Route::post('get-selected-quiz-declare-settings', 'SiteBaseQuizQuestionDeclareController@getSelectedQuizDeclareSettings')->name('get-selected-quiz-declare-settings');
            Route::post('get-active-subject-list-for-quiz-declare', 'SiteBaseQuizQuestionDeclareController@getActiveSubjectListByYearClassForQuizDeclare')->name('get-active-subject-list-for-quiz-declare');
            Route::post('get-active-topic-list-for-quiz-declare', 'SiteBaseQuizQuestionDeclareController@getSubjectTopicListForQuizQuestionDeclare')->name('get-active-topic-list-for-quiz-declare');
            Route::post('create-site-student-quiz-question-declare', 'SiteBaseQuizQuestionDeclareController@createQuizQuestionDeclare')->name('create-site-student-quiz-question-declare');

            //    Route::get('get-quiz-question-declare-list', 'SiteBaseQuizQuestionDeclareController@createQuizQuestionDeclare')->name('create-site-student-quiz-question-declare');

            Route::post('get-active-quiz-list', 'QuizRoomController@getActiveQuizList')->name('get-active-quiz-list');
            Route::post('get-quiz-event-students-info', 'QuizRoomController@getQuizEventStudentsInfo')->name('get-quiz-event-students-info');

            Route::post('get-present-students-count', 'QuizRoomController@getPreSentStudents')->name('get-present-students-count');

            Route::post('quiz-start-by-admin', 'QuizRoomController@quizStartByAdmin')->name('quiz-admin-by-admin');
        });
        Route::group(['prefix' => 'quiz-report',  'namespace' => 'Report'], function () {
            Route::get('/', 'SiteQuizReportController@index')->name('get-site-quiz-report-master');
            // Route::post('add', 'QuizQuestionController@quizQuestionAdd')->name('quiz-question-add');
            Route::get('quiz-list', 'SiteQuizReportController@quizListForReport')->name('quiz-list-for-report');
            Route::post('list', 'SiteQuizReportController@getSiteQuizReport')->name('get-site-quiz-report-list');


            /////



        });
    });





    Route::group(['namespace' => 'Exam\Question', 'prefix' => 'question-declare'], function () {
        Route::get('site-exam-question-declare-form', 'SiteExamQuestionDeclareController@index')->name('site-exam-question-declare-form');
        Route::post('site-exam-type-for-question-declare', 'SiteExamQuestionDeclareController@siteExamTypeForQuestionDeclare')->name('site-exam-type-for-question-declare');
        Route::post('site-student-list-for-question-declare', 'SiteExamQuestionDeclareController@siteStudentListForQuestionDeclare')->name('site-student-list-for-question-declare');
        Route::post('site-question-list-for-question-declare', 'SiteExamQuestionDeclareController@siteQuestionListForQuestionDeclare')->name('site-question-list-for-question-declare');
        Route::post('create-site-student-question-declare', 'SiteExamQuestionDeclareController@createSiteStudentQuestionDeclare')->name('create-site-student-question-declare');

        //=========student question list
        Route::post('site-exam-type-student-question-declare-list', 'SiteExamQuestionDeclareController@siteExamTypeStudentQuestionDeclareList')->name('site-exam-type-student-question-declare-list');
        Route::post('site-student-exam-question-list-show', 'SiteExamQuestionDeclareController@siteStudentExamQuestionListShow')->name('site-student-exam-question-list-show');
    });


    Route::group(['namespace' => 'Result', 'prefix' => 'result-setting'], function () {
        Route::get('site-result-setting-form', 'SiteBaseResultSettingController@index')->name('site-result-setting-form');
        Route::post('get-site-base-examination-exam-type-list', 'SiteBaseResultSettingController@getSiteBaseExaminationExamTypeList')->name('get-site-base-examination-exam-type-list');
        Route::post('create-update-site-result-setting', 'SiteBaseResultSettingController@createUpdateSiteResultSetting')->name('create-update-site-result-setting');
    });


    Route::group(['namespace' => 'Result', 'prefix' => 'result-system-setting'], function () {
        Route::post('get-site-base-examination-result-system-list', 'SiteBaseResultSystemSettingController@getSiteBaseResultSystemList')->name('get-site-base-examination-result-system-list');
        Route::post('create-update-result-system-setting', 'SiteBaseResultSystemSettingController@createUpdateResultSystemSetting')->name('create-update-result-system-setting');
    });
    Route::group(['namespace' => 'Result', 'prefix' => 'result-card-setting'], function () {
        Route::post('get-site-class-base-result-list', 'SiteBaseResultReportSettingController@getSiteBaseResultTypeList')->name('get-site-class-base-result-list');
        Route::post('get-site-class-base-result-report-system-list', 'SiteBaseResultReportSettingController@getSiteClassBaseResultReportSettingsList')->name('get-site-class-base-result-report-system-list');
        Route::post('create-update-result-card-setting', 'SiteBaseResultReportSettingController@createUpdateResultCardSetting')->name('create-update-result-card-setting');
    });


    Route::group(['namespace' => 'Result', 'prefix' => 'result-generate'], function () {
        Route::get('site-result-generate-form', 'SiteBaseResultGenerateController@index')->name('site-result-generate-form');
        Route::post('get-site-base-result-type-list-for-result-generate', 'SiteBaseResultGenerateController@getSiteBaseResultTypeListForResultGenerate')->name('get-site-base-result-type-list-for-result-generate');
        Route::post('create-update-result-list-for-result-generate', 'SiteBaseResultGenerateController@createUpdateResultListForResultGenerate')->name('create-update-result-list-for-result-generate');

        Route::post('publish-pause-result-to-employee-student-panel', 'SiteBaseResultGenerateController@publishPauseResultToEmployeeStudentPanel')->name('publish-pause-result-to-employee-student-panel');


        Route::post('delete-result-to-employee-student-panel', 'SiteBaseResultGenerateController@deleteResultToEmployeeStudentPanel')->name('delete-result-to-employee-student-panel');

        Route::post('update-site-other-result-report', 'SiteBaseResultGenerateController@updateOtherResultGenerate')->name('update-site-other-result-report');

        Route::post('create-update-exam-result-academic-performance', 'SiteBaseResultGenerateController@createUpdateAcademicResultOtherPerformance')->name('create-update-exam-result-academic-performance');
        Route::post('get-student-result-other-performance', 'SiteBaseResultGenerateController@getStudentResultList')->name('get-student-result-other-performance');

        Route::post('create-update-exam-result-merit-list', 'SiteBaseResultGenerateController@createUpdateMeritList')->name('create-update-exam-result-merit-list');



        Route::post('get-site-base-combine-result-type-list-for-result-generate', 'SiteBaseCombineResultGenerateController@getSiteBaseCombineResultTypeListForResultGenerate')->name('get-site-base-combine-result-type-list-for-result-generate');
        Route::post('create-update-combine-type-result-list-for-result-generate', 'SiteBaseCombineResultGenerateController@createUpdateCombineTypeResultListForResultGenerate')->name('create-update-combine-type-result-list-for-result-generate');
        Route::post('get-site-base-combine-result-type-list-for-marit-list-generate', 'SiteBaseCombineResultGenerateController@getSiteBaseCombineResultListForMaritList')->name('get-site-base-combine-result-type-list-for-marit-list-generate');
        Route::post('create-update-combine-exam-result-merit-list', 'SiteBaseCombineResultGenerateController@createUpdateCombineMeritList')->name('create-update-combine-exam-result-merit-list');
    });

    Route::group(['namespace' => 'Result'], function () {
        Route::group(['namespace' => 'Permission', 'prefix' => 'result-permission'], function () {
            Route::get('site-result-permission', 'SiteBaseResultPermissionController@index')->name('site-result-permission-master');
            Route::post('get-site-class-result-list', 'SiteBaseResultPermissionController@getResultList')->name('get-site-class-result-list');
            Route::post('get-student-list-for-result-permission', 'SiteBaseResultPermissionController@getStudentListForResultPermission')->name('get-student-list-for-result-permission');
            Route::post('submit-student-result-permission', 'SiteBaseResultPermissionController@submitStudentResultPermission')->name('submit-student-result-permission');
            // Route::post('create-update-result-list-for-result-generate', 'SiteBaseResultGenerateController@createUpdateResultListForResultGenerate')->name('create-update-result-list-for-result-generate');

            // Route::post('publish-pause-result-to-employee-student-panel', 'SiteBaseResultGenerateController@publishPauseResultToEmployeeStudentPanel')->name('publish-pause-result-to-employee-student-panel');

            // Route::post('get-site-base-combine-result-type-list-for-result-generate', 'SiteBaseResultGenerateController@getSiteBaseCombineResultTypeListForResultGenerate')->name('get-site-base-combine-result-type-list-for-result-generate');
            // Route::post('create-update-combine-type-result-list-for-result-generate', 'SiteBaseResultGenerateController@createUpdateCombineTypeResultListForResultGenerate')->name('create-update-combine-type-result-list-for-result-generate');

            // Route::post('delete-result-to-employee-student-panel', 'SiteBaseResultGenerateController@deleteResultToEmployeeStudentPanel')->name('delete-result-to-employee-student-panel');

        });
    });




    Route::group(['namespace' => 'Result\Certification', 'prefix' => 'certification'], function () {

        Route::get('site-certification-letter-form', 'SiteCertificationLetterController@index')->name('site-certification-letter-form');
        Route::post('create-site-Certification-setting', 'SiteCertificationLetterController@CreateSiteCertificationSetting')->name('create-site-Certification-setting');
        Route::post('get-student-list-for-generate-certification', 'SiteCertificationLetterController@GetSiteStudentListForCertification')->name('get-student-list-for-generate-certification');
        Route::post('Certification-pdf-download', 'SiteCertificationLetterController@CertificationPdfDownload')->name('Certification-pdf-download');
    });
    Route::group(['namespace' => 'Result\Protyonpotro', 'prefix' => 'protyonpotro'], function () {
        Route::get('site-protyonpotro-form', 'SiteProtyonpotroController@index')->name('site-protyonpotro-form');
        Route::post('create-site-protyonpotro-setting', 'SiteProtyonpotroController@CreateSiteProtyonpotroSetting')->name('create-site-protyonpotro-setting');
        Route::post('get-student-list-for-generate-protyonpotro', 'siteProtyonpotroController@GetSiteStudentListForProtyonpotro')->name('get-student-list-for-generate-protyonpotro');
        Route::post('get-employee-list-for-generate-protyonpotro', 'siteProtyonpotroController@GetEmployeeListForProtyonpotro')->name('get-employee-list-for-generate-protyonpotro');


        Route::post('get-result-type-base-protyonpotro-setting', 'SiteProtyonpotroController@getResultTypeBaseProtyonpotroSetting')->name('get-result-type-base-protyonpotro-setting');

        Route::post('create-update-site-protyonpotro', 'SiteProtyonpotroController@createUpdateSiteProtyonpotro')->name('create-update-site-protyonpotro');

        Route::post('protyonpotro-pdf-download', 'SiteProtyonpotroController@protyonpotroPdfDownload')->name('protyonpotro-pdf-download');
    });
    Route::group(['namespace' => 'Result\Testimonial', 'prefix' => 'testimonial'], function () {

        Route::get('site-testimonial-form', 'SiteTestimonialResultInputController@index')->name('site-testimonial-form');

        Route::post('get-result-type-list-for-testimonial', 'SiteTestimonialResultInputController@getResultTypeListForTestimonial')->name('get-result-type-list-for-testimonial');
        Route::post('get-result-type-base-testimonial-setting', 'SiteTestimonialResultInputController@getResultTypeBaseTestimonialSetting')->name('get-result-type-base-testimonial-setting');
        Route::post('create-site-testimonial-setting', 'SiteTestimonialResultInputController@createSiteTestimonialSetting')->name('create-site-testimonial-setting');


        Route::post('get-year-class-base-result-type-list-for-testimonial', 'SiteTestimonialResultInputController@getYearClassBaseResultTypeListForTestimonial')->name('get-year-class-base-result-type-list-for-testimonial');
        Route::post('get-student-list-for-generate-testimonial', 'SiteTestimonialResultInputController@getStudentListForGenerateTestimonial')->name('get-student-list-for-generate-testimonial');
        Route::post('create-update-site-testimonial', 'SiteTestimonialResultInputController@createUpdateSiteTestimonial')->name('create-update-site-testimonial');
        Route::post('testimonial-pdf-download', 'SiteTestimonialResultInputController@testimonialPdfDownload')->name('testimonial-pdf-download');

        Route::post('get-student-list-for-generate-manually-testimonial', 'SiteManuallyTestimonialController@getStudentListForGenerateMenuallyTestimonial')->name('get-student-list-for-generate-manually-testimonial');
        Route::post('get-year-class-base-result-type-list-for-manually-testimonial', 'SiteManuallyTestimonialController@getYearClassBaseResultTypeListForManuallyTestimonial')->name('get-year-class-base-result-type-list-for-manually-testimonial');
        Route::post('create-update-site-manually-testimonial', 'SiteManuallyTestimonialController@createUpdateSiteManuallyTestimonial')->name('create-update-site-manually-testimonial');
        Route::post('manually-testimonial-pdf-download', 'SiteManuallyTestimonialController@manuallyTestimonialPdfDownload')->name('manually-testimonial-pdf-download');
        Route::post('manually-testimonial-multiple-pdf-download', 'SiteManuallyTestimonialController@manuallyTestimonialMultiplePdfDownload')->name('manually-testimonial-multiple-pdf-download');

        Route::post('get-result-type-list-for-manually-testimonial', 'SiteManuallyTestimonialController@getResultTypeListForManuallyTestimonial')->name('get-result-type-list-for-manually-testimonial');
        Route::post('get-result-type-base-manually-testimonial-setting', 'SiteManuallyTestimonialController@getResultTypeBaseManuallyTestimonialSetting')->name('get-result-type-base-manually-testimonial-setting');
        Route::post('create-site-manually-testimonial-setting', 'SiteManuallyTestimonialController@createSiteManuallyTestimonialSetting')->name('create-site-manually-testimonial-setting');
    });

    Route::group(['namespace' => 'Result\Report', 'prefix' => 'result-statistics'], function () {

        Route::post('get-site-primary-result-total-statistics', 'SiteResultStatisticsController@getSitePrimaryResultTotalStatistics')->name('get-site-primary-result-total-statistics');

        Route::post('get-site-primary-result-subject-pass-fail-statistics', 'SiteResultStatisticsController@getSitePrimaryResultSubjectPassFailStatistics')->name('get-site-primary-result-subject-pass-fail-statistics');
        Route::post('get-fixed-count-failed-student-list', 'SiteResultStatisticsController@getFixedCountFailedStudentList')->name('get-fixed-count-failed-student-list');

        Route::post('get-exam-subject-absent-pass-fail-student-list', 'SiteResultStatisticsController@getExamSubjectAbsentPassFailStudentList')->name('get-exam-subject-absent-pass-fail-student-list');

        // result two
        Route::post('get-site-primary-result-overview-two-total-statistics', 'SiteResultStatisticsController@getSitePrimaryResultOverviewTwoTotalStatistics')->name('get-site-primary-result-overview-two-total-statistics');
        Route::post('get-site-primary-result-overview-two-total-statistics-pdf', 'SiteResultStatisticsController@getSitePrimaryResultOverviewTwoTotalStatisticsPdf')->name('get-site-primary-result-overview-two-total-statistics-pdf');
        Route::post('get-site-primary-result-two-total-statistics', 'SiteResultStatisticsController@getSitePrimaryResultTwoTotalStatistics')->name('get-site-primary-result-two-total-statistics');
        Route::post('get-site-primary-result-two-total-statistics-pdf', 'SiteResultStatisticsController@getSitePrimaryResultReportTwoPdf')->name('get-site-primary-result-two-total-statistics-pdf');
        Route::post('get-site-primary-result-new-two-subject-pass-fail-statistics', 'SiteResultStatisticsController@getSitePrimaryResultNewTwoSubjectPassFailStatistics')->name('get-site-primary-result-new-two-subject-pass-fail-statistics');
        Route::post('get-site-primary-result-two-subject-pass-fail-statistics', 'SiteResultStatisticsController@getSitePrimaryResultTwoSubjectPassFailStatistics')->name('get-site-primary-result-two-subject-pass-fail-statistics');
        Route::post('get-site-primary-result-new-two-subject-pass-fail-statistics-pdf', 'SiteResultStatisticsController@getSitePrimaryResultNewTwoSubjectPassFailStatisticsPdf')->name('get-site-primary-result-new-two-subject-pass-fail-statistics-pdf');
        Route::post('get-site-primary-result-two-subject-pass-fail-statistics-pdf', 'SiteResultStatisticsController@getSitePrimaryResultTwoSubjectPassFailStatisticsPdf')->name('get-site-primary-result-two-subject-pass-fail-statistics-pdf');
        Route::post('get-site-exam-result-short-list', 'SiteResultStatisticsController@getSiteExamResultShortList')->name('get-site-exam-result-short-list');
        Route::post('get-site-exam-result-short-list-pdf', 'SiteResultStatisticsController@getSiteExamResultShortListPdf')->name('get-site-exam-result-short-list-pdf');

        // combine result
        Route::get('site-combine-result-report-master', 'SiteCombineResultStatisticsController@index')->name('site-combine-result-report-master');
        Route::post('get-site-base-combine-result-list', 'SiteCombineResultStatisticsController@getSiteBaseCombineResultList')->name('get-site-base-combine-result-list');
        Route::post('get-site-exam-combine-result-short-list', 'SiteCombineResultStatisticsController@getSiteExamCombineResultShortList')->name('get-site-exam-combine-result-short-list');
        Route::post('get-site-exam-combine-result-short-list-pdf', 'SiteCombineResultStatisticsController@getSiteExamCombineResultShortListPdf')->name('get-site-exam-combine-result-short-list-pdf');
    });

    Route::group(['namespace' => 'Result', 'prefix' => 'result-report'], function () {
        Route::get('site-result-report-form', 'SiteBaseResultReportController@index')->name('site-result-report-form');
        Route::post('get-site-base-student-and-primary-result-list', 'SiteBaseResultReportController@getSiteBaseStudentAndPrimaryResultList')->name('get-site-base-student-and-primary-result-list');
        Route::post('get-site-base-student-and-primary-result-list-for-employee', 'SiteBaseResultReportController@getSiteBaseStudentAndPrimaryResultListForEmployee')->name('get-site-base-student-and-primary-result-list-for-employee');
        Route::post('get-site-student-and-primary-result-type-base_result-detail', 'SiteBaseResultReportController@getSiteStudentAndPrimaryResultTypeBaseResultDetail')->name('get-site-student-and-primary-result-type-base_result-detail');

        Route::post('site-base-multiple-student-detail-result-pdf', 'SiteBaseResultReportController@siteBaseMultipleStudentDetailResultPdf')->name('site-base-multiple-student-detail-result-pdf');
        Route::get('site-base-multiple-student-detail-result-pdf-show/{data}', 'SiteBaseResultReportController@siteBaseMultipleStudentDetailResultPdfShow')->name('site-base-multiple-student-detail-result-pdf-show');

        Route::post('get-site-base-primary-result-list', 'SiteBaseResultReportController@getSiteBasePrimaryResultList')->name('get-site-base-primary-result-list');
        Route::post('get-site-base-student-simple-tabulation-sheet', 'SiteBaseResultReportController@getSiteBaseStudentSimpleTabulationSheet')->name('get-site-base-student-simple-tabulation-sheet');
        //  Route::post('get-site-base-student-simple-tabulation-sheet', 'SiteBaseResultReportController@getSiteBaseStudentTabulationTwoSheet')->name('get-site-base-student-simple-tabulation-sheet');

        Route::post('get-site-base-student-simple-tabulation-sheet-pdf', 'SiteBaseResultReportController@getSiteBaseStudentSimpleTabulationSheetPdf')->name('get-site-base-student-simple-tabulation-sheet-pdf');
        Route::get('get-site-base-student-simple-tabulation-sheet-pdf-show/{data}', 'SiteBaseResultReportController@getSiteBaseStudentSimpleTabulationSheetPdfShow')->name('get-site-base-student-simple-tabulation-sheet-pdf-show');

        Route::post('get-site-base-student-tabulation-two-sheet', 'SiteBaseResultReportController@getSiteBaseStudentTabulationTwoSheet')->name('get-site-base-student-tabulation-two-sheet');

        //  Route::post('create-update-exam-result-academic-performance', 'SiteBaseResultReportController@createUpdateAcademicResultOtherPerformance')->name('create-update-exam-result-academic-performance');

        // result report settings

        Route::get('site-base-mark-sheet-result-setting', 'SiteBaseResultReportController@getSiteBaseResultReportSettings')->name('site-base-mark-sheet-result-setting');
        Route::post('create-update-site-base-mark-sheet-result-setting', 'SiteBaseResultReportController@createUpdateSiteBaseResultReportSettings')->name('create-update-site-base-mark-sheet-result-setting');
        // result report two

        Route::get('site-result-report-two-master', 'SiteBaseResultReportController@index')->name('site-result-report-two-master');

        Route::group(['namespace' => 'Report'], function () {

            // generate

            // report
            Route::post('get-site-base-student-and-combine-result-list', 'SiteBaseCombineResultReportController@getSiteBaseStudentAndCombineResultList')->name('get-site-base-student-and-combine-result-list');
            Route::post('get-site-student-and-combine-result-type-base_result-detail', 'SiteBaseCombineResultReportController@getSiteStudentAndCombineResultTypeBaseResultDetailOne')->name('get-site-student-and-combine-result-type-base_result-detail');
            Route::post('site-base-multiple-student-details-combine-result-pdf', 'SiteBaseCombineResultReportController@siteBaseMultipleStudentDetailsCombineResultPdf')->name('site-base-multiple-student-details-combine-result-pdf');
        });
        // combine result report
        // Route::get('site-combine-result-report-master', 'SiteBaseCombineResultReportController@index')->name('site-combine-result-report-master');
        // Route::post('get-site-exam-combine-result-short-list', 'SiteBaseCombineResultReportController@getSiteExamCombineResultShortList')->name('get-site-exam-combine-result-short-list');
        //   Route::post('get-site-exam-result-short-list-pdf', 'SiteResultStatisticsController@getSiteExamResultShortListPdf')->name('get-site-exam-result-short-list-pdf');



    });

    Route::group(['namespace' => 'Result', 'prefix' => 'result-report'], function () {
        Route::get('site-result-report-sms-master-component', 'SiteResultSendController@index')->name('site-result-report-send-sms-form');
        Route::post('get-site-base-primary-result-list-for-sms', 'SiteResultSendController@getSiteBasePrimaryResultListForSms')->name('get-site-base-primary-result-list-for-sms');
        Route::post('get-site-base-student-result-list-for-sms', 'SiteResultSendController@getSiteBaseStudentResultListForSms')->name('get-site-base-student-result-list-for-sms');
        Route::post('result-send-to-single-student', 'SiteResultSendController@resultSendToSingleStudent')->name('result-send-to-single-student');
        Route::post('result-send-to-multiple-student', 'SiteResultSendController@resultSendToMultipleStudent')->name('result-send-to-multiple-student');
    });


    Route::group(['namespace' => 'Academic', 'prefix' => 'academic'], function () {
        //API-----
        Route::get(
            'get-version-year-shift-based-based-sections-or-class-groups-and-sessions-by-class/{version_id}/{year_id}/{shift_id}/{class_id}/{dept_id?}',
            'AcademicController@versionYearShiftBasedSectionsOrClassGroupsAndSessionByClass'
        )
            ->name('site-academic-get-version-year-shift-based-sections-or-class-groups-by-class');

        Route::get(
            'get-global-version-year-shift-based-based-sections-or-class-groups-and-sessions-by-class/{academic_group_id}/{version_id}/{year_id}/{shift_id}/{class_id}/{dept_id?}',
            'AcademicController@globalVersionYearShiftBasedSectionsOrClassGroupsAndSessionByClass'
        )
            ->name('global-site-academic-get-version-year-shift-based-sections-or-class-groups-by-class');


        Route::get('get-version-year-shift-based-based-sections-or-class-groups-and-sessions-by-class-by-user/{version_id}/{year_id}/{shift_id}/{class_id}/{dept_id?}', 'AcademicController@versionYearShiftBasedSectionsOrClassGroupsAndSessionByClassByUser')->name('get-version-year-shift-based-based-sections-or-class-groups-and-sessions-by-class-by-user');
        Route::get('get-site-class-base-section-by-user/{class_id}/{shift_id}/{class_group_id}/{year_id}', 'AcademicController@siteClassBaseSectionByUser')
            ->name('site-class-shift-group-base-section-by-user');


        Route::get('get-version-year-shift-based-sections-by-class-and-class-group/{version_id}/{year_id}/{shift_id}/{class_id}/{class_group_id}', 'AcademicController@versionYearShiftBasedSectionsByClassAndClassGroup')->name('site-academic-get-version-year-shift-based-sections-by-class-and-class-group');

        Route::get('get-version-year-shift-dept-class-group-section-session-period-type-session-type-list', 'AcademicController@getVersionYearShiftDeptClassGroupSectionSessionPeriodTypeAndSessionTypeList')->name('site-academic-get-version-year-shift-dept-class-group-section-session-period-type-session-type-list');
        Route::get('get-version-year-shift', 'AcademicController@getVersionYearShiftDeptList')->name('site-academic-get-version-year-shift-list');
        Route::get('get-version-year-shift-by-user', 'AcademicController@getVersionYearShiftListByUser')->name('site-academic-get-version-year-shift-list-by-user');
        Route::get('get-student-shift-list', 'AcademicController@getStudentShiftList')->name('site-academic-get-student-shift-list');

        Route::get('get-site-academic-group-list', 'AcademicController@getSiteAcademicGroupList')->name('site-academic-get-site-academic-group-list');
        Route::get('get-global-version-year-shift', 'AcademicController@getGlobalVersionYearShiftDeptList')->name('site-academic-get-global-version-year-shift-list');


        Route::get('get-year-and-period-type-for-academic-group', 'AcademicController@getYearPeriodTypeForAcademicGroup')->name('site-academic-get-year-and-period-type-for-academic-group');
        Route::get('list-by-fee-head-id-fee-group-id/{feeHeadId}/{feeGroupId}', 'AcademicController@getFeeSubHeadListByFeeHeadIdFeeGroupId')->name('get-academic-fee-sub-head-list-by-fee-head-id-fee-group-id-data');


        //        Route::get('get-site-academic-year-list', 'AcademicController@getSiteAcademicYearList')->name('get-site-academic-year-list');

        Route::group(['prefix' => 'session-type'], function () {});

        Route::group(['prefix' => 'period-type'], function () {


            Route::get('setting', 'PeriodTypeController@sessionTypeSetting')->name('site-academic-period-type-setting');
            Route::post('create-setting', 'PeriodTypeController@createPeriodTypeSetting')->name('site-academic-period-type-create-setting');
            Route::post('update-setting/{id}', 'PeriodTypeController@updateSessionTypeSetting')->name('site-academic-period-type-update-setting');
            Route::delete('delete-setting/{id}', 'PeriodTypeController@deleteSessionTypeSetting')->name('site-academic-period-type-delete-setting');

            //API
            Route::get('get-setting-list', 'PeriodTypeController@getPeriodTypeSettingList')->name('site-academic-period-type-get-setting-list');
            Route::get('get-period-type-for-site', 'PeriodTypeController@getPeriodTypeForSite')->name('site-academic-period-type-get-period-type-for-site');
        });
    });


    Route::group(['prefix' => 'subject-group-condition-setting'], function () {
        Route::get('list', 'SubjectGroupConditionSettingController@index')->name('subject-group-condition-setting-view');
        Route::get('get-site-info', 'SubjectGroupConditionSettingController@getSiteInfo')->name('get-site-info');

        Route::get('get-department-class-list', 'SubjectGroupConditionSettingController@getYearDepartmentClassList')->name('site-subject-group-condition-setting-get-year-dept-class-list');

        Route::get('get-section-list/{id}', 'SubjectGroupConditionSettingController@getSectionList')->name('site-subject-group-condition-setting-get-section-list-by-site');
        Route::get('get-subject-list/{class_id}/{department_id}/{year_id}', 'SubjectGroupConditionSettingController@getSubjectList')->name('site-subject-group-condition-setting-get-subject-list-by-site');
        Route::get('get-subject-list-based-on-class-exam-condition', 'SubjectGroupConditionSettingController@getSubjectsBasedOnSubjectClassExamCondition')->name('site-routine-get-subjects-based-on-subject-class-exam-condition-keys');
        Route::post('add', 'SubjectGroupConditionSettingController@store')->name('subject-group-condition-setting-create');
        Route::put('edit/{id}', 'SubjectGroupConditionSettingController@update')->name('subject-group-condition-setting-edit');
        Route::delete('delete/{id}', 'SubjectGroupConditionSettingController@destroy')->name('subject-group-condition-setting-delete');

        //API----------
        Route::get('get-active-subject-list/{year_id}/{department_id}/{class_id}', 'SubjectGroupConditionSettingController@getActiveSubjectListByYearDepartmentClass')->name('site-subject-group-condition-setting-subject-list-by-year-department-class');

        Route::post('get-site-group-section-base-subject-limit', 'SubjectGroupConditionSettingController@getSiteGroupSectionBaseSubjectLimit')->name('get-site-group-section-base-subject-limit');
        Route::post('create-subject-condition-limit', 'SubjectGroupConditionSettingController@createSubjectConditionLimit')->name('create-subject-condition-limit');

        Route::post('get-site-department-class-base-examination-list', 'SubjectGroupConditionSettingController@getSiteDepartmentClassBaseExaminationList')->name('get-site-department-class-base-examination');

        // Route::get('subject-exam-marks-setting', 'SubjectGroupConditionSettingController@index')->name('subject-exam-marks-setting');
        // Route::post('subject-exam-type-marks-setup', 'SubjectGroupConditionSettingController@subjectListForExamTypeMarksSetup')->name('subject-exam-type-marks-setup');
        // Route::post('subject-exam-type-marks-setup-submit', 'SubjectGroupConditionSettingController@subjectListForExamTypeMarksSetupSubmit')->name('subject-exam-type-marks-setup-submit');


    }); //getExamSubjectList


    Route::group(['namespace' => 'Batch', 'prefix' => 'batch'], function () {
        Route::get('site-batch-form', 'BatchController@index')->name('site-batch-form');
        //        Route::get('list', 'BatchController@getList')->name('site-batch-list-detail');
        Route::post('add', 'BatchController@create')->name('site-batch-add');
        Route::put('update/{id}', 'BatchController@update')->name('site-batch-update');

        Route::post('get-batch', 'BatchController@getBatches')->name('site-batch-get-batch');
        Route::get('get-active-batch-list', 'BatchController@getActiveBatchList')->name('site-batch-get-active-batch-list');
    });


    // Routine
    Route::group(['namespace' => 'Routine', 'prefix' => 'routine'], function () {

        Route::get('master', 'RoutineController@index')->name('site-routine-setting'); //AcademicSubjectClassExamCondition
        Route::get('get-employee-weekly-class', 'RoutineController@getEmployeeWeeklyClassList')->name('site-routine-get-employee-weekly-class');
        Route::post('save-employee-weekly-class', 'RoutineController@saveEmployeeWeeklyClass')->name('site-routine-save-employee-weekly-class');
        Route::get('get-subject-with-weekly-class', 'SubjectWeeklyClassController@getSubjectWeeklyList')->name('site-routine-get-subject-with-weekly-class');
        Route::post('save-subject-weekly-class', 'SubjectWeeklyClassController@saveSubjectWeeklyList')->name('site-routine-save-subject-weekly-class');
        Route::get('get-subject-wise-assigned-teacher-list', 'SubjectWeeklyClassController@getSubjectWiseAssignedTeacher')->name('site-subject-get-subject-wise-assigned-teacher-list');


        Route::group(['prefix' => 'routine-activation'], function () {
            Route::get('get-routine-details', 'RoutineController@getRoutineActivation')->name('routine-activation-get-routine-details');
            Route::post('save-routine-details', 'RoutineController@saveRoutineActivation')->name('routine-activation-save-routine-details');
            Route::post('copy-routine-details', 'RoutineController@copyPasteRoutine')->name('routine-copy-paste-copy-routine-details');
        });


        Route::group(['prefix' => 'report'], function () {
            Route::get('get-routine-report', 'RoutineReportController@routineReport')->name('routine-report-get-routine-report');
            Route::get('get-shift-wise-weekday-report', 'RoutineReportController@shiftWiseWeekdayReport')->name('routine-report-shift-wise-weekday-routine-report');
        });

        Route::group(['prefix' => 'routine-details'], function () {
            Route::get('get-weekday-class-timing-list/{academic_version_id}/{academic_year_id}/{academic_department_id}/{academic_class_id}/{academic_section_id}/{academic_shift_id}/{academic_class_group_id}/{academic_session_id}/{academic_session_type_id}', 'RoutineDetailsController@getWeekDayClassTimingList')->name('get-weekday-class-timing-list');
            Route::get('routine-details-entries', 'RoutineDetailsController@routineDetailsEntries')->name('routine-details-get-routine-details');
            Route::post('routine-details-add-new-slot', 'RoutineDetailsController@addNewSlot')->name('routine-details-routine-details-add-new-slot');
            Route::get('routine-details-regenerate', 'RoutineDetailsController@routineDetailsRegenerate')->name('site-routine-details-regenerate');
            Route::post('routine-details-drop', 'RoutineDetailsController@dropRoutine')->name('site-routine-details-drop');
            Route::get('get-subject-based-on-slot/{slot_id}', 'RoutineDetailsController@getSubjectsBasedOnSlot')->name('site-routine-details-get-subject-based-on-slot');
        });


        Route::group(['prefix' => 'routine-allocation'], function () {
            Route::get('check-auto-capability', 'AutoGeneratorController@checkAutoCapability')->name('site-routine-check-auto-capability');
            Route::get('auto-generate', 'AutoGeneratorController@autoGenerate')->name('site-routine-auto-generate');


            Route::get('allocate-employee-subject-room', 'RoutineAllocationController@allocateEmployeeSubjectRoom')->name('routine-allocation-allocate-employee-subject-room');
            Route::post('assign-and-remove', 'RoutineAllocationController@assignAndRemove')->name('routine-allocation-assign-and-remove');
            Route::post('allocation-update', 'RoutineAllocationController@updateAllocations')->name('site-routine-allocation-update');
            Route::post('assign-and-retain', 'RoutineAllocationController@assignAndRetain')->name('routine-allocation-assign-and-retain');
            Route::get('allocation-delete/{id}', 'RoutineAllocationController@deleteAllocation')->name('routine-allocation-delete-allocation');
        });

        Route::group(['prefix' => 'swap-cancel'], function () {

            Route::get('class-routine-slot-by-date', 'SwapCancelController@getClassWiseRoutineByDate')->name('routine-details-get-class-wise-routine-slot-by-date');

            Route::get('get-available-teacher-to-swap', 'SwapCancelController@getTeacherToSwap')->name('site-routine-swap-cancel-available-teacher-to-swap');
            Route::post('swap-class', 'SwapCancelController@swapClass')->name('site-routine-swap-cancel-swap-class');
            Route::post('cancel-class', 'SwapCancelController@cancelClass')->name('site-routine-swap-cancel-cancel-class');
            Route::post('revert-class', 'SwapCancelController@revertClass')->name('site-routine-swap-cancel-revert-class');
        });
    });


    Route::group(['prefix' => 'class-similarity'], function () {
        Route::get('list', 'ClassSimilarityController@index')->name('site-class-similarity-list');

        Route::get('get-class-similarities-list', 'ClassSimilarityController@getSiteClassSimilaritiesList')->name('site-class-similarity-get-class-similarities-list');
        Route::put('edit/{id}', 'ClassSimilarityController@update')->name('site-class-similarity-edit');
        Route::post('add', 'ClassSimilarityController@store')->name('site-class-similarity-add');
        Route::delete('delete/{id}', 'ClassSimilarityController@destroy')->name('site-class-similarity-delete');
    });
    Route::get('waiver-offer-settings', 'SiteFeeSubHeadAllocationController@waiverOfferSettings')->name('waiver-offer-setting');



    Route::group(['prefix' => 'fee'], function () {
        Route::get('get-site-version-year-shift-base-department-class/{version}/{year}/{shift}', 'SiteFeeAllocationController@getSiteVersionYearShiftBaseDepartmentClass')->name('get-only-site-version-year-shift-based-department-class');
        Route::get('settings', 'SiteFeeSubHeadAllocationController@feeSettings')->name('site-fee-settings');
        Route::post('get-site-group-global-fee-head-allocation', 'SiteFeeAllocationController@getSiteGlobalFeeHeadAllocation')->name('get-site-group-global-fee-head-allocation-list');
        Route::get('site-fee-head-group-subhead-list', 'SiteFeeSubHeadAllocationController@siteFeeHeadGroupSubHeadList')->name('get-site-fee-head-group-subhead-list');

        Route::group(['prefix' => 'fee-sub-head-allocation'], function () {

            Route::get('get-fee-head-and-group-list', 'SiteFeeAllocationController@getHeadAndFeeGroupList')->name('site-fee-get-fee-head-and-group-list');

            Route::get('view', 'SiteFeeSubHeadAllocationController@index')->name('site-fee-sub-head-allocation-view');
            Route::get('list', 'SiteFeeSubHeadAllocationController@getSiteFeeHeadAllocationList')->name('site-fee-sub-head-allocation-list');
            Route::get('fee-head-list', 'SiteFeeSubHeadAllocationController@getFeeHeadList')->name('site-fee-head-list');
            Route::get('fee-group-list', 'SiteFeeSubHeadAllocationController@getFeeGroupList')->name('site-fee-group-list');
            Route::post('create-update', 'SiteFeeSubHeadAllocationController@createUpdateFeeHeadGroupSubHead')->name('site-fee-sub-head-allocation-add');
            Route::post('edit/{id}', 'SiteFeeSubHeadAllocationController@update')->name('site-fee-sub-head-allocation-edit');
            Route::delete('delete/{id}', 'SiteFeeSubHeadAllocationController@destroy')->name('site-fee-sub-head-allocation-delete');
        });
        Route::group(['prefix' => 'fee-allocation'], function () {

            Route::get('view', 'SiteFeeAllocationController@index')->name('site-fee-allocation-view');
            Route::get('list', 'SiteFeeAllocationController@getSiteFeeHeadAllocationList')->name('site-fee-allocation-list');
            Route::get('sub-head-list/{offerType?}/{siteVersionId?}/{siteYearId?}/{siteShiftId?}/{departmentId?}/{classId?}/{sectionId?}/{classGroupId?}/{sessionId?}', 'SiteFeeAllocationController@getSubHeadListByVersionIdYearidShiftIdClassId')->name('sub-head-list-by-version-id-year-id-shift-id-class-id');
            //            Route::get('sub-head-list/{feeHeadId?}/{feeGroupId?}/{siteVersionId?}/{siteYearId?}/{siteShiftId?}/{departmentId?}/{classId?}/{sectionId?}/{classGroupId?}/{sessionId?}', 'SiteFeeAllocationController@getSubHeadListByFeeHeadFeeGroupYearSessionShiftClassGroupSection')->name('site-fee-sub-head-list-by-fee-head-fee-group-year-session-shift-class-group-section');
            Route::get('sub-head-details-list/{siteVersionId?}/{siteYearId?}/{siteShiftId?}/{departmentId?}/{classId?}/{sectionId?}/{classGroupId?}/{sessionId?}', 'SiteFeeAllocationController@getSubHeadListByFeeHeadFeeGroupYearSessionShiftClassGroupSection')->name('site-fee-sub-head-list-by-fee-head-fee-group-year-session-shift-class-group-section');
            Route::get('class-list', 'SiteFeeAllocationController@getSiteClassList')->name('site-class-list');
            //            Route::post('create-update-site-group-fee-allocation', 'SiteGroupFeeAllocationController@createUpdateSiteGroupFeeAllocation')->name('create-update-site-group-fee-allocation');
            Route::post('get-site-classbase-studentbase-fee-head-allocation', 'SiteFeeAllocationController@getSiteClassbaseStudentbaseFeeHeadAllocation')->name('get-site-classbase-studentbase-fee-head-allocation');

            Route::post('check_exist_fee_allocation', 'SiteFeeAllocationController@checkExistFeeAllocation')->name('fee-allocation-check-exist');
            Route::post('add', 'SiteFeeAllocationController@createUpdateSiteFeeAllocation')->name('fee-allocation-add');
            Route::post('edit/{id}', 'SiteFeeAllocationController@update')->name('student-waiver-history-edit');
            Route::delete('delete/{id}', 'SiteFeeAllocationController@destroy')->name('student-waiver-history-delete');
        });

        Route::group(['prefix' => 'student-fee-generate'], function () {

            Route::get('view', 'SiteStudentFeeGenerateController@index')->name('site-student-fee-generate-view');
            Route::get('list/{siteYearId}/{siteShiftId}/{classId?}/{sectionId?}/{sessionId?}/{classGroupId?}/{departmentId?}', 'SiteStudentFeeGenerateController@getStudentFeeGenerateList')->name('student-fee-generate-list');
            Route::post('list-by-sub-head', 'SiteStudentFeeGenerateController@getStudentFeeGenerateListBySubHeadId')->name('student-fee-generate-list-by-sub-head-ids');
            Route::get('site-accademic-session/{year_id}/{shift_id}/{class_id}', 'SiteStudentFeeGenerateController@getSiteAcademicSessionList')->name('site-session-list');
            Route::get('sub-head-with-all-details-list/{siteYearId}/{siteShiftId}/{classId}/{sectionId?}/{sessionId?}/{classGroupId?}/{departmentId?}', 'SiteStudentFeeGenerateController@getSubHeadDeetailsListByFeeHeadFeeGroupYearSessionShiftClassGroupSection')->name('site-fee-sub-head-details-list-by-fee-head-fee-group-year-session-shift-class-group-section');
            Route::post('student-list', 'SiteStudentFeeGenerateController@getStudentListByYearSessionShiftClassGroupSection')->name('student-list-by-year-session-shift-class-group-section');
            Route::post('add', 'SiteStudentFeeGenerateController@store')->name('site-student-fee-add');

            Route::post('change-site-base-class-fee-head-list', 'SiteStudentFeeGenerateController@getSiteClassDeptfeeHeadBaseFee')->name('change-site-base-class-fee-head-list-for-site');
            Route::post('change-site-base-class-fee-head-list-of-pdf', 'SiteStudentFeeGenerateController@getSiteClassDeptfeeHeadBaseFeePdf')->name('change-site-base-class-fee-head-list-of-pdf');

            Route::post('get-site-academic-head-list', 'SiteStudentFeeGenerateController@getSiteAcademicHeadList')->name('get-site-academic-head-list');

            Route::post('get-site-fee-head-base-type-list', 'SiteStudentFeeGenerateController@getSiteFeeHeadBaseTypeList')->name('get-site-fee-head-base-type-list-for-site');

            Route::post('create-update-site-fee-generate', 'SiteStudentFeeGenerateController@createUpdateSiteFeeGenerate')->name('create-update-site-fee-generate');

            //Route::post('edit/{id}', 'SiteStudentFeeGenerateController@update')->name('student-waiver-history-edit');
            //Route::delete('delete/{id}', 'SiteStudentFeeGenerateController@destroy')->name('student-waiver-history-delete');

        });

        Route::group(['namespace' => 'Fee', 'prefix' => 'student-waiver-generate'], function () {
            Route::post('get-instant-waiver-base-type-student-list', 'StudentWaiverHistoryController@getInstentWaiverBaseTypeStudentList')->name('get-site-base-instant-waiver-base-type-student-list');
            Route::post('get-site-base-class-fee-list-for-waiver', 'StudentWaiverHistoryController@getSiteBaseClassFeeListForWaiver')->name('get-student-site-base-class-fee-list-for-waiver');
            Route::post('create-update-site-waiver-generate', 'StudentWaiverHistoryController@createUpdateSiteGroupWaiverGenerate')->name('create-update-site-waiver-generate');
            Route::get('get-student-waiver-type-base-waiver-amount/{waivertype}/{studentid}', 'StudentWaiverHistoryController@getStudentWaiverTypeBaseWaiverAmount')->name('get-student-waiver-type-base-waiver-amount-for-site');
            Route::get('get-site-group-base-waiver-type-list', 'StudentWaiverHistoryController@getSiteBaseWaiverTypeList')->name('get-site-base-waiver-type-list');
        });

        Route::group(['namespace' => 'Fee', 'prefix' => 'student-fine'], function () {
            Route::post('get-site-student-fine-list', 'StudentFineHistoryController@getStudentFineList')->name('get-site-student-fine-list');
            // Route::post('get-site-base-class-fee-list-for-waiver', 'StudentWaiverHistoryController@getSiteBaseClassFeeListForWaiver')->name('get-student-site-base-class-fee-list-for-waiver');
            // Route::post('create-update-site-waiver-generate', 'StudentWaiverHistoryController@createUpdateSiteGroupWaiverGenerate')->name('create-update-site-waiver-generate');
            // Route::get('get-student-waiver-type-base-waiver-amount/{waivertype}/{studentid}', 'StudentWaiverHistoryController@getStudentWaiverTypeBaseWaiverAmount')->name('get-student-waiver-type-base-waiver-amount-for-site');
            // Route::get('get-site-group-base-waiver-type-list', 'StudentWaiverHistoryController@getSiteBaseWaiverTypeList')->name('get-site-base-waiver-type-list');
        });

        Route::group(['namespace' => 'Fee', 'prefix' => 'student-waiver-history'], function () {

            Route::get('view', 'StudentWaiverHistoryController@index')->name('student-waiver-history-view');
            Route::get('list', 'StudentWaiverHistoryController@getSiteFeeHeadAllocationList')->name('student-waiver-history-list');
            Route::post('add', 'StudentWaiverHistoryController@store')->name('student-waiver-history-add');
            Route::post('edit/{id}', 'StudentWaiverHistoryController@update')->name('student-waiver-history-edit');
            Route::delete('delete/{id}', 'StudentWaiverHistoryController@destroy')->name('student-waiver-history-delete');
        });
        Route::group(['namespace' => 'Fee', 'prefix' => 'student-waiver-document'], function () {

            Route::get('view', 'StudentWaiverDocumentController@index')->name('student-waiver-document-view');
            Route::get('list', 'StudentWaiverDocumentController@getStudentWaiverDocumentList')->name('student-waiver-document-list');
            Route::post('add', 'StudentWaiverHistoryController@store')->name('student-waiver-history-add');
            Route::post('edit/{id}', 'StudentWaiverHistoryController@update')->name('student-waiver-history-edit');
            Route::delete('delete/{id}', 'StudentWaiverHistoryController@destroy')->name('student-waiver-history-delete');
        });

        Route::group(['namespace' => 'Fee', 'prefix' => 'student-fee-offer-detail'], function () {

            Route::get('view', 'SiteStudentFeeOfferDetailController@index')->name('student-fee-offer-detail-view');
            Route::get('list', 'SiteStudentFeeOfferDetailController@getStudentFeeOfferList')->name('student-fee-offer-detail-list');
            Route::get('offer-list', 'SiteStudentFeeOfferDetailController@getStudentOfferList')->name('student-offer-list');
            Route::post('add', 'SiteStudentFeeOfferDetailController@store')->name('student-fee-offer-detail-add');
            Route::post('edit/{id}', 'SiteStudentFeeOfferDetailController@update')->name('student-fee-offer-detail-edit');
            Route::delete('delete/{id}', 'SiteStudentFeeOfferDetailController@destroy')->name('student-fee-offer-detail-delete');
        });

        Route::group(['namespace' => 'Fee', 'prefix' => 'gateway-settings'], function () {

            Route::get('get-site-payment-gateway', 'SiteFeeBankTransferController@getSitePaymentGateway')->name('get-site-payment-gateway');
            Route::post('get-site-payment-gateway-wise-fee-info', 'SiteFeeBankTransferController@getHeadWiseSubheadList')->name('get-site-payment-gateway-wise-fee-info');
            Route::post('site-student-fee-payment-gateway-setting-save', 'SiteFeeBankTransferController@siteStudentFeePaymentGatewaySettigSave')->name('site-student-fee-payment-gateway-setting-save');
            // Route::get('pdf/{slipNo}', 'SiteStudentFeeDemandSlipController@getDemadSlipPdf')->name('demand-slip-pdf-view');
            // Route::post('get-class-dept-base-site-fee-head-sub-head-list', 'SiteStudentFeeDemandSlipController@getClassDeptBaseSiteFeeHeadSubHeadList')->name('get-class-dept-base-site-fee-head-sub-head-list-for-site');
            // Route::post('create-site-base-demand-slip', 'SiteStudentFeeDemandSlipController@createSiteBaseDemandSlip')->name('create-site-base-demand-slip');
            // Route::post('update-site-base-demand-slip', 'SiteStudentFeeDemandSlipController@updateSiteGroupBaseDemandSlip')->name('update-site-base-demand-slip');

            // Route::post('get-studetnt-list', 'SiteStudentFeeDemandSlipController@getStudentList')->name('get-studetnt');
            // Route::post('get-student-last-demand-slip-list', 'SiteStudentFeeDemandSlipController@getDemandSlipList')->name('demand-slip-list');

            // Route::post('single-student-demand-slip-cancel', 'SiteStudentFeeDemandSlipController@singleStudentDemandSlipCancel')->name('single-student-demand-slip-cancel');


        });

        Route::group(['namespace' => 'Fee', 'prefix' => 'demand-slip'], function () {

            Route::get('view', 'SiteStudentFeeDemandSlipController@index')->name('demand-slip-view');
            Route::get('pdf/{slipNo}', 'SiteStudentFeeDemandSlipController@getDemadSlipPdf')->name('demand-slip-pdf-view');
            Route::post('get-class-dept-base-site-fee-head-sub-head-list', 'SiteStudentFeeDemandSlipController@getClassDeptBaseSiteFeeHeadSubHeadList')->name('get-class-dept-base-site-fee-head-sub-head-list-for-site');
            Route::post('create-site-base-demand-slip', 'SiteStudentFeeDemandSlipController@createSiteBaseDemandSlip')->name('create-site-base-demand-slip');
            Route::post('update-site-base-demand-slip', 'SiteStudentFeeDemandSlipController@updateSiteGroupBaseDemandSlip')->name('update-site-base-demand-slip');

            Route::post('get-studetnt-list', 'SiteStudentFeeDemandSlipController@getStudentList')->name('get-studetnt');
            Route::post('get-student-last-demand-slip-list', 'SiteStudentFeeDemandSlipController@getDemandSlipList')->name('demand-slip-list');
            Route::post('get-student-last-demand-slip-list-pdf', 'SiteStudentFeeDemandSlipController@getDemandSlipListPdf')->name('demand-slip-list-pdf');

            Route::post('single-student-demand-slip-cancel', 'SiteStudentFeeDemandSlipController@singleStudentDemandSlipCancel')->name('single-student-demand-slip-cancel');
        });

        Route::group(['namespace' => 'Fee', 'prefix' => 'student-payment'], function () {

            Route::get('view', 'SiteStudentPaymentHistoryController@index')->name('student-payment-view');
            Route::get('list', 'SiteStudentPaymentHistoryController@getStudentFeeOfferList')->name('student-payment-list');
            Route::get('std-pay-slip-list', 'SiteStudentFeePaymentHistoryController@getStudentPaySlipList')->name('student-pay-slip-list');
            Route::get('std-pay-slip-pdf/{slip_id}', 'SiteStudentFeePaymentHistoryController@getStudentPaySlipPdf')->name('student-pay-slip-pdf');
            Route::get('single-student-payment-pdf/{print_status?}/{voucher_no?}', 'SiteStudentFeePaymentHistoryController@singleStudentPaymentPDF')->name('single-student-payment-pdf');
            Route::get('single-student-finance-ledger-pdf/{class_id?}/{start_date?}/{end_date?}', 'SiteStudentFeePaymentHistoryController@singleStudentFinancialLedgerPDF')->name('single-student-financial-ledger-pdf');
            //    Route::get('std-pay-slip-pdf', 'SiteStudentPaymentHistoryController@getStudentPaySlipPdf')->name('student-pay-slip-pdf');
            Route::get('offer-list', 'SiteStudentPaymentHistoryController@getStudentOfferList')->name('student-offer-list');
            Route::post('add', 'SiteStudentFeePaymentHistoryController@store')->name('student-payment-detail-add');
            Route::post('edit/{id}', 'SiteStudentPaymentHistoryController@update')->name('student-waiver-history-edit');
            Route::delete('delete/{id}', 'SiteStudentPaymentHistoryController@destroy')->name('student-waiver-history-delete');

            Route::post('get-multiple-student-demand-slip-list-for-payment', 'SiteStudentFeePaymentHistoryController@getMultipleStudentDemandSlipListForPayment')->name('get-multiple-student-demand-slip-list-for-payment-for-site');
            Route::post('get-multiple-student-list-for-payment-check', 'SiteStudentFeePaymentHistoryController@siteStudentOnlinePaymentList')->name('get-multiple-student-list-for-payment-check');
            Route::post('get-multiple-student-list-for-payment-pdf', 'SiteStudentFeePaymentHistoryController@siteStudentOnlinePaymentPDF')->name('get-multiple-student-list-for-payment-pdf');


            Route::post('get-gateway-account-list', 'SiteStudentFeePaymentHistoryController@getGatewayAccountList')->name('get-gateway-account-list');
            Route::post('get-multiple-student-account-wise-for-payment-list', 'SiteStudentFeePaymentHistoryController@siteStudentAccountWiseOnlinePaymentList')->name('get-multiple-student-account-wise-for-payment-list');
            Route::post('get-multiple-student-account-wise-for-payment-list-pdf', 'SiteStudentFeePaymentHistoryController@siteStudentAccountWiseOnlinePaymentListPdf')->name('get-multiple-student-account-wise-for-payment-list-pdf');


            Route::get('get-site-student-payment-slip-pdf/{voucher_no}', 'SiteStudentFeePaymentHistoryController@geSiteStudentPaymentBankSlipPdf')->name('get-site-student-payment-slip-pdf');

            Route::post('create-site-base-multiple-student-payment', 'SiteStudentFeePaymentHistoryController@createSiteBaseMultipleStudentPayment')->name('create-site-base-multiple-student-payment');

            Route::get('fee-cancel-view', 'SiteStudentFeePaymentHistoryController@feeCancelIndex')->name('student-fee-cancel-view');

            Route::post('get-student-list-for-payment-list', 'SiteStudentFeePaymentHistoryController@getStudentListForPaymentList')->name('get-student-list-for-payment-list');
            Route::post('get-student-last-payment-list', 'SiteStudentFeePaymentHistoryController@getStudentLastPaymentList')->name('get-student-last-payment-list');
            Route::post('get-student-last-payment-list-pdf', 'SiteStudentFeePaymentHistoryController@getStudentLastPaymentListPdf')->name('get-student-last-payment-list-pdf');

            Route::post('single-student-payment-cancel', 'SiteStudentFeePaymentHistoryController@singleStudentPaymetCancel')->name('single-student-payment-cancel');
        });

        Route::group(['namespace' => 'FeeReport', 'prefix' => 'student-payment-report'], function () {
            //=================student wise report=====================
            Route::get('view', 'SiteFeeReportController@index')->name('student-payment-report-view');
            Route::post('get-single-student-payment-report-list', 'SiteFeeReportController@getSingleStudentPaymentReportList')->name('get-single-student-payment-report-list');
            Route::get('get-academic-year-list', 'SiteFeeReportController@getAcademicYearList')->name('get-academic-year-list-list-for-studentwise-report');
            Route::post('get-site-fee-head-base-type-list', 'SiteFeeReportController@getSiteFeeHeadBaseTypeList')->name('get-site-fee-head-base-type-list-for-report');
            Route::post('get-site-fee-head-fee-type-base-fee-list', 'SiteFeeReportController@getSiteFeeHeadFeeTypeBaseFeeList')->name('get-site-fee-head-fee-type-base-fee-list-for-report');
            Route::post('get-site-single-student-payment-summary', 'SiteFeeReportController@getSiteSingleStudentFeeSummary')->name('get-site-single-student-payment-summary');

            Route::post('get-single-student-payment-report-pdf', 'SiteFeeReportController@pdfStudentWisePaymentReport')->name('pdf-site-fee-head-fee-type-base-fee-list-for-report');

            Route::post('individual-report-pdf', 'SiteFeeReportController@createIndividualPaymentReportPdf')->name('create-individual-report-pdf');
            Route::get('individual-report-pdf-show/{data}', 'SiteFeeReportController@showIndividualPaymentReportPdf')->name('individual-report-pdf-show');
            Route::get('individual-student-payment-summary-pdf-show/{user_name}/{academic_year_id}', 'SiteFeeReportController@showIndividualStudentPaymentSummaryReportPdf')->name('individual-student-payment-summary-pdf-show');

            //=================class wise report=====================
            Route::post('get-site-class-base-fee-list', 'SiteFeeReportController@getSiteFeeHeadClassBaseFeeList')->name('get-site-class-base-fee-list-for-report');
            Route::post('class-base-report-pdf', 'SiteFeeReportController@createClassBasePaymentReportPdf')->name('create-class-base-report-pdf');
            Route::get('class-base-report-pdf-show/{data}', 'SiteFeeReportController@classBasePaymentPdfShow')->name('class-base-report-pdf-show');
            Route::get('student-base-report-pdf/{student_history_id}', 'SiteFeeReportController@studentBasePaymentPdfShow')->name('site-student-base-report-pdf');


            //=================general report=====================
            Route::post('get-site-general-fee-list', 'SiteFeeReportController@getSiteGeneralFeeList')->name('get-site-general-fee-list-for-report');
            Route::post('general-report-pdf', 'SiteFeeReportController@createGeneralPaymentReportPdf')->name('create-general-report-pdf');
            Route::get('general-report-pdf-show/{data}', 'SiteFeeReportController@showGeneralReportPdf')->name('general-report-pdf-show');

            //=================sub headgeneral report=====================
            Route::post('get-sub-head-list-for-report', 'SiteFeeReportController@getSubHeadList')->name('get-sub-head-list-for-report');
            Route::post('get-site-sub-head-wise-fee-list', 'SiteFeeReportController@getSiteSubHeadGeneralFeeList')->name('get-site-sub-head-general-fee-list-for-report');

            Route::post('sub-head-wise-general-report-pdf', 'SiteFeeReportController@createSubHeadWisePaymentReportPdf')->name('create-sub-head-wise-general-report-pdf');
            //  Route::get('general-report-pdf-show/{data}', 'SiteFeeReportController@showGeneralReportPdf')->name('general-report-pdf-show');



        });

        Route::group(['namespace' => 'Fee', 'prefix' => 'student-payment-slip-generate'], function () {
            Route::post('get-demand-list-for-payment', 'SiteStudentFeePaymentHistoryController@getDemandListForPayment')->name('get-demand-list-for-payment-for-site');
            Route::get('get-demand-slip-no-list-for-payment', 'SiteStudentFeePaymentHistoryController@getDemandSlipNoListForPayment')->name('get-demand-slip-no-list-for-payment-for-site');
            Route::post('get-demand-list-for-payment-for-edit', 'SiteStudentFeePaymentHistoryController@getDemandListForPaymentEdit')->name('get-demand-list-for-payment-for-edit-for-site');
        });
    });

    Route::group(['prefix' => 'shift-class-group-section-setting'], function () {
        Route::get('master', 'SiteShiftClassGroupSectionSettingController@index')->name('site-shift-class-group-section-setting-opening-page');
        Route::get('get-shift-base-checked-class-group-section-list/{shift_id}/{year_id}/{version_id}', 'SiteShiftClassGroupSectionSettingController@getShiftClassGroupSectionList')->name('shift-class-group-section-setting-get-shift-base-checked-class-group-section-list');
        Route::post('insert-update', 'SiteShiftClassGroupSectionSettingController@insertUpdateShiftClassGroupSectionList')->name('shift-class-group-section-setting-insert-update');
        Route::get('get-academic-group-base-shift', 'SiteShiftClassGroupSectionSettingController@getAcademicGroupBaseShiftYearVersion')->name('get-academic-group-base-shift');
        Route::get('get-site-year-version-base-department-class/{version_id}/{year_id}', 'SiteShiftClassGroupSectionSettingController@getSiteYearVersionBaseDepartmentClass')->name('get-site-year-version-base-department-class');

        Route::get('get-site-year-version-shift-based-department-class', 'SiteShiftClassGroupSectionSettingController@getYearVersionAndShiftBasedDepartmentClass')->name('site-class-section-setup-get-year-version-shift-based-department-class');
        Route::get('get-site-year-version-multiple-shift-based-department-class', 'SiteShiftClassGroupSectionSettingController@getYearVersionAndMultipleShiftBasedDepartmentClass')->name('get-site-year-version-multiple-shift-based-department-class');
        Route::get('get-site-academic-group-year-version-shift-based-department-class', 'SiteShiftClassGroupSectionSettingController@getAcademicGroupYearVersionAndShiftBasedDepartmentClass')->name('get-site-academic-group-year-version-shift-based-department-class');
        Route::post('get-site-academic-group-year-shift-class-based-group-section', 'SiteShiftClassGroupSectionSettingController@getAcademicGroupYearVersionAndShiftClassBasedGroupSection')->name('get-site-academic-group-year-shift-class-based-group-section');

        Route::get('get-global-site-year-version-shift-based-department-class-by-user', 'SiteShiftClassGroupSectionSettingController@getGlobalSiteYearVersionAndShiftBasedDepartmentClassByUser')->name('get-global-site-class-section-setup-get-year-version-shift-based-department-class-by-user');

        Route::get('get-site-year-version-shift-based-department-class-by-user', 'SiteShiftClassGroupSectionSettingController@getYearVersionAndShiftBasedDepartmentClassByUser')->name('site-class-section-setup-get-year-version-shift-based-department-class-by-user');

        Route::get('get-department-base-class-list/{department_id}', 'SiteShiftClassGroupSectionSettingController@getDepartmentBaseClassList')->name('get-department-base-class-list');
        Route::get('get-global-department-base-class-list/{academic_group_id}/{department_id}', 'SiteShiftClassGroupSectionSettingController@getGlobalDepartmentBaseClassList')->name('get-global-department-base-class-list');
        Route::get('get-department-base-class-list-by-user/{department_id}', 'SiteShiftClassGroupSectionSettingController@getDepartmentBaseClassListByUser')->name('get-department-base-class-list-by-user');

        Route::get('get-academic-class-list-for-set-session', 'SiteShiftClassGroupSectionSettingController@getAcademicClassListForSetSession')->name('get-academic-class-list-for-set-session');
        Route::post('create-class-session-serial-setting', 'SiteShiftClassGroupSectionSettingController@createClassSessionSerial')->name('create-class-session-serial-setting');
    });

    //user and role and access managemnt for the  site if self
    Route::group(['prefix' => 'user'], function () {


        Route::get('master', 'SiteUserController@index')->name('site-user-list');
        Route::post('add', 'SiteUserController@siteUserStore')->name('site-user-store');
        Route::put('edit/{id}', 'SiteUserController@update')->name('site-user-edit');
        Route::put('data-update/{id}', 'SiteUserController@updateUserData')->name('site-user-data-update');
        Route::put('generate-login-info/{id}', 'SiteUserController@generateLoginInfo')->name('site-user-generate-login-info');
        Route::put('change-user-status/{id}', 'SiteUserController@changeUserStatus')->name('site-user-change-user-status');
        //Api
        Route::get('get-site-user-list', 'SiteUserController@siteUserList')->name('site-user-get-site-user-list');
        Route::get('get-site-user-list-with-pagination', 'SiteUserController@getSiteUserListWithPagination')->name('site-user-get-site-user-list-with-pagination');
        Route::get('get-site-user-by-user-type', 'SiteUserController@getSiteUserByType')->name('site-user-get-site-user-by-user-type');
        Route::put('assign-roles-to-user/{id}', 'SiteUserController@assignRolesToUser')->name('site-user-assign-roles-to-user');
        Route::get('get-the-user-details/{id}', 'SiteUserController@getUserDetails')->name('site-user-get-the-user-details');

        Route::group(['prefix' => 'role'], function () {
            Route::post('add', 'RolesController@create')->name('site-role-add');
            Route::put('update/{id}', 'RolesController@update')->name('site-role-update');
            Route::delete('delete/{id}', 'RolesController@delete')->name('site-role-delete');
            Route::get('get-role-list-and-user-assigned-roles/{user_id}', 'RolesController@getRolesListAndUserAssignedRoles')->name('site-role-get-role-list-and-user-assigned-roles');
            Route::get('get-role-list', 'RolesController@getRolesList')->name('site-role-get-role-list');
            Route::get('get-roles-with-accesses', 'RolesController@getRolesWithAccesses')->name('site-user-role-get-roles-with-accesses');
            Route::get('get-roles-without-admin-role', 'RolesController@getRolesWithoutAdminRole')->name('site-user-role-get-roles-without-admin-role');
            //palette
            Route::get('get-palette-list', 'RolesController@getPaletteList')->name('site-user-role-get-palette-list');
        });
        Route::group(['prefix' => 'permission'], function () {
            Route::post('assign-sub-module-to-user', 'UserPermissionController@assignSubModuleToUser')->name('site-assign-sub-module-to-user');
        });
    });
    Route::group(['prefix' => 'access'], function () {
        Route::get('get-assigned-list-for-the-site', 'SiteAccessController@getAssignedListForTheSite')->name('site-access-get-assigned-list-for-the-site');
        Route::post('assign-sub-module-to-site', 'SiteAccessController@assignSubModuleToSite')->name('site-access-assign-sub-module-to-site');
    });

    Route::group(['prefix' => 'category-position'], function () {
        Route::get('category-position-form', 'EmployeeCategoryPositionController@index')->name('site-category-position-category-position-form');
        Route::get('get-site-category-position-list', 'EmployeeCategoryPositionController@getSiteCategoryPositionList')->name('get-site-category-position-list');
        Route::post('create-update-site-category-position', 'EmployeeCategoryPositionController@createUpdateSiteCategoryPosition')->name('create-update-site-category-position');
    });

    Route::group(['prefix' => 'task'], function () {

        Route::get('task-form', 'TaskController@index')->name('site-task-task-form');
        Route::get('get-site-task-list', 'TaskController@getSiteTaskList')->name('get-site-task-list');
        Route::post('create-update-site-task', 'TaskController@createUpdateSiteTask')->name('create-update-site-task');
        Route::post('task-status-update/{id}', 'TaskController@taskStatusUpdate')->name('site-task-status-update');
        Route::post('task-delete/{id}', 'TaskController@taskDelete')->name('site-task-delete');
    });

    Route::group(['namespace' => 'Employee', 'prefix' => 'employee'], function () {

        Route::get('employee-attach-form', 'EmployeeAttachController@employeeAttachForm')->name('user-list');
        Route::get('get-employee-desigantion-religion-gender-list', 'EmployeeAttachController@employeeDesignationReligionGenderList')->name('site-get-employee-designation-religion-gender-list');
        Route::get('get-residence-empgrade-transport-quata-bloodgroup-list', 'EmployeeAttachController@getResidenceEmpgradeTransportQuataBloodgroupList')->name('site-get-residence-empgrade-transport-quata-bloodgroup-list');
        Route::get('get-employee-academic-assign-subject-list', 'EmployeeAttachController@getEmployeeAcademicAssignSubjectList')->name('get-employee-academic-assign-subject-list');
        Route::get('get-employee-examination-list', 'EmployeeAttachController@getEmployeeExaminationList')->name('site-get-employee-examination-list');
        Route::post('employee-create', 'EmployeeAttachController@employeeCreate')->name('site-employee-create');
        Route::post('employee-update', 'EmployeeAttachController@employeeUpdate')->name('site-employee-update');
        Route::post('employee-field-data-update', 'EmployeeController@updateFieldData')->name('site-employee-field-data-update');
        Route::post('employee-pause/{id}', 'EmployeeAttachController@employeePause')->name('site-employee-pause');
        Route::post('employee-active-from-pause/{id}', 'EmployeeAttachController@employeeActiveFromPause')->name('site-employee-active-from-pause');
        Route::post('employee-delete/{id}', 'EmployeeAttachController@employeeDelete')->name('site-employee-delete');
        Route::get('get-active-employee-list', 'EmployeeAttachController@getActiveEmployeeList')->name('site-get-active-employee-list');
        Route::get('get-list-by-search', 'EmployeeAttachController@getEmployeeBySearch')->name('site-employee-get-list-by-search');
        Route::get('get-pause-employee-list', 'EmployeeAttachController@getPauseEmployeeList')->name('site-get-pause-employee-list');
        Route::get('get-deleted-employee-list', 'EmployeeAttachController@getDeletedEmployeeList')->name('site-get-deleted-employee-list');
        Route::get('get-employee-list-for-edit/{id}', 'EmployeeAttachController@getEmployeeListForEdit')->name('site-get-employee-list-for-edit');
        //Api
        Route::get('site-employee-get-all-employee-by-search', 'EmployeeController@getAllEmployeeBySearch')->name('site-employee-get-all-employee-by-search');
        // payroll for
        Route::get('site-employee-get-all-employee-by-search-for-payroll', 'EmployeeController@getAllEmployeeBySearchForPayroll')->name('site-employee-get-all-employee-by-search-for-payroll');
        Route::get('site-employee-get-all-year-month-payroll', 'EmployeeController@getAllEmployeeYearMonthPayroll')->name('site-employee-get-all-year-month-payroll');
        Route::get('site-employee-get-payroll-report-by-date', 'EmployeeController@getAllEmployeeReportByDatePayroll')->name('site-employee-get-payroll-report-by-date');
        Route::get('site-employee-get-payroll-report-by-month', 'EmployeeController@getAllEmployeeReportByMonthPayroll')->name('site-employee-get-payroll-report-by-month');
        Route::get('site-employee-get-payroll-voucher-by-month', 'EmployeeController@getAllEmployeeReportByMonthVoucherPayroll')->name('site-employee-get-payroll-voucher-by-month');
        Route::post('site-single-employee-get-payroll-report-by-month', 'EmployeeController@SingleEmployeeReportByMonthPayroll')->name('site-single-employee-get-payroll-report-by-month');
        Route::post('site-single-employee-get-payroll-voucher-by-month', 'EmployeeController@SingleEmployeeVoucherByMonthPayroll')->name('site-single-employee-get-payroll-voucher-by-month');
        Route::post('site-single-employee-get-payroll-report-by-date', 'EmployeeController@SingleEmployeeReportByDatePayroll')->name('site-single-employee-get-payroll-report-by-date');
        // payroll for Acounts
        Route::post('site-employee-get-payroll-report-by-month-for-accounts', 'EmployeeController@getAllEmployeeReportByMonthPayrollForAccounts')->name('site-employee-get-payroll-report-by-month-for-accounts');
        // attendance
        Route::get('site-employee-attendance-get-list-by-search', 'EmployeeController@getAllEmployeeAttendance')->name('site-employee-attendance-get-list-by-search');

        // payroll end
        Route::get('site-employee-get-employee-data-by-search', 'EmployeeController@getEmployeeDataBySearch')->name('site-employee-get-employee-data-by-search');
        Route::get('get-simple-active-list', 'EmployeeController@getSimpleActiveEmployeeList')->name('site-employee-get-simple-active-list');
        Route::get('get-all-month-list', 'EmployeeController@getAllMonthList')->name('get-all-month-list');
        Route::get('get-the-subject-assigned-teacher-list', 'EmployeeController@getTheSubjectAssignedTeacherList')->name('site-employee-get-employees-by-department-class-subject-or-type');

        Route::get('get-version-year-shift-for-employee', 'EmployeeController@getVersionYearShiftForEmployee')->name('site-employee-get-version-year-shift-for-employee');
        Route::get('get-year-version-shift-based-dept-or-class-for-employee/{version_id}/{year_id}/{shift_id}', 'EmployeeController@getYearVersionAndShiftBasedDepartmentClass')->name('site-employee-get-year-version-shift-based-dept-or-class-for-employee');
        Route::get('get-employee-category-list', 'EmployeeCategoryController@getEmployeeCategoryList')->name('site-employee-get-employee-category-list');
        Route::get('site-employee-get-department-class-subject-list/{user_id}', 'EmployeeAttachController@siteEmployeeGetDepartmentClassSubjectList')->name('site-employee-get-department-class-subject-list');
        Route::get('site-employee-get-department-class-subject-list', 'EmployeeAttachController@getEmployeeAssignedSubjectByVersionYearShift')->name('site-employee-get-employee-assigned-subject-by-version-year-shift');
        Route::post('create-update-employee-department-class-subject', 'EmployeeAttachController@createEmployeeDepartmentClassSubject')->name('create-update-employee-department-class-subject');
        Route::get('get-single-employee-detail/{id}', 'EmployeeAttachController@getSingleEmployeeDetail')->name('get-single-employee-detail');
        Route::get('site-employee-get-category-position-list/{user_id}', 'EmployeeAttachController@siteEmployeeGetCategoryPositionList')->name('site-employee-get-category-position-list');
        Route::post('create-update-employee-category-position', 'EmployeeAttachController@createUpdateEmployeeCategoryPosition')->name('create-update-employee-category-position');


        Route::get('employee-report', 'EmployeeController@getEmployeeReport')->name('site-employee-get-employee-report');
        Route::get('employee-full-details-report', 'EmployeeController@getEmployeeFullDetailsReport')->name('site-employee-get-employee-full-details-report');
        Route::get('single-employee-full-details-report', 'EmployeeController@getSingleEmployeeFullDetailsReport')->name('site-employee-get-single-employee-full-details-report');


        //report

        Route::group(['namespace' => 'Report', 'prefix' => 'report'], function () {
            Route::get('master', 'EmployeeReportController@reportMaster')->name('site-employee-report-master');
            Route::post('get-student-list', 'StudentReportController@getStudents')->name('site-student-report-get-student-list');
        });


        Route::group(['namespace' => 'IdCard', 'prefix' => 'idcard'], function () {
            Route::post('get-employee-list', 'EmployeeIdCardController@getEmployees')->name('site-employee-idcard-get-employee-list');
            Route::post('view-pdf', 'EmployeeIdCardController@idCardViewPdf')->name('site-employee-id-card-view-pdf');
            Route::post('save-update-rf-card-code', 'EmployeeIdCardController@saveUpdateStudentRfIdCardCode')->name('site-save-update-rf-id-card-code');
            Route::post('create-update-setting-data', 'EmployeeIdCardController@createUpdateIdcardSettingData')->name('create-update-setting-data');
            Route::get('get-setting-data-for-employee', 'EmployeeIdCardController@getSettingData')->name('site-employee-id-card-get-setting-data');
        });

        Route::group(['namespace' => 'Attendance', 'prefix' => 'attendance'], function () {

            Route::get('master', 'EmployeeAttendanceController@index')->name('add-employee-attendance');
            Route::get('employee-individual-attendance-master', 'EmployeeAttendanceController@employeeIndividualAttendanceMaster')->name('site-employee-individual-attendance');
            Route::get('get-employee-individual-attendance', 'EmployeeAttendanceController@getIndividualAttendance')->name('site-employee-attendance-get-employee-individual-attendance');
            Route::get('get-shift-list', 'EmployeeAttendanceController@getShiftList')->name('site-employee-get-shift-list-for-employee');
            Route::get('attendance-list-by-shift-date', 'EmployeeAttendanceController@getAllEmployeeAttendanceListByShiftDate')->name('all-employee-attendance-list-by-shift-date');

            Route::post('attendance-edit', 'EmployeeAttendanceController@updateEmployeeAttendance')->name('employee-attendance-edit');
            Route::post('take-access-time', 'EmployeeAttendanceController@takeAccessTime')->name('employee-attendance-take-access-time');
            Route::post('send-sms', 'EmployeeAttendanceController@sendSms')->name('site-employee-attendance-send-sms');
            Route::post('employee-attendance-by-geolocation', 'EmployeeAttendanceController@employeeGeoLocationAttendance')->name('employee-attendance-by-geolocation');
            Route::post('check-employee-attendance-activity', 'EmployeeAttendanceController@checkEmployeeAttendanceActivity')->name('check-employee-attendance-activity');

            Route::get('attendance-qr-code', 'EmployeeAttendanceController@getAttendanceQrCode')->name('employee-attendance-qr-code');

            Route::get('employee-attendance-by-qrcode', 'EmployeeAttendanceController@employeeAttendanceByQrcode')->name('employee-attendance-by-qrcode');
            // Route::get('employee-attendance-request-message', 'EmployeeAttendanceController@employeeAttendanceMessage')->name('employee-attendance-request-message');

            // settings
            Route::group(['prefix' => 'setting'], function () {
                Route::get('get-employee-attendance-settings', 'EmployeeAttendanceSettingsController@getEmployeeAttendanceSettings')->name('get-employee-attendance-settings');
                Route::post('update-employee-attendance-settings', 'EmployeeAttendanceSettingsController@updateEmployeeAttendanceSettings')->name('update-employee-attendance-settings');
                Route::get('get-employee-geolocation', 'EmployeeAttendanceSettingsController@getEmployeeGeolocation')->name('get-employee-geolocation');
                Route::post('update-employee-geolocation', 'EmployeeAttendanceSettingsController@updateEmployeeGeolocation')->name('employee-geolocation-update');
            });

            //report

            Route::group(['prefix' => 'report'], function () {
                Route::get('open-report/{name}', 'AttendanceReportController@openReport')->name('open-pdf-file-storage');
                Route::post('date-and-shift-wise', 'AttendanceReportController@getDateAndShiftWiseReport')->name('site-employee-attendance-report-date-and-shift');
                Route::post('month-and-shift-wise', 'AttendanceReportController@getMonthAndShiftWiseReport')->name('site-employee-attendance-report-month-and-shift');
                Route::post('month-and-shift-wise-short-report', 'AttendanceReportController@getMonthAndShiftWiseShortReport')->name('site-employee-attendance-short-report-year-month-and-shift');
                Route::post('employee-wise-yearly-report', 'AttendanceReportController@getYearlyReport')->name('site-employee-attendance-employee-wise-yearly-report');
            });
        });
        Route::group(['namespace' => 'Routine', 'prefix' => 'routine'], function () {
            Route::get('master', 'EmployeeRoutineController@index')->name('site-employee-routine-master');
            Route::get('get-routine-details', 'EmployeeRoutineController@getRoutineDetails')->name('site-employee-routine-get-routine-details');
            Route::get('get-routine-report', 'EmployeeRoutineController@routineReport')->name('site-employee-routine-report-get-routine-report');
            Route::get('get-period-hours-report', 'EmployeeRoutineController@teacherPeriodAndHourReport')->name('site-employee-routine-report-period-hours-report');
            Route::get('get-routine-details-for-the-teacher', 'EmployeeRoutineController@getRoutineForTheTeacher')->name('routine-details-get-routine-details-for-the-teacher');
        });
    });

    Route::group(['prefix' => 'shift-details'], function () {

        Route::get('list', 'SiteShiftDetailsController@index')->name('site-shift-details-list');
        Route::get('shift/list', 'SiteShiftDetailsController@shiftList')->name('academic-shift-list');
        Route::get('session/list', 'SiteShiftDetailsController@sessionList')->name('academic-session-list');
        Route::get('get-day-list-data', 'SiteShiftDetailsController@getDayListData')->name('shift-details-get-day-list-data');
        Route::post('save-data', 'SiteShiftDetailsController@store')->name('shift-details-save-data');
        Route::post('edit', 'SiteShiftDetailsController@update')->name('site-shift-details-edit');
        Route::delete('delete/{id}', 'SiteShiftDetailsController@destroy')->name('site-class-similarity-delete');

        //report
        Route::get('get-shift-details-report/{belongs_to}/{academic_shift_id}/{academic_period_type_id}', 'SiteShiftDetailsController@getShiftDetailsReport')->name('shift-details-data');
    });

    Route::group(['namespace' => 'SiteAcademicSettingReplication', 'prefix' => 'site-academic-setting-replication'], function () {
        Route::get('view', 'SiteAcademicSettingReplicationController@index')->name('site-academic-setting-replication-view');
        Route::get('setting-list/{pr_year_id}/{new_year_id}', 'SiteAcademicSettingReplicationController@getAcademicSettingList')->name('get-site-academic-setting-list');
        Route::post('add', 'SiteAcademicSettingReplicationController@replicateSiteAcademicSetting')->name('site-academic-settng-replicate');
        Route::get('session-list', 'SiteAcademicSettingReplicationController@sessionListForReplication')->name('get-session-list-for-replication');
    });


    Route::group(['namespace' => 'Student', 'prefix' => 'student'], function () {

        Route::group(['namespace' => 'Attendance', 'prefix' => 'attendance'], function () {

            //view
            Route::get('master', 'StudentAttendanceController@studentAttendance')->name('site-student-attendance-list');
            Route::get('manual', 'StudentAttendanceController@manualAttendance')->name('site-student-attendance-manual');

            Route::post('add', 'StudentAttendanceController@addStudentAttendance')->name('add-student-attendance');

            Route::get('site-accademic-class', 'StudentAttendanceController@getAccademicClassBySiteID')->name('site-accademic-class-by-site-id');
            //API


            Route::get('route_user_list', 'StudentAttendanceController@route_user_list')->name('route_user_list');
            Route::post('route_site_update_attendance_setting_details', 'StudentAttendanceController@route_site_update_attendance_setting_details')->name('route_site_update_attendance_setting_details');
            Route::get('route_site_get_attendance_setting_details', 'StudentAttendanceController@route_site_get_attendance_setting_details')->name('route_site_get_attendance_setting_details');
            Route::put('route_student_update_attendance_sms/{id}', 'StudentAttendanceController@route_student_update_attendance_sms')->name('route_student_update_attendance_sms');
            Route::put('route_single_student_update_attendance_sms/{id}', 'StudentAttendanceController@route_single_student_update_attendance_sms')->name('route_single_student_update_attendance_sms');


            //monitor===

            Route::get('site-accademic-group/{classid}/{shiftid}/{yearid?}', 'StudentAttendanceController@getAccademicClassGroupByClassIdAndShiftId')->name('site-accademic-class-group-by-class-id-shift-id');
            Route::get('site-accademic-group-section/{classid}/{shiftid}/{groupid}/{yeard?}', 'StudentAttendanceController@getAccademicClassGroupSectionByClassIdAndShiftIdAndGroupId')->name('site-accademic-section-by-class-id-shift-id-group-id');
            Route::get('site-accademic-section/{classid}/{shiftid}/{yearid?}', 'StudentAttendanceController@getAccademicClassGroupSectionByClassIdAndShiftId')->name('site-accademic-section-by-class-id-shift-id');
            Route::get('get-student-list/{yearid}/{classid}/{shiftid}/{sectionid}/{groupid?}', 'StudentAttendanceController@getStudentListForBiometricIdAttachment')->name('student-list-by-class-id-shift-id-group-id-section-id');
            Route::get('get-student-biometric-id-list-for-create', 'StudentAttendanceController@getSdudentsBiometricIdList')->name('student-biometric-id-list-for-create');

            Route::get('list-by-class/{class_id}/{start_date}/{end_date}', 'StudentAttendanceController@getStudentAllAttendanceListByClass')->name('site-student-attendance-list-by-class-and-date');
            Route::get('list-by-roll-date/{year1}/{month1}/{date1}/{year2}/{month2}/{date2}/{roll}', 'StudentAttendanceController@getStudentAllAttendanceListByRollDate');
            Route::get('list-by-section-and-date/{class}/{section}/{start_date}/{end_date}', 'StudentAttendanceController@getStudentAllAttendanceListBySection')->name('site-student-attendance-list-by-section-and-date');
            //Device

            Route::post('attendance-list-by-date', 'StudentAttendanceController@getStudentDeviceAttendanceListByDate')->name('all-student-attendance-list-by-date');
            Route::post('attendance-edit', 'StudentAttendanceController@updateStudentDeviceAttendance')->name('student-attendance-edit');
            Route::post('send-sms', 'StudentAttendanceController@attendanceSms')->name('student-attendance-send-sms');
            Route::post('get-absent-students', 'StudentAttendanceController@getAbsentStudents')->name('student-attendance-get-absent-students');
            Route::post('send-absent-sms', 'StudentAttendanceController@sendAbsentSms')->name('site-student-attendance-send-absent-sms');
            Route::post('send-periodic-attendance-count-sms', 'StudentAttendanceController@sendPeriodicAttendanceCountSms')->name('site-student-attendance-send-absent-sms');
            Route::get('get-absent-details', 'StudentAttendanceController@getAbsentDetails')->name('site-student-attendance-get-absent-details');


            Route::get('get-att-setting-details', 'StudentAttendanceController@getAttendanceSettingDetails')->name('site-student-attendance-get-attendance-setting-details');
            Route::post('update-att-setting-details', 'StudentAttendanceController@updateAttendanceSettingDetails')->name('site-student-attendance-update-setting-details');

            //manual ---
            Route::get('list-by-section/{version_id}/{year_id}/{shift_id}/{dept_id}/{class_id}/{class_group_id}/{section_id}/{session_id}/{date}', 'StudentAttendanceController@getStudentListBySection')->name('student-list-by-section');
            Route::get('get-subject-by-routine-details-id-for-employee/{routine_details_id}', 'StudentAttendanceController@getSubjectByRoutineDetailsId')->name('site-student-attendance-manual-get-subject-by-routine-details-id-for-employee');


            //Report
            Route::get('report-by-subject-and-date/{version_id}/{year_id}/{shift_id}/{dept_id}/{class_id}/{class_group_id}/{section_id}/{session_id}/{routine_allocation_id}/{date}/{status}', 'AttendanceReportController@subjectAndDateWise')->name('site-student-attendance-report-get-report-by-subject-and-date-wise');
            Route::get('device-attendance-report/{date}/{type}/{version?}/{year?}/{shift?}/{dept?}/{class?}/{class_group?}/{section?}/{session?}', 'StudentAttendanceController@deviceAttendanceReport')->name('student-attendance-device-date-wise-attendance-report');


            //Student Leave

            Route::group(['prefix' => 'leave'], function () {
                Route::post('get-leave-list', 'StudentLeaveController@getLeaveList')->name('site-student-attendance-leave-get-leave-list');
                Route::post('add', 'StudentLeaveController@create')->name('site-student-attendance-leave-create');
                Route::put('update', 'StudentLeaveController@update')->name('site-student-attendance-leave-update');
                Route::delete('delete', 'StudentLeaveController@delete')->name('site-student-attendance-leave-delete');
                Route::delete('approve-cancel', 'StudentLeaveController@approveCancel')->name('site-student-attendance-leave-approve-cancel');
            });


            //report
            Route::group(['prefix' => 'report'], function () {
                Route::get('master', 'StudentAttendanceController@reportMaster')->name('site-student-attendance-report-master');
                Route::get('class-wise-report', 'AttendanceReportController@classWiseReport')->name('site-student-attendance-report-class-wise-report');

                Route::get('student-attendance-count-report', 'AttendanceReportController@studentAttendanceCountReport')->name('site-student-attendance-count-report');

                Route::get('monthly-class-wise-report', 'AttendanceReportController@monthlyClassWiseReport')->name('site-student-attendance-report-monthly-class-wise-report');
                Route::get('period-wise-report', 'AttendanceReportController@periodWiseReport')->name('site-student-attendance-report-period-wise-report');
                Route::get('period-wise-date-range-count-report', 'AttendanceReportController@periodWiseDateRangeCountReport')->name('site-student-attendance-report-period-wise-date-rage-count-report');
                Route::post('period-wise-date-range-count-details', 'AttendanceReportController@periodWiseDateRangeCountDetails')->name('site-student-attendance-report-period-wise-date-rage-count-details');
                //monitor report
                Route::post('monitor-get-daily-present-absent-leave-report', 'AttendanceReportController@getDailyAttendanceFullReport')->name('site-student-attendance-get-daily-present-absent-leave-report');

                //  Route::post('date-and-shift-wise', 'AttendanceReportController@getDateAndShiftWiseReport')->name('site-employee-attendance-report-date-and-shift');
                //  Route::post('month-and-shift-wise', 'AttendanceReportController@getMonthAndShiftWiseReport')->name('site-employee-attendance-report-month-and-shift');
                //  Route::post('employee-wise-yearly-report', 'AttendanceReportController@getYearlyReport')->name('site-employee-attendance-employee-wise-yearly-report');
            });
        });

        Route::group(['namespace' => 'Attendance', 'prefix' => 'periodic'], function () {

            Route::post('manual-get-routine-period-list-for-admin', 'PeriodicAttendanceController@getPeriodListForAdmin')->name('site-student-attendance-manual-get-routine-period-list-for-admin');
            Route::post('student-list-by-allocation', 'PeriodicAttendanceController@getStudentListByAllocation')->name('site-student-attendance-student-list-by-period-subject-for-admin');
            Route::post('save-periodic-attendance', 'PeriodicAttendanceController@savePeriodicAttendance')->name('site-student-attendance-manual-save-attendance-for-admin');
            Route::get('get-routine-period-list-by-date-for-employee', 'PeriodicAttendanceController@getPeriodListForEmployee')->name('site-student-attendance-manual-get-routine-period-list-for-employee');


            //teacher
            ///  Route::post('list-by-subject', 'PeriodicAttendanceController@getStudentListBySubject')->name('site-student-attendance-manual-get-student-list-by-subject-list-for-employee');

        });

        Route::group(['namespace' => 'IDCard', 'prefix' => 'idcard'], function () {
            Route::get('master', 'StudentIDCardController@master')->name('site-student-id-card-master');
            Route::post('get-student-for-card-order', 'StudentIDCardController@getStudentsForCardOrder')->name('site-student-id-card-get-student-for-card-order');
            Route::post('get-card-view-data', 'StudentIDCardController@getCardViewData')->name('site-student-id-card-get-card-view-data');
            Route::post('save-card-order', 'StudentIDCardController@saveCardOrder')->name('site-student-id-card-save-card-order');
            Route::post('view-pdf', 'StudentIDCardController@idCardViewPdf')->name('site-student-id-card-view-pdf');
            Route::post('Back-view-pdf', 'StudentIDCardController@idCardBackViewPdf')->name('site-student-id-card-back-view-pdf');

            Route::post('get-student-list-for-rf-id-card-code', 'RfIdCardController@getStudentListForRfIdCardCode')->name('get-student-list-for-rf-id-card-code');
            Route::post('save-update-student-rf-id-card-code', 'RfIdCardController@saveUpdateStudentRfIdCardCode')->name('save-update-student-rf-id-card-code');

            //setting
            Route::post('create-update-setting-data', 'StudentIDCardController@createUpdateIdcardSettingData')->name('create-update-site-student-id-card');
            Route::get('get-setting-data', 'StudentIDCardController@getSettingData')->name('site-student-id-card-get-setting-data');
        });


        Route::group(['namespace' => 'QuickUpdate', 'prefix' => 'quick-update'], function () {
            Route::get('site-student-quick-update-master', 'SiteStudentQuickUpdateController@index')->name('site-student-quick-update-master');
            Route::post('get-student-for-roll-registration-quick-update', 'SiteStudentQuickUpdateController@getStudentForRollRegistrationQuickUpdate')->name('get-student-for-roll-registration-quick-update');
            Route::post('quick-update-roll-registration', 'SiteStudentQuickUpdateController@quickUpdateRollRegistration')->name('quick-update-roll-registration');

            Route::post('get-student-for-personal-information-quick-update', 'SiteStudentQuickUpdateController@getStudentForPersonalInformationQuickUpdate')->name('get-student-for-personal-information-quick-update');
            Route::post('quick-update-personal-information', 'SiteStudentQuickUpdateController@quickUpdatePersonalInformation')->name('quick-update-personal-information');

            //  getStudentForAcademicSubjectQuickUpdate
            Route::post('get-student-for-contacts-quick-update', 'SiteStudentQuickUpdateController@getStudentForContactsQuickUpdate')->name('get-student-for-contacts-quick-update');
            Route::post('quick-update-contacts-information', 'SiteStudentQuickUpdateController@quickUpdateContactsInformation')->name('quick-update-contacts-information');

            Route::post('get-student-for-address-quick-update', 'SiteStudentQuickUpdateController@getStudentForAddressQuickUpdate')->name('get-student-for-address-quick-update');
            Route::post('quick-update-address-information', 'SiteStudentQuickUpdateController@quickUpdateAddressInformation')->name('quick-update-address-information');

            Route::post('get-student-for-password-change-quick-update', 'SiteStudentQuickUpdateController@getStudentForPasswordChangeQuickUpdate')->name('get-student-for-password-change-quick-update');
            //            Route::post('quick-single-student-password-change', 'SiteStudentQuickUpdateController@quickSingleStudentPasswordChange')->name('quick-single-student-password-change');
            Route::post('quick-student-password-change', 'SiteStudentQuickUpdateController@quickStudentPasswordChange')->name('quick-student-password-change');


            Route::post('get-student-for-subject-quick-update', 'SiteStudentQuickUpdateController@getStudentForSubjectQuickUpdate')->name('get-student-for-subject-quick-update');
            Route::post('quick-update-subjects-information', 'SiteStudentQuickUpdateController@quickUpdateSubjectInformation')->name('quick-update-subjects-information');

            // report test
            // Route::post('get-student-for-contact-quick-update', 'SiteStudentQuickUpdateController@quickUpdateContactInformation')->name('get-student-for-contact-quick-update');
            // Route::post('quick-update-contact-information', 'SiteStudentQuickUpdateController@quickUpdateContactInformation')->name('quick-update-contact-information');


            Route::post('get-student-for-section-quick-update', 'SiteStudentQuickUpdateController@getStudentForSectionQuickUpdate')->name('get-student-for-section-quick-update');
            Route::post('quick-update-section-information', 'SiteStudentQuickUpdateController@quickUpdateSectionInformation')->name('quick-update-section-information');


            Route::post('get-student-for-shift-group-quick-update', 'SiteStudentQuickUpdateController@getStudentForShiftGroupQuickUpdate')->name('get-student-for-shift-group-quick-update');
            Route::post('quick-update-shift-group-information', 'SiteStudentQuickUpdateController@quickUpdateShiftGroupInformation')->name('quick-update-shift-group-information');

            Route::post('set-userid-to-studentid', 'SiteStudentQuickUpdateController@setUseridToStudentid')->name('set-userid-to-studentid');


            Route::post('get-student-for-image-quick-update', 'SiteStudentQuickUpdateController@getStudentForImageQuickUpdate')->name('get-student-for-image-quick-update');
            Route::post('quick-update-single-image', 'SiteStudentQuickUpdateController@quickUpdateSingleImage')->name('quick-update-single-image');
            Route::post('quick-update-all-image', 'SiteStudentQuickUpdateController@quickUpdateAllImage')->name('quick-update-all-image');

            Route::post('get-student-for-status-quick-update', 'SiteStudentQuickUpdateController@getStudentForStatusQuickUpdate')->name('get-student-for-status-quick-update');
            Route::post('quick-update-all-status', 'SiteStudentQuickUpdateController@quickUpdateAllStatus')->name('quick-update-all-status');
        });


        Route::group(['namespace' => 'QuickInsert', 'prefix' => 'quick-insert'], function () {
            Route::post('get-blank-student-list-for-quick-insert', 'SiteStudentQuickInsertController@getBlankStudentListForQuickInsert')->name('get-blank-student-list-for-quick-insert');
            Route::post('quick-multiple-student-personal-information-insert', 'SiteStudentQuickInsertController@quickMultipleStudentPersonalInformationInsert')->name('quick-multiple-student-personal-information-insert');
            Route::post('quick-multiple-student-insert-from-excel', 'SiteStudentQuickInsertController@quickMultipleStudentInsertFromExcel')->name('quick-multiple-student-insert-from-excel');
        });


        Route::group(['namespace' => 'Manual', 'prefix' => 'manual'], function () {
            Route::get('site-student-manual-count', 'SiteStudentManualCountController@index')->name('site-student-manual-count');
            Route::post('add-manual-number-of-student', 'SiteStudentManualCountController@addManualNumberOfStudent')->name('add-manual-number-of-student');
            Route::get('get-manual-number-of-student', 'SiteStudentManualCountController@manualStudentCountList')->name('get-manual-number-of-student');
        });


        //======================promotion===============================
        Route::group(['namespace' => 'Promotion', 'prefix' => 'promotion'], function () {
            Route::get('view', 'StudentPromotionController@index')->name('student-promotion-view');
            Route::post('student-data-list', 'StudentPromotionController@getStudentResultFeeDataList')->name('student-data-list-for-promotion');
            Route::post('student-promotion', 'StudentPromotionController@studentPromotion')->name('student-promotion');
            Route::post('student-promotion-cancel', 'StudentPromotionController@studentPromotionCancel')->name('student-promotion-cancel');
            Route::post('section-list', 'StudentPromotionController@getAllClassSection')->name('student-class-section-list-for-promotion');
            Route::post('student-history-data-list', 'StudentPromotionController@getAllStudentList')->name('student-history-data-list-for-promotion');
            Route::post('student-section-assign', 'StudentPromotionController@studentSectionAssign')->name('student-section-assign');
        });

        //======================transfer cerficate===============================
        Route::group(['namespace' => 'TC', 'prefix' => 'tc'], function () {
            Route::get('tc-master-form', 'StudentTCController@index')->name('get-site-student-tc-master-form');
            Route::post('tc-data-list', 'StudentTCController@getTCDataList')->name('tc-data-list');
            //   Route::get('tc-setting-list', 'StudentTCController@getTcSettingList')->name('tc-setting-list');
            Route::get('get-tc-setting-data', 'StudentTCController@getTcSettingData')->name('get-tc-setting-data');
            Route::post('create-update-tc-setting', 'StudentTCController@createUpdateTCSetting')->name('create-update-site-student-tc-setting');
            Route::post('get-student-tc-setup', 'StudentTCController@getStudentTCSetup')->name('get-site-student-tc-setup');
            Route::post('create-update-site-student-tc', 'StudentTCController@createUpdateStudentTC')->name('create-update-site-student-tc');
            Route::post('delete-site-student-tc', 'StudentTCController@deleteStudentTC')->name('delete-site-student-tc');
            Route::post('get-student-result', 'StudentTCController@getStudentResult')->name('get-student-result');
            Route::post('download-pdf-student-tc', 'StudentTCController@TCPdfDownload')->name('download-pdf-student-tc');

            // Route::post('edit-tc-setting', 'StudentTCController@updateTcSetting')->name('edit-tc-setting');
            // Route::post('delete-tc-setting', 'StudentTCController@updateTcSetting')->name('delete-tc-setting');
            // Route::post('get-student-list-for-tc-application', 'StudentTCController@getStudentListForTcApplication')->name('get-student-list-for-tc-application');

        });

        Route::group(['namespace' => 'attestation', 'prefix' => 'attestation'], function () {
            Route::get('attestation-master-form', 'StudentAttestationController@index')->name('get-site-student-attestation-master-form');

            Route::post('attestation-data-list', 'StudentAttestationController@getAttestationDataList')->name('attestation-data-list');
            Route::post('download-pdf-student-attestation', 'StudentAttestationController@downloadStudentPdfAttestation')->name('download-pdf-student-attestation');
        });


        Route::group(['namespace' => 'Report', 'prefix' => 'report'], function () {
            Route::get('master', 'StudentReportController@reportMaster')->name('site-student-report-master');
            Route::post('get-student-list', 'StudentReportController@getStudents')->name('site-student-report-get-student-list');
            Route::post('get-student-list-for-excel-shit', 'StudentReportController@getStudentsForExcelShit')->name('site-student-report-get-student-list-for-excel-shit');
            Route::get('get-tot-list', 'StudentReportController@getTotListPdf')->name('site-student-report-get-tot-list');
            Route::get('get-tot-list-second', 'StudentReportController@getTotListSecondPdf')->name('site-student-report-get-tot-list-second');
            Route::get('get-evaluation-list', 'StudentReportController@getEvaluationPdf')->name('site-student-report-get-evaluation-list');
            Route::get('details-pdf', 'StudentReportController@detailsPdfReport')->name('site-student-report-details-pdf-report');
            Route::get('get-routine-pdf', 'StudentReportController@getRoutinePdf')->name('site-student-routine-get-routine-details-pdf-report');


            Route::post('get-site-base-student-statistics', 'StudentReportController@getSiteBaseStudentStatistics')->name('get-site-base-student-statistics');
            Route::post('get-site-base-student-statistics-pdf', 'StudentReportController@getSiteBaseStudentStatisticsPdf')->name('get-site-base-student-statistics-pdf');
            Route::post('get-site-base-student-attendance-statistics-count', 'StudentReportController@getSiteBaseStudentAttendanceStatisticsCount')->name('get-site-base-student-attendance-statistics-count');
        });
    });

    Route::group(['namespace' => 'Guardian', 'prefix' => 'guardian'], function () {
        Route::get('list', ['as' => 'guardian-list', 'uses' => 'GuardiansController@index']);
        Route::get('guardian-by-id/{id}', ['as' => 'guardian-image-by-id', 'uses' => 'GuardiansController@getGuardianImageByID']);
        Route::get('add', 'GuardiansController@createGuardianForm')->name('guardian-add-form');
        Route::post('add', ['as' => 'guardian-create', 'uses' => 'GuardiansController@createGuardian']);
        Route::get('edit/{id}', ['as' => 'guardian-edit-form', 'uses' => 'GuardiansController@editGuardianForm']);
        Route::patch('edit/{id}', ['as' => 'guardian-edit', 'uses' => 'GuardiansController@editGuardian']);
        Route::get('view/{id}', ['as' => 'guardian-view', 'uses' => 'GuardiansController@viewGuardian']);
        Route::get('delete/{id}', ['as' => 'guardian-delete', 'uses' => 'GuardiansController@deleteGuardian']);

        Route::get('get-guardian-list', 'GuardianController@getGuardianList')->name('site-guardian-get-guardian-list');
    });

    //notice

    Route::group(['namespace' => 'Notice', 'prefix' => 'notice'], function () {

        Route::get('edit/{id?}', 'NoticesController@index')->name('site-notice-◘master-view');
        Route::get('master', 'NoticesController@index')->name('site-notice-master-view');

        Route::post('add', 'NoticesController@createNotice')->name('site-notice-create');
        Route::post('update', 'NoticesController@updateNotice')->name('site-notice-update');
        Route::get('get-notice-details/{id}', 'NoticesController@getNoticeDetails')->name('site-notice-get-notice-details');
        Route::get('notice-list-with-pagination', 'NoticesController@getNoticeListWithPagination')->name('site-notice-list-with-pagination');
        Route::post('send-notice-to-student', 'NoticesController@sendNoticeToStudent')->name('site-notice-send-notice-to-student');
        Route::post('send-notice-to-guardian', 'NoticesController@sendNoticeToGuardian')->name('site-notice-send-notice-to-guardian');
        Route::post('send-notice-to-employee', 'NoticesController@sendNoticeToEmployee')->name('site-notice-send-notice-to-employee');
        Route::post('delete/{id}', 'NoticesController@deleteNotice')->name('site-notice-delete');

        Route::post('notification-delete/{id}', 'NoticesController@deleteNoticeFromNotification')->name('site-notification-delete-for-view-all-page');
    });

    //Live streaming

    Route::group(['namespace' => 'Live', 'prefix' => 'live'], function () {


        Route::group(['prefix' => 'setting'], function () {
            Route::get('get-setting', 'SettingController@getSetting')->name('site-live-get-setting');
            Route::post('add-update', 'SettingController@create')->name('site-live-setting-create');
        });
        Route::group(['prefix' => 'meeting'], function () {
            Route::get('invitation/{id?}', 'MeetingController@index')->name('site-live-meeting-index');
            Route::get('routine-invitation/{id?}', 'MeetingController@index')->name('site-live-meeting-index');
            Route::get('list', 'MeetingController@index')->name('site-live-meeting-index');

            Route::post('get-user-invitation', 'MeetingController@getInvitationList')->name('site-live-meeting-get-user-invitation');
            Route::post('get-user-to-invite', 'MeetingController@getUserToInvite')->name('site-live-meeting-get-user-to-invite');
            Route::post('save-user-activity', 'MeetingController@saveUserActivity')->name('site-live-meeting-save-user-activity');


            Route::post('send-meeting-invitation-to-user', 'MeetingController@sendMeetingToUser')->name('site-live-meeting-send-meeting-invitation-to-user');
            Route::post('send-meeting-invitation-to-routine-allocation', 'MeetingController@sendMeetingToRoutine')->name('site-live-meeting-send-meeting-invitation-to-routine-allocation');


            Route::get('get-zoom-meeting-list', 'MeetingController@getZoomMeetingList')->name('site-live-meeting-get-zoom-meeting-list');
            Route::post('create-zoom-meeting', 'MeetingController@createZoomMeeting')->name('site-live-meeting-create-zoom-meeting');
            Route::get('get-zoom-meeting/{id}', 'MeetingController@getZoomMeeting')->name('site-live-meeting-get-zoom-meeting');
            Route::get('get-the-meeting/{id}', 'MeetingController@getMeetingDetails')->name('site-live-meeting-get-meeting-details');
            Route::get('delete-zoom-meeting/{id}', 'MeetingController@zoomMeetingDelete')->name('site-live-meeting-delete-zoom-meeting');
        });
    });


    Route::group(['namespace' => 'Message', 'prefix' => 'message'], function () {


        Route::post('add', 'MessageController@createMessage')->name('site-message-create');
        Route::get('inbox', 'MessageController@messageInbox')->name('site-message-inbox');
        Route::get('message-list-with-pagination', 'MessageController@getMessageListWithPagination')->name('site-message-list-with-pagination');
        Route::get('sent-message-list-with-pagination', 'MessageController@getSentMessageListWithPagination')->name('site-sent-message-list-with-pagination');
        Route::post('delete/{id}', 'MessageController@softDeleteMessage')->name('site-message-soft-delete');
        Route::get('trash-message-list-with-pagination', 'MessageController@getTrashMessageListWithPagination')->name('site-trash-message-list-with-pagination');
        Route::get('view/{id}', 'MessageController@viewMessage')->name('site-message-view');
        Route::post('permanent-delete/{id}', 'MessageController@permanentDeleteMessage')->name('site-message-permanent-delete');
        Route::post('delete-sent-message/{id}', 'MessageController@sentmessageDelete')->name('site-message-delete-sent-message');


        //Route::get('inbox', ['as'=>'message-inbox','uses'=>'NoticesController@messageInbox']);
        // Route::get('trash', ['as'=>'message-trash','uses'=>'NoticesController@messageTrash']);
        // Route::get('trash-view/{id}', ['as'=>'message-trash-view','uses'=>'NoticesController@viewTrashMessage']);
        // Route::get('edit/{id}', ['as'=>'message-edit-form','uses'=>'NoticesController@getMessageEditForm']);
        // Route::patch('edit/{id}', ['as'=>'message-edit','uses'=>'NoticesController@editMessage']);
        // Route::get('delete/{id}', ['as'=>'message-delete','uses'=>'NoticesController@deleteMessage']);
    });

    Route::group(['namespace' => 'Sms', 'prefix' => 'sms'], function () {

        Route::get('master', 'SmsController@index')->name('site-communication-sms-master-view');

        Route::post('add', 'SmsController@createSms')->name('site-communication-sms-create');
        Route::put('update', 'SmsController@update')->name('site-communication-sms-update');


        //   Route::get('get-sms-details', 'SmsController@getDetails')->name('site-communication-sms-get-sms-details');
        Route::post('get-list-student-contact-list', 'StudentController@getStudentListContractList')->name('get-list-student-contact-list');
        Route::post('get-guardians-contact-list', 'GurardiansController@getGuardiansContractList')->name('get-guardians-contact-list');

        Route::get('get-list-with-pagination', 'SmsController@getListWithPagination')->name('site-communication-sms-list-with-pagination');
        Route::post('send-sms-to-student', 'SmsController@sendToStudent')->name('site-communication-sms-send-sms-to-student');
        Route::post('send-sms-to-guardian', 'SmsController@sendToGuardian')->name('site-communication-sms-send-sms-to-guardian');
        Route::post('send-sms-to-employee', 'SmsController@sendToEmployee')->name('site-communication-sms-send-sms-to-employee');
        Route::get('delete/{id}', 'SmsController@delete')->name('site-communication-sms-delete');

        // contact setting for student sms
        Route::post('get-studnt-list-for-sms-contact-setting', 'SmsController@studentListForSmsSetting')->name('get-studnt-list-for-sms-contact-setting');
        Route::post('save-contact-for-sms-setting', 'SmsController@saveContactSettingForSms')->name('save-contact-for-sms-setting');

        //phone book group


        //Phone Book

        Route::post('phone-book-group-name-list', 'PhoneBookController@phoneBookGroupNameList')->name('phone-book-group-name-list');
        Route::get('get-phone-book-list', 'PhoneBookController@getPhoneBookList')->name('site-communication-sms-phone-book-list');
        Route::post('phone-book-add', 'PhoneBookController@create')->name('site-communication-sms-phone-book-create');
        Route::put('phone-book-update', 'PhoneBookController@update')->name('site-communication-sms-phone-book-update');
        Route::delete('phone-book-delete', 'PhoneBookController@delete')->name('site-communication-sms-phone-book-delete');
        Route::post('phone-book-excel-upload', 'PhoneBookController@excelUpload')->name('site-communication-sms-phone-book-excel');

        //Sms campaign
        Route::group(['prefix' => 'campaign'], function () {
            /*
                    Route::post('add', 'SmsCampaignController@createCampaign')->name('site-communication-sms-campaign-create');
                    Route::put('update', 'SmsCampaignController@updateCampaign')->name('site-communication-sms-campaign-update');*/


            // Route::get('get-sms-campaign-details', 'SmsCampaignController@getDetails')->name('site-communication-sms-get-sms-campaign-details');
            //  Route::get('get-list-with-pagination', 'SmsCampaignController@getListWithPagination')->name('site-communication-sms-campaign-list-with-pagination');
            Route::post('send-to-numbers', 'SmsCampaignController@sendToNumbers')->name('site-communication-sms-campaign-send-to-numbers');
            Route::post('send-sms-using-phone-book', 'SmsCampaignController@sendUsingPhoneBook')->name('site-communication-sms-campaign-send-using-phone-book');
            Route::post('resend-failed-sms', 'SmsCampaignController@resendFailedSms')->name('site-communication-sms-resend-failed-sms');
            //  Route::get('delete/{id}', 'SmsCampaignController@delete')->name('site-communication-sms-campaign-delete');


        });
    });
});

Route::group(['namespace' => 'Settings', 'prefix' => 'site-setting'], function () {
    Route::get('list/{id?}', ['as' => 'site-setting-list', 'uses' => 'SettingController@index']);
    Route::get('add', ['as' => 'site-setting-add-form', 'uses' => 'SettingController@index']);
    Route::post('add', ['as' => 'site-setting-create', 'uses' => 'SettingController@createSiteSetting']);
    Route::get('view/{id}', ['as' => 'site-setting-view', 'uses' => 'SettingController@viewSiteSetting']);
    Route::get('edit/{id}', ['as' => 'site-setting-edit-form', 'uses' => 'SettingController@getSiteSettingEditForm']);
    Route::patch('edit/{id}', ['as' => 'site-setting-edit', 'uses' => 'SettingController@editSiteSetting']);
    Route::get('delete/{id}', ['as' => 'site-setting-delete', 'uses' => 'SettingController@deleteSiteSetting']);
});


Route::group(['namespace' => 'Settings', 'prefix' => 'settings'], function () {
    Route::get('view', ['as' => 'settings-view', 'uses' => 'SettingController@doSettings']);
});

Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {
    Route::group(['namespace' => 'Calendar', 'prefix' => 'calendar'], function () {
        Route::get('index', 'CalendarController@index')->name('calendar-index');
        Route::get('monthly-view', 'CalendarController@monthlyView')->name('calendar-monthly-view');
        Route::get('yearly-view', 'CalendarController@yearlyView')->name('calendar-yearly-view');
        Route::get('list-view', 'CalendarController@listView')->name('calendar-list-view');
        Route::get('calendar-list/{monthIncrement?}', 'CalendarController@getCalendarList')->name('get-calendar-list');
        Route::get('calendar-list-2/{monthIncrement?}', 'CalendarController@getCalendarList')->name('get-calendar-list-for-student');
        Route::get('calendar-title-list/{headId?}', 'CalendarController@getCalendarTitleList')->name('get-calendar-title-list-by-head-id');
        Route::get('yearly-calendar-list/{academic_year?}', 'CalendarController@getYearlyCalendarList')->name('get-yearly-calendar-list');
        Route::get('yearly-calendar-list-2/{academic_year?}', 'CalendarController@getYearlyCalendarList')->name('get-yearly-calendar-list-for-student');
        Route::get('calendar-subhead-color-list/{acSubHeadId?}', 'CalendarController@getCalendarSubHeadColorList')->name('get-calendar-sub-head-color-list');
    });

    Route::group(['namespace' => 'Employee', 'prefix' => 'employee'], function () {
        Route::group(['namespace' => 'TeacherAssignToClass', 'prefix' => 'teacher-assign-to-class-section'], function () {
            Route::get('index', 'TeacherAssignToClassSectionController@index')->name('teacher-assign-to-class-section-index');
            Route::post('teacher-list', 'TeacherAssignToClassSectionController@getTeacherList')->name('teacher-list-for-teacher-assign-to-class-section');
            Route::post('class-section-list', 'TeacherAssignToClassSectionController@getClassSectionList')->name('class-section-list-for-teacher-assign-to-class-section');
            Route::post('add', 'TeacherAssignToClassSectionController@assignTeacherToClassSection')->name('teacher-assign-to-class-section-add');
            Route::get('list', 'TeacherAssignToClassSectionController@assignTeacherToClassSectionList')->name('teacher-assign-to-class-list');
        });
        Route::group(['namespace' => 'TeacherAssignToClass', 'prefix' => 'student-assing-to-teacher'], function () {
            Route::get('get-student-list', 'TeacherAssignToClassSectionController@getStudentList')->name('get-student-list-for-assign-to-teacher');
            Route::post('add', 'TeacherAssignToClassSectionController@assignStudentToTeacher')->name('add-for-assign-to-teacher');
            Route::post('assign-details', 'TeacherAssignToClassSectionController@assignDetails')->name('details-for-assign-to-teacher');
        });
    });
});






/*
Route::fallback(function() {
    return 'Hm, why did you land here somehow?';
});*/

//site-site-group-membership-country-list
