<?php

/**
 * Created by PhpStorm.
 * User: raja
 * Date: 4/17/16
 * Time: 10:54 AM
 */


Route::group(['namespace' => 'User', 'prefix' => 'user'], function () {


    Route::get('profile', 'UsersController@profilePage')->name('employee-profile');
    Route::get('my-invitation', 'UsersController@myInvitation')->name('user-my-invitation');
    Route::post('/change-profile', 'UsersController@changePassword')->name('change-user-password');
    Route::post('/update-user-profile', 'UsersController@updateProfile')->name('change-user-profile');

    Route::group(['prefix' => 'notification'], function () {


        Route::post('/notifications', 'UsersController@getNotifications')->name('user-notification-get-notifications');


        Route::get('all', 'UsersController@viewAllNotice')->name('site-notice-view-all');
        Route::get('notice-list-with-pagination-for-view-all-page', 'UsersController@getNoticeListWithPaginationForViewAllPage')->name('site-notice-list-with-pagination-for-view-all-page');
        Route::get('view/{id}', 'UsersController@viewNotification')->name('site-notice-view');
        Route::get('leave-approve/{id}', 'UsersController@viewEmpLeaveNotification')->name('site-emp-leave-notification-view');
        Route::get('leave-application/{id}', 'UsersController@viewEmpLeaveApplicationNotification')->name('site-emp-leave-application-notification-view');
    });
});


Route::group(['namespace' => 'Holiday', 'prefix' => 'holiday-type'], function () {
    Route::get('edit-form/{id}', ['as' => 'edit-holidaytype-form', 'uses' => 'HolydayController@editHolidayTypeForm']);
    Route::patch('edit/{id}', ['as' => 'edit-holidaytype', 'uses' => 'HolydayController@editHolidayType']);
    Route::get('view/{id}', ['as' => 'view-holidaytype', 'uses' => 'HolydayController@viewHolidayType']);
    Route::get('delete/{id}', ['as' => 'delete-holidaytype', 'uses' => 'HolydayController@deleteHolidayType']);
});
Route::group(['namespace' => 'Holiday', 'prefix' => 'holyday'], function () {
    Route::get('edit-form/{id}', ['as' => 'edit-holiday-form', 'uses' => 'HolydayController@editHolidayForm']);
    Route::patch('edit/{id}', ['as' => 'edit-holiday', 'uses' => 'HolydayController@editHoliday']);
    Route::get('view/{id}', ['as' => 'view-holiday', 'uses' => 'HolydayController@viewHoliday']);
    Route::get('delete/{id}', ['as' => 'delete-holiday', 'uses' => 'HolydayController@deleteHoliday']);
});

Route::group(['namespace' => 'Status', 'prefix' => 'status'], function () {
    Route::get('edit-form/{id}', ['as' => 'edit-status-form', 'uses' => 'StatusController@editStatusForm']);
    Route::patch('edit/{id}', ['as' => 'edit-status', 'uses' => 'StatusController@editStatus']);
});

Route::group(['namespace' => 'Teacher', 'prefix' => 'teacher'], function () {
    Route::get('list', ['as' => 'teacher-list', 'uses' => 'TeachersController@index']);
    Route::get('add', ['as' => 'teacher-add-form', 'uses' => 'TeachersController@createTeacherForm']);
    Route::post('add', ['as' => 'teacher-create', 'uses' => 'TeachersController@createTeacher']);
    Route::get('edit/{id}', ['as' => 'teacher-edit-form', 'uses' => 'TeachersController@editTeacherForm']);
    Route::patch('edit/{id}', ['as' => 'teacher-edit', 'uses' => 'TeachersController@editTeacher']);
    Route::get('view/{id}', ['as' => 'teacher-view', 'uses' => 'TeachersController@viewTeacher']);
    Route::get('delete/{id}', ['as' => 'teacher-delete', 'uses' => 'TeachersController@deleteTeacher']);
});


Route::group(['namespace' => 'AcademicAll', 'prefix' => 'student-class'], function () {


    Route::get('add', 'AcademicClassController@createClassForm')->name('class-add-form');
    Route::post('add', ['as' => 'class-create', 'uses' => 'AcademicClassController@createClass']);
    Route::get('list', ['as' => 'class-list', 'uses' => 'AcademicClassController@index']);
    Route::get('edit/{id}', ['as' => 'class-edit-form', 'uses' => 'AcademicClassController@editClassForm']);
    Route::patch('edit/{id}', ['as' => 'class-edit', 'uses' => 'AcademicClassController@editClass']);
    Route::get('delete/{id}', ['as' => 'class-delete', 'uses' => 'AcademicClassController@deleteClass']);
    Route::get('{classId}', ['as' => 'class-section', 'uses' => 'AcademicClassController@sectionOfClass']);


});


Route::group(['namespace' => 'Subject', 'prefix' => 'subject'], function () {
    Route::get('add', ['as' => 'subject-add-form', 'uses' => 'SubjectController@createSubjectForm']);
    Route::post('add', ['as' => 'subject-create', 'uses' => 'SubjectController@createSubject']);
    Route::get('list', ['as' => 'subject-list', 'uses' => 'SubjectController@index']);
    Route::get('view/{id}', ['as' => 'subject-view', 'uses' => 'SubjectController@viewSubject']);
    Route::get('edit/{id}', ['as' => 'subject-edit-form', 'uses' => 'SubjectController@getSubjectEditForm']);
    Route::patch('edit/{id}', ['as' => 'subject-edit', 'uses' => 'SubjectController@editSubject']);
    Route::get('delete/{id}', ['as' => 'subject-delete', 'uses' => 'SubjectController@deleteSubject']);
});

Route::group(['namespace' => 'SubjectGroup', 'prefix' => 'subject-group'], function () {
    Route::get('add', ['as' => 'subject-group-add-form', 'uses' => 'SubjectGroupController@createSubjectGroupForm']);
    Route::post('add', ['as' => 'subject-group-create', 'uses' => 'SubjectGroupController@createSubjectGroup']);
    Route::get('list', ['as' => 'subject-group-list', 'uses' => 'SubjectGroupController@index']);
    Route::get('view/{id}', ['as' => 'subject-group-view', 'uses' => 'SubjectGroupController@viewSubjectGroup']);
    Route::get('edit/{id}', ['as' => 'subject-group-edit-form', 'uses' => 'SubjectGroupController@getSubjectGroupEditForm']);
    Route::patch('edit/{id}', ['as' => 'subject-group-edit', 'uses' => 'SubjectGroupController@editSubjectGroup']);
    Route::get('delete/{id}', ['as' => 'subject-group-delete', 'uses' => 'SubjectGroupController@deleteSubjectGroup']);
    Route::get('subject-class', ['as' => 'subject-class', 'uses' => 'SubjectGroupController@getSubjectTableByClass']);
    Route::get('subject-class-edit', ['as' => 'subject-class-edit', 'uses' => 'SubjectGroupController@getSubjectTableByClassAndSubjectGroup']);
});

Route::group(['namespace' => 'Building', 'prefix' => 'building'], function () {

    Route::get('building-floor-room-form', 'BuildingController@index')->name('building-floor-room-form');
    Route::get('list', 'BuildingController@getBuildingList')->name('building-list');
    Route::post('add', 'BuildingController@createBuilding')->name('building-create');
    Route::post('edit', 'BuildingController@editBuilding')->name('building-edit');
    Route::post('delete', 'BuildingController@deleteBuilding')->name('building-delete');


//    Route::get('add', ['as' => 'building-add-form', 'uses' => 'BuildingController@createBuildingForm']);
//    Route::get('edit/{id}', ['as' => 'building-edit-form', 'uses' => 'BuildingController@getBuildingEditForm']);
});


Route::group(['namespace' => 'Floor', 'prefix' => 'floor'], function () {

    Route::get('view', 'FloorController@index')->name('floor-view-page');
    Route::post('list', 'FloorController@getFloorList')->name('floor-list');
    Route::post('add', 'FloorController@createFloor')->name('floor-create');
    Route::post('edit', 'FloorController@editFloor')->name('floor-edit');
    Route::post('delete', 'FloorController@deleteFloor')->name('floor-delete');


//    Route::get('add', ['as' => 'floor-add-form', 'uses' => 'FloorController@createFloorForm']);
//    Route::get('edit/{id}', ['as' => 'floor-edit-form', 'uses' => 'FloorController@getFloorEditForm']);
    Route::get('{buildId}', ['as' => 'floor-build', 'uses' => 'FloorController@floorOfBuilding']);
});

Route::group(['namespace' => 'Room', 'prefix' => 'room'], function () {

    Route::get('view', 'RoomController@index')->name('room-view-page');
    Route::post('list', 'RoomController@getRoomList')->name('room-list');
    Route::post('add', 'RoomController@createRoom')->name('room-create');
    Route::post('edit', 'RoomController@editRoom')->name('room-edit');
    Route::post('delete', 'RoomController@deleteRoom')->name('room-delete');


//    Route::get('add', ['as' => 'room-add-form', 'uses' => 'RoomController@createRoomForm']);
//    Route::get('edit/{id}', ['as' => 'room-edit-form', 'uses' => 'RoomController@getRoomEditForm']);
    Route::get('get-room-by-floor/{floorId}', ['as' => 'room-floor', 'uses' => 'RoomController@roomOfFloor']);

    Route::get('get-room-list-with-building-and-floor-appended', 'RoomController@getRoomListWithBuildingAndFloorAppended')->name('site-room-get-room-list-with-building-and-floor-appended');

});


Route::group(['namespace' => 'Examination', 'prefix' => 'examination'], function () {
    Route::get('add', ['as' => 'examination-add-form', 'uses' => 'ExaminationController@createExaminationForm']);
    Route::post('add', ['as' => 'examination-create', 'uses' => 'ExaminationController@createExamination']);
    Route::get('list', ['as' => 'examination-list', 'uses' => 'ExaminationController@index']);
    Route::get('view/{id}', ['as' => 'examination-view', 'uses' => 'ExaminationController@viewExamination']);
    Route::get('edit/{id}', ['as' => 'examination-edit-form', 'uses' => 'ExaminationController@getExaminationEditForm']);
    Route::patch('edit/{id}', ['as' => 'examination-edit', 'uses' => 'ExaminationController@editExamination']);
    Route::get('delete/{id}', ['as' => 'examination-delete', 'uses' => 'ExaminationController@deleteExamination']);
});

Route::group(['namespace' => 'Examination', 'prefix' => 'examination-schedule'], function () {
    Route::get('add', ['as' => 'examinationSchedule-add-form', 'uses' => 'ExaminationController@createExaminationScheduleForm']);
    Route::post('add', ['as' => 'examinationSchedule-create', 'uses' => 'ExaminationController@createExaminationSchedule']);

    Route::get('list', ['as' => 'examinationSchedule-list', 'uses' => 'ExaminationController@examinationScheduleList']);
    Route::get('view/{id}', ['as' => 'examinationSchedule-view', 'uses' => 'ExaminationController@viewExaminationSchedule']);
    Route::get('edit/{id}', ['as' => 'examinationSchedule-edit-form', 'uses' => 'ExaminationController@getExaminationScheduleEditForm']);
    Route::patch('edit/{id}', ['as' => 'examinationSchedule-edit', 'uses' => 'ExaminationController@editExaminationSchedule']);
    Route::get('delete/{id}', ['as' => 'examinationSchedule-delete', 'uses' => 'ExaminationController@deleteExaminationSchedule']);
});

Route::group(['namespace' => 'Country', 'prefix' => 'country'], function () {

    Route::get('view', 'CountryController@index')->name('country-view-page');
    Route::post('add', 'CountryController@createCountry')->name('country-create');
    Route::post('edit/{id}', 'CountryController@editCountry')->name('country-edit');
    Route::delete('delete/{id}', 'CountryController@deleteCountry')->name('country-delete');
    Route::get('get-site-base-country-list/{id}', 'CountryController@SiteBaseCountryList')->name('get-site-base-country-list');
    Route::get('get-country-list', 'CountryController@getCountryList')->name('country-get-country-list');
    Route::post('get-country-list-pagination', 'CountryController@getCountryListPagination')->name('country-get-country-list-pagination');
});

Route::group(['namespace' => 'Division', 'prefix' => 'division'], function () {
    Route::get('view', 'DivisionController@index')->name('division-view-page');
    Route::post('get-division-list-pagination', 'DivisionController@getDivisionListPagination')->name('division-list-pagination');
    Route::get('get-division-list', 'DivisionController@getDivisionList')->name('division-list');
    Route::get('get-division-list/{country_id}', 'DivisionController@getDivisionListByCountryID')->name('division-list-by-country-id');
//    Route::get('list-by-country-id/{id}', 'DivisionController@getDivisionByCountryId')->name('division-get-division-list-by-country-id');
    Route::post('add', 'DivisionController@createDivision')->name('division-create');
    Route::post('edit/{id}', 'DivisionController@editDivision')->name('division-edit');
    Route::delete('delete/{id}', 'DivisionController@deleteDivision')->name('division-delete');
});

Route::group(['namespace' => 'District', 'prefix' => 'district'], function () {
    Route::get('view', ['as' => 'district-view-page', 'uses' => 'DistrictController@index']);
    Route::get('get-district-list', ['as' => 'district-list', 'uses' => 'DistrictController@getDistrictList']);
    Route::post('get-district-list-pagination', ['as' => 'district-list-pagination', 'uses' => 'DistrictController@getDistrictListPagination']);
    Route::get('get-district-list/{division_id}', 'DistrictController@getDistrictByDivisionId')->name('district-get-district-list-by-division-id');
//    Route::get('list-by-division-id/{id}', 'DistrictController@getDistrictByDivisionId')->name('division-get-district-list-by-division-id');
    Route::get('add/{id?}', 'DistrictController@createDistrictForm')->name('district-add-form');
    Route::post('add', 'DistrictController@createDistrict')->name('district-create');
    Route::post('edit/{id}', 'DistrictController@editDistrict')->name('district-edit');
    Route::delete('delete/{id}', 'DistrictController@deleteDistrict')->name('district-delete');
});

Route::group(['namespace' => 'Thana', 'prefix' => 'thana'], function () {
    Route::get('view', ['as' => 'thana-view-page', 'uses' => 'ThanaController@index']);
    Route::get('get-thana-list', ['as' => 'thana-list', 'uses' => 'ThanaController@getThanaList']);
    Route::post('get-thana-list-pagination', ['as' => 'thana-list-pagination', 'uses' => 'ThanaController@getThanaListPagination']);
    Route::get('get-thana-list/{district_id}', 'ThanaController@getThanaByDistrictId')->name('thana-get-thana-list-by-district-id');
    Route::post('add', 'ThanaController@createThana')->name('thana-create');
    Route::post('edit/{id}', 'ThanaController@editThana')->name('thana-edit');
    Route::delete('delete/{id}', 'ThanaController@deleteThana')->name('thana-delete');
});


Route::group(['namespace' => 'Student', 'prefix' => 'report'], function () {
    Route::get('student-id-card', ['as' => 'report-student-id-card', 'uses' => 'StudentController@idCardPage']);
    Route::get('student-admit-card', ['as' => 'report-student-admit-card', 'uses' => 'StudentController@admitCardPage']);
    Route::get('testimonial', ['as' => 'report-testimonial', 'uses' => 'StudentController@testimonialPage']);
    Route::get('tc', ['as' => 'report-tc', 'uses' => 'StudentController@tcPage']);
    Route::get('clearance', ['as' => 'report-clearance', 'uses' => 'StudentController@clearancePage']);
    Route::get('certification', ['as' => 'report-certification', 'uses' => 'StudentController@certificationPage']);
    Route::get('{sectionId}', ['as' => 'report-section', 'uses' => 'StudentController@studentOfSection']);
    Route::get('student-id-card-report/{studentClassId}/{sectionId}/{studentId}', ['as' => 'student-id-card-details', 'uses' => 'StudentController@studentIdCard']);
    Route::get('student-admit-card-report/{examinationId}/{studentClassId}/{sectionId}/{studentId}', ['as' => 'student-admit-card-details', 'uses' => 'StudentController@studentAdmitCard']);
    Route::get('testimonial-report/{studentClassId}/{sectionId}/{studentId}', ['as' => 'testimonial-details', 'uses' => 'StudentController@studentTestimonial']);
    Route::get('tc-report/{applicationSubject}/{studentClassId}/{sectionId}/{studentId}', ['as' => 'tc-details', 'uses' => 'StudentController@studentTc']);
    Route::get('clearance-report/{studentClassId}/{sectionId}/{studentId}', ['as' => 'clearance-details', 'uses' => 'StudentController@studentClearance']);
    Route::get('certification-report/{studentClassId}/{sectionId}/{studentId}', ['as' => 'certification-details', 'uses' => 'StudentController@studentCertification']);
});


Route::group(['namespace' => 'AccountType', 'prefix' => 'account-type'], function () {
    Route::get('list', ['as' => 'account-type-list', 'uses' => 'AccountTypeController@index']);
    Route::get('add', ['as' => 'account-type-add-form', 'uses' => 'AccountTypeController@createAccountTypeForm']);
    Route::post('add', ['as' => 'account-type-create', 'uses' => 'AccountTypeController@createAccountType']);
    Route::get('view/{id}', ['as' => 'account-type-view', 'uses' => 'AccountTypeController@viewAccountType']);
    Route::get('edit/{id}', ['as' => 'account-type-edit-form', 'uses' => 'AccountTypeController@getAccountTypeEditForm']);
    Route::patch('edit/{id}', ['as' => 'account-type-edit', 'uses' => 'AccountTypeController@editAccountType']);
    Route::get('delete/{id}', ['as' => 'account-type-delete', 'uses' => 'AccountTypeController@deleteAccountType']);
});

Route::group(['namespace' => 'AmountType', 'prefix' => 'amount-type'], function () {
    Route::get('list', ['as' => 'amount-type-list', 'uses' => 'AmountTypeController@index']);
    Route::get('add', ['as' => 'amount-type-add-form', 'uses' => 'AmountTypeController@createAmountTypeForm']);
    Route::post('add', ['as' => 'amount-type-create', 'uses' => 'AmountTypeController@createAmountType']);
    Route::get('edit/{id}', ['as' => 'amount-type-edit-form', 'uses' => 'AmountTypeController@getAmountTypeEditForm']);
    Route::patch('edit/{id}', ['as' => 'amount-type-edit', 'uses' => 'AmountTypeController@editAmountType']);
    Route::get('delete/{id}', ['as' => 'amount-type-delete', 'uses' => 'AmountTypeController@deleteAmountType']);
});

Route::group(['namespace' => 'AmountCategory', 'prefix' => 'amount-category'], function () {
    Route::get('list', ['as' => 'amount-category-list', 'uses' => 'AmountCategoryController@index']);
    Route::get('add', ['as' => 'amount-category-add-form', 'uses' => 'AmountCategoryController@createAmountCategoryForm']);
    Route::post('add', ['as' => 'amount-category-create', 'uses' => 'AmountCategoryController@createAmountCategory']);
    Route::get('edit/{id}', ['as' => 'amount-category-edit-form', 'uses' => 'AmountCategoryController@getAmountCategoryEditForm']);
    Route::patch('edit/{id}', ['as' => 'amount-category-edit', 'uses' => 'AmountCategoryController@editAmountCategory']);
    Route::get('delete/{id}', ['as' => 'amount-category-delete', 'uses' => 'AmountCategoryController@deleteAmountCategory']);
});

Route::group(['namespace' => 'Account', 'prefix' => 'account'], function () {
    Route::get('list', ['as' => 'account-list', 'uses' => 'AccountController@index']);
    Route::get('add', ['as' => 'account-add-form', 'uses' => 'AccountController@createAccountForm']);
    Route::post('add', ['as' => 'account-create', 'uses' => 'AccountController@createAccount']);
    Route::get('edit/{id}', ['as' => 'account-edit-form', 'uses' => 'AccountController@getAccountEditForm']);
    Route::patch('edit/{id}', ['as' => 'account-edit', 'uses' => 'AccountController@editAccount']);
    Route::get('view/{id}', ['as' => 'account-view', 'uses' => 'AccountController@viewAccount']);
    Route::get('receipt/{id}', ['as' => 'account-receipt', 'uses' => 'AccountController@receiptAccount']);
    Route::get('delete/{id}', ['as' => 'account-delete', 'uses' => 'AccountController@deleteAccount']);
    Route::get('reports', ['as' => 'account-report', 'uses' => 'AccountController@accountReportPage']);
    Route::get('{roleId}', ['as' => 'account-user-list', 'uses' => 'AccountController@userOfRole']);
    Route::get('account-report/{receiptNo}/{roleId}/{userId}/{accountTypeId}/{amountTypeId}/{amountCategoryId}/{fromDate}/{toDate}', ['as' => 'account-report-details', 'uses' => 'AccountController@accountReport']);
});


Route::group(['namespace' => 'GeneralReport', 'prefix' => 'general-report'], function () {
    Route::get('reports', ['as' => 'general-report-page', 'uses' => 'GeneralReportController@generalReportPage']);
    Route::get('teacher-report', ['as' => 'general-report-teacher', 'uses' => 'GeneralReportController@generateTeacherReport']);
    Route::get('student-report', ['as' => 'general-report-student', 'uses' => 'GrController@generateStudentReport']);
    Route::get('routine-report', ['as' => 'general-report-routine', 'uses' => 'GeneralReportController@generateRoutineReport']);
    Route::get('exam-report', ['as' => 'general-report-exam', 'uses' => 'GeneralReportController@generateExamRoutineReport']);
    Route::get('student-list-by-departmentId', ['as' => 'student-list-by-departmentId', 'uses' => 'GrController@studentOfDepartment']);
    Route::get('student-list-by-sectionId-departmentId', ['as' => 'student-list-by-sectionId-departmentId', 'uses' => 'GrController@studentOfDepartmentWithSection']);
    //Route::get('account-report/{roleId}/{userId}/{accountTypeId}/{amountTypeId}/{amountCategoryId}/{fromDate}/{toDate}',['as'=>'account-report-details','uses'=>'AccountController@accountReport']);

});


Route::group(['namespace' => 'Tabulation', 'prefix' => 'tabulation'], function () {
    Route::get('tabulation-sheet', ['as' => 'tabulation-sheet-page', 'uses' => 'TabulationReportController@tabulationSheetPage']);
    Route::get('tabulation-report', ['as' => 'tabulation-sheet-report', 'uses' => 'TabulationReportController@generateTabulationSheetReport']);

});

Route::group(['namespace' => 'BookCategory', 'prefix' => 'book-category'], function () {
    Route::get('list', ['as' => 'book-category-list', 'uses' => 'BookCategoryController@index']);
    Route::get('add', ['as' => 'book-category-add-form', 'uses' => 'BookCategoryController@createBookCategoryForm']);
    Route::post('add', ['as' => 'book-category-create', 'uses' => 'BookCategoryController@createBookCategory']);
    Route::get('edit/{id}', ['as' => 'book-category-edit-form', 'uses' => 'BookCategoryController@getBookCategoryEditForm']);
    Route::patch('edit/{id}', ['as' => 'book-category-edit', 'uses' => 'BookCategoryController@editBookCategory']);
    Route::get('delete/{id}', ['as' => 'book-category-delete', 'uses' => 'BookCategoryController@deleteBookCategory']);
});

Route::group(['namespace' => 'Author', 'prefix' => 'author'], function () {
    Route::get('list', ['as' => 'author-list', 'uses' => 'AuthorController@index']);
    Route::get('add', ['as' => 'author-add-form', 'uses' => 'AuthorController@createAuthorForm']);
    Route::post('add', ['as' => 'author-create', 'uses' => 'AuthorController@createAuthor']);
    Route::get('view/{id}', ['as' => 'author-view', 'uses' => 'AuthorController@viewAuthor']);
    Route::get('edit/{id}', ['as' => 'author-edit-form', 'uses' => 'AuthorController@getAuthorEditForm']);
    Route::patch('edit/{id}', ['as' => 'author-edit', 'uses' => 'AuthorController@editAuthor']);
    Route::get('delete/{id}', ['as' => 'author-delete', 'uses' => 'AuthorController@deleteAuthor']);
});

Route::group(['namespace' => 'Rack', 'prefix' => 'rack'], function () {
    Route::get('list', ['as' => 'rack-list', 'uses' => 'RackController@index']);
    Route::get('add', ['as' => 'rack-add-form', 'uses' => 'RackController@createRackForm']);
    Route::post('add', ['as' => 'rack-create', 'uses' => 'RackController@createRack']);
//    Route::get('view/{id}', ['as'=>'rack-view','uses'=>'RackController@viewRack']);
    Route::get('edit/{id}', ['as' => 'rack-edit-form', 'uses' => 'RackController@getRackEditForm']);
    Route::patch('edit/{id}', ['as' => 'rack-edit', 'uses' => 'RackController@editRack']);
    Route::get('delete/{id}', ['as' => 'rack-delete', 'uses' => 'RackController@deleteRack']);
});

Route::group(['namespace' => 'Book', 'prefix' => 'book'], function () {
    Route::get('list', ['as' => 'book-list', 'uses' => 'BookController@index']);
    Route::get('add', ['as' => 'book-add-form', 'uses' => 'BookController@createBookForm']);
    Route::post('add', ['as' => 'book-create', 'uses' => 'BookController@createBook']);
    Route::get('view/{id}', ['as' => 'book-view', 'uses' => 'BookController@viewBook']);
    Route::get('edit/{id}', ['as' => 'book-edit-form', 'uses' => 'BookController@getBookEditForm']);
    Route::patch('edit/{id}', ['as' => 'book-edit', 'uses' => 'BookController@editBook']);
    Route::get('delete/{id}', ['as' => 'book-delete', 'uses' => 'BookController@deleteBook']);
});

Route::group(['namespace' => 'Training', 'prefix' => 'training'], function () {
    Route::get('list', ['as' => 'training-list', 'uses' => 'TrainingController@index']);
    Route::get('add', ['as' => 'training-add-form', 'uses' => 'TrainingController@createTrainingForm']);
    Route::post('add', ['as' => 'training-create', 'uses' => 'TrainingController@createTraining']);
    Route::get('view/{id}', ['as' => 'training-view', 'uses' => 'TrainingController@viewTraining']);
    Route::get('edit/{id}', ['as' => 'training-edit-form', 'uses' => 'TrainingController@getTrainingEditForm']);
    Route::patch('edit/{id}', ['as' => 'training-edit', 'uses' => 'TrainingController@editTraining']);
    Route::get('delete/{id}', ['as' => 'training-delete', 'uses' => 'TrainingController@deleteTraining']);
});

Route::group(['namespace' => 'ProfessionalQualification', 'prefix' => 'professional-qualification'], function () {
    Route::get('list', ['as' => 'professional-qualification-list', 'uses' => 'ProfessionalQualificationController@index']);
    Route::get('add', ['as' => 'professional-qualification-add-form', 'uses' => 'ProfessionalQualificationController@createProfessionalQualificationForm']);
    Route::post('add', ['as' => 'professional-qualification-create', 'uses' => 'ProfessionalQualificationController@createProfessionalQualification']);
    Route::get('view/{id}', ['as' => 'professional-qualification-view', 'uses' => 'ProfessionalQualificationController@viewProfessionalQualification']);
    Route::get('edit/{id}', ['as' => 'professional-qualification-edit-form', 'uses' => 'ProfessionalQualificationController@getProfessionalQualificationEditForm']);
    Route::patch('edit/{id}', ['as' => 'professional-qualification-edit', 'uses' => 'ProfessionalQualificationController@editProfessionalQualification']);
    Route::get('delete/{id}', ['as' => 'professional-qualification-delete', 'uses' => 'ProfessionalQualificationController@deleteProfessionalQualification']);
});

Route::group(['namespace' => 'BusinessType', 'prefix' => 'business-type'], function () {
    Route::get('list', ['as' => 'business-type-list', 'uses' => 'BusinessTypeController@index']);
    Route::get('add', ['as' => 'business-type-add-form', 'uses' => 'BusinessTypeController@createBusinessTypeForm']);
    Route::post('add', ['as' => 'business-type-create', 'uses' => 'BusinessTypeController@createBusinessType']);
//    Route::get('view/{id}', ['as'=>'business-type-view','uses'=>'BusinessTypeController@viewBusinessType']);
    Route::get('edit/{id}', ['as' => 'business-type-edit-form', 'uses' => 'BusinessTypeController@getBusinessTypeEditForm']);
    Route::patch('edit/{id}', ['as' => 'business-type-edit', 'uses' => 'BusinessTypeController@editBusinessType']);
    Route::get('delete/{id}', ['as' => 'business-type-delete', 'uses' => 'BusinessTypeController@deleteBusinessType']);
});

Route::group(['namespace' => 'ExperienceCategory', 'prefix' => 'experience-category'], function () {
    Route::get('list', ['as' => 'experience-category-list', 'uses' => 'ExperienceCategoryController@index']);
    Route::get('add', ['as' => 'experience-category-add-form', 'uses' => 'ExperienceCategoryController@createExperienceCategoryForm']);
    Route::post('add', ['as' => 'experience-category-create', 'uses' => 'ExperienceCategoryController@createExperienceCategory']);
//    Route::get('view/{id}', ['as'=>'experience-category-view','uses'=>'ExperienceCategoryController@viewExperienceCategory']);
    Route::get('edit/{id}', ['as' => 'experience-category-edit-form', 'uses' => 'ExperienceCategoryController@getExperienceCategoryEditForm']);
    Route::patch('edit/{id}', ['as' => 'experience-category-edit', 'uses' => 'ExperienceCategoryController@editExperienceCategory']);
    Route::get('delete/{id}', ['as' => 'experience-category-delete', 'uses' => 'ExperienceCategoryController@deleteExperienceCategory']);
    Route::get('{experienceCategoryId}', ['as' => 'category-experience', 'uses' => 'ExperienceCategoryController@experienceOfExperienceCategory']);
});

Route::group(['namespace' => 'Experience', 'prefix' => 'experience'], function () {
    Route::get('list', ['as' => 'experience-list', 'uses' => 'ExperienceController@index']);
    Route::get('add', ['as' => 'experience-add-form', 'uses' => 'ExperienceController@createExperienceForm']);
    Route::post('add', ['as' => 'experience-create', 'uses' => 'ExperienceController@createExperience']);
//    Route::get('view/{id}', ['as'=>'experience-view','uses'=>'ExperienceController@viewExperience']);
    Route::get('edit/{id}', ['as' => 'experience-edit-form', 'uses' => 'ExperienceController@getExperienceEditForm']);
    Route::patch('edit/{id}', ['as' => 'experience-edit', 'uses' => 'ExperienceController@editExperience']);
    Route::get('delete/{id}', ['as' => 'experience-delete', 'uses' => 'ExperienceController@deleteExperience']);
});

Route::group(['namespace' => 'SkillCategory', 'prefix' => 'skill-category'], function () {
    Route::get('list', ['as' => 'skill-category-list', 'uses' => 'SkillCategoryController@index']);
    Route::get('add', ['as' => 'skill-category-add-form', 'uses' => 'SkillCategoryController@createSkillCategoryForm']);
    Route::post('add', ['as' => 'skill-category-create', 'uses' => 'SkillCategoryController@createSkillCategory']);
//    Route::get('view/{id}', ['as'=>'skill-category-view','uses'=>'SkillCategoryController@viewSkillCategory']);
    Route::get('edit/{id}', ['as' => 'skill-category-edit-form', 'uses' => 'SkillCategoryController@getSkillCategoryEditForm']);
    Route::patch('edit/{id}', ['as' => 'skill-category-edit', 'uses' => 'SkillCategoryController@editSkillCategory']);
    Route::get('delete/{id}', ['as' => 'skill-category-delete', 'uses' => 'SkillCategoryController@deleteSkillCategory']);
    Route::get('{skillCategoryId}', ['as' => 'category-skill', 'uses' => 'SkillCategoryController@skillOfSkillCategory']);
});

Route::group(['namespace' => 'Skill', 'prefix' => 'skill'], function () {
    Route::get('list', ['as' => 'skill-list', 'uses' => 'SkillController@index']);
    Route::get('add', ['as' => 'skill-add-form', 'uses' => 'SkillController@createSkillForm']);
    Route::post('add', ['as' => 'skill-create', 'uses' => 'SkillController@createSkill']);
//    Route::get('view/{id}', ['as'=>'skill-view','uses'=>'SkillController@viewSkill']);
    Route::get('edit/{id}', ['as' => 'skill-edit-form', 'uses' => 'SkillController@getSkillEditForm']);
    Route::patch('edit/{id}', ['as' => 'skill-edit', 'uses' => 'SkillController@editSkill']);
    Route::get('delete/{id}', ['as' => 'skill-delete', 'uses' => 'SkillController@deleteSkill']);
});

Route::group(['namespace' => 'CvLanguage', 'prefix' => 'cv-language'], function () {
    Route::get('list', ['as' => 'cv-language-list', 'uses' => 'CvLanguageController@index']);
    Route::get('add', ['as' => 'cv-language-add-form', 'uses' => 'CvLanguageController@createCvLanguageForm']);
    Route::post('add', ['as' => 'cv-language-create', 'uses' => 'CvLanguageController@createCvLanguage']);
//    Route::get('view/{id}', ['as'=>'cv-language-view','uses'=>'CvLanguageController@viewCvLanguage']);
    Route::get('edit/{id}', ['as' => 'cv-language-edit-form', 'uses' => 'CvLanguageController@getCvLanguageEditForm']);
    Route::patch('edit/{id}', ['as' => 'cv-language-edit', 'uses' => 'CvLanguageController@editCvLanguage']);
    Route::get('delete/{id}', ['as' => 'cv-language-delete', 'uses' => 'CvLanguageController@deleteCvLanguage']);
});

Route::group(['namespace' => 'CvLanguageSkill', 'prefix' => 'cv-language-skill'], function () {
    Route::get('list', ['as' => 'cv-language-skill-list', 'uses' => 'CvLanguageSkillController@index']);
    Route::get('add', ['as' => 'cv-language-skill-add-form', 'uses' => 'CvLanguageSkillController@createCvLanguageSkillForm']);
    Route::post('add', ['as' => 'cv-language-skill-create', 'uses' => 'CvLanguageSkillController@createCvLanguageSkill']);
//    Route::get('view/{id}', ['as'=>'cv-language-skill-view','uses'=>'CvLanguageSkillController@viewCvLanguageSkill']);
    // Route::get('edit/{id}', ['as' => 'cv-language-skill-edit-form', 'uses' => 'CvLanguageSkillController@getCvLanguageSkillEditForm']);
    Route::patch('edit/{id}', ['as' => 'cv-language-skill-edit', 'uses' => 'CvLanguageSkillController@editCvLanguageSkill']);
    Route::get('delete/{id}', ['as' => 'cv-language-skill-delete', 'uses' => 'CvLanguageSkillController@deleteCvLanguageSkill']);
});

Route::group(['namespace' => 'Relation', 'prefix' => 'relation'], function () {
    Route::get('list', ['as' => 'relation-list', 'uses' => 'RelationController@index']);
    Route::get('add', ['as' => 'relation-add-form', 'uses' => 'RelationController@createRelationForm']);
    Route::post('add', ['as' => 'relation-create', 'uses' => 'RelationController@createRelation']);
//    Route::get('view/{id}', ['as'=>'relation-view','uses'=>'RelationController@viewRelation']);
    Route::get('edit/{id}', ['as' => 'relation-edit-form', 'uses' => 'RelationController@getRelationEditForm']);
    Route::patch('edit/{id}', ['as' => 'relation-edit', 'uses' => 'RelationController@editRelation']);
    Route::get('delete/{id}', ['as' => 'relation-delete', 'uses' => 'RelationController@deleteRelation']);
});

Route::group(['namespace' => 'Reference', 'prefix' => 'reference'], function () {
    Route::get('list', ['as' => 'reference-list', 'uses' => 'ReferenceController@index']);
    Route::get('add', ['as' => 'reference-add-form', 'uses' => 'ReferenceController@createReferenceForm']);
    Route::post('add', ['as' => 'reference-create', 'uses' => 'ReferenceController@createReference']);
    Route::get('view/{id}', ['as' => 'reference-view', 'uses' => 'ReferenceController@viewReference']);
    Route::get('edit/{id}', ['as' => 'reference-edit-form', 'uses' => 'ReferenceController@getReferenceEditForm']);
    Route::patch('edit/{id}', ['as' => 'reference-edit', 'uses' => 'ReferenceController@editReference']);
    Route::get('delete/{id}', ['as' => 'reference-delete', 'uses' => 'ReferenceController@deleteReference']);
});

Route::group(['namespace' => 'EmploymentHistory', 'prefix' => 'employment-history'], function () {
    Route::get('list', ['as' => 'employment-history-list', 'uses' => 'EmploymentHistoryController@index']);
    Route::get('add', ['as' => 'employment-history-add-form', 'uses' => 'EmploymentHistoryController@createEmploymentHistoryForm']);
    Route::post('add', ['as' => 'employment-history-create', 'uses' => 'EmploymentHistoryController@createEmploymentHistory']);
    Route::get('view/{id}', ['as' => 'employment-history-view', 'uses' => 'EmploymentHistoryController@viewEmploymentHistory']);
    Route::get('edit/{id}', ['as' => 'employment-history-edit-form', 'uses' => 'EmploymentHistoryController@getEmploymentHistoryEditForm']);
    Route::patch('edit/{id}', ['as' => 'employment-history-edit', 'uses' => 'EmploymentHistoryController@editEmploymentHistory']);
    Route::get('delete/{id}', ['as' => 'employment-history-delete', 'uses' => 'EmploymentHistoryController@deleteEmploymentHistory']);
});

Route::group(['namespace' => 'Specialization', 'prefix' => 'specialization'], function () {
    Route::get('list', ['as' => 'specialization-list', 'uses' => 'SpecializationController@index']);
    Route::get('add', ['as' => 'specialization-add-form', 'uses' => 'SpecializationController@createSpecializationForm']);
    Route::post('add', ['as' => 'specialization-create', 'uses' => 'SpecializationController@createSpecialization']);
    Route::get('view/{id}', ['as' => 'specialization-view', 'uses' => 'SpecializationController@viewSpecialization']);
    Route::get('edit/{id}', ['as' => 'specialization-edit-form', 'uses' => 'SpecializationController@getSpecializationEditForm']);
    Route::patch('edit/{id}', ['as' => 'specialization-edit', 'uses' => 'SpecializationController@editSpecialization']);
    Route::get('delete/{id}', ['as' => 'specialization-delete', 'uses' => 'SpecializationController@deleteSpecialization']);
});

Route::group(['namespace' => 'EducationLevel', 'prefix' => 'education-level'], function () {
    Route::get('list', ['as' => 'education-level-list', 'uses' => 'EducationLevelController@index']);
    Route::get('add', ['as' => 'education-level-add-form', 'uses' => 'EducationLevelController@createEducationLevelForm']);
    Route::post('add', ['as' => 'education-level-create', 'uses' => 'EducationLevelController@createEducationLevel']);
    Route::get('edit/{id}', ['as' => 'education-level-edit-form', 'uses' => 'EducationLevelController@getEducationLevelEditForm']);
    Route::patch('edit/{id}', ['as' => 'education-level-edit', 'uses' => 'EducationLevelController@editEducationLevel']);
    Route::get('delete/{id}', ['as' => 'education-level-delete', 'uses' => 'EducationLevelController@deleteEducationLevel']);
});

Route::group(['namespace' => 'AcademicQualification', 'prefix' => 'academic-qualification'], function () {
    Route::get('list', ['as' => 'academic-qualification-list', 'uses' => 'AcademicQualificationController@index']);
    Route::get('add', ['as' => 'academic-qualification-add-form', 'uses' => 'AcademicQualificationController@createAcademicQualificationForm']);
    Route::post('add', ['as' => 'academic-qualification-create', 'uses' => 'AcademicQualificationController@createAcademicQualification']);
    Route::get('view/{id}', ['as' => 'academic-qualification-view', 'uses' => 'AcademicQualificationController@viewAcademicQualification']);
    Route::get('edit/{id}', ['as' => 'academic-qualification-edit-form', 'uses' => 'AcademicQualificationController@getAcademicQualificationEditForm']);
    Route::patch('edit/{id}', ['as' => 'academic-qualification-edit', 'uses' => 'AcademicQualificationController@editAcademicQualification']);
    Route::get('delete/{id}', ['as' => 'academic-qualification-delete', 'uses' => 'AcademicQualificationController@deleteAcademicQualification']);
});

Route::group(['namespace' => 'Office', 'prefix' => 'office'], function () {
    Route::get('report', ['as' => 'site-report', 'uses' => 'OfficeController@siteReportPage']);
    Route::get('generate-site-report', ['as' => 'official-site-report', 'uses' => 'OfficeController@generateSiteReport']);
    Route::get('generate-site-report-view', ['as' => 'official-site-report-view', 'uses' => 'OfficeController@generateSiteReportView']);
});


Route::group(['namespace' => 'StudentReport', 'prefix' => 'student-report'], function () {
    Route::get('reports', ['as' => 'student-report-page', 'uses' => 'StudentReportController@studentReportPage']);
    Route::get('routine-report', ['as' => 'student-report-routine', 'uses' => 'StudentReportController@generateClassRoutineReport']);
    Route::get('exam-report', ['as' => 'student-report-exam', 'uses' => 'StudentReportController@generateExamRoutineReport']);
    Route::get('account-report', ['as' => 'student-report-account', 'uses' => 'StudentReportController@generateStudentAccountReport']);
    Route::get('testimonial-report', ['as' => 'student-report-testigetSiteOptionsmonial', 'uses' => 'StudentReportController@generateStudentTestimonialReport']);
});


Route::group(['namespace' => 'AcademicAll', 'prefix' => 'academic-subject'], function () {
    Route::get('list', 'AcademicSubjectController@index')->name('academic-subject-list');
    Route::get('get-subject-list', 'AcademicSubjectController@getAcademicSubjectList')->name('academic-subject-get-subject-list');
    Route::post('save-subject', 'AcademicSubjectController@store')->name('academic-subject-save-subject');
    Route::put('update-subject/{id}', 'AcademicSubjectController@update')->name('academic-subject-update-subject');
    Route::delete('delete-subject/{id}', 'AcademicSubjectController@destroy')->name('academic-subject-delete-subject');
});


//===========================================================Accounts=====================================================================


Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {
    Route::group(['namespace' => 'Accounts', 'prefix' => 'accounts'], function () {
        Route::group(['namespace' => 'AccountsLedger', 'prefix' => 'accounts-ledger'], function () {
//            Route::get('master-view', 'AccountsLedgerController@masterIndex')->name('site-accounts-accounts-ledger-master-view');

            Route::get('chart-of-account-download', 'AccountsLedgerController@ChartOfAccountsDownload')->name('site-accounts-chart-of-account-download');
            Route::get('view', 'AccountsLedgerController@index')->name('site-accounts-accounts-ledger-view');
            Route::get('list', 'AccountsLedgerController@getAccountsLedgerList')->name('site-accounts-accounts-ledger-list');
            Route::get('list-with-pagination', 'AccountsLedgerController@getAccountsLedgerListWithPagination')->name('site-accounts-accounts-ledger-list-with-pagination');
            Route::get('parent-list', 'AccountsLedgerController@getAccountsLedgerParentList')->name('site-accounts-accounts-ledger-parent-list');
            Route::post('add', 'AccountsLedgerController@create')->name('site-accounts-accounts-ledger-create');
            Route::post('update', 'AccountsLedgerController@update')->name('site-accounts-accounts-ledger-update');
            Route::delete('delete/{id}', 'AccountsLedgerController@delete')->name('site-accounts-accounts-ledger-delete');
        });
        Route::group(['namespace' => 'AccountsSubGroup', 'prefix' => 'accounts-sub-group'], function () {
            Route::get('view', 'AccountsSubGroupController@index')->name('site-accounts-accounts-sub-group-view');
            Route::get('list', 'AccountsSubGroupController@getAccountsSubGroupList')->name('site-accounts-accounts-sub-group-list');
            Route::get('list-with-pagination', 'AccountsSubGroupController@getAccountsSubGroupListWithPagination')->name('site-accounts-accounts-sub-group-list-with-pagination');
            Route::post('add', 'AccountsSubGroupController@create')->name('site-accounts-accounts-sub-group-create');
            Route::post('update', 'AccountsSubGroupController@update')->name('site-accounts-accounts-sub-group-update');
            Route::delete('delete/{id}', 'AccountsSubGroupController@delete')->name('site-accounts-accounts-sub-group-delete');
        });
        Route::group(['namespace' => 'AccountsGroup', 'prefix' => 'accounts-group'], function () {
            Route::get('view', 'AccountsGroupController@index')->name('site-accounts-accounts-group-view');
            Route::get('list', 'AccountsGroupController@getAccountsGroupList')->name('site-accounts-accounts-group-list');
            Route::get('list/{acc_head_id}', 'AccountsGroupController@getAccountsGroupListByAccountsHeadId')->name('site-accounts-accounts-group-list-by-accounts-head-id');
            Route::get('accounts-head-list', 'AccountsGroupController@getAccountsHeadList')->name('site-accounts-accounts-group-accounts-head-list');
            Route::get('list-with-pagination', 'AccountsGroupController@getAccountsGroupListWithPagination')->name('site-accounts-accounts-group-list-with-pagination');
            Route::post('add', 'AccountsGroupController@create')->name('site-accounts-accounts-group-create');
            Route::post('update', 'AccountsGroupController@update')->name('site-accounts-accounts-group-update');
            Route::delete('delete/{id}', 'AccountsGroupController@delete')->name('site-accounts-accounts-group-delete');
        });
        Route::group(['namespace' => 'AccountsTransaction', 'prefix' => 'accounts-transaction'], function () {
            Route::get('credit-voucher/view', 'AccountsTransactionController@creditVoucherindex')->name('site-accounts-accounts-transaction-cv-view');
            Route::get('credit-voucher/list-view', 'AccountsTransactionController@creditVoucherindex')->name('site-accounts-accounts-transaction-cv-view');
            Route::get('credit-voucher/list-with-pagination', 'AccountsTransactionController@getCreditVoucherListWithPagination')->name('site-accounts-accounts-transaction-cv-list-with-pagination');
            Route::get('credit-voucher/edit/{id}', 'AccountsTransactionController@creditVoucherindex')->name('site-accounts-accounts-transaction-cv-edit-view');
            Route::get('credit-voucher/details/{id}', 'AccountsTransactionController@creditVoucherDetailsForUpdate')->name('site-accounts-accounts-transaction-cv-details-for-update');
            Route::get('credit-voucher/fee-amount-for-accounts/{type}/{fee_start_date}/{fee_end_date}', 'AccountsTransactionController@creditVoucherForFeeAmount')->name('site-accounts-accounts-transaction-cv-fee-amount-for-accounts');
            Route::post('credit-voucher-add', 'AccountsTransactionController@createAccountsWithCreditVoucher')->name('site-accounts-credit-voucher-add');
            Route::post('credit-voucher-update', 'AccountsTransactionController@updateAccountsWithCreditVoucher')->name('site-accounts-credit-voucher-update');
            Route::get('credit-voucher-pdf/{voucher_id}', 'AccountsTransactionController@getAccountsCreditVoucherPdf')->name('site-accounts-credit-voucher-pdf-by-voucher-id');
            Route::post('credit-voucher/delete/{voucher_id}', 'AccountsTransactionController@deleteAccountsCreditVoucher')->name('site-accounts-credit-voucher-delete-by-voucher-id');

            Route::get('debit-voucher/view', 'AccountsTransactionController@debitVoucherindex')->name('site-accounts-accounts-transaction-dv-view');;
            Route::get('debit-voucher/list-view', 'AccountsTransactionController@debitVoucherindex')->name('site-accounts-accounts-transaction-dv-view');
            Route::get('debit-voucher/edit/{id}', 'AccountsTransactionController@debitVoucherindex')->name('site-accounts-accounts-transaction-dv-edit-view');
            Route::get('debit-voucher/list-with-pagination', 'AccountsTransactionController@getDebitVoucherListWithPagination')->name('site-accounts-accounts-transaction-dv-list-with-pagination');
            Route::get('debit-voucher/details/{id}', 'AccountsTransactionController@debitVoucherDetailsForUpdate')->name('site-accounts-accounts-transaction-dv-details-for-update');
            Route::post('debit-voucher-update', 'AccountsTransactionController@updateAccountsWithDebitVoucher')->name('site-accounts-debit-voucher-update');
            Route::post('debit-voucher/delete/{voucher_id}', 'AccountsTransactionController@deleteAccountsDebitVoucher')->name('site-accounts-debit-voucher-delete-by-voucher-id');

            Route::get('debit-voucher-pdf/{voucher_id}', 'AccountsTransactionController@getAccountsDebitVoucherPdf')->name('site-accounts-debit-voucher-pdf-by-voucher-id');
            Route::post('debit-voucher-add', 'AccountsTransactionController@createAccountsWithDebitVoucher')->name('site-accounts-debit-voucher-add');

            Route::get('contra-voucher/view', 'AccountsTransactionController@contraVoucherindex')->name('site-accounts-accounts-transaction-contra-voucher-view');
            Route::get('contra-voucher/list-view', 'AccountsTransactionController@contraVoucherindex')->name('site-accounts-accounts-transaction-contra-voucher-view');
            Route::get('contra-voucher/edit/{id}', 'AccountsTransactionController@contraVoucherindex')->name('site-accounts-accounts-transaction-contra-voucher-edit-view');
            Route::get('contra-voucher/list-with-pagination', 'AccountsTransactionController@getContraVoucherListWithPagination')->name('site-accounts-accounts-transaction-contra-voucher-list-with-pagination');
            Route::get('contra-voucher/details/{id}', 'AccountsTransactionController@cotraVoucherDetailsForUpdate')->name('site-accounts-accounts-transaction-contra-voucher-details-for-update');
            Route::post('contra-voucher-update', 'AccountsTransactionController@updateAccountsWithContraVoucher')->name('site-accounts-accounts-transaction-contra-voucher-update');
            Route::post('contra-voucher/delete/{voucher_id}', 'AccountsTransactionController@deleteAccountsContraVoucher')->name('site-accounts-accounts-transaction-contra-voucher-delete-by-voucher-id');
            Route::post('contra-voucher-add', 'AccountsTransactionController@createAccountsWithContraVoucher')->name('site-accounts-accounts-transaction-contra-voucher-add');
            Route::get('contra-voucher-pdf/{voucher_id}', 'AccountsTransactionController@getAccountsContraVoucherPdf')->name('site-accounts-accounts-transaction-contra-voucher-pdf-by-voucher-id');


            Route::get('journal-voucher/view', 'AccountsTransactionController@journalVoucherindex')->name('site-accounts-accounts-transaction-jv-view');
            Route::get('journal-voucher/list-view', 'AccountsTransactionController@journalVoucherindex')->name('site-accounts-accounts-transaction-jv-view');
            Route::get('journal-voucher/edit/{id}', 'AccountsTransactionController@journalVoucherindex')->name('site-accounts-accounts-transaction-jv-edit-view');
            Route::get('journal-voucher/list-with-pagination', 'AccountsTransactionController@getJournalVoucherListWithPagination')->name('site-accounts-accounts-transaction-jv-list-with-pagination');
            Route::get('journal-voucher/details/{id}', 'AccountsTransactionController@journalVoucherDetailsForUpdate')->name('site-accounts-accounts-transaction-jv-details-for-update');
            Route::post('journal-voucher-update', 'AccountsTransactionController@updateAccountsWithJournalVoucher')->name('site-accounts-journal-voucher-update');
            Route::post('journal-voucher/delete/{voucher_id}', 'AccountsTransactionController@deleteAccountsJournalVoucher')->name('site-accounts-journal-voucher-delete-by-voucher-id');

            Route::post('journal-voucher-add', 'AccountsTransactionController@createAccountsWithJournalVoucher')->name('site-accounts-journal-voucher-add');
            Route::get('journal-voucher-pdf/{voucher_id}', 'AccountsTransactionController@getAccountsJournalVoucherPdf')->name('site-accounts-journal-voucher-pdf-by-voucher-id');

            Route::get('month-list/{empID?}/{mode?}', 'AccountsTransactionController@getMonthList')->name('site-accounts-accounts-transaction-month-list');
            Route::get('ledger-list-for-report', 'AccountsTransactionController@getAccountsLedgerListForReport')->name('site-accounts-accounts-transaction-ledger-list-for-report');
            Route::get('ledger-list', 'AccountsTransactionController@getAccountsLedgerList')->name('site-accounts-accounts-transaction-ledger-list');
            Route::get('cash-bank-ledger-list', 'AccountsTransactionController@getOnlyCashAndBankAccountsLedgerList')->name('site-accounts-accounts-transaction-cash-bank-ledger-list');
            Route::get('expense-ledger-list', 'AccountsTransactionController@getAccountsExpenseLedgerList')->name('site-accounts-accounts-transaction-expense-ledger-list');



        });
        Route::group(['namespace' => 'Bank', 'prefix' => 'bank'], function () {
            Route::get('view', 'AccountsBankController@index')->name('site-accounts-bank-view');
            Route::get('list', 'AccountsBankController@getAccountsBankList')->name('site-accounts-bank-list');
            Route::get('list-with-pagination', 'AccountsBankController@getAccountsBankListWithPagination')->name('site-accounts-bank-list-with-pagination');
            Route::post('add', 'AccountsBankController@create')->name('site-accounts-bankr-create');
            Route::post('update', 'AccountsBankController@update')->name('site-accounts-bank-update');
            Route::delete('delete/{id}', 'AccountsBankController@delete')->name('site-accounts-bank-delete');

            Route::get('account-list/{bankID}', 'AccountsBankController@getAccountsBankAccountListByBankID')->name('site-accounts-bank-account-list-by-bank-id');
            Route::get('account_balance/{accountID}', 'AccountsBankController@getAccountsBankAccountBalance')->name('site-accounts-bank-account-balance-by-account-id');
            Route::get('account-list-with-pagination', 'AccountsBankController@getAccountsBankAccountListWithPaginationByBankID')->name('site-accounts-bank-account-list-with-pagination-by-bank-id');
            Route::post('account-add', 'AccountsBankController@createBankAccount')->name('site-accounts-bank-account-create');
            Route::post('account-update', 'AccountsBankController@updateBankAccount')->name('site-accounts-bank-account-update');
            Route::delete('account-delete/{id}', 'AccountsBankController@deleteBankAccount')->name('site-accounts-bank-account-delete');

        });
        Route::group(['namespace' => 'Party', 'prefix' => 'party'], function () {
            Route::get('view', 'AccountsPartyController@index')->name('site-accounts-party-view');
            Route::get('list', 'AccountsPartyController@getAccountsPartyList')->name('site-accounts-party-list');
            Route::get('list-with-pagination', 'AccountsPartyController@getAccountsPartyListWithPagination')->name('site-accounts-party-list-with-pagination');
            Route::post('add', 'AccountsPartyController@create')->name('site-accounts-party-create');
            Route::post('update', 'AccountsPartyController@update')->name('site-accounts-party-update');
            Route::delete('delete/{id}', 'AccountsPartyController@delete')->name('site-accounts-party-delete');
        });
        Route::group(['namespace' => 'ChequeRegister', 'prefix' => 'cheque-register'], function () {
            Route::get('view', 'ChequeRegisterController@index')->name('site-accounts-cheque-register-view');
            Route::get('list', 'ChequeRegisterController@getChequeRegisterList')->name('site-accounts-cheque-register-list');
            Route::get('list-with-pagination', 'ChequeRegisterController@getChequeRegisterListWithPagination')->name('site-accounts-cheque-register-list-with-pagination');
            Route::post('add', 'ChequeRegisterController@create')->name('site-accounts-cheque-register-create');
            Route::post('update', 'ChequeRegisterController@update')->name('site-accounts-cheque-register-update');
            Route::delete('delete/{id}', 'ChequeRegisterController@delete')->name('site-accounts-cheque-register-delete');
        });
        Route::group(['namespace' => 'Report', 'prefix' => 'report'], function () {
            Route::get('general-ledger', 'SiteAccountsReportController@index')->name('site-accounts-report-general-ledger');
            Route::get('financial-statements', 'SiteAccountsReportController@index')->name('site-accounts-fs-report-ledger');
            Route::get('ledger', 'SiteAccountsReportController@index')->name('site-accounts-report-ledger');
            Route::get('trial-balance', 'SiteAccountsReportController@index')->name('site-accounts-tb-report-ledger');
            Route::get('balance-sheet', 'SiteAccountsReportController@index')->name('site-accounts-bs-report-ledger');
            Route::get('profit-loss-statements', 'SiteAccountsReportController@index')->name('site-accounts-pls-report-ledger');

            Route::post('ledger-details-list', 'SiteAccountsReportController@getLedgerDetailsList')->name('site-accounts-report-ledger-details-list');
            Route::post('ledger-details-list-for-trial-balance-single-date-wise', 'SiteAccountsReportController@getLedgerDetailsListForTrialBalanceSingleDateWiseReport')->name('site-accounts-report-ledger-details-list-for-trial-balance-single-date-wise');
            Route::post('ledger-details-list-for-trial-balance', 'SiteAccountsReportController@getLedgerDetailsListForTrialBalanceReport')->name('site-accounts-report-ledger-details-list-for-trial-balance');
            Route::post('profit-loss-details-list', 'SiteAccountsReportController@getProfitAndLossDetailsList')->name('site-accounts-report-profit-loss-details-list');
            Route::post('balance-sheet-details-list', 'SiteAccountsReportController@getBalanceSheetDetailsList')->name('site-accounts-report-balance-sheet-details-list');

            Route::get('ledger-pdf/{form_date}/{to_date}/{ledger_id?}', 'SiteAccountsReportController@getLedgerPDF')->name('site-accounts-report-ledger-pdf');
            Route::get('trial-balance-report-signle-date-wise-pdf/{at_date}', 'SiteAccountsReportController@getTrialBalanceReportSingleDateWisePDF')->name('site-accounts-report-trial-balance-single-date-wise-pdf');
            Route::get('trial-balance-report-pdf/{form_date}/{to_date}', 'SiteAccountsReportController@getTrialBalanceReportPDF')->name('site-accounts-report-trial-balance-pdf');
            Route::get('profit-loss-report-pdf/{form_date}/{to_date}', 'SiteAccountsReportController@getProfitLossReportPDF')->name('site-accounts-report-profit-loss-pdf');
            Route::get('balance-sheet-report-pdf/{at_date}', 'SiteAccountsReportController@getBalanceSheetReportPDF')->name('site-accounts-report-balance-sheet-pdf');

        });
    });
});

//===========================================================Payment Get Way=====================================================================

Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {
    Route::group(['namespace' => 'Payment', 'prefix' => 'payment-gateway'], function () {

        Route::get('view', 'PaymentGatewayController@index')->name('site-payment-gateway-view');
        Route::get('list', 'PaymentGatewayController@getPaymentGatewayList')->name('site-apayment-gateway-list');
        Route::get('list-with-pagination', 'PaymentGatewayController@getPaymentGatewayListWithPagination')->name('site-payment-gateway-list-with-pagination');
        Route::get('payment-type-list', 'PaymentGatewayController@getPaymentGatewayPaymentTypeList')->name('site-payment-gateway-payment-type-list');
        Route::get('payment-method-list/{key}', 'PaymentGatewayController@getPaymentGatewayPaymentMethodList')->name('site-payment-gateway-payment-method-list-by-payment-type-key');
        Route::get('payment-marchent-type-list/{key}', 'PaymentGatewayController@getPaymentGatewayPaymentMarchentTypeList')->name('site-payment-gateway-payment-marchent-type-list-by-payment-method-key');
        Route::post('add', 'PaymentGatewayController@create')->name('site-payment-gateway-create');
        Route::post('update', 'PaymentGatewayController@update')->name('site-payment-gateway-update');
        Route::delete('delete/{id}', 'PaymentGatewayController@delete')->name('site-payment-gateway-delete');

        Route::get('edu-payment-method-list', 'PaymentGatewayController@eduPaymentMethodList')->name('edut-payment-method-list-for-site');
        Route::get('bkash-payment/{invoice_no?}/{total_amount?}', 'PaymentGatewayController@testingpaymentpage')->name('edu-payment-bkash-payment-for-site');
        Route::post('get-token', 'PaymentGatewayController@getToken')->name('get-token-for-edu-payment');
//            Route::post('get-bkash-token', 'SiteStudentTransactionController@getBkashToken')->name('get-bkash-token');
//            Route::post('get-config-file', 'SiteStudentTransactionController@getConfigFile')->name('get-config-file');
        Route::get('create-bkash-payment', 'PaymentGatewayController@createBkashPayment')->name('create-bkash-payment-for-edu-payment');
        Route::get('execute-bkash-payment', 'PaymentGatewayController@executeBakashPayment')->name('execute-bkash-payment-for-edu-payment');



    });

    Route::group(['namespace' => 'Payment', 'prefix' => 'invoice'], function () {
        Route::get('master', 'SiteInvoiceController@index')->name('site-invoice-master');

        Route::get('create', 'SiteInvoiceController@index')->name('site-invoice-create');
        Route::post('create', 'SiteInvoiceController@create')->name('site-invoice-create');
        Route::get('edit/{id}', 'SiteInvoiceController@index')->name('invoice-edit');
        Route::post('update', 'SiteInvoiceController@update')->name('site-invoice-update');
        Route::get('delete/{id}', 'SiteInvoiceController@deleteSiteInvoice')->name('site-invoice-delete');

        Route::get('get-list', 'SiteInvoiceController@getInvoiceList')->name('site-invoice-get-invoice-list');
        Route::post('get-list-by-site', 'SiteInvoiceController@getInvoiceListBySite')->name('site-invoice-get-invoice-list-by-site');
        Route::get('get-invoice-details/{id}', 'SiteInvoiceController@getInvoiceDetailsForPayment')->name('esite-invoice-get-the-invoice-details-for-payment');
        Route::get('get-data-for-new-invoice-by-site/{type}/{site}', 'SiteInvoiceController@getDataForNewInvoiceBySite')->name('site-invoice-get-data-for-new-invoice-by-site');
        Route::post('get-invoice-by-search', 'SiteInvoiceController@getInvoiceBySearch')->name('site-invoice-get-invoice-by-search');

        Route::get('pdf-report/{id}', 'SiteInvoiceController@getInvoicePdfReport')->name('site-invoice-get-pdf-report');

    });
});

//===========================================================Edu Payment Get Way For Site=====================================================================

Route::group(['namespace' => 'Edu', 'prefix' => 'edu'], function () {
    Route::group(['namespace' => 'SitePayment', 'prefix' => 'site-payment'], function () {

        Route::get('edu-payment-method-list', 'SitePaymentController@eduPaymentMethodList')->name('edut-payment-method-list-for-site');
        Route::get('bkash-payment/{invoice_no?}/{total_amount?}', 'SitePaymentController@paymentPage')->name('edu-payment-bkash-payment-for-site');
        Route::post('get-token', 'SitePaymentController@getToken')->name('get-token-for-edu-payment');
        Route::get('create-bkash-payment', 'SitePaymentController@creatBkashPayment')->name('create-bkash-payment-for-edu-payment');
        Route::get('execute-bkash-payment', 'SitePaymentController@executeBakashPayment')->name('execute-bkash-payment-for-edu-payment');

    });
});

//===========================================================Website setting View=====================================================================

Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {
    Route::group(['namespace' => 'Web', 'prefix' => 'web'], function () {
        Route::group(['prefix' => 'setting'], function () {
            Route::get('master', 'WebSiteSettingController@master')->name('site-web-setting-master');
            Route::get('about/list', 'WebSiteSettingController@master')->name('site-web-setting-about-list');
            Route::get('about/new', 'WebSiteSettingController@master')->name('site-web-setting-about-new');
            Route::get('about/edit/{id}', 'WebSiteSettingController@master')->name('site-web-setting-about-edit');
            Route::get('website-video/new', 'WebSiteSettingController@master')->name('site-web-setting-video-new');
            Route::get('website-video/list', 'WebSiteSettingController@master')->name('site-web-setting-video-list');
            Route::get('website-video/edit/{id}', 'WebSiteSettingController@master')->name('site-web-setting-video-edit');
            Route::get('message/list', 'WebSiteSettingController@master')->name('site-web-setting-message-list');
            Route::get('message/new', 'WebSiteSettingController@master')->name('site-web-setting-message-new');
            Route::get('message/edit/{id}', 'WebSiteSettingController@master')->name('site-web-setting-message-edit');
            Route::get('class-room/list', 'WebSiteSettingController@master')->name('site-web-setting-class-room-list');
            Route::get('class-room/new', 'WebSiteSettingController@master')->name('site-web-setting-class-room-new');
            Route::get('class-room/edit/{id}', 'WebSiteSettingController@master')->name('site-web-setting-class-room-edit');
            Route::get('event/new', 'WebSiteSettingController@master')->name('site-web-setting-event-new');
            Route::get('event/edit/{id}', 'WebSiteSettingController@eventEdit')->name('api-website-event-edit-event');
            Route::get('web-menu/{parent?}', 'WebSiteSettingController@webMenu')->name('site-web-setting-web-menu');
            Route::get('citizen-charter', 'WebSiteSettingController@master')->name('site-web-setting-citizen-charter');
            Route::get('citizen-charter/new', 'WebSiteSettingController@master')->name('site-web-setting-citizen-charter-new');

            Route::get('social-icon/{parent?}', 'WebSiteSettingController@master')->name('site-web-setting-social-icon-set');
            Route::post('social-icon-setting', 'WebSiteSettingController@socialIconSetting')->name('site-web-setting-social-icon-setting');
            Route::get('get-social-icon-setting', 'WebSiteSettingController@getSocialIconSetting')->name('get-social-icon-setting');


            Route::get('header-design/{parent?}', 'WebSiteSettingController@master')->name('site-web-setting-header-design-set');
            Route::get('get-web-header-design', 'WebSiteSettingController@getWebHeaderDesign')->name('get-web-header-design');
            Route::post('create-update-web-header-design', 'WebSiteSettingController@createUpdateWebHeaderDesign')->name('create-update-web-header-design');

            Route::get('get-current-site-info', 'WebSiteSettingController@getCurrentSiteInfo'); //->name('get-web-header-design');

//            Route::get('website-video', 'WebSiteSettingController@master')->name('site-web-setting-video');
//            Route::get('website-video/list', 'WebSiteSettingController@master')->name('site-web-setting-video-list');

        });
    });

});

//===========================================================student payment report =====================================================================

Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {
    Route::group(['namespace' => 'Student', 'prefix' => 'student'], function () {
        Route::group(['namespace' => 'Report', 'prefix' => 'report'], function () {
            Route::get('payment-master', 'PaymentReportController@master')->name('site-student-report-payment-report-master');
            Route::get('general-payment-report-view', 'PaymentReportController@index')->name('site-student-report-general-payment-report-view');
            Route::get('financial-statement-view', 'PaymentReportController@index')->name('site-student-report-financial-statement-view');
            Route::get('general-payment-list', 'PaymentReportController@getGeneralPaymentList')->name('site-student-report-general-payment-list');
            Route::get('financial-statement-list', 'PaymentReportController@getStudentFinancialStatement')->name('site-student-report-financial-statement-list');
            Route::get('financial-statement-ledger-pdf/{class_id}/{start_date}/{end_date}', 'PaymentReportController@getStudentFinancialLedgerPDF')->name('site-student-financial-statement-ledger-pdf');

            Route::get('academic-class-list', 'PaymentReportController@getAcademicClassList')->name('site-student-report-academic-class-list');
//            Route::get('demand-slip-fee-details/{demand_slip_no}', 'PaymentReportController@getDemandSlipFeeDetails')->name('site-student-report-demand-slip-fee-details');
//            Route::get('payment-slip-pdf-show/{id}', 'PaymentReportController@getGetPaymentSlip')->name('site-student-report-payment-slip');

        });

    });

});

//===========================================================Website setting=API====================================================================

Route::group(['namespace' => 'Api', 'prefix' => 'api'], function () {
    Route::group(['namespace' => 'Site', 'prefix' => 'site'], function () {
        Route::group(['namespace' => 'Web', 'prefix' => 'web'], function () {
            Route::group(['namespace' => 'Setting', 'prefix' => 'setting'], function () {

                Route::group(['namespace' => 'Video', 'prefix' => 'video'], function () {
                    Route::get('get-video-list-with-pagination', 'VideoController@getVideoListWithPagination')->name('api-website-setting-video-get-video-list-with-pagination');
                    Route::get('get-video-details/{id}', 'VideoController@getVideoDetails')->name('api-website-setting-video-get-video-details');
                    Route::post('create', 'VideoController@create')->name('api-website-setting-video-create');
                    Route::post('update', 'VideoController@update')->name('api-website-setting-video-update');
                    Route::post('delete/{id}', 'VideoController@delete')->name('api-website-setting-video-delete');

                });
                Route::group(['prefix' => 'classroom'], function () {
                    Route::get('get-active-subject-list/{year_id}/{department_id}/{class_id}', 'ClassRoomController@getSubjectList')->name('api-website-setting-get-subject-list');
                    Route::post('add', 'ClassRoomController@createClassRoom')->name('api-website-setting-classroom-create');
                    Route::get('get-class-room-list-with-pagination', 'ClassRoomController@getClassRoomList')->name('api-website-setting-classroom-list');
                    Route::get('get-class-room-details/{id}', 'ClassRoomController@getClassRoomDetails')->name('api-website-setting-classroom-get-class-room-details');
                    Route::post('update', 'ClassRoomController@updateClassRoom')->name('api-website-setting-classroom-update');
                    Route::post('delete/{id}', 'ClassRoomController@deleteClassRoom')->name('api-website-setting-classroom-delete');

                    Route::get('class-lesson-view', 'ClassRoomController@index')->name('api-website-setting-class-lesson-view');
                    Route::get('class-lesson/new', 'ClassRoomController@index')->name('api-website-setting-class-lesson-view');;
                    Route::get('class-lesson/edit/{id}', 'ClassRoomController@index');
                    Route::get('get-active-subject-list-by-user/{year_id}/{department_id}/{class_id}', 'ClassRoomController@getSubjectListByUser')->name('api-website-setting-get-subject-list-by-user');
                    Route::get('get-class-lesson-list-with-pagination', 'ClassRoomController@getClassLessonList')->name('api-website-setting-class-lesson-list');
                    Route::post('add-lesson', 'ClassRoomController@createClassLesson')->name('api-website-setting-class-lesson-create');
                    Route::post('update-lesson', 'ClassRoomController@updateClassLesson')->name('api-website-setting-class-lesson-update');
                    Route::post('lesson-publish-status', 'ClassRoomController@updateClassLessonPublishStatus')->name('api-website-setting-class-lesson-publish-status-update');

                    Route::get('api-site-employee-get-dept-class-subject-list-for-lesson-replicate/{id}', 'ClassRoomController@apiSiteEmployeeGetDeptClassSubjectListForLessonReplicate')->name('api-site-employee-get-dept-class-subject-list-for-lesson-replicate');
                    Route::post('api-site-employee-lecture-replicate-create', 'ClassRoomController@apiSiteEmployeeLectureReplicateCreate')->name('api-site-employee-lecture-replicate-create');


                    Route::post('api-lecture-feedback-save', 'ClassRoomController@apiLectureFeedbackSave')->name('api-lecture-feedback-save');
                    Route::post('get-lecture-feedback', 'ClassRoomController@getLectureFeedback')->name('get-lecture-feedback');
                    Route::post('delete-lecture-feedback', 'ClassRoomController@deleteLectureFeedback')->name('delete-lecture-feedback');

                    Route::post('lecture-feedback-reply-save', 'ClassRoomController@lectureFeedbackReplySave')->name('lecture-feedback-reply-save');
                    Route::post('delete-lecture-feedback-reply', 'ClassRoomController@deleteLectureFeedbackReply')->name('delete-lecture-feedback-reply');
//                    Route::post('get-lecture-feedback-reply', 'ClassRoomController@getLectureFeedbackReply')->name('get-lecture-feedback-reply');

                });

            });
        });

    });
});






