<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title><?php echo e($report_tittle); ?></title>

    <style>

        @page  {
            margin: 100px 25px;
        }

        /*       header {
                   position: fixed;
                   top: -60px;
                   left: 0px;
                   right: 0px;
                   background-color: lightblue;
                   height: 50px;
               }
               */
        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("<?php echo e(public_path()); ?>/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {
            background-color: #dcdcdc;
            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
            font-weight: bold;
        }

        .data-table td {
            border: 1px solid #999999;
            text-align: center;
        }

        .image {
            width: 60px;
            height: 60px;
            border-radius: 10px;
        }

    </style>

</head>
<body>

<?php echo $__env->make('default.site.layout.pdf-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<header>
</header>

<main>

    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <td style="width: 2px">S/L</td>
            <td>Name</td>


            <?php if($img_status): ?>
                <td>Pic</td>
            <?php endif; ?>

            <td>User Id</td>
            <td>Shift</td>
            <td>Joining Date</td>
            <td>Contact No.</td>
            <td>Email</td>

        </tr>
        </thead>


        <tbody>
        <?php $__currentLoopData = $emp_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <tr>
                <td><?php echo e($key +1); ?></td>
                <td>
                    <nobr>  <?php echo e($value->full_name ?? 'N/A'); ?></nobr>
                    <br>
                    <span style="font-size: 9px">  ( <?php echo e($value->activeHistory->designation->name ?? 'N/A'); ?> )</span>
                </td>

                <?php if($img_status): ?>
                    <td>
                        <?php if(file_exists(public_path("uploads").'/'.$value->latestPhoto->name)): ?>
                            <img class="image"
                                 src="<?php echo e(asset("uploads").'/'.$value->latestPhoto->name  ?? 'image-not.png'); ?>">
                        <?php else: ?>
                            <img class="image"
                                 src="<?php echo e(asset("uploads").'/image-not.png'); ?>">
                        <?php endif; ?>
                    </td>
                <?php endif; ?>


                <td><?php echo e($value->username); ?></td>
                <td>
                    <?php $__currentLoopData = $value->empShifts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key1 =>$shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if((count($value->empShifts)-1)>$key1): ?>
                            <?php echo e($shift->shift->shift_name ?? '--'); ?>,
                        <?php else: ?>
                            <?php echo e($shift->shift->shift_name ?? '--'); ?>

                        <?php endif; ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
                <td>
                    <?php if($value->dept_join_date): ?>
                        <nobr>  <?php echo e(date('M d Y', strtotime($value->dept_join_date))); ?></nobr>
                    <?php else: ?>
                        --
                    <?php endif; ?>

                </td>
                <td>
                    <?php echo e($value->contact_number); ?>

                </td>
                <td>
                    <?php echo e($value->email); ?>

                </td>


            </tr>


        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>


    </table>
</main>
<footer>
    <?php echo $__env->make('default.site.layout.pdf-footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</footer>
</body>


<style>
    footer .pagenum:before {
        content: counter(page);
    }

    @page  {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/site/employee/enrolment/report/employee-report.blade.php ENDPATH**/ ?>