<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Academic Transcript</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      /* margin: 5px; */
      color: #333;
    }
    .transcript {
      border: 2px solid #0c4b75;
      padding: 20px;
    }
    .header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      border-bottom: 2px solid #0c4b75;
      background-color: #dab15fb6 !important;
    }
   
    .header h1 {
      text-align: center;
      font-size: 22px;
      margin: 0 auto;
      color: #0c4b75;
    }
    .student-details, .performance, .results {
      margin-bottom: 10px;
    }
    .student-details table,
    .performance table,
    .results table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    .student-details td,
    .performance th, .performance td,
    .results th, .results td {
      border: 1px solid #ccc;
      padding: 6px;
      font-size: 13px;
    }
   

    .student-details td, student-details th{
      text-align: left !important;
    }
  
    .performance td {
      background: #f9f9f9;
      padding: 2px !important;
      /* font-size: 10px !important */
    }
    .results th {
      background: #dab15fb6;
      color: #000;
      text-align: center;
    }
    .results td {
      text-align: center;
      background: #E3F0EE;
    }
    .total-summary table td, .total-summary table th  {
      font-size: 12px !important;
    }
    .note {
      font-size: 11px;
      margin-top: 10px;
    }

    .signature{
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }


    .page-break {
      page-break-before: always; /* start new page */
    }
  </style>
</head>
<body>
    <?php $__currentLoopData = $result_list_array; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  <div class="transcript">
  <div class="cademic-transcript">
    <!-- Header -->
    <div style="background-color: #dab15fb6; padding-top: 10px; border:2px solid #0c4b75;">
      <div class="header">
        <img style="width:80px; height:70px; margin-top:5px" src="<?php echo public_path($site_info->site_logo); ?>">
        <h1 style="padding-top:20px">ACADEMIC TRANSCRIPT</h1>
      </div>
    </div>

    <!-- Student Details -->
    <div class="results student-details">
      <h3 style="text-align: center">Student Details</h3>
      <table>
        <tr>
          <td><b>Student's Name:</b></td>
          <td><?php echo e($item['student_history']['student']['full_name']); ?></td>
          <td><b>ID No:</b></td>
          <td><?php echo e($item['student_history']['student']['username']); ?></td>
        </tr>
         <tr>
          <td><b>Class:</b></td>
          <td><?php echo e($item['student_history']['stClass']['class_name']); ?></td>
          <td><b>Section:</b></td>
          <td><?php echo e($item['student_history']['section']?$item['student_history']['section']['section_name']:''); ?></td>
        </tr>
       <tr>
          <td><b>Examination Term:</b></td>
          <td><?php echo e($item['result_type_name']); ?></td>
          <td><b>Session:</b></td>
          <td><?php echo e($item['student_history']['session']?$item['student_history']['session']['session_name']:''); ?></td>
        </tr>
      </table>
    </div>

    <!-- Performance Level -->
    <div class="results performance">
      <h3 style="text-align: center">Performance Level</h3>
      <table>
        <tr>
          <th style="width: 100px">Performance</th>
          <th style="width: 50x">Grades</th>
          <th style="width: 80px">Mark</th>
          <th>Description</th>
        </tr>
          <?php $__currentLoopData = $result_system_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $systemkey=>$opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                  <td style="text-align:left"><?php echo e(($opt['performance'])); ?></td>
                  <td><?php echo e($opt['academicResultSystem']['name']); ?></td>
                  <td><?php echo e(floor($opt['number_from'])); ?>-<?php echo e(floor($opt['number_to'])); ?></td>
                  <td style="text-align:left"><?php echo e($opt['description']); ?></td>
              </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </table>
    </div>

    <!-- Subject Based Result -->
    <div class="results">
      <h3 style="text-align: center">Subject Based Result</h3>
      <table>
        <tr>
          <th>#</th>
          <th>Subject</th>
          <th>CT+CPE+P(50)</th>
          <th>Final(50)</th>
          <th>TOTAL(50)</th>
          <th>Progress Bar</th>
          <th>Grade</th>
        </tr>

          <?php $__currentLoopData = $item['subject_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keys=>$items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($keys+1); ?></td>
            <td style="text-align: left"><?php echo e($items->exam_dependent_academic_subject); ?></td>
            <td><?php echo e($items->obtain_raw_total_marks_in_class_test); ?></td>
            <td><?php echo e($items->obtain_raw_total_marks_in_term_exam); ?></td>
            <td><?php echo e($items->obtain_subject_total_marks); ?></td>
            <td>
              <div style="border: #70707081 1px solid;">
                <div class="w3-grey" style="background-color: #43705aa1; height:15px;width:<?php echo e($items->subject_marks_percentage); ?>%"></div>
              </div>
            </td>
            <td><?php echo e($items->subject_grade); ?></td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       
      </table>
    </div>

    <p class="note" style="width: 100%; height: auto; background: #cdd4d483; padding: 10px; text-align: center;">
      CT = Class Test, CPE = Class Performance and Engagement, P = Project
    </p>
    <div class="results total-summary">
    <table>
        <tr>
            <td><b>Result Summary</b></td>
            <th>Total Marks</th>
            <td><?php echo e($item['sum_of_raw_total_marks']); ?></td>
            <th>Obtained</th>
            <td><?php echo e($item['sum_of_obtain_total_marks_for_show']); ?></td>
            <th>Marks %</th>
            <td><?php echo e($item['sum_of_obtain_total_percent_for_show']); ?></td>
            <th>Grade</th>
            <td><?php echo e($item['grade']); ?></td>
        </tr>
     
    </table>
    </div>
    </div>

    
    <div class="page-break"></div>

    <div class="pregress-report">
      <!-- Space -->
    <div style="height:10px"></div>
      <!-- Header -->
    <div style="background-color: #dab15fb6; padding-top: 10px; border:2px solid #0c4b75;">
      <div class="header" style="margin-top: 10px">
        <img style="width:80px; height:70px; margin-top:5px" src="<?php echo public_path($site_info->site_logo); ?>">
        <h1 style="padding-top:20px">PROGRESS REPORT</h1>
      </div>
    </div>

    <?php
      $academic_days = $item['academic_days']??0;
      $present_days = $item['present_days']??0;
      $absent_days = $item['absent_days']??0;
      if($academic_days>0){
        $present_percentage = ($absent_days/$present_days)*100;
      }else{
        $present_percentage = 0;
      }
    ?>

     <!-- Attendance Summary -->
    <div class="results">
      <h3 style="text-align: center">Attendance Summary</h3>
      <table>
        <tr>
          <th>Working Days</th>
          <th>Present</th>
          <th>Absent</th>
          <th colspan="2">Progress Bar</th>
        </tr>
        <tr>
          <td><?php echo e($item['academic_days']??0); ?></td>
          <td><?php echo e($item['present_days']??0); ?></td>
          <td style="color:red"><?php echo e($item['absent_days']??0); ?></td>
          <td colspan="2">
             <div style="border: #4d4b4b81 1px solid; background-color: rgb(204, 121, 121);">
              <div class="w3-grey" style="background-color: #7E9F91; height:15px;width:<?php echo e($present_percentage); ?>%"></div>
            </div>
          </td>
        </tr>
      </table>
    </div>

    <?php 
      $punctuality        =     $item['punctuality']*10;
      $obedience          =     $item['obedience']*10;
      $attentiveness      =     $item['attentiveness']*10;
      $classroom_behaviour=     $item['classroom_behaviour']*10;
      $commitment         =     $item['commitment']*10;
      $cleanliness        =     $item['cleanliness']*10;
      $handwriting        =     $item['handwriting']*10;
      $homework           =     $item['homework']*10;
      $classwork          =     $item['classwork']*10;
    ?>
     <!-- Student Details -->
    <div class="results">
      <h3 style="text-align: center">Performance Summary</h3>
      <table>
        <tr>
          <th>Performance on</th>
          <th>Marks</th>
          <th>Progress Bar</th>
        </tr>
        <tr>
          <td style="text-align: left">Punctuality</td>
          <td style="text-align: center"><?php echo e($item['commitment']); ?></td>
          <td>
             <div style="border: #4d4b4b81 1px solid;">
              <div class="w3-grey" style="background-color: #7E9F91; height:15px;width:<?php echo e($punctuality); ?>%"></div>
            </div>
          </td>
        </tr>
       <tr>
          <td style="text-align: left">Obedience</td>
          <td style="text-align: center"><?php echo e($item['obedience']); ?></td>
          <td>
             <div style="border: #4d4b4b81 1px solid;">
              <div class="w3-grey" style="background-color: #7E9F91; height:15px;width:<?php echo e($obedience); ?>%"></div>
            </div>
          </td>
        </tr>
         <tr>
          <td style="text-align: left">Attentiveness</td>
          <td style="text-align: center"><?php echo e($item['attentiveness']); ?></td>
          <td>
             <div style="border: #4d4b4b81 1px solid;">
              <div class="w3-grey" style="background-color: #7E9F91; height:15px;width:<?php echo e($attentiveness); ?>%"></div>
            </div>
          </td>
        </tr>
        <tr>
          <td style="text-align: left">Classroom behaviour</td>
          <td style="text-align: center"><?php echo e($item['classroom_behaviour']); ?></td>
          <td>
             <div style="border: #4d4b4b81 1px solid;">
              <div class="w3-grey" style="background-color: #7E9F91; height:15px;width:<?php echo e($classroom_behaviour); ?>%"></div>
            </div>
          </td>
        </tr>
         <tr>
        <td style="text-align: left">Commitment</td>
        <td style="text-align: center"><?php echo e($item['commitment']); ?></td>
        <td>
           <div style="border: #4d4b4b81 1px solid;">
            <div class="w3-grey" style="background-color: #7E9F91; height:15px;width:<?php echo e($commitment); ?>%"></div>
          </div>
        </td>
      </tr>
      <tr>
        <td style="text-align: left">Cleanliness</td>
        <td style="text-align: center"><?php echo e($item['cleanliness']); ?></td>
        <td>
           <div style="border: #4d4b4b81 1px solid;">
            <div class="w3-grey" style="background-color: #7E9F91; height:15px;width:<?php echo e($cleanliness); ?>%"></div>
          </div>
        </td>
      </tr>
      <tr>
        <td style="text-align: left">Handwriting</td>
        <td style="text-align: center"><?php echo e($item['handwriting']); ?></td>
        <td>
           <div style="border: #4d4b4b81 1px solid;">
            <div class="w3-grey" style="background-color: #7E9F91; height:15px;width:<?php echo e($handwriting); ?>%"></div>
          </div>
        </td>
      </tr>
    <tr>
        <td style="text-align: left">Homework</td>
        <td style="text-align: center"><?php echo e($item['homework']); ?></td>
        <td>
           <div style="border: #4d4b4b81 1px solid;">
            <div class="w3-grey" style="background-color: #7E9F91; height:15px;width:<?php echo e($homework); ?>%"></div>
          </div>
        </td>
      </tr>
      <tr>
        <td style="text-align: left">Classwork</td>
        <td style="text-align: center"><?php echo e($item['classwork']); ?></td>
        <td>
           <div style="border: #4d4b4b81 1px solid;">
            <div class="w3-grey" style="background-color: #7E9F91; height:15px;width:<?php echo e($classwork); ?>%"></div>
          </div>
        </td>
      </tr>
      </table>

    </div>

      <!-- Comments Summary -->
    <div class="results">
      <table>
        <tr>
          <th colspan="2" style="text-align: left">Comments:</th>
        </tr>
        <tr>
          <td style="width:150ox"><b>Islamic</b></td>
          <td style="min-height:100px; height:60px; text-align: justify;">
            <?php echo e($item['comment']); ?>

          </td>
        </tr>
        <tr>
          <td style="width:150ox"><b>General</b></td>
          <td style="min-height:100px; height:60px; text-align: justify;">
             <?php echo e($item['comment_two']); ?>

          </td>
        </tr>
      </table>
    </div>
   

    <div>
      <table style="width: 100%; border-collapse: collapse; margin-top: 50px;">
        <tr>
          <td style="text-align: center; width:33.33%">
            <div style="margin-top: 30px">
              <?php if($resultSetting['left_designation']): ?>
                <?php if($resultSetting['left_signature']): ?>
                    <img style="text-align: center;" width="80px" height="35px;"
                        src="<?php echo public_path($resultSetting['left_signature']); ?>">
                <?php endif; ?>
                <br>
              <span>..............................</span><br>
              <span><?php echo e($resultSetting['left_designation']); ?></span>
              <?php endif; ?>
            </div>
          </td>
          <td style="text-align: center; width:33.33%">
            <div style="margin-top: 30px">
              <?php if($resultSetting['center_designation']): ?>

               <?php if($resultSetting['center_signature']): ?>
                    <img style="text-align: center;" width="80px" height="35px;"
                        src="<?php echo public_path($resultSetting['center_signature']); ?>">
                <?php endif; ?>
                <br>
              <span>..............................</span><br>

              <span><?php echo e($resultSetting['center_designation']); ?></span>
              <?php endif; ?>
            </div>
          </td>
          <td style="text-align: center; width:33.33%">
            <div style="margin-top: 30px">
              <?php if($resultSetting['right_designation']): ?>
                <?php if($resultSetting['right_signature']): ?>
                    <img style="text-align: center;" width="80px" height="35px;"
                        src="<?php echo public_path($resultSetting['right_signature']); ?>">
                <?php endif; ?>
                <br>
              <span>..............................</span><br>
              <span><?php echo e($resultSetting['right_designation']); ?></span>
              <?php endif; ?>
            </div>
          </td>
         
        </tr>
      </table>
    </div>

  </div>
  </div>
   
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>
</html>
<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site/result/result_report/site-base-multiple-student-result-detail-report-nine-cambridge.blade.php ENDPATH**/ ?>