<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($title_view); ?></title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }
        .slot-table td {
            border: 1px solid #999999;
            border-width: thin;
            border-spacing: 2px;
            /*border-style: none;*/

        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: middle;
            padding-left: 20px;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }


    </style>

</head>
<body>
<?php echo $__env->make('default.site.layout.pdf-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<table width="100%">
    <tr>
        <td align="left"> <b>StudentID:</b> <?php echo e($data['student_detail']['username']); ?></td>
        <td align="left"><b> Student Name:</b>  <?php echo e($data['student_detail']['std_name']); ?></td>
        <td align="left"><b> Roll:</b>  <?php echo e($data['student_detail']['roll']); ?></td>
    </tr>
    <tr>
        <td align="left"> <b>Version:</b> <?php echo e($data['student_detail']['version_name']); ?></td>
        <td align="left"> <b>Year:</b> <?php echo e($data['student_detail']['year_name']); ?></td>
        <td align="left"> <b>Shift:</b> <?php echo e($data['student_detail']['shift_name']); ?></td>
    </tr>
    <tr>
        <td align="left"><b> Class:</b>  <?php echo e($data['student_detail']['class_name']); ?></td>
        <td align="left"><b> Group:</b>  <?php echo e($data['student_detail']['group_name']); ?></td>
        <td align="left"> <b>Section:</b>  <?php echo e($data['student_detail']['section_name']); ?></td>
    </tr>
    <tr>
        <td align="left"><b> Category:</b>  <?php echo e($data['student_detail']['category_name']); ?></td>
        <td align="left"><b> Session:</b>  <?php echo e($data['student_detail']['session_name']); ?></td>
        <td align="left"><b> Type:</b>  <?php echo e($data['student_detail']['type_name']); ?></td>
    </tr>
    <tr>
        <td align="left"><b> Contact No:</b>  <?php echo e($data['student_detail']['contact_number']); ?></td>
    </tr>

</table>

<table class="slot-table" width="100%" cellspacing="0" border="0" style="margin-top: 10px">
    <thead style="background-color:  #b3dbff;">
    <tr>

        <td align="center" style="padding:2px;"><b>SL</b></td>
        <td align="center" style="padding:2px;"><b>Invoice No</b></td>
        <td align="center" style="padding:2px;"><b>Tran. Type</b></td >
        <td align="center" style="padding:2px;"><b>Paid By</b></td >
        
        <td align="center"><b>Created Date</b></td>
        <td style="padding:2px;" class="amount-right"><b>Waiver</b></td>
        <td style="padding:2px;" class="amount-right"><b>Fine</b></td>
        <td style="padding:2px;" class="amount-right"><b>Debit</b></td>
        <td style="padding:2px;" class="amount-right"><nobr><b>Cradit</b></nobr></td>
        <td  style="padding:2px;" class="amount-right"><nobr><b>Due</b></nobr></td>
    </tr>
    </thead>
    <tbody>


    <?php ($sl=1); ?>
    <?php $__currentLoopData = $data['payment_array']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <tr>
            <td align="center" class="text-right" style="padding:2px;"><nobr><?php echo e($key+1); ?></nobr></td>
            <td align="center" style="padding:2px;"><?php echo e($value['invoice_no']); ?></td>
            <td align="center" style="padding:2px;"><?php echo e($value['tran_type']); ?></td>
            <td align="center" style="padding:2px;"><?php echo e($value['paid_by']); ?> 
                <?php if($value['paid_by']=='cash'): ?> 
                   , <?php echo e($value['collected_by']); ?>

                <?php endif; ?>
            </td>
            
            <td align="center" style="padding:2px;"><?php echo e($value['created_date']); ?></td>
            <td class="amount-right" style="padding:2px;"><?php echo e($value['waiver_amount']); ?></td> 
            <td class="amount-right" style="padding:2px;"><?php echo e($value['fine_amount']); ?></td> 
            <td class="amount-right" style="padding:2px;"><?php echo e($value['debit_amount']); ?></td>
            <td class="amount-right" style="padding:2px;"><?php echo e($value['credit_amount']); ?></td>
            <td class="amount-right" style="padding:2px;"><?php echo e($value['total_due_mount']); ?></td>
          
        </tr>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    </tbody>
    <tfoot  style="background-color:  #e6e6e6;">
    <tr>
        <td colspan="5" style="" class="amount-right">Total</td>
        <td class="amount-right" style=""><?php echo e($data['total_waiver_amount']); ?></td>
        <td class="amount-right" style=""><?php echo e($data['total_fine_amount']); ?></td>
        <td class="amount-right" style=""><?php echo e($data['total_debit_amount']); ?></td>
        <td class="amount-right" style=""><?php echo e($data['total_credit_amount']); ?></td>
        <td class="amount-right" style=""><?php echo e($data['total_due_amount']); ?></td>
    </tr>
    </tfoot>

</table>

<table width="100%">
    <br>
    <tr>
        <td align="left">
            
        </td>
    </tr>

</table>

</body>



<style>
    @page  {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        border:1px dotted black;
    }

    .table_tr {
        /* background-color: #e2e6e9 */
    }

</style>
</html>
<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site/student-fee/report/student-wise-slip-and-payment-history-report-pdf.blade.php ENDPATH**/ ?>