<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    

    <style>
        /* Base table styles */
        table {
            border-collapse: collapse;
            font-size: 12px;
            width: 100%;
            border: 1px solid black;
            /* outer border */
        }

        /* All table header and data cells */
        .resultlist th,
        .resultlist td,
        .table-bordered th,
        .table-bordered td {
            border: 1px solid black;
            text-align: center;
            font-size: 14px;
            height: 22px;
        }

        .resultlist th {
            height: 20px;
        }

        /* Remove background color from all table headers */
        thead th {
            background-color: transparent !important;
        }

        /* Signature tables: no border on cells */
        .signature tr th {
            text-align: center;
            border: none;
        }

        /* Margin for div wrappers */
        .my-div {
            margin-top: 5px;
        }

        /* Group title box */
        .text-center h4 {
            display: inline-block;
            border-bottom: 1px solid #000;
            padding: 5px 10px;
            margin-top: 29px;
            text-align: center;
        }

        /* Responsive overflow for tables */
        .table-responsive {
            overflow-x: auto;
        }

        /* Header container */
        .headerco {
            width: 100%;
            margin-bottom: 10px;
        }

        /* Header title styling */
        .header-title span {
            font-size: 12px;
            display: block;
            margin-bottom: 5px;
        }

        /* Logo image styling */
        .logo-img {
            width: 70px;
            height: 70px;
            padding-top: 0;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }

        /* Body margin */
        body {
            margin: 10px 10px 10px 20px;
        }

        /* No border on specific tables/cells */
        .no-border,
        .no-border * {
            border: none !important;
        }

        /* Logo image */
        .logo-img {
            width: 70px;
            height: 70px;
            display: block;
            margin: auto;
        }

        /* Layout for logo cell and title */
        .logo-cell {
            width: 10%;
            text-align: left;
        }

        .title-cell {
            width: 90%;
            text-align: center;
        }

        .site-name {
            font-size: 25px;
        }

        .sub-text {
            font-size: 15px;
        }

        /* Title section */
        .header-title span {
            font-size: 12px;
            display: block;
            margin-bottom: 5px;
        }

        /* Signature section layout */
        .signature-section {
            margin-top: 70px;
        }

        .left-align {
            text-align: left;
        }

        /* Page size for printing */
        @page  {
            size: 22cm 36cm portrait;
            margin: 1px 0;
        }
    </style>

</head>

<body>

    
    <div class="headerco">
        <table class="no-border">
            <tr>
                <td class="logo-cell">
                    <img class="logo-img" src="<?php echo public_path('img/site_group/logo/' . $siteGroup['group_logo']); ?>">
                </td>
                <td class="title-cell">
                    <span class="site-name"><?php echo e($siteGroup['name']); ?></span> <br>
                    <?php if($site_name): ?>
                        <span class="sub-text"><?php echo e($site_name); ?></span> <br>
                    <?php else: ?>
                        <span class="sub-text">Education Department</span> <br>
                        <span class="sub-text">Inter College</span> <br>
                    <?php endif; ?>
                    <span class="sub-text"><?php echo e($sheet_info['result_name']); ?> 2025</span>
                </td>
            </tr>
        </table>
    </div>

    
    <div class="header-title">
        <span><?php echo e(strip_tags($report_tittle2)); ?></span>
    </div>

    <div>

        
        <?php if(!empty($global_result_statistics) && count($global_result_statistics) > 0): ?>
            <div class="my-div">
                <table width="100%" style="margin-bottom: 3px; border: none;">
                    <tr>
                        <td style="text-align: center; font-size: 20px; padding: 10px;">
                            <b>Total Statistics </b>
                        </td>
                    </tr>
                </table>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Total : <?php echo e($global_result_statistics['total_student']); ?></th>
                            <th>Present : <?php echo e($global_result_statistics['total_present']); ?></th>
                            <th>Absent : <?php echo e($global_result_statistics['total_absent']); ?></th>
                            <th>Pass : <?php echo e($global_result_statistics['total_passed']); ?></th>
                            <th>Fail : <?php echo e($global_result_statistics['total_failed']); ?></th>
                            <th>Percentage : <?php echo e($global_result_statistics['pass_percentage']); ?>%</th>
                        </tr>
                    </thead>
                </table>
            </div>
        <?php endif; ?>

        
        <?php $__currentLoopData = $group_base_result_array; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group_array): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
            <table width="100%" style="margin-bottom: 3px; border: none;">
                <tr>
                    <td style="text-align: center; font-size: 20px; padding: 10px;">
                        <b><?php echo e($group_array['class_group_name'] ?? ''); ?></b>
                    </td>
                </tr>
            </table>


            <div class="my-div">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Total : <?php echo e($group_array['total_student'] ?? 0); ?></th>
                            <th>Present : <?php echo e($group_array['total_present'] ?? 0); ?></th>
                            <th>Absent : <?php echo e($group_array['total_absent'] ?? 0); ?></th>
                            <th>Pass : <?php echo e($group_array['total_passed'] ?? 0); ?></th>
                            <th>Fail : <?php echo e($group_array['total_failed'] ?? 0); ?></th>
                            <th>Percentage : <?php echo e($group_array['pass_percentage'] ?? 0); ?>%</th>
                        </tr>
                    </thead>
                </table>
            </div>

            
            <div class="my-div">
                <b>Passed:
                    <?php echo e($group_array['passed_student_count'] ?? count($group_array['passed_student_rolls'] ?? [])); ?></b>
                <div style="padding: 10px; border: 1px solid #050505;">
                    <?php $__currentLoopData = $group_array['passed_student_rolls'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($items['roll'] ?? ''); ?> (<?php echo e($items['gpa'] ?? ''); ?>) <?php if(!$loop->last): ?>
                            ,
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            
            <?php if(!empty($group_array['subject_result_array'])): ?>
                <div class="table-responsive my-div">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Subject</th>
                                <th>Total</th>
                                <th>Present</th>
                                <th>Absent</th>
                                <th>Pass</th>
                                <th>Fail</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $group_array['subject_result_array']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item['subject_name'] ?? ''); ?></td>
                                    <td><?php echo e($item['total_student_count'] ?? 0); ?></td>
                                    <td><?php echo e($item['attended_student_count'] ?? 0); ?></td>
                                    <td><?php echo e($item['absent_student_count'] ?? 0); ?></td>
                                    <td><?php echo e($item['passed_student_count'] ?? 0); ?></td>
                                    <td><?php echo e($item['failed_student_count'] ?? 0); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>

            
            <?php if(!empty($group_array['failed_subject_list'])): ?>
                <div class="table-responsive my-div">
                    <div>
                        <b>Student Failed Subject Count (Without 4th Subject)</b>
                    </div>
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th style="width:150px;">Failed Subject</th>
                                <th style="width:90px;">Failed Student</th>
                                <th style="width:500px;">Roll Number</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $group_array['failed_subject_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item['failed_subject_count'] ?? 0); ?> Subject Fail</td>
                                    <td><?php echo e($item['failed_subject_student'] ?? 0); ?> Student</td>
                                    <td style="text-align: left">
                                        <?php $__currentLoopData = $item['failed_student_ids'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            
                                            <?php if(!empty($items['roll'])): ?>
                                                <?php echo e($items['roll']); ?><?php if($index + 1 < count($item['failed_student_ids'])): ?>
                                                    ,
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>

    
    <div style="margin-top:70px;">
        <table class="signature" width="100%" style="border: none;">
            <tr style="border: none;">
                <th width="33%" style='float:left'>Counter Signature</th>
                <th width="33%"></th>
                <th width="33%"> </th>
            </tr>
        </table>
    </div>

    <div style="margin-top:70px;">

        <table class="signature" width="100%" style="border: none;">
            <tr style="border: none;">
                <th width="33%">

                </th>
                <th width="33%">
                     <img style="text-align: center; padding-top: 0px;" width="200px" height="40px;"
                                   src="<?php echo e(public_path('images/site_group/secretary.png')); ?>">
                                   
                    <span>..............................</span><br>
                    <span>Member Secretary</span><br>
                    <span>Central Annual Exam Committee 2025</span>
                </th>

                <th width="33%">
                     <img style="text-align: center; padding-top: 0px;" width="200px" height="40px;"
                                   src="<?php echo e(public_path('images/site_group/convenor.png')); ?>">
                    <span>..............................</span><br>
                    <span>Convener</span> <br>
                    <span>Central Annual Exam Committee 2025</span>
                </th>
            </tr>
        </table>
    </div>


</body>

</html>
<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site_group/result/result_report/site-group-base-summry-result-pass-fail-student-summery-report.blade.php ENDPATH**/ ?>