<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    

    <style>
        @font-face {
            font-family: 'SolaimanLipi';
            src: url('<?php echo e(public_path('fonts/SolaimanLipi.ttf')); ?>') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

      
    </style>
    <style>
        /* Base table styles */

        
        table {
            border-collapse: collapse;
            font-size: 12px;
            width: 100%;
            border: 1px solid black;
            /* outer border */
        }

        /* All table header and data cells */
        .resultlist th,
        .resultlist td,
        .table-bordered th,
        .table-bordered td {
            border: 1px solid black;
            text-align: center;
            font-size: 14px;
            height: 22px;
        }

        .resultlist th {
            height: 20px;
        }

        /* Remove background color from all table headers */
        thead th {
            background-color: transparent !important;
        }

        /* Signature tables: no border on cells */
        .signature tr th {
            text-align: center;
            border: none;
        }

        /* Margin for div wrappers */
        .my-div {
            margin-top: 5px;
        }

        /* Group title box */
        .text-center h4 {
            display: inline-block;
            border-bottom: 1px solid #000;
            padding: 5px 10px;
            margin-top: 29px;
            text-align: center;
        }

        /* Responsive overflow for tables */
        .table-responsive {
            overflow-x: auto;
        }

        /* Header container */
        .headerco {
            width: 100%;
            margin-bottom: 10px;
        }

        /* Header title styling */
        .header-title span {
            font-size: 12px;
            display: block;
            margin-bottom: 5px;
        }

        /* Logo image styling */
        .logo-img {
            width: 70px;
            height: 70px;
            padding-top: 0;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }

        /* Body margin */
        body {
            margin: 10px 10px 10px 20px;
            font-family: 'SolaimanLipi', sans-serif;
        }

        /* No border on specific tables/cells */
        .no-border,
        .no-border * {
            border: none !important;
        }

        /* Logo image */
        .logo-img {
            width: 70px;
            height: 70px;
            display: block;
            margin: auto;
        }

        /* Layout for logo cell and title */
        .logo-cell {
            width: 10%;
            text-align: left;
        }

        .title-cell {
            width: 90%;
            text-align: center;
        }

        .site-name {
            font-size: 25px;
        }

        .sub-text {
            font-size: 15px;
        }

        /* Title section */
        .header-title span {
            font-size: 12px;
            display: block;
            margin-bottom: 5px;
        }

        /* Signature section layout */
        .signature-section {
            margin-top: 70px;
        }

        .left-align {
            text-align: left;
        }

        /* Page size for printing */
        @page  {
            size: 22cm 36cm portrait;
            margin: 1px 0;
        }
    </style>

</head>

<body>

    
    <div class="headerco">
        <table class="no-border">
            <tr>
                <td class="logo-cell">
                    <img class="logo-img" src="<?php echo public_path('img/site_group/logo/' . $siteGroup['group_logo']); ?>">
                </td>
                <td class="title-cell">
                    <span class="site-name"><?php echo e($siteGroup['name']); ?></span> <br>
                    <?php if($site_result_list[0]['site_name']): ?>
                        <span class="sub-text"><?php echo e($site_result_list[0]['site_name']); ?></span> <br>
                    <?php else: ?>
                        <span class="sub-text">Education Department</span> <br>
                        <span class="sub-text">Inter College</span> <br>
                    <?php endif; ?>
                    <span class="sub-text"><?php echo e($sheet_info['result_name']); ?> 2025</span>
                </td>
            </tr>
        </table>
    </div>

    
    <div class="header-title">
        <span><?php echo e(strip_tags($report_tittle2)); ?></span>
    </div>

    <div>

        <table class="table table-bordered text-center student_tables">
            <thead class="bg-primary">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Roll</th>
                    <th>Central Roll</th>
                    <th>Grade</th>

                    <th>Comment</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $site_result_list[0]['result_details']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e($item['student_name'] ?? ''); ?></td>
                        <td><?php echo e($item['roll_number'] ?? ''); ?></td>
                        <td><?php echo e($item['central_roll'] ?? ''); ?></td>
                        <td><?php echo e($item['grade'] ?? ''); ?></td>

                        <td style="text-align: left;"><?php echo e($item['comment'] ?? ''); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>


    </div>

    
    <div style="margin-top:70px;">
        <table class="signature" width="100%" style="border: none;">
            <tr style="border: none;">
                <th width="33%" style='float:left'>Counter Signature</th>
                <th width="33%"></th>
                <th width="33%"> </th>
            </tr>
        </table>
    </div>

    <div style="margin-top:70px;">

        <table class="signature" width="100%" style="border: none;">
            <tr style="border: none;">
                <th width="33%">

                </th>
                <th width="33%">
                    <span>..............................</span><br>
                    <span>Member Secretary</span><br>
                    <span>Central Annual Exam Committee 2025</span>
                </th>

                <th width="33%">
                    <span>..............................</span><br>
                    <span>Convener</span> <br>
                    <span>Central Annual Exam Committee 2025</span>
                </th>
            </tr>
        </table>
    </div>


</body>

</html>
<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site_group/result/result_report/site-group-base-summry-result-review-report.blade.php ENDPATH**/ ?>