<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($title_view); ?></title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }
        .slot-table td {
            border: 1px solid #999999;
            border-width: thin;
            border-spacing: 2px;
            /*border-style: none;*/

        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: middle;
            padding-left: 20px;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }


    </style>

</head>
<body>
<?php echo $__env->make('default.site.layout.pdf-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<table width="100%">
    <tr>
        <td align="left"> <b>Shift:</b> <?php echo e($class_shift_details->shift_name ?? ""); ?></td>
        <td align="left"><b> Class:</b> <?php echo e($class_details->class_name); ?></td>
        <td align="left"><b> Group:</b> <?php echo e($class_group_details->group_name ?? ""); ?></td>
        <td align="left"> <b>Section:</b> <?php echo e($class_section_details->section_name ?? ""); ?></td>
        <td align="left"><b> From Date:</b> <?php echo e($from_date ?? ""); ?></td>
        <td align="left"><b> To Date:</b> <?php echo e($to_date ?? ""); ?></td>
    </tr>

</table>

<table class="slot-table" width="100%" cellspacing="0" border="0" style="">
    <thead style="background-color:  #b3dbff;">
    <tr>

        <td  style="padding:2px; width:150px"><b>Student Name</b></td>
        <td align="center" style="padding:2px;"><b>Roll</b></td >
        <td align="center" style="padding:2px;"><b>User ID</b></td >
        <?php if($gross_total_due_paid_amount!='0'): ?>
            <td  style="padding:2px;" class="amount-right"><nobr><b>P.C. Due Paid</b></nobr></td>
        <?php endif; ?>
        <td  style="padding:2px;" class="amount-right"><nobr><b>Gen. Amount</b></nobr></td>
        <td style="padding:2px;" class="amount-right"><b>Fine</b></td>
        <td style="padding:2px;" class="amount-right"><nobr><b>Waiver</b></nobr></td>
        <td  style="padding:2px;" class="amount-right"><nobr><b>Payable</b></nobr></td>
        <td align="center" style="padding:2px;" class="amount-right"><nobr><b>Paid</b></nobr></td>
        <td  style="padding:2px;" class="amount-right"><nobr><b>Due</b></nobr></td>
    </tr>
    </thead>
    <tbody>


    <?php ($sl=1); ?>
    <?php $__currentLoopData = $all_student_total_payment_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <tr>
            <td class="text-right" style="padding:2px;"><?php echo e($value['std_name']); ?></td>
            <td align="center" style="padding:2px;"><?php echo e($value['student_roll_number']); ?></td>
            <td align="center" style="padding:2px;"><?php echo e($value['reg_no']); ?></td>
            <?php if($gross_total_due_paid_amount!='0'): ?>
            <td class="amount-right" style="padding:2px;"><?php echo e($value['prev_paid_total_amount']==0?"0.00":number_format($value['total_generate_amount']).".00"); ?></td>
            <?php endif; ?>
            <td class="amount-right" style="padding:2px;"><?php echo e($value['total_generate_amount']==0?"0.00":number_format($value['total_generate_amount']).".00"); ?></td>
            <td class="amount-right" style="padding:2px;"><?php echo e($value['fee_fine']==0?"0.00":number_format($value['fee_fine']).".00"); ?></td>
            <td class="amount-right" style="padding:2px;"><?php echo e($value['total_waiver_amount']==0?"0.00":number_format($value['total_waiver_amount']).".00"); ?></td>
            <td class="amount-right" style="padding:2px;"><?php echo e($value['total_payable_amount']==0?"0.00":number_format($value['total_payable_amount']).".00"); ?></td>
            <td class="amount-right" style="padding:2px;"><?php echo e($value['total_paid_amount']==0?"0.00":number_format($value['total_paid_amount']).".00"); ?></td>
            <td class="amount-right" style="padding:2px;"><?php echo e($value['due']==0?"0.00":number_format($value['due']).".00"); ?></td>
        </tr>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    </tbody>
    <tfoot  style="background-color:  #e6e6e6;">
    <tr>
        <td colspan="3" style="" class="amount-right">Total</td>
        <?php if($gross_total_due_paid_amount!='0'): ?>
            <td class="amount-right" style=""><?php echo e($gross_total_due_paid_amount.".00"); ?></td>
        <?php endif; ?>
        <td class="amount-right" style=""><?php echo e($all_std_total_generate_amount.".00"); ?></td>
        <td class="amount-right" style=""><?php echo e($all_std_total_fee_fine_amount.".00"); ?></td>
        <td class="amount-right" style=""><?php echo e($all_student_total_waiver_amount.".00"); ?></td>
        <td class="amount-right" style=""><?php echo e($all_student_total_payable_amount.".00"); ?></td>
        <td class="amount-right" style=""><?php echo e($all_student_total_paid_amount.".00"); ?></td>
        <td class="amount-right" style=""><?php echo e($all_student_total_due_amount.".00"); ?></td>

    </tr>
    </tfoot>

</table>

<table width="100%">
    <br>
    <tr>
        <td align="left">
            
        </td>
    </tr>

</table>

</body>



<style>
    @page  {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        /*border:1px dotted black;*/
    }

</style>
</html>
<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site/student-fee/report/payment-class-wise-report-pdf.blade.php ENDPATH**/ ?>