<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">

    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }

        body {
            margin: 10px;
            padding: 5px;
        }

        .header-title {
            font-size: 20px;
            text-align: center;
            padding: 10px 0;
        }

        .logo {
            text-align: left;
            padding-top: 0px;
        }

        .center-header {
            text-align: center;
            padding-right: 100px;
        }
    </style>
</head>
<body>
    <div class="page">

        
            <div class="headerco" style="width: 100%;">
                <table style="width: 100%; border: none;">
                    <tr>
                        <td style="width: 10%; text-align: left; border: none;">
                            <img style="text-align: center; padding-top: 0px;" width="70px" height="70px;"
                                src="<?php echo public_path('img/site_group/logo/' . $SiteGroupInfo['group_logo']); ?>">
                        </td>
                        <td style="width: 100%; text-align: center; padding-right: 100px; border: none;">
                            <span style="font-size: 25px"><?php echo e($SiteGroupInfo['name']); ?></span> <br>
                            <span style="font-size: 15px"> Education Department </span>
                             <span style="font-size: 15px"> Inter College </span> <br>
                            <span style="font-size: 15px"> <?php echo e($sheet_info['result_name']); ?> 2025</span>
                        </td>
                    </tr>
                </table>
            </div>

        
        <div class="header-title">
            <span style="font-size: 20px"><?php echo e($resultType['name']); ?></span> <br>

            <strong>Combined Merit list</strong>

        </div>

        
        <?php
            $meritList = $getSiteGroupPrimaryResultMeritListStatistics['merit_list'] ?? [];
        ?>

        <?php if(count($meritList) > 0): ?>
            <table>
                <thead style="background-color: #f2f2f2;">
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Username</th>
                        <th>Institute</th>
                        <th>Group</th>
                        <th>Class Roll</th>
                        <th>Central Roll</th>
                        <th>Total</th>
                        <th>%</th>
                        <th>Grade</th>
                        <th>Point</th>
                        <th>Rank</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $meritList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            <td><?php echo e($item['student_name']); ?></td>
                            <td><?php echo e($item['username']); ?></td>
                            <td><?php echo e($item['site_name']); ?></td>
                            <td><?php echo e($item['class_group']); ?></td>
                            <td><?php echo e($item['class_roll']); ?></td>
                            <td><?php echo e($item['central_roll']); ?></td>
                            <td><?php echo e($item['total_mark']); ?></td>
                            <td><?php echo e($item['mark_percentage']); ?></td>
                            <td><?php echo e($item['grade']); ?></td>
                            <td><?php echo e($item['gpa']); ?></td>
                            <td><?php echo e($item['central_rank']); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php else: ?>
            <p style="text-align: center; padding: 20px;">No merit list data available.</p>
        <?php endif; ?>
    </div>

    <div style="margin-top:70px;">
        <table class="signature" width="100%">
            <tr>
                <th width="33%" style='float:left'>Counter Signature</th>
                <th width="33%"></th>
                <th width="33%"> </th>
            </tr>
        </table>
    </div>

    <div style="margin-top:70px;">

        <table class="signature" width="100%">
            <tr>
                <th width="33%">

                </th>
                <th width="33%">
                    <span>..............................</span><br>
                    <span>Member Secretary</span><br>
                    <span>Central Annual Exam Committee 2025</span>
                </th>

                <th width="33%">
                    <span>..............................</span><br>
                    <span>Convener</span> <br>
                    <span>Central Annual Exam Committee 2025</span>
                </th>
            </tr>
        </table>
    </div>
</body>

<style>
    @page  {
        size: A4 protrait   ;
        margin: 10px;
    }
</style>
</html>
<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site_group/result/result_report/site-group-base-merit-list-report.blade.php ENDPATH**/ ?>