<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($title_view); ?></title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

   

    .slot-table th,.slot-table td {
        border: 1px solid #999999;
        padding: 6px;
        text-align: center;
    }
  

        .heading-slot-bg{
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: middle;
            padding-left: 20px;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }

    </style>

</head>
<body>
<?php echo $__env->make('default.site.layout.pdf-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<table width="100%">
    

</table>

<table class="slot-table" width="100%" cellspacing="0" border="0">
    <thead>
        <tr class="heading-slot-bg">
            <th>#</th>
            <th>Payment Method</th>
            <th>Account Name</th>
            <th>Account No.</th>
            <th>Amount</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $resp_data['accont_amount_array']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $account_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($index + 1); ?></td>
                <td><?php echo e($account_data['payment_method_name']); ?></td>
                <td><?php echo e($account_data['user_name']); ?></td>
                <td><?php echo e($account_data['account_no']); ?></td>
                <td style="text-align: right"><strong><?php echo e(number_format($account_data['pay_amount'], 2)); ?></strong></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php if($resp_data['total_amount'] > 0): ?>
            <tr>
                <td colspan="4" style="text-align: right"><strong>Total Amount</strong></td>
                <td style="text-align: right"><strong><?php echo e(number_format($resp_data['total_amount'], 2)); ?></strong></td>
            </tr>
        <?php endif; ?>
    </tbody>

</table>

</body>



<style>
   @page  {
    size: A4 landscape; /* Set to A4 landscape */
    margin: 1px 0;
    }

    body {
        margin: 5px 20px 0;
        /* border: 1px dotted black; */
    }

   

</style>
</html><?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site/admission/account-base-admission-fee-report-pdf.blade.php ENDPATH**/ ?>